/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;

public record ArmorMaterial(int durability, Map<ArmorType, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, TagKey<Item> repairIngredient, ResourceLocation modelId) {
    public Item.Properties humanoidProperties(Item.Properties $$0, ArmorType $$1) {
        return $$0.durability($$1.getDurability(this.durability)).attributes(this.createAttributes($$1)).enchantable(this.enchantmentValue).component(DataComponents.EQUIPPABLE, Equippable.builder($$1.getSlot()).setEquipSound(this.equipSound).setModel(this.modelId).build()).repairable(this.repairIngredient);
    }

    public Item.Properties animalProperties(Item.Properties $$0, HolderSet<EntityType<?>> $$1) {
        return $$0.durability(ArmorType.BODY.getDurability(this.durability)).attributes(this.createAttributes(ArmorType.BODY)).repairable(this.repairIngredient).component(DataComponents.EQUIPPABLE, Equippable.builder(EquipmentSlot.BODY).setEquipSound(this.equipSound).setModel(this.modelId).setAllowedEntities($$1).build());
    }

    public Item.Properties animalProperties(Item.Properties $$0, Holder<SoundEvent> $$1, boolean $$2, HolderSet<EntityType<?>> $$3) {
        if ($$2) {
            $$0 = $$0.durability(ArmorType.BODY.getDurability(this.durability)).repairable(this.repairIngredient);
        }
        return $$0.attributes(this.createAttributes(ArmorType.BODY)).component(DataComponents.EQUIPPABLE, Equippable.builder(EquipmentSlot.BODY).setEquipSound($$1).setModel(this.modelId).setAllowedEntities($$3).setDamageOnHurt($$2).build());
    }

    private ItemAttributeModifiers createAttributes(ArmorType $$0) {
        int $$1 = this.defense.getOrDefault($$0, 0);
        ItemAttributeModifiers.Builder $$2 = ItemAttributeModifiers.builder();
        EquipmentSlotGroup $$3 = EquipmentSlotGroup.bySlot($$0.getSlot());
        ResourceLocation $$4 = ResourceLocation.withDefaultNamespace("armor." + $$0.getName());
        $$2.add(Attributes.ARMOR, new AttributeModifier($$4, $$1, AttributeModifier.Operation.ADD_VALUE), $$3);
        $$2.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier($$4, this.toughness, AttributeModifier.Operation.ADD_VALUE), $$3);
        if (this.knockbackResistance > 0.0f) {
            $$2.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier($$4, this.knockbackResistance, AttributeModifier.Operation.ADD_VALUE), $$3);
        }
        return $$2.build();
    }
}

