/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.language;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.metadata.language.LanguageMetadataSection;
import net.minecraft.locale.Language;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class LanguageManager
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final LanguageInfo DEFAULT_LANGUAGE = new LanguageInfo("US", "English", false);
    private Map<String, LanguageInfo> languages = ImmutableMap.of((Object)"en_us", (Object)DEFAULT_LANGUAGE);
    private String currentCode;
    private final Consumer<ClientLanguage> reloadCallback;
    private Locale javaLocale;

    public LanguageManager(String p_118971_, Consumer<ClientLanguage> p_342376_) {
        this.reloadCallback = p_342376_;
        this.setSelected(p_118971_);
    }

    private static Map<String, LanguageInfo> extractLanguages(Stream<PackResources> p_118982_) {
        HashMap map = Maps.newHashMap();
        p_118982_.forEach(p_264712_ -> {
            try {
                LanguageMetadataSection languagemetadatasection = (LanguageMetadataSection)p_264712_.getMetadataSection(LanguageMetadataSection.TYPE);
                if (languagemetadatasection != null) {
                    languagemetadatasection.languages().forEach(map::putIfAbsent);
                }
            }
            catch (IOException | RuntimeException runtimeexception) {
                LOGGER.warn("Unable to parse language metadata section of resourcepack: {}", (Object)p_264712_.packId(), (Object)runtimeexception);
            }
        });
        return ImmutableMap.copyOf((Map)map);
    }

    @Override
    public void onResourceManagerReload(ResourceManager p_118973_) {
        LanguageInfo languageinfo;
        this.languages = LanguageManager.extractLanguages(p_118973_.listPacks());
        ArrayList<String> list = new ArrayList<String>(2);
        boolean flag = DEFAULT_LANGUAGE.bidirectional();
        list.add("en_us");
        if (!this.currentCode.equals("en_us") && (languageinfo = this.languages.get(this.currentCode)) != null) {
            list.add(this.currentCode);
            flag = languageinfo.bidirectional();
        }
        ClientLanguage clientlanguage = ClientLanguage.loadFrom(p_118973_, list, flag);
        I18n.setLanguage(clientlanguage);
        Language.inject(clientlanguage);
        this.reloadCallback.accept(clientlanguage);
    }

    public Locale getJavaLocale() {
        return this.javaLocale;
    }

    public void setSelected(String p_265224_) {
        this.currentCode = p_265224_;
        String[] langSplit = p_265224_.split("_", 2);
        this.javaLocale = langSplit.length == 1 ? Locale.of(langSplit[0]) : Locale.of(langSplit[0], langSplit[1]);
    }

    public String getSelected() {
        return this.currentCode;
    }

    public SortedMap<String, LanguageInfo> getLanguages() {
        return new TreeMap<String, LanguageInfo>(this.languages);
    }

    @Nullable
    public LanguageInfo getLanguage(String p_118977_) {
        return this.languages.get(p_118977_);
    }
}

