/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;

public class ServerboundContainerClickPacket
implements Packet<ServerGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundContainerClickPacket> STREAM_CODEC = Packet.codec(ServerboundContainerClickPacket::write, ServerboundContainerClickPacket::new);
    private static final int MAX_SLOT_COUNT = 128;
    private static final StreamCodec<RegistryFriendlyByteBuf, Int2ObjectMap<ItemStack>> SLOTS_STREAM_CODEC = ByteBufCodecs.map(Int2ObjectOpenHashMap::new, ByteBufCodecs.SHORT.map(Short::intValue, Integer::shortValue), ItemStack.OPTIONAL_STREAM_CODEC, 128);
    private final int containerId;
    private final int stateId;
    private final int slotNum;
    private final int buttonNum;
    private final ClickType clickType;
    private final ItemStack carriedItem;
    private final Int2ObjectMap<ItemStack> changedSlots;

    public ServerboundContainerClickPacket(int $$0, int $$1, int $$2, int $$3, ClickType $$4, ItemStack $$5, Int2ObjectMap<ItemStack> $$6) {
        this.containerId = $$0;
        this.stateId = $$1;
        this.slotNum = $$2;
        this.buttonNum = $$3;
        this.clickType = $$4;
        this.carriedItem = $$5;
        this.changedSlots = Int2ObjectMaps.unmodifiable($$6);
    }

    private ServerboundContainerClickPacket(RegistryFriendlyByteBuf $$0) {
        this.containerId = $$0.readContainerId();
        this.stateId = $$0.readVarInt();
        this.slotNum = $$0.readShort();
        this.buttonNum = $$0.readByte();
        this.clickType = $$0.readEnum(ClickType.class);
        this.changedSlots = Int2ObjectMaps.unmodifiable((Int2ObjectMap)((Int2ObjectMap)SLOTS_STREAM_CODEC.decode($$0)));
        this.carriedItem = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode($$0);
    }

    private void write(RegistryFriendlyByteBuf $$0) {
        $$0.writeContainerId(this.containerId);
        $$0.writeVarInt(this.stateId);
        $$0.writeShort(this.slotNum);
        $$0.writeByte(this.buttonNum);
        $$0.writeEnum(this.clickType);
        SLOTS_STREAM_CODEC.encode($$0, this.changedSlots);
        ItemStack.OPTIONAL_STREAM_CODEC.encode($$0, this.carriedItem);
    }

    @Override
    public PacketType<ServerboundContainerClickPacket> type() {
        return GamePacketTypes.SERVERBOUND_CONTAINER_CLICK;
    }

    @Override
    public void handle(ServerGamePacketListener $$0) {
        $$0.handleContainerClick(this);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getSlotNum() {
        return this.slotNum;
    }

    public int getButtonNum() {
        return this.buttonNum;
    }

    public ItemStack getCarriedItem() {
        return this.carriedItem;
    }

    public Int2ObjectMap<ItemStack> getChangedSlots() {
        return this.changedSlots;
    }

    public ClickType getClickType() {
        return this.clickType;
    }

    public int getStateId() {
        return this.stateId;
    }
}

