/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class OminousBannerRarityFix
extends DataFix {
    public OminousBannerRarityFix(Schema $$0) {
        super($$0, false);
    }

    public TypeRewriteRule makeRule() {
        Type $$0 = this.getInputSchema().getType(References.BLOCK_ENTITY);
        Type $$1 = this.getInputSchema().getType(References.ITEM_STACK);
        TaggedChoice.TaggedChoiceType $$22 = this.getInputSchema().findChoiceType(References.BLOCK_ENTITY);
        OpticFinder $$3 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)References.ITEM_NAME.typeName(), NamespacedSchema.namespacedString()));
        OpticFinder $$4 = $$0.findField("components");
        OpticFinder $$5 = $$1.findField("components");
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("Ominous Banner block entity common rarity to uncommon rarity fix", $$0, $$2 -> {
            Object $$3 = ((Pair)$$2.get($$22.finder())).getFirst();
            return $$3.equals("minecraft:banner") ? this.fix((Typed<?>)$$2, (OpticFinder<?>)$$4) : $$2;
        }), (TypeRewriteRule)this.fixTypeEverywhereTyped("Ominous Banner item stack common rarity to uncommon rarity fix", $$1, $$2 -> {
            String $$3 = $$2.getOptional($$3).map(Pair::getSecond).orElse("");
            return $$3.equals("minecraft:white_banner") ? this.fix((Typed<?>)$$2, (OpticFinder<?>)$$5) : $$2;
        }));
    }

    private Typed<?> fix(Typed<?> $$02, OpticFinder<?> $$1) {
        return $$02.updateTyped($$1, $$0 -> $$0.update(DSL.remainderFinder(), $$02 -> {
            boolean $$1 = $$02.get("minecraft:item_name").asString().result().flatMap(ComponentDataFixUtils::extractTranslationString).filter($$0 -> $$0.equals("block.minecraft.ominous_banner")).isPresent();
            if ($$1) {
                return $$02.set("minecraft:rarity", $$02.createString("uncommon")).set("minecraft:item_name", ComponentDataFixUtils.createTranslatableComponent($$02.getOps(), "block.minecraft.ominous_banner"));
            }
            return $$02;
        }));
    }
}

