/*
 * Decompiled with CFR 0.152.
 */
package generator;

import generator.BackgroundGenerator;
import java.util.logging.Level;
import java.util.logging.Logger;
import sudoku.DifficultyLevel;
import sudoku.DifficultyType;
import sudoku.GameMode;
import sudoku.Options;
import sudoku.StepConfig;

public class BackgroundGeneratorThread
implements Runnable {
    private static final boolean DEBUG = false;
    private static BackgroundGeneratorThread instance = null;
    private BackgroundGenerator generator;
    private final Thread thread = new Thread(this);
    private boolean newRequest = false;
    private boolean threadStarted = false;

    private BackgroundGeneratorThread() {
        this.generator = new BackgroundGenerator();
    }

    public static BackgroundGeneratorThread getInstance() {
        if (instance == null) {
            instance = new BackgroundGeneratorThread();
        }
        return instance;
    }

    public synchronized String getSudoku(DifficultyLevel level, GameMode mode) {
        String[] puzzles = this.getPuzzleArray(level, mode);
        String newPuzzle = null;
        if (puzzles[0] != null) {
            newPuzzle = puzzles[0];
            int i = 1;
            while (i < puzzles.length) {
                puzzles[i - 1] = puzzles[i];
                ++i;
            }
            puzzles[puzzles.length - 1] = null;
        }
        this.startCreation();
        return newPuzzle;
    }

    private synchronized void setSudoku(DifficultyLevel level, GameMode mode, String sudoku) {
        String[] puzzles = this.getPuzzleArray(level, mode);
        int i = 0;
        while (i < puzzles.length) {
            if (puzzles[i] == null) {
                puzzles[i] = sudoku;
                break;
            }
            ++i;
        }
    }

    public synchronized void resetAll() {
        String[][] puzzles = Options.getInstance().getNormalPuzzles();
        int i = 0;
        while (i < puzzles.length) {
            int j = 0;
            while (j < puzzles[i].length) {
                puzzles[i][j] = null;
                ++j;
            }
            ++i;
        }
        this.resetTrainingPractising();
    }

    public synchronized void resetTrainingPractising() {
        String[] puzzles1 = Options.getInstance().getLearningPuzzles();
        int i = 0;
        while (i < puzzles1.length) {
            puzzles1[i] = null;
            ++i;
        }
        puzzles1 = Options.getInstance().getPractisingPuzzles();
        i = 0;
        while (i < puzzles1.length) {
            puzzles1[i] = null;
            ++i;
        }
        this.startCreation();
    }

    public synchronized void setNewLevel(int newLevel) {
        int maxTrainingLevel = this.getTrainingLevel();
        if (maxTrainingLevel == -1 || newLevel < maxTrainingLevel) {
            return;
        }
        if (newLevel == Options.getInstance().getPractisingPuzzlesLevel()) {
            return;
        }
        String[] puzzles = Options.getInstance().getPractisingPuzzles();
        int i = 0;
        while (i < puzzles.length) {
            puzzles[i] = null;
            ++i;
        }
        Options.getInstance().setPractisingPuzzlesLevel(newLevel);
        this.startCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCreation() {
        if (this.thread == null) {
            return;
        }
        if (!this.threadStarted) {
            this.thread.start();
            this.threadStarted = true;
        }
        Thread thread = this.thread;
        synchronized (thread) {
            this.newRequest = true;
            this.thread.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: while (!this.thread.isInterrupted()) {
            try {
                Thread thread = this.thread;
                synchronized (thread) {
                    if (!this.newRequest) {
                        this.thread.wait();
                    }
                    if (!this.newRequest) {
                        continue;
                    }
                    this.newRequest = false;
                }
                DifficultyLevel level = null;
                GameMode mode = null;
                while (level == null && !this.thread.isInterrupted()) {
                    String puzzle;
                    BackgroundGeneratorThread backgroundGeneratorThread = this;
                    synchronized (backgroundGeneratorThread) {
                        int i;
                        String[][] puzzles = Options.getInstance().getNormalPuzzles();
                        int i2 = 0;
                        while (i2 < puzzles.length) {
                            int j = 0;
                            while (j < puzzles[i2].length) {
                                if (puzzles[i2][j] == null) {
                                    level = Options.getInstance().getDifficultyLevel(i2 + 1);
                                    mode = GameMode.PLAYING;
                                    break;
                                }
                                ++j;
                            }
                            if (level != null) break;
                            ++i2;
                        }
                        int trLevel = this.getTrainingLevel();
                        String[] puzzles1 = Options.getInstance().getLearningPuzzles();
                        if (level == null && trLevel != -1) {
                            i = 0;
                            while (i < puzzles1.length) {
                                if (puzzles1[i] == null) {
                                    level = Options.getInstance().getDifficultyLevel(DifficultyType.EXTREME.ordinal());
                                    mode = GameMode.LEARNING;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (trLevel != -1 && Options.getInstance().getPractisingPuzzlesLevel() == -1) {
                            this.setNewLevel(Options.getInstance().getActLevel());
                        }
                        puzzles1 = Options.getInstance().getPractisingPuzzles();
                        if (level == null && trLevel != -1 && Options.getInstance().getActLevel() >= trLevel) {
                            i = 0;
                            while (i < puzzles1.length) {
                                if (puzzles1[i] == null) {
                                    level = Options.getInstance().getDifficultyLevel(Options.getInstance().getPractisingPuzzlesLevel());
                                    mode = GameMode.PRACTISING;
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                    if (level == null || (puzzle = this.generator.generate(level, mode)) == null) continue block9;
                    this.setSudoku(level, mode, puzzle);
                    level = null;
                    mode = null;
                }
            }
            catch (InterruptedException ex) {
                this.thread.interrupt();
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error checking progress", ex);
            }
        }
    }

    private String[] getPuzzleArray(DifficultyLevel level, GameMode mode) {
        String[] puzzles = null;
        switch (mode) {
            case PLAYING: {
                puzzles = Options.getInstance().getNormalPuzzles()[level.getOrdinal() - 1];
                break;
            }
            case LEARNING: {
                puzzles = Options.getInstance().getLearningPuzzles();
                break;
            }
            case PRACTISING: {
                puzzles = Options.getInstance().getPractisingPuzzles();
            }
        }
        return puzzles;
    }

    private int getTrainingLevel() {
        StepConfig[] conf = Options.getInstance().getOrgSolverSteps();
        int level = -1;
        StepConfig[] stepConfigArray = conf;
        int n = conf.length;
        int n2 = 0;
        while (n2 < n) {
            int actLevel;
            StepConfig act = stepConfigArray[n2];
            if (act.isEnabledTraining() && (actLevel = act.getLevel()) > level) {
                level = actLevel;
            }
            ++n2;
        }
        return level;
    }
}

