/*
 * Decompiled with CFR 0.152.
 */
package generator;

import generator.GeneratorPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import sudoku.Options;
import sudoku.Sudoku2;
import sudoku.SudokuSinglesQueue;
import sudoku.SudokuStatus;

public class SudokuGenerator {
    private static final boolean DEBUG = false;
    private static final int MAX_TRIES = 1000000;
    private static Sudoku2 EMPTY_GRID = new Sudoku2();
    private int[] solution = new int[81];
    private int solutionCount = 0;
    private RecursionStackEntry[] stack = new RecursionStackEntry[82];
    private int[] generateIndices = new int[81];
    private int[] newFullSudoku = new int[81];
    private int[] newValidSudoku = new int[81];
    private Random rand = new Random();
    private int anzTries = 0;
    private int anzNS = 0;
    private int anzHS = 0;
    private int anzTriesGen = 0;
    private int anzClues = 0;
    private long nanos = 0L;
    private long setNanos = 0L;

    protected SudokuGenerator() {
        int i = 0;
        while (i < this.stack.length) {
            this.stack[i] = new RecursionStackEntry();
            ++i;
        }
    }

    public int getNumberOfSolutions(Sudoku2 sudoku, int maxSolutionCount) {
        long ticks = System.currentTimeMillis();
        this.solve(sudoku, maxSolutionCount);
        if (this.solutionCount == 1) {
            sudoku.setSolution(Arrays.copyOf(this.solution, this.solution.length));
        }
        ticks = System.currentTimeMillis() - ticks;
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "validSolution() {0}ms", ticks);
        return this.solutionCount;
    }

    public boolean validSolution(Sudoku2 sudoku) {
        boolean unique;
        long ticks = System.currentTimeMillis();
        this.solve(sudoku, 1);
        boolean bl = unique = this.solutionCount == 1;
        if (unique) {
            sudoku.setSolution(Arrays.copyOf(this.solution, this.solution.length));
        }
        ticks = System.currentTimeMillis() - ticks;
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "validSolution() {0}ms", ticks);
        return unique;
    }

    public void solve(Sudoku2 sudoku, int maxSolutionCount) {
        this.stack[0].sudoku.set(sudoku);
        this.stack[0].index = 0;
        this.stack[0].candidates = null;
        this.stack[0].candIndex = 0;
        this.solve(maxSolutionCount);
    }

    public void solve(String sudokuString, int maxSolutionCount) {
        this.stack[0].sudoku.set(EMPTY_GRID);
        this.stack[0].candidates = null;
        this.stack[0].candIndex = 0;
        int i = 0;
        while (i < sudokuString.length() && i < 81) {
            int value = sudokuString.charAt(i) - 48;
            if (value >= 1 && value <= 9) {
                this.stack[0].sudoku.setCell(i, value, false, false);
                this.setAllExposedSingles(this.stack[0].sudoku);
            }
            ++i;
        }
        this.solve(maxSolutionCount);
    }

    public void solve(int[] cellValues, int maxSolutionCount) {
        this.stack[0].sudoku.set(EMPTY_GRID);
        this.stack[0].candidates = null;
        this.stack[0].candIndex = 0;
        int i = 0;
        while (i < cellValues.length) {
            int value = cellValues[i];
            if (value >= 1 && value <= 9) {
                this.stack[0].sudoku.setCellBS(i, value);
            }
            ++i;
        }
        this.stack[0].sudoku.rebuildInternalData();
        this.setAllExposedSingles(this.stack[0].sudoku);
        this.solve(maxSolutionCount);
    }

    private void solve(int maxSolutionCount) {
        boolean done;
        this.anzTries = 0;
        this.anzNS = 0;
        this.anzHS = 0;
        this.solutionCount = 0;
        if (!this.setAllExposedSingles(this.stack[0].sudoku)) {
            return;
        }
        if (this.stack[0].sudoku.getUnsolvedCellsAnz() == 0) {
            this.solution = Arrays.copyOf(this.stack[0].sudoku.getValues(), 81);
            ++this.solutionCount;
            return;
        }
        int level = 0;
        block0: do {
            if (this.anzTries >= 1000000) {
                System.out.println("Exceeded tries");
                break;
            }
            if (this.stack[level].sudoku.getUnsolvedCellsAnz() == 0) {
                ++this.solutionCount;
                if (this.solutionCount == 1) {
                    this.solution = Arrays.copyOf(this.stack[level].sudoku.getValues(), 81);
                } else if (this.solutionCount > maxSolutionCount) {
                    return;
                }
            } else {
                int index = -1;
                int anzCand = 9;
                Sudoku2 sudoku = this.stack[level].sudoku;
                int i = 0;
                while (i < 81) {
                    if (sudoku.getCell(i) != 0 && Sudoku2.ANZ_VALUES[sudoku.getCell(i)] < anzCand) {
                        index = i;
                        anzCand = Sudoku2.ANZ_VALUES[sudoku.getCell(i)];
                    }
                    ++i;
                }
                ++level;
                if (index < 0) {
                    this.solutionCount = 0;
                    return;
                }
                this.stack[level].index = (short)index;
                this.stack[level].candidates = Sudoku2.POSSIBLE_VALUES[this.stack[level - 1].sudoku.getCell(index)];
                this.stack[level].candIndex = 0;
            }
            done = false;
            while (true) {
                if (this.stack[level].candIndex >= this.stack[level].candidates.length) {
                    if (--level > 0) continue;
                    done = true;
                }
                if (done) continue block0;
                int nextCand = this.stack[level].candidates[this.stack[level].candIndex++];
                ++this.anzTries;
                this.stack[level].sudoku.setBS(this.stack[level - 1].sudoku);
                if (this.stack[level].sudoku.setCell(this.stack[level].index, nextCand, false, false) && this.setAllExposedSingles(this.stack[level].sudoku)) break;
            }
        } while (!done);
    }

    public Sudoku2 generateSudoku(boolean symmetric) {
        int index = Options.getInstance().getGeneratorPatternIndex();
        boolean[] pattern = null;
        ArrayList<GeneratorPattern> patterns = Options.getInstance().getGeneratorPatterns();
        if (index != -1 && index < patterns.size() && patterns.get(index).isValid()) {
            pattern = patterns.get(index).getPattern();
        }
        return this.generateSudoku(symmetric, pattern);
    }

    public Sudoku2 generateSudoku(boolean symmetric, boolean[] pattern) {
        int i;
        this.generateFullGrid();
        if (pattern == null) {
            this.generateInitPos(symmetric);
        } else {
            boolean ok = false;
            System.out.println("Trying with pattern!");
            i = 0;
            while (i < 1000000) {
                ok = this.generateInitPos(pattern);
                if (ok) break;
                if (i % 1000 == 0) {
                    System.out.println("  try: " + i);
                }
                ++i;
            }
            if (!ok) {
                System.out.println("nothing found!");
                return null;
            }
            System.out.println("puzzle found!");
        }
        Sudoku2 sudoku = new Sudoku2();
        i = 0;
        while (i < this.newValidSudoku.length) {
            if (this.newValidSudoku[i] != 0) {
                sudoku.setCell(i, this.newValidSudoku[i]);
                sudoku.setIsFixed(i, true);
                ++this.anzClues;
            }
            ++i;
        }
        sudoku.setStatus(SudokuStatus.VALID);
        sudoku.setStatusGivens(SudokuStatus.VALID);
        return sudoku;
    }

    private void generateFullGrid() {
        while (!this.doGenerateFullGrid()) {
        }
    }

    private boolean doGenerateFullGrid() {
        boolean done;
        this.anzTries = 0;
        this.anzNS = 0;
        this.anzHS = 0;
        int actTries = 0;
        int max = this.generateIndices.length;
        int i = 0;
        while (i < max) {
            this.generateIndices[i] = i;
            ++i;
        }
        i = 0;
        while (i < max) {
            int index1 = this.rand.nextInt(max);
            int index2 = this.rand.nextInt(max);
            while (index1 == index2) {
                index2 = this.rand.nextInt(max);
            }
            int dummy = this.generateIndices[index1];
            this.generateIndices[index1] = this.generateIndices[index2];
            this.generateIndices[index2] = dummy;
            ++i;
        }
        this.stack[0].sudoku.set(EMPTY_GRID);
        int level = 0;
        this.stack[0].index = -1;
        block3: do {
            if (this.stack[level].sudoku.getUnsolvedCellsAnz() == 0) {
                System.arraycopy(this.stack[level].sudoku.getValues(), 0, this.newFullSudoku, 0, this.newFullSudoku.length);
                return true;
            }
            int index = -1;
            int[] actValues = this.stack[level].sudoku.getValues();
            int i2 = 0;
            while (i2 < 81) {
                int actTry = this.generateIndices[i2];
                if (actValues[actTry] == 0) {
                    index = actTry;
                    break;
                }
                ++i2;
            }
            this.stack[++level].index = (short)index;
            this.stack[level].candidates = Sudoku2.POSSIBLE_VALUES[this.stack[level - 1].sudoku.getCell(index)];
            this.stack[level].candIndex = 0;
            if (++actTries > 100) {
                return false;
            }
            done = false;
            while (true) {
                if (this.stack[level].candIndex >= this.stack[level].candidates.length) {
                    if (--level > 0) continue;
                    done = true;
                }
                if (done) continue block3;
                int nextCand = this.stack[level].candidates[this.stack[level].candIndex++];
                ++this.anzTries;
                this.stack[level].sudoku.setBS(this.stack[level - 1].sudoku);
                if (this.stack[level].sudoku.setCell(this.stack[level].index, nextCand, false, false) && this.setAllExposedSingles(this.stack[level].sudoku)) break;
            }
        } while (!done);
        return false;
    }

    private boolean generateInitPos(boolean[] pattern) {
        System.arraycopy(this.newFullSudoku, 0, this.newValidSudoku, 0, this.newFullSudoku.length);
        int i = 0;
        while (i < pattern.length) {
            if (!pattern[i]) {
                this.newValidSudoku[i] = 0;
            }
            ++i;
        }
        this.solve(this.newValidSudoku, 1);
        if (this.solutionCount > 1) {
            return false;
        }
        System.out.println("!!!! FOUND ONE !!!!");
        return true;
    }

    private void generateInitPos(boolean isSymmetric) {
        int maxPosToFill = 17;
        boolean[] used = new boolean[81];
        int usedCount = used.length;
        Arrays.fill(used, false);
        System.arraycopy(this.newFullSudoku, 0, this.newValidSudoku, 0, this.newFullSudoku.length);
        int remainingClues = this.newValidSudoku.length;
        while (remainingClues > maxPosToFill && usedCount > 1) {
            int i = this.rand.nextInt(81);
            do {
                if (i < 80) {
                    ++i;
                    continue;
                }
                i = 0;
            } while (used[i]);
            used[i] = true;
            --usedCount;
            if (this.newValidSudoku[i] == 0 || isSymmetric && (i / 9 != 4 || i % 9 != 4) && this.newValidSudoku[9 * (8 - i / 9) + (8 - i % 9)] == 0) continue;
            this.newValidSudoku[i] = 0;
            --remainingClues;
            int symm = 0;
            if (isSymmetric && (i / 9 != 4 || i % 9 != 4)) {
                symm = 9 * (8 - i / 9) + (8 - i % 9);
                this.newValidSudoku[symm] = 0;
                used[symm] = true;
                --usedCount;
                --remainingClues;
            }
            this.solve(this.newValidSudoku, 1);
            ++this.anzTriesGen;
            if (this.solutionCount <= 1) continue;
            this.newValidSudoku[i] = this.newFullSudoku[i];
            ++remainingClues;
            if (!isSymmetric || i / 9 == 4 && i % 9 == 4) continue;
            this.newValidSudoku[symm] = this.newFullSudoku[symm];
            ++remainingClues;
        }
    }

    private boolean setAllExposedSingles(Sudoku2 sudoku) {
        boolean valid = true;
        SudokuSinglesQueue nsQueue = sudoku.getNsQueue();
        SudokuSinglesQueue hsQueue = sudoku.getHsQueue();
        do {
            int value;
            int index;
            int singleIndex = 0;
            while (valid && (singleIndex = nsQueue.getSingle()) != -1) {
                index = nsQueue.getIndex(singleIndex);
                value = nsQueue.getValue(singleIndex);
                if ((sudoku.getCell(index) & Sudoku2.MASKS[value]) == 0) continue;
                ++this.anzNS;
                valid = sudoku.setCell(index, value, false, false);
            }
            while (valid && (singleIndex = hsQueue.getSingle()) != -1) {
                index = hsQueue.getIndex(singleIndex);
                value = hsQueue.getValue(singleIndex);
                if ((sudoku.getCell(index) & Sudoku2.MASKS[value]) == 0) continue;
                ++this.anzHS;
                valid = sudoku.setCell(index, value, false, false);
            }
        } while (valid && (!nsQueue.isEmpty() || !hsQueue.isEmpty()));
        return valid;
    }

    public int getSolutionCount() {
        return this.solutionCount;
    }

    public int[] getSolution() {
        return this.solution;
    }

    public String getSolutionAsString() {
        return this.getSolutionAsString(this.solution);
    }

    public String getSolutionAsString(int[] array) {
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            temp.append("").append(array[i]);
            ++i;
        }
        return temp.toString();
    }

    private String getGridStr(Sudoku2 sudoku) {
        return this.getSolutionAsString(sudoku.getValues());
    }

    public String printStat() {
        return "anzTries: " + this.anzTries + ", anzNS: " + this.anzNS + ", anzHS: " + this.anzHS;
    }

    private class RecursionStackEntry {
        Sudoku2 sudoku = new Sudoku2();
        int index;
        int[] candidates;
        int candIndex;

        private RecursionStackEntry() {
        }
    }
}

