/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.util.ArrayList;
import java.util.List;
import solver.SudokuStepFinder;
import sudoku.SolutionStep;
import sudoku.Sudoku2;
import sudoku.SudokuSet;

public class GroupNode {
    public SudokuSet indices = new SudokuSet();
    public SudokuSet buddies = new SudokuSet();
    public int cand;
    public int line = -1;
    public int col = -1;
    public int block;
    public int index1;
    public int index2;
    public int index3;
    private static SudokuSet candInHouse = new SudokuSet();
    private static SudokuSet tmpSet = new SudokuSet();

    public GroupNode(int cand, SudokuSet indices) {
        this.cand = cand;
        this.indices.set(indices);
        this.index1 = indices.get(0);
        this.index2 = indices.get(1);
        this.index3 = -1;
        if (indices.size() > 2) {
            this.index3 = indices.get(2);
        }
        this.block = Sudoku2.getBlock(this.index1);
        if (Sudoku2.getRow(this.index1) == Sudoku2.getRow(this.index2)) {
            this.line = Sudoku2.getRow(this.index1);
        }
        if (Sudoku2.getCol(this.index1) == Sudoku2.getCol(this.index2)) {
            this.col = Sudoku2.getCol(this.index1);
        }
        this.buddies.set(Sudoku2.buddies[this.index1]);
        this.buddies.and(Sudoku2.buddies[this.index2]);
        if (this.index3 >= 0) {
            this.buddies.and(Sudoku2.buddies[this.index3]);
        }
    }

    public String toString() {
        return "GroupNode: " + this.cand + " - " + SolutionStep.getCompactCellPrint(this.index1, this.index2, this.index3) + "  - " + this.index1 + "/" + this.index2 + "/" + this.index3 + " (" + this.line + "/" + this.col + "/" + this.block + ")";
    }

    public static List<GroupNode> getGroupNodes(SudokuStepFinder finder) {
        ArrayList<GroupNode> groupNodes = new ArrayList<GroupNode>();
        GroupNode.getGroupNodesForHouseType(groupNodes, finder, Sudoku2.ROW_TEMPLATES);
        GroupNode.getGroupNodesForHouseType(groupNodes, finder, Sudoku2.COL_TEMPLATES);
        return groupNodes;
    }

    private static void getGroupNodesForHouseType(List<GroupNode> groupNodes, SudokuStepFinder finder, SudokuSet[] houses) {
        int i = 0;
        while (i < houses.length) {
            int cand = 1;
            while (cand <= 9) {
                candInHouse.set(houses[i]);
                candInHouse.and(finder.getCandidates()[cand]);
                if (!candInHouse.isEmpty()) {
                    int j = 0;
                    while (j < Sudoku2.BLOCK_TEMPLATES.length) {
                        tmpSet.set(candInHouse);
                        tmpSet.and(Sudoku2.BLOCK_TEMPLATES[j]);
                        if (!tmpSet.isEmpty() && tmpSet.size() >= 2) {
                            groupNodes.add(new GroupNode(cand, tmpSet));
                        }
                        ++j;
                    }
                }
                ++cand;
            }
            ++i;
        }
    }
}

