/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import solver.AbstractSolver;
import solver.SudokuStepFinder;
import sudoku.Candidate;
import sudoku.SolutionStep;
import sudoku.SolutionType;
import sudoku.Sudoku2;
import sudoku.SudokuSinglesQueue;
import sudoku.SudokuUtil;

public class SimpleSolver
extends AbstractSolver {
    private boolean[] singleFound = new boolean[81];
    private List<SolutionStep> steps;
    private SolutionStep globalStep = new SolutionStep();
    private boolean[] sameConstraint = new boolean[Sudoku2.CONSTRAINTS[0].length];
    private boolean[] foundConstraint = new boolean[Sudoku2.CONSTRAINTS[0].length];
    private int[] constraint = new int[Sudoku2.CONSTRAINTS[0].length];
    private int[] indices2 = new int[2];
    private int[] indices3 = new int[3];
    private int[] indices4 = new int[4];
    private List<SolutionStep> cachedSteps = new ArrayList<SolutionStep>();
    private int cachedStepsNumber = -1;
    private int[] tmpArr1 = new int[9];
    private short[] ipcMask = new short[10];

    protected SimpleSolver(SudokuStepFinder finder) {
        super(finder);
        this.steps = new ArrayList<SolutionStep>();
    }

    @Override
    protected SolutionStep getStep(SolutionType type) {
        SolutionStep result = null;
        this.sudoku = this.finder.getSudoku();
        switch (type) {
            case FULL_HOUSE: {
                result = this.findFullHouse(false);
                break;
            }
            case HIDDEN_SINGLE: {
                result = this.findHiddenSingle();
                break;
            }
            case HIDDEN_PAIR: {
                result = this.findHiddenXle(2);
                break;
            }
            case HIDDEN_TRIPLE: {
                result = this.findHiddenXle(3);
                break;
            }
            case HIDDEN_QUADRUPLE: {
                result = this.findHiddenXle(4);
                break;
            }
            case NAKED_SINGLE: {
                result = this.findNakedSingle();
                break;
            }
            case LOCKED_PAIR: {
                result = this.findNakedXle(2, true);
                break;
            }
            case NAKED_PAIR: {
                result = this.findNakedXle(2, false);
                break;
            }
            case LOCKED_TRIPLE: {
                result = this.findNakedXle(3, true);
                break;
            }
            case NAKED_TRIPLE: {
                result = this.findNakedXle(3, false);
                break;
            }
            case NAKED_QUADRUPLE: {
                result = this.findNakedXle(4, false);
                break;
            }
            case LOCKED_CANDIDATES: 
            case LOCKED_CANDIDATES_1: 
            case LOCKED_CANDIDATES_2: {
                result = this.findLockedCandidates(type);
                break;
            }
        }
        return result;
    }

    @Override
    protected boolean doStep(SolutionStep step) {
        boolean handled = true;
        this.sudoku = this.finder.getSudoku();
        switch (step.getType()) {
            case FULL_HOUSE: 
            case HIDDEN_SINGLE: 
            case NAKED_SINGLE: {
                this.sudoku.setCell(step.getIndices().get(0), step.getValues().get(0));
                break;
            }
            case HIDDEN_PAIR: 
            case HIDDEN_TRIPLE: 
            case HIDDEN_QUADRUPLE: 
            case NAKED_PAIR: 
            case NAKED_TRIPLE: 
            case NAKED_QUADRUPLE: 
            case LOCKED_PAIR: 
            case LOCKED_TRIPLE: 
            case LOCKED_CANDIDATES: 
            case LOCKED_CANDIDATES_1: 
            case LOCKED_CANDIDATES_2: {
                for (Candidate cand : step.getCandidatesToDelete()) {
                    this.sudoku.delCandidate(cand.getIndex(), cand.getValue());
                }
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    protected List<SolutionStep> findAllFullHouses() {
        this.sudoku = this.finder.getSudoku();
        List<SolutionStep> oldList = this.steps;
        ArrayList<SolutionStep> newList = new ArrayList<SolutionStep>();
        this.steps = newList;
        this.findFullHouse(true);
        Collections.sort(this.steps);
        this.steps = oldList;
        return newList;
    }

    private SolutionStep findFullHouse(boolean all) {
        SolutionStep step = null;
        byte[][] free = this.sudoku.getFree();
        SudokuSinglesQueue nsQueue = this.sudoku.getNsQueue();
        int queueIndex = nsQueue.getFirstIndex();
        while (queueIndex != -1) {
            int index = nsQueue.getIndex(queueIndex);
            int value = nsQueue.getValue(queueIndex);
            if (this.sudoku.getValue(index) == 0) {
                int i = 0;
                while (i < Sudoku2.CONSTRAINTS[index].length) {
                    int constr = Sudoku2.CONSTRAINTS[index][i];
                    boolean valid = true;
                    int j = 1;
                    while (j <= 9) {
                        if (j != value && free[constr][j] != 0) {
                            valid = false;
                            break;
                        }
                        ++j;
                    }
                    if (valid) {
                        step = new SolutionStep(SolutionType.FULL_HOUSE);
                        step.addValue(value);
                        step.addIndex(index);
                        if (all) {
                            this.steps.add(step);
                            break;
                        }
                        return step;
                    }
                    ++i;
                }
            }
            queueIndex = nsQueue.getNextIndex();
        }
        return step;
    }

    private SolutionStep findNakedSingle() {
        SolutionStep step = null;
        SudokuSinglesQueue nsQueue = this.sudoku.getNsQueue();
        int queueIndex = -1;
        while ((queueIndex = nsQueue.getSingle()) != -1) {
            int index = nsQueue.getIndex(queueIndex);
            int value = nsQueue.getValue(queueIndex);
            if (this.sudoku.getValue(index) != 0) continue;
            step = new SolutionStep(SolutionType.NAKED_SINGLE);
            step.addValue(value);
            step.addIndex(index);
            break;
        }
        return step;
    }

    protected List<SolutionStep> findAllNakedSingles() {
        this.sudoku = this.finder.getSudoku();
        List<SolutionStep> oldList = this.steps;
        ArrayList<SolutionStep> newList = new ArrayList<SolutionStep>();
        this.steps = newList;
        SudokuSinglesQueue nsQueue = this.sudoku.getNsQueue();
        int queueIndex = nsQueue.getFirstIndex();
        while (queueIndex != -1) {
            int index = nsQueue.getIndex(queueIndex);
            int value = nsQueue.getValue(queueIndex);
            if (this.sudoku.getValue(index) == 0) {
                SolutionStep step = new SolutionStep(SolutionType.NAKED_SINGLE);
                step.addValue(value);
                step.addIndex(index);
                this.steps.add(step);
            }
            queueIndex = nsQueue.getNextIndex();
        }
        Collections.sort(this.steps);
        this.steps = oldList;
        return newList;
    }

    private SolutionStep findNakedXle(int anz, boolean lockedOnly) {
        SudokuUtil.clearStepList(this.steps);
        if (this.cachedSteps.size() > 0 && this.cachedStepsNumber == this.finder.getStepNumber()) {
            SolutionType type = SolutionType.NAKED_PAIR;
            if (anz == 2 && lockedOnly) {
                type = SolutionType.LOCKED_PAIR;
            }
            if (anz == 3 && !lockedOnly) {
                type = SolutionType.NAKED_TRIPLE;
            }
            if (anz == 3 && lockedOnly) {
                type = SolutionType.LOCKED_TRIPLE;
            }
            if (anz == 4) {
                type = SolutionType.NAKED_QUADRUPLE;
            }
            for (SolutionStep step : this.cachedSteps) {
                if (step.getType() != type) continue;
                return step;
            }
        }
        this.cachedSteps.clear();
        this.cachedStepsNumber = this.finder.getStepNumber();
        SolutionStep step = this.findNakedXleInEntity(Sudoku2.BLOCKS, anz, lockedOnly, !lockedOnly, true);
        if (step != null || lockedOnly) {
            return step;
        }
        step = this.findNakedXleInEntity(Sudoku2.ROWS, anz, lockedOnly, !lockedOnly, true);
        if (step != null) {
            return step;
        }
        step = this.findNakedXleInEntity(Sudoku2.COLS, anz, lockedOnly, !lockedOnly, true);
        return step;
    }

    protected List<SolutionStep> findAllNakedXle() {
        this.sudoku = this.finder.getSudoku();
        List<SolutionStep> oldList = this.steps;
        ArrayList<SolutionStep> newList = new ArrayList<SolutionStep>();
        this.steps = newList;
        List<SolutionStep> tmpSteps = this.findAllNakedSingles();
        this.steps.addAll(tmpSteps);
        int i = 2;
        while (i <= 4) {
            this.findNakedXleInEntity(Sudoku2.BLOCKS, i, false, false, false);
            this.findNakedXleInEntity(Sudoku2.ROWS, i, false, false, false);
            this.findNakedXleInEntity(Sudoku2.COLS, i, false, false, false);
            ++i;
        }
        Collections.sort(this.steps);
        this.steps = oldList;
        return newList;
    }

    private SolutionStep findNakedXleInEntity(int[][] indices, int anz, boolean lockedOnly, boolean nakedOnly, boolean onlyOne) {
        SolutionStep step = null;
        int entity = 0;
        while (entity < indices.length) {
            int maxIndex = 0;
            int i = 0;
            while (i < indices[entity].length) {
                int tmpAnz = Sudoku2.ANZ_VALUES[this.sudoku.getCell(indices[entity][i])];
                if (tmpAnz != 0 && tmpAnz <= anz) {
                    this.tmpArr1[maxIndex++] = indices[entity][i];
                }
                ++i;
            }
            if (maxIndex >= anz) {
                int i1 = 0;
                while (i1 < maxIndex - anz + 1) {
                    short cell1 = this.sudoku.getCell(this.tmpArr1[i1]);
                    int i2 = i1 + 1;
                    while (i2 < maxIndex - anz + 2) {
                        short cell2 = (short)(cell1 | this.sudoku.getCell(this.tmpArr1[i2]));
                        if (Sudoku2.ANZ_VALUES[cell2] <= anz) {
                            if (anz == 2) {
                                if (Sudoku2.ANZ_VALUES[cell2] == anz && (step = this.createSubsetStep(this.tmpArr1[i1], this.tmpArr1[i2], -1, -1, cell2, SolutionType.NAKED_PAIR, lockedOnly, nakedOnly)) != null && onlyOne) {
                                    return step;
                                }
                            } else {
                                int i3 = i2 + 1;
                                while (i3 < maxIndex - anz + 3) {
                                    short cell3 = (short)(cell2 | this.sudoku.getCell(this.tmpArr1[i3]));
                                    if (Sudoku2.ANZ_VALUES[cell3] <= anz) {
                                        if (anz == 3) {
                                            if (Sudoku2.ANZ_VALUES[cell3] == anz && (step = this.createSubsetStep(this.tmpArr1[i1], this.tmpArr1[i2], this.tmpArr1[i3], -1, cell3, SolutionType.NAKED_TRIPLE, lockedOnly, nakedOnly)) != null && onlyOne) {
                                                return step;
                                            }
                                        } else {
                                            int i4 = i3 + 1;
                                            while (i4 < maxIndex) {
                                                short cell4 = (short)(cell3 | this.sudoku.getCell(this.tmpArr1[i4]));
                                                if (Sudoku2.ANZ_VALUES[cell4] <= anz && Sudoku2.ANZ_VALUES[cell4] == anz && (step = this.createSubsetStep(this.tmpArr1[i1], this.tmpArr1[i2], this.tmpArr1[i3], this.tmpArr1[i4], cell4, SolutionType.NAKED_QUADRUPLE, lockedOnly, nakedOnly)) != null && onlyOne) {
                                                    return step;
                                                }
                                                ++i4;
                                            }
                                        }
                                    }
                                    ++i3;
                                }
                            }
                        }
                        ++i2;
                    }
                    ++i1;
                }
            }
            ++entity;
        }
        return null;
    }

    private SolutionStep findHiddenSingle() {
        SolutionStep step = null;
        byte[][] free = this.sudoku.getFree();
        SudokuSinglesQueue hsQueue = this.sudoku.getHsQueue();
        int queueIndex = -1;
        block0: while ((queueIndex = hsQueue.getSingle()) != -1) {
            int index = hsQueue.getIndex(queueIndex);
            int value = hsQueue.getValue(queueIndex);
            if (this.sudoku.getValue(index) != 0) continue;
            int i = 0;
            while (i < Sudoku2.CONSTRAINTS[index].length) {
                if (free[Sudoku2.CONSTRAINTS[index][i]][value] == 1) {
                    step = new SolutionStep(SolutionType.HIDDEN_SINGLE);
                    step.addValue(value);
                    step.addIndex(index);
                    break block0;
                }
                ++i;
            }
            break block0;
        }
        return step;
    }

    protected List<SolutionStep> findAllHiddenSingles() {
        this.sudoku = this.finder.getSudoku();
        List<SolutionStep> oldList = this.steps;
        ArrayList<SolutionStep> newList = new ArrayList<SolutionStep>();
        this.steps = newList;
        Arrays.fill(this.singleFound, false);
        byte[][] free = this.sudoku.getFree();
        SudokuSinglesQueue hsQueue = this.sudoku.getHsQueue();
        int queueIndex = hsQueue.getFirstIndex();
        while (queueIndex != -1) {
            int index = hsQueue.getIndex(queueIndex);
            int value = hsQueue.getValue(queueIndex);
            if (this.sudoku.getValue(index) == 0 && !this.singleFound[index]) {
                int i = 0;
                while (i < Sudoku2.CONSTRAINTS[index].length) {
                    if (free[Sudoku2.CONSTRAINTS[index][i]][value] == 1) {
                        SolutionStep step = new SolutionStep(SolutionType.HIDDEN_SINGLE);
                        step.addValue(value);
                        step.addIndex(index);
                        step.setEntity(i);
                        this.steps.add(step);
                        this.singleFound[index] = true;
                        break;
                    }
                    ++i;
                }
            }
            queueIndex = hsQueue.getNextIndex();
        }
        Collections.sort(this.steps);
        this.steps = oldList;
        return newList;
    }

    protected List<SolutionStep> findAllHiddenXle() {
        this.sudoku = this.finder.getSudoku();
        List<SolutionStep> oldList = this.steps;
        ArrayList<SolutionStep> newList = new ArrayList<SolutionStep>();
        this.steps = newList;
        List<SolutionStep> tmpSteps = this.findAllHiddenSingles();
        this.steps.addAll(tmpSteps);
        int i = 2;
        while (i <= 4) {
            this.findHiddenXleInEntity(18, Sudoku2.BLOCKS, i, false);
            this.findHiddenXleInEntity(0, Sudoku2.ROWS, i, false);
            this.findHiddenXleInEntity(9, Sudoku2.COLS, i, false);
            ++i;
        }
        Collections.sort(this.steps);
        this.steps = oldList;
        return newList;
    }

    private SolutionStep findHiddenXle(int anz) {
        SudokuUtil.clearStepList(this.steps);
        SolutionStep step = this.findHiddenXleInEntity(18, Sudoku2.BLOCKS, anz, true);
        if (step != null) {
            return step;
        }
        step = this.findHiddenXleInEntity(0, Sudoku2.ROWS, anz, true);
        if (step != null) {
            return step;
        }
        step = this.findHiddenXleInEntity(9, Sudoku2.COLS, anz, true);
        return step;
    }

    private SolutionStep findHiddenXleInEntity(int constraintBase, int[][] indices, int anz, boolean onlyOne) {
        SolutionStep step = null;
        int entity = 0;
        while (entity < indices.length) {
            int maxIndex = 0;
            int i = 0;
            while (i < indices[entity].length) {
                if (this.sudoku.getCell(indices[entity][i]) != 0) {
                    ++maxIndex;
                }
                ++i;
            }
            if (maxIndex > anz) {
                int candMask = 0;
                byte[][] free = this.sudoku.getFree();
                int i2 = 1;
                while (i2 <= 9) {
                    byte actFree = free[constraintBase + entity][i2];
                    if (actFree != 0 && actFree <= anz) {
                        candMask = (short)(candMask | Sudoku2.MASKS[i2]);
                        this.ipcMask[i2] = 0;
                        int j = 0;
                        while (j < 9) {
                            if ((this.sudoku.getCell(indices[entity][j]) & Sudoku2.MASKS[i2]) != 0) {
                                int n = i2;
                                this.ipcMask[n] = (short)(this.ipcMask[n] | Sudoku2.MASKS[j + 1]);
                            }
                            ++j;
                        }
                    }
                    ++i2;
                }
                if (Sudoku2.ANZ_VALUES[candMask] >= anz) {
                    int[] candArr = Sudoku2.POSSIBLE_VALUES[candMask];
                    int i1 = 0;
                    while (i1 < candArr.length - anz + 1) {
                        short cand1 = Sudoku2.MASKS[candArr[i1]];
                        short cell1 = this.ipcMask[candArr[i1]];
                        int i22 = i1 + 1;
                        while (i22 < candArr.length - anz + 2) {
                            short cand2 = (short)(cand1 | Sudoku2.MASKS[candArr[i22]]);
                            short cell2 = (short)(cell1 | this.ipcMask[candArr[i22]]);
                            if (anz == 2) {
                                int[] tmp;
                                if (Sudoku2.ANZ_VALUES[cell2] == anz && (step = this.createSubsetStep(indices[entity][(tmp = Sudoku2.POSSIBLE_VALUES[cell2])[0] - 1], indices[entity][tmp[1] - 1], -1, -1, cand2, SolutionType.HIDDEN_PAIR, onlyOne, onlyOne)) != null && onlyOne) {
                                    return step;
                                }
                            } else {
                                int i3 = i22 + 1;
                                while (i3 < candArr.length - anz + 3) {
                                    short cand3 = (short)(cand2 | Sudoku2.MASKS[candArr[i3]]);
                                    short cell3 = (short)(cell2 | this.ipcMask[candArr[i3]]);
                                    if (anz == 3) {
                                        int[] tmp;
                                        if (Sudoku2.ANZ_VALUES[cell3] == anz && (step = this.createSubsetStep(indices[entity][(tmp = Sudoku2.POSSIBLE_VALUES[cell3])[0] - 1], indices[entity][tmp[1] - 1], indices[entity][tmp[2] - 1], -1, cand3, SolutionType.HIDDEN_TRIPLE, onlyOne, onlyOne)) != null && onlyOne) {
                                            return step;
                                        }
                                    } else {
                                        int i4 = i3 + 1;
                                        while (i4 < candArr.length) {
                                            int[] tmp;
                                            short cand4 = (short)(cand3 | Sudoku2.MASKS[candArr[i4]]);
                                            short cell4 = (short)(cell3 | this.ipcMask[candArr[i4]]);
                                            if (Sudoku2.ANZ_VALUES[cell4] == anz && (step = this.createSubsetStep(indices[entity][(tmp = Sudoku2.POSSIBLE_VALUES[cell4])[0] - 1], indices[entity][tmp[1] - 1], indices[entity][tmp[2] - 1], indices[entity][tmp[3] - 1], cand4, SolutionType.HIDDEN_QUADRUPLE, onlyOne, onlyOne)) != null && onlyOne) {
                                                return step;
                                            }
                                            ++i4;
                                        }
                                    }
                                    ++i3;
                                }
                            }
                            ++i22;
                        }
                        ++i1;
                    }
                }
            }
            ++entity;
        }
        return null;
    }

    private SolutionStep findLockedCandidates(SolutionType type) {
        SudokuUtil.clearStepList(this.steps);
        SolutionStep step = null;
        if ((type == SolutionType.LOCKED_CANDIDATES || type == SolutionType.LOCKED_CANDIDATES_1) && (step = this.findLockedCandidatesInEntityN(18, Sudoku2.BLOCKS, true)) != null) {
            return step;
        }
        if (type == SolutionType.LOCKED_CANDIDATES || type == SolutionType.LOCKED_CANDIDATES_2) {
            step = this.findLockedCandidatesInEntityN(0, Sudoku2.ROWS, true);
            if (step != null) {
                return step;
            }
            step = this.findLockedCandidatesInEntityN(9, Sudoku2.COLS, true);
            if (step != null) {
                return step;
            }
        }
        return null;
    }

    protected List<SolutionStep> findAllLockedCandidates() {
        this.sudoku = this.finder.getSudoku();
        List<SolutionStep> oldList = this.steps;
        ArrayList<SolutionStep> newList = new ArrayList<SolutionStep>();
        this.steps = newList;
        this.findLockedCandidatesInEntityN(18, Sudoku2.BLOCKS, false);
        this.findLockedCandidatesInEntityN(0, Sudoku2.ROWS, false);
        this.findLockedCandidatesInEntityN(9, Sudoku2.COLS, false);
        Collections.sort(this.steps);
        this.steps = oldList;
        return newList;
    }

    private SolutionStep findLockedCandidatesInEntityN(int constraintBase, int[][] indices, boolean onlyOne) {
        SolutionStep step = null;
        byte[][] free = this.sudoku.getFree();
        int constr = 0;
        while (constr < 9) {
            int cand = 1;
            while (cand <= 9) {
                block13: {
                    int skipConstraint;
                    byte unitFree;
                    block14: {
                        int aktConstraint;
                        block16: {
                            block15: {
                                unitFree = free[constr + constraintBase][cand];
                                if (unitFree != 2 && unitFree != 3) break block13;
                                boolean first = true;
                                this.sameConstraint[2] = true;
                                this.sameConstraint[1] = true;
                                this.sameConstraint[0] = true;
                                int i = 0;
                                while (i < indices[constr].length) {
                                    int index = indices[constr][i];
                                    short cell = this.sudoku.getCell(index);
                                    if ((cell & Sudoku2.MASKS[cand]) != 0) {
                                        if (first) {
                                            this.constraint[0] = Sudoku2.CONSTRAINTS[index][0];
                                            this.constraint[1] = Sudoku2.CONSTRAINTS[index][1];
                                            this.constraint[2] = Sudoku2.CONSTRAINTS[index][2];
                                            first = false;
                                        } else {
                                            int j = 0;
                                            while (j < Sudoku2.CONSTRAINTS[0].length) {
                                                if (this.sameConstraint[j] && this.constraint[j] != Sudoku2.CONSTRAINTS[index][j]) {
                                                    this.sameConstraint[j] = false;
                                                }
                                                ++j;
                                            }
                                        }
                                    }
                                    ++i;
                                }
                                skipConstraint = constraintBase + constr;
                                aktConstraint = -1;
                                if (constraintBase != 18) break block14;
                                if (!this.sameConstraint[0] || free[this.constraint[0]][cand] <= unitFree) break block15;
                                aktConstraint = this.constraint[0];
                                break block16;
                            }
                            if (!this.sameConstraint[1] || free[this.constraint[1]][cand] <= unitFree) break block13;
                            aktConstraint = this.constraint[1];
                        }
                        step = this.createLockedCandidatesStep(SolutionType.LOCKED_CANDIDATES_1, cand, skipConstraint, Sudoku2.ALL_UNITS[aktConstraint]);
                        if (onlyOne) {
                            return step;
                        }
                        this.steps.add(step);
                        break block13;
                    }
                    if (this.sameConstraint[2] && free[this.constraint[2]][cand] > unitFree) {
                        step = this.createLockedCandidatesStep(SolutionType.LOCKED_CANDIDATES_2, cand, skipConstraint, Sudoku2.ALL_UNITS[this.constraint[2]]);
                        if (onlyOne) {
                            return step;
                        }
                        this.steps.add(step);
                    }
                }
                ++cand;
            }
            ++constr;
        }
        return null;
    }

    private SolutionStep createLockedCandidatesStep(SolutionType type, int cand, int skipConstraint, int[] indices) {
        this.globalStep.reset();
        this.globalStep.setType(type);
        this.globalStep.addValue(cand);
        this.globalStep.setEntity(Sudoku2.CONSTRAINT_TYPE_FROM_CONSTRAINT[skipConstraint]);
        this.globalStep.setEntityNumber(Sudoku2.CONSTRAINT_NUMBER_FROM_CONSTRAINT[skipConstraint]);
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if ((this.sudoku.getCell(index) & Sudoku2.MASKS[cand]) != 0) {
                if (Sudoku2.CONSTRAINTS[index][0] == skipConstraint || Sudoku2.CONSTRAINTS[index][1] == skipConstraint || Sudoku2.CONSTRAINTS[index][2] == skipConstraint) {
                    this.globalStep.addIndex(index);
                } else {
                    this.globalStep.addCandidateToDelete(index, cand);
                }
            }
            ++i;
        }
        return (SolutionStep)this.globalStep.clone();
    }

    private SolutionStep createSubsetStep(int i1, int i2, int i3, int i4, short cands, SolutionType type, boolean lockedOnly, boolean nakedOnly) {
        if (i4 >= 0) {
            this.indices4[0] = i1;
            this.indices4[1] = i2;
            this.indices4[2] = i3;
            this.indices4[3] = i4;
            return this.createSubsetStep(this.indices4, cands, type, lockedOnly, nakedOnly);
        }
        if (i3 >= 0) {
            this.indices3[0] = i1;
            this.indices3[1] = i2;
            this.indices3[2] = i3;
            return this.createSubsetStep(this.indices3, cands, type, lockedOnly, nakedOnly);
        }
        this.indices2[0] = i1;
        this.indices2[1] = i2;
        return this.createSubsetStep(this.indices2, cands, type, lockedOnly, nakedOnly);
    }

    private SolutionStep createSubsetStep(int[] indices, short cands, SolutionType type, boolean lockedOnly, boolean nakedHiddenOnly) {
        int i;
        this.globalStep.reset();
        this.globalStep.setType(type);
        this.sameConstraint[2] = true;
        this.sameConstraint[1] = true;
        this.sameConstraint[0] = true;
        this.constraint[0] = Sudoku2.CONSTRAINTS[indices[0]][0];
        this.constraint[1] = Sudoku2.CONSTRAINTS[indices[0]][1];
        this.constraint[2] = Sudoku2.CONSTRAINTS[indices[0]][2];
        int i2 = 1;
        while (i2 < indices.length) {
            int j = 0;
            while (j < Sudoku2.CONSTRAINTS[0].length) {
                if (this.sameConstraint[j] && this.constraint[j] != Sudoku2.CONSTRAINTS[indices[i2]][j]) {
                    this.sameConstraint[j] = false;
                }
                ++j;
            }
            ++i2;
        }
        int anzFoundConstraints = 0;
        if (type.isHiddenSubset()) {
            i = 0;
            while (i < indices.length) {
                short candsToDelete = (short)(this.sudoku.getCell(indices[i]) & ~cands);
                if (candsToDelete != 0) {
                    int[] candArray = Sudoku2.POSSIBLE_VALUES[candsToDelete];
                    int k = 0;
                    while (k < candArray.length) {
                        this.globalStep.addCandidateToDelete(indices[i], candArray[k]);
                        ++k;
                    }
                }
                ++i;
            }
        } else {
            this.foundConstraint[2] = false;
            this.foundConstraint[1] = false;
            this.foundConstraint[0] = false;
            i = 0;
            while (i < this.sameConstraint.length) {
                if (this.sameConstraint[i]) {
                    int[] cells = Sudoku2.ALL_UNITS[this.constraint[i]];
                    int j = 0;
                    while (j < cells.length) {
                        short candsToDelete;
                        boolean skip = false;
                        int k = 0;
                        while (k < indices.length) {
                            if (cells[j] == indices[k]) {
                                skip = true;
                                break;
                            }
                            ++k;
                        }
                        if (!skip && (candsToDelete = (short)(this.sudoku.getCell(cells[j]) & cands)) != 0) {
                            int[] candArray = Sudoku2.POSSIBLE_VALUES[candsToDelete];
                            int k2 = 0;
                            while (k2 < candArray.length) {
                                this.globalStep.addCandidateToDelete(cells[j], candArray[k2]);
                                if (!(this.foundConstraint[i] || i != 2 && Sudoku2.CONSTRAINTS[cells[j]][2] == this.constraint[2])) {
                                    this.foundConstraint[i] = true;
                                    ++anzFoundConstraints;
                                }
                                ++k2;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (this.globalStep.getAnzCandidatesToDelete() == 0) {
            return null;
        }
        boolean isLocked = false;
        if (indices.length < 4 && anzFoundConstraints > 1 && !type.isHiddenSubset() && (this.sameConstraint[2] && this.sameConstraint[0] || this.sameConstraint[2] && this.sameConstraint[1])) {
            isLocked = true;
        }
        if (isLocked) {
            if (type == SolutionType.NAKED_PAIR) {
                this.globalStep.setType(SolutionType.LOCKED_PAIR);
            }
            if (type == SolutionType.NAKED_TRIPLE) {
                this.globalStep.setType(SolutionType.LOCKED_TRIPLE);
            }
        }
        int i3 = 0;
        while (i3 < indices.length) {
            this.globalStep.addIndex(indices[i3]);
            ++i3;
        }
        int[] candArray = Sudoku2.POSSIBLE_VALUES[cands];
        int i4 = 0;
        while (i4 < candArray.length) {
            this.globalStep.addValue(candArray[i4]);
            ++i4;
        }
        SolutionStep step = (SolutionStep)this.globalStep.clone();
        if (lockedOnly && !nakedHiddenOnly) {
            if (!isLocked) {
                this.cachedSteps.add(step);
                step = null;
            }
        } else if (nakedHiddenOnly && !lockedOnly) {
            if (isLocked) {
                this.cachedSteps.add(step);
                step = null;
            }
        } else if (!lockedOnly && !nakedHiddenOnly) {
            this.steps.add(step);
        }
        return step;
    }
}

