/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import solver.AbstractSolver;
import solver.SudokuStepFinder;
import sudoku.Candidate;
import sudoku.Options;
import sudoku.SolutionStep;
import sudoku.SolutionType;
import sudoku.Sudoku2;
import sudoku.SudokuSet;

public class SingleDigitPatternSolver
extends AbstractSolver {
    private static final int[][] erOffsets;
    private static final int[] erLineOffsets;
    private static final int[] erColOffsets;
    private static final SudokuSet[][] erSets;
    private static final int[][] erLines;
    private static final int[][] erCols;
    private SudokuSet blockCands = new SudokuSet();
    private SudokuSet tmpSet = new SudokuSet();
    private List<SolutionStep> steps = new ArrayList<SolutionStep>();
    private SolutionStep globalStep = new SolutionStep();
    private int[][] only2Indices = new int[18][2];
    private SudokuSet firstUnit = new SudokuSet();

    static {
        int[][] nArrayArray = new int[9][];
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 9;
        nArray[3] = 10;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 2;
        nArray2[2] = 9;
        nArray2[3] = 11;
        nArrayArray[1] = nArray2;
        nArrayArray[2] = new int[]{1, 2, 10, 11};
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[2] = 18;
        nArray3[3] = 19;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[1] = 2;
        nArray4[2] = 18;
        nArray4[3] = 20;
        nArrayArray[4] = nArray4;
        nArrayArray[5] = new int[]{1, 2, 19, 20};
        nArrayArray[6] = new int[]{9, 10, 18, 19};
        nArrayArray[7] = new int[]{9, 11, 18, 20};
        nArrayArray[8] = new int[]{10, 11, 19, 20};
        erOffsets = nArrayArray;
        int[] nArray5 = new int[9];
        nArray5[0] = 2;
        nArray5[1] = 2;
        nArray5[2] = 2;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArray5[5] = 1;
        erLineOffsets = nArray5;
        int[] nArray6 = new int[9];
        nArray6[0] = 2;
        nArray6[1] = 1;
        nArray6[3] = 2;
        nArray6[4] = 1;
        nArray6[6] = 2;
        nArray6[7] = 1;
        erColOffsets = nArray6;
        erSets = new SudokuSet[9][9];
        erLines = new int[9][9];
        erCols = new int[9][9];
        int indexOffset = 0;
        int lineOffset = 0;
        int colOffset = 0;
        int i = 0;
        while (i < Sudoku2.BLOCKS.length) {
            int j = 0;
            while (j < erOffsets.length) {
                SingleDigitPatternSolver.erSets[i][j] = new SudokuSet();
                int k = 0;
                while (k < erOffsets[j].length) {
                    erSets[i][j].add(erOffsets[j][k] + indexOffset);
                    ++k;
                }
                ++j;
            }
            SingleDigitPatternSolver.erLines[i] = new int[9];
            SingleDigitPatternSolver.erCols[i] = new int[9];
            j = 0;
            while (j < erLineOffsets.length) {
                SingleDigitPatternSolver.erLines[i][j] = erLineOffsets[j] + lineOffset;
                SingleDigitPatternSolver.erCols[i][j] = erColOffsets[j] + colOffset;
                ++j;
            }
            indexOffset += 3;
            colOffset += 3;
            if (i % 3 == 2) {
                indexOffset += 18;
                lineOffset += 3;
                colOffset = 0;
            }
            ++i;
        }
    }

    protected SingleDigitPatternSolver(SudokuStepFinder finder) {
        super(finder);
    }

    @Override
    protected SolutionStep getStep(SolutionType type) {
        SolutionStep result = null;
        this.sudoku = this.finder.getSudoku();
        switch (type) {
            case SKYSCRAPER: {
                result = this.findSkyscraper();
                break;
            }
            case TWO_STRING_KITE: {
                result = this.findTwoStringKite();
                break;
            }
            case EMPTY_RECTANGLE: {
                result = this.findEmptyRectangle();
                break;
            }
        }
        return result;
    }

    @Override
    protected boolean doStep(SolutionStep step) {
        boolean handled = true;
        this.sudoku = this.finder.getSudoku();
        switch (step.getType()) {
            case SKYSCRAPER: 
            case TWO_STRING_KITE: 
            case EMPTY_RECTANGLE: 
            case DUAL_TWO_STRING_KITE: 
            case DUAL_EMPTY_RECTANGLE: {
                for (Candidate cand : step.getCandidatesToDelete()) {
                    this.sudoku.delCandidate(cand.getIndex(), cand.getValue());
                }
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    protected List<SolutionStep> findAllEmptyRectangles() {
        this.sudoku = this.finder.getSudoku();
        List<SolutionStep> oldList = this.steps;
        ArrayList<SolutionStep> newList = new ArrayList<SolutionStep>();
        this.steps = newList;
        this.findEmptyRectangles(false);
        this.findDualEmptyRectangles(this.steps);
        Collections.sort(this.steps);
        this.steps = oldList;
        return newList;
    }

    protected SolutionStep findEmptyRectangle() {
        this.steps.clear();
        SolutionStep step = this.findEmptyRectangles(true);
        if (step != null && !Options.getInstance().isAllowDualsAndSiamese()) {
            return step;
        }
        if (this.steps.size() > 0 && Options.getInstance().isAllowDualsAndSiamese()) {
            this.findDualEmptyRectangles(this.steps);
            Collections.sort(this.steps);
            return this.steps.get(0);
        }
        return null;
    }

    private SolutionStep findEmptyRectangles(boolean onlyOne) {
        int i = 1;
        while (i <= 9) {
            SolutionStep step = this.findEmptyRectanglesForCandidate(i, onlyOne);
            if (step != null && onlyOne && !Options.getInstance().isAllowDualsAndSiamese()) {
                return step;
            }
            ++i;
        }
        return null;
    }

    private SolutionStep findEmptyRectanglesForCandidate(int cand, boolean onlyOne) {
        byte[][] free = this.sudoku.getFree();
        int i = 0;
        while (i < Sudoku2.BLOCK_TEMPLATES.length) {
            if (free[18 + i][cand] >= 2 && free[18 + i][cand] <= 5) {
                this.blockCands.set(this.finder.getCandidates()[cand]);
                this.blockCands.and(Sudoku2.BLOCK_TEMPLATES[i]);
                int j = 0;
                while (j < erSets[i].length) {
                    int erLine = 0;
                    int erCol = 0;
                    boolean notEnoughCandidates = true;
                    this.tmpSet.setAnd(this.blockCands, erSets[i][j]);
                    if (this.tmpSet.isEmpty()) {
                        this.tmpSet.setAnd(this.blockCands, Sudoku2.ROW_TEMPLATES[erLines[i][j]]);
                        if (this.tmpSet.size() >= 2) {
                            notEnoughCandidates = false;
                        }
                        this.tmpSet.andNot(Sudoku2.COL_TEMPLATES[erCols[i][j]]);
                        if (!this.tmpSet.isEmpty()) {
                            erLine = erLines[i][j];
                            this.tmpSet.setAnd(this.blockCands, Sudoku2.COL_TEMPLATES[erCols[i][j]]);
                            if (this.tmpSet.size() >= 2) {
                                notEnoughCandidates = false;
                            }
                            this.tmpSet.andNot(Sudoku2.ROW_TEMPLATES[erLines[i][j]]);
                            if (!this.tmpSet.isEmpty()) {
                                erCol = erCols[i][j];
                                if (!notEnoughCandidates || Options.getInstance().isAllowErsWithOnlyTwoCandidates()) {
                                    SolutionStep step = this.checkEmptyRectangle(cand, i, this.blockCands, Sudoku2.ROWS[erLine], Sudoku2.ROW_TEMPLATES, Sudoku2.COL_TEMPLATES, erCol, false, onlyOne);
                                    if (onlyOne && step != null && !Options.getInstance().isAllowDualsAndSiamese()) {
                                        return step;
                                    }
                                    step = this.checkEmptyRectangle(cand, i, this.blockCands, Sudoku2.COLS[erCol], Sudoku2.COL_TEMPLATES, Sudoku2.ROW_TEMPLATES, erLine, true, onlyOne);
                                    if (onlyOne && step != null && !Options.getInstance().isAllowDualsAndSiamese()) {
                                        return step;
                                    }
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private SolutionStep checkEmptyRectangle(int cand, int block, SudokuSet blockCands, int[] indices, SudokuSet[] lineTemplates, SudokuSet[] colTemplates, int firstCol, boolean lineColReversed, boolean onlyOne) {
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (this.sudoku.getValue(index) == 0 && Sudoku2.getBlock(index) != block && this.sudoku.isCandidate(index, cand)) {
                this.tmpSet.set(this.finder.getCandidates()[cand]);
                int actCol = Sudoku2.getCol(index);
                if (lineColReversed) {
                    actCol = Sudoku2.getRow(index);
                }
                this.tmpSet.and(colTemplates[actCol]);
                if (this.tmpSet.size() == 2) {
                    int index2 = this.tmpSet.get(0);
                    if (index2 == index) {
                        index2 = this.tmpSet.get(1);
                    }
                    int actLine = Sudoku2.getRow(index2);
                    if (lineColReversed) {
                        actLine = Sudoku2.getCol(index2);
                    }
                    this.tmpSet.set(this.finder.getCandidates()[cand]);
                    this.tmpSet.and(lineTemplates[actLine]);
                    int j = 0;
                    while (j < this.tmpSet.size()) {
                        int indexDel = this.tmpSet.get(j);
                        if (Sudoku2.getBlock(indexDel) != block) {
                            int colDel = Sudoku2.getCol(indexDel);
                            if (lineColReversed) {
                                colDel = Sudoku2.getRow(indexDel);
                            }
                            if (colDel == firstCol) {
                                this.globalStep.reset();
                                this.globalStep.setType(SolutionType.EMPTY_RECTANGLE);
                                this.globalStep.setEntity(0);
                                this.globalStep.setEntityNumber(block + 1);
                                this.globalStep.addValue(cand);
                                this.globalStep.addIndex(index);
                                this.globalStep.addIndex(index2);
                                int k = 0;
                                while (k < blockCands.size()) {
                                    this.globalStep.addFin(blockCands.get(k), cand);
                                    ++k;
                                }
                                this.globalStep.addCandidateToDelete(indexDel, cand);
                                SolutionStep step = (SolutionStep)this.globalStep.clone();
                                if (onlyOne && !Options.getInstance().isAllowDualsAndSiamese()) {
                                    return step;
                                }
                                this.steps.add(step);
                                break;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private void findDualEmptyRectangles(List<SolutionStep> ers) {
        if (!Options.getInstance().isAllowDualsAndSiamese()) {
            return;
        }
        int maxIndex = ers.size();
        int i = 0;
        while (i < maxIndex - 1) {
            int j = i + 1;
            while (j < maxIndex) {
                SolutionStep step1 = ers.get(i);
                SolutionStep step2 = ers.get(j);
                if (step1.getEntity() == step2.getEntity() && step1.getEntityNumber() == step2.getEntityNumber() && step1.getFins().size() == step2.getFins().size()) {
                    boolean finsEqual = true;
                    int k = 0;
                    while (k < step1.getFins().size()) {
                        if (!step1.getFins().get(k).equals(step2.getFins().get(k))) {
                            finsEqual = false;
                            break;
                        }
                        ++k;
                    }
                    if (finsEqual && !step1.getCandidatesToDelete().get(0).equals(step2.getCandidatesToDelete().get(0))) {
                        SolutionStep dual = (SolutionStep)step1.clone();
                        dual.setType(SolutionType.DUAL_EMPTY_RECTANGLE);
                        dual.addIndex(step2.getIndices().get(0));
                        dual.addIndex(step2.getIndices().get(1));
                        dual.addCandidateToDelete(step2.getCandidatesToDelete().get(0));
                        ers.add(dual);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected List<SolutionStep> findAllSkyscrapers() {
        this.sudoku = this.finder.getSudoku();
        List<SolutionStep> oldList = this.steps;
        ArrayList<SolutionStep> newList = new ArrayList<SolutionStep>();
        this.steps = newList;
        this.findSkyscraper(true, false);
        this.findSkyscraper(false, false);
        Collections.sort(this.steps);
        this.steps = oldList;
        return newList;
    }

    protected SolutionStep findSkyscraper() {
        this.steps.clear();
        SolutionStep step = this.findSkyscraper(true, true);
        if (step != null) {
            return step;
        }
        return this.findSkyscraper(false, true);
    }

    private SolutionStep findSkyscraper(boolean lines, boolean onlyOne) {
        int cStart = 0;
        int cEnd = 9;
        if (!lines) {
            cStart += 9;
            cEnd += 9;
        }
        byte[][] free = this.sudoku.getFree();
        int cand = 1;
        while (cand <= 9) {
            int constrCount = 0;
            int constr = cStart;
            while (constr < cEnd) {
                if (free[constr][cand] == 2) {
                    int[] indices = Sudoku2.ALL_UNITS[constr];
                    int candIndex = 0;
                    int i = 0;
                    while (i < indices.length) {
                        if (this.sudoku.isCandidate(indices[i], cand)) {
                            this.only2Indices[constrCount][candIndex++] = indices[i];
                            if (candIndex >= 2) break;
                        }
                        ++i;
                    }
                    ++constrCount;
                }
                ++constr;
            }
            int i = 0;
            while (i < constrCount) {
                int j = i + 1;
                while (j < constrCount) {
                    boolean found = false;
                    int otherIndex = 1;
                    if (lines) {
                        if (Sudoku2.getCol(this.only2Indices[i][0]) == Sudoku2.getCol(this.only2Indices[j][0])) {
                            found = true;
                        }
                        if (!found && Sudoku2.getCol(this.only2Indices[i][1]) == Sudoku2.getCol(this.only2Indices[j][1])) {
                            found = true;
                            otherIndex = 0;
                        }
                    } else {
                        if (Sudoku2.getRow(this.only2Indices[i][0]) == Sudoku2.getRow(this.only2Indices[j][0])) {
                            found = true;
                        }
                        if (!found && Sudoku2.getRow(this.only2Indices[i][1]) == Sudoku2.getRow(this.only2Indices[j][1])) {
                            found = true;
                            otherIndex = 0;
                        }
                    }
                    if (!(!found || lines && Sudoku2.getCol(this.only2Indices[i][otherIndex]) == Sudoku2.getCol(this.only2Indices[j][otherIndex]) || !lines && Sudoku2.getRow(this.only2Indices[i][otherIndex]) == Sudoku2.getRow(this.only2Indices[j][otherIndex]))) {
                        this.firstUnit.setAnd(this.finder.getCandidates()[cand], Sudoku2.buddies[this.only2Indices[i][otherIndex]]);
                        this.firstUnit.and(Sudoku2.buddies[this.only2Indices[j][otherIndex]]);
                        if (!this.firstUnit.isEmpty()) {
                            SolutionStep step = new SolutionStep(SolutionType.SKYSCRAPER);
                            step.addValue(cand);
                            if (otherIndex == 0) {
                                step.addIndex(this.only2Indices[i][0]);
                                step.addIndex(this.only2Indices[j][0]);
                                step.addIndex(this.only2Indices[i][1]);
                                step.addIndex(this.only2Indices[j][1]);
                            } else {
                                step.addIndex(this.only2Indices[i][1]);
                                step.addIndex(this.only2Indices[j][1]);
                                step.addIndex(this.only2Indices[i][0]);
                                step.addIndex(this.only2Indices[j][0]);
                            }
                            int k = 0;
                            while (k < this.firstUnit.size()) {
                                step.addCandidateToDelete(this.firstUnit.get(k), cand);
                                ++k;
                            }
                            if (onlyOne) {
                                return step;
                            }
                            this.steps.add(step);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++cand;
        }
        return null;
    }

    protected List<SolutionStep> findAllTwoStringKites() {
        this.sudoku = this.finder.getSudoku();
        List<SolutionStep> oldList = this.steps;
        ArrayList<SolutionStep> newList = new ArrayList<SolutionStep>();
        this.steps = newList;
        this.findTwoStringKite(false);
        if (Options.getInstance().isAllowDualsAndSiamese()) {
            this.findDualTwoStringKites(this.steps);
        }
        Collections.sort(this.steps);
        this.steps = oldList;
        return newList;
    }

    protected SolutionStep findTwoStringKite() {
        this.steps.clear();
        SolutionStep step = this.findTwoStringKite(true);
        if (step != null && !Options.getInstance().isAllowDualsAndSiamese()) {
            return step;
        }
        this.findDualTwoStringKites(this.steps);
        if (this.steps.size() > 0) {
            Collections.sort(this.steps);
            return this.steps.get(0);
        }
        return null;
    }

    private SolutionStep findTwoStringKite(boolean onlyOne) {
        byte[][] free = this.sudoku.getFree();
        int cand = 1;
        while (cand <= 9) {
            int constr1Count = 0;
            int constr2Count = 0;
            int constr = 0;
            while (constr < 18) {
                if (free[constr][cand] == 2) {
                    int[] indices = Sudoku2.ALL_UNITS[constr];
                    int candIndex = 0;
                    int i = 0;
                    while (i < indices.length) {
                        if (this.sudoku.isCandidate(indices[i], cand)) {
                            this.only2Indices[constr1Count + constr2Count][candIndex++] = indices[i];
                            if (candIndex >= 2) break;
                        }
                        ++i;
                    }
                    if (constr < 9) {
                        ++constr1Count;
                    } else {
                        ++constr2Count;
                    }
                }
                ++constr;
            }
            int i = 0;
            while (i < constr1Count) {
                int j = constr1Count;
                while (j < constr1Count + constr2Count) {
                    block17: {
                        int crossIndex;
                        block14: {
                            int tmp;
                            block16: {
                                block15: {
                                    if (Sudoku2.getBlock(this.only2Indices[i][0]) == Sudoku2.getBlock(this.only2Indices[j][0])) break block14;
                                    if (Sudoku2.getBlock(this.only2Indices[i][0]) != Sudoku2.getBlock(this.only2Indices[j][1])) break block15;
                                    tmp = this.only2Indices[j][0];
                                    this.only2Indices[j][0] = this.only2Indices[j][1];
                                    this.only2Indices[j][1] = tmp;
                                    break block14;
                                }
                                if (Sudoku2.getBlock(this.only2Indices[i][1]) != Sudoku2.getBlock(this.only2Indices[j][0])) break block16;
                                tmp = this.only2Indices[i][0];
                                this.only2Indices[i][0] = this.only2Indices[i][1];
                                this.only2Indices[i][1] = tmp;
                                break block14;
                            }
                            if (Sudoku2.getBlock(this.only2Indices[i][1]) != Sudoku2.getBlock(this.only2Indices[j][1])) break block17;
                            tmp = this.only2Indices[j][0];
                            this.only2Indices[j][0] = this.only2Indices[j][1];
                            this.only2Indices[j][1] = tmp;
                            tmp = this.only2Indices[i][0];
                            this.only2Indices[i][0] = this.only2Indices[i][1];
                            this.only2Indices[i][1] = tmp;
                        }
                        if (this.only2Indices[i][0] != this.only2Indices[j][0] && this.only2Indices[i][0] != this.only2Indices[j][1] && this.only2Indices[i][1] != this.only2Indices[j][0] && this.only2Indices[i][1] != this.only2Indices[j][1] && this.sudoku.isCandidate(crossIndex = Sudoku2.getIndex(Sudoku2.getRow(this.only2Indices[j][1]), Sudoku2.getCol(this.only2Indices[i][1])), cand)) {
                            SolutionStep step = new SolutionStep(SolutionType.TWO_STRING_KITE);
                            step.addValue(cand);
                            step.addIndex(this.only2Indices[i][1]);
                            step.addIndex(this.only2Indices[j][1]);
                            step.addIndex(this.only2Indices[i][0]);
                            step.addIndex(this.only2Indices[j][0]);
                            step.addCandidateToDelete(crossIndex, cand);
                            step.addFin(this.only2Indices[i][0], cand);
                            step.addFin(this.only2Indices[j][0], cand);
                            if (onlyOne && !Options.getInstance().isAllowDualsAndSiamese()) {
                                return step;
                            }
                            this.steps.add(step);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++cand;
        }
        return null;
    }

    private void findDualTwoStringKites(List<SolutionStep> kites) {
        if (!Options.getInstance().isAllowDualsAndSiamese()) {
            return;
        }
        int maxIndex = kites.size();
        int i = 0;
        while (i < maxIndex - 1) {
            int j = i + 1;
            while (j < maxIndex) {
                SolutionStep step1 = kites.get(i);
                SolutionStep step2 = kites.get(j);
                int b11 = step1.getIndices().get(2);
                int b12 = step1.getIndices().get(3);
                int b21 = step2.getIndices().get(2);
                int b22 = step2.getIndices().get(3);
                if ((b11 == b21 && b12 == b22 || b12 == b21 && b11 == b22) && !step1.getCandidatesToDelete().get(0).equals(step2.getCandidatesToDelete().get(0))) {
                    SolutionStep dual = (SolutionStep)step1.clone();
                    dual.setType(SolutionType.DUAL_TWO_STRING_KITE);
                    dual.addIndex(step2.getIndices().get(0));
                    dual.addIndex(step2.getIndices().get(1));
                    dual.addIndex(step2.getIndices().get(2));
                    dual.addIndex(step2.getIndices().get(3));
                    dual.addCandidateToDelete(step2.getCandidatesToDelete().get(0));
                    kites.add(dual);
                }
                ++j;
            }
            ++i;
        }
    }
}

