/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import sudoku.Chain;
import sudoku.Options;
import sudoku.SudokuSet;

public class TableEntry {
    private static final long EXPANDED = 0x2000000000000000L;
    private static final long ON_TABLE = 0x4000000000000000L;
    private static final long EXTENDED_TABLE = Long.MIN_VALUE;
    int index = 0;
    int[] entries = new int[Options.getInstance().getMaxTableEntryLength()];
    long[] retIndices = new long[Options.getInstance().getMaxTableEntryLength()];
    SudokuSet[] onSets = new SudokuSet[10];
    SudokuSet[] offSets = new SudokuSet[10];
    SortedMap<Integer, Integer> indices = new TreeMap<Integer, Integer>();

    TableEntry() {
        int i = 0;
        while (i < this.onSets.length) {
            this.onSets[i] = new SudokuSet();
            this.offSets[i] = new SudokuSet();
            ++i;
        }
    }

    void reset() {
        this.index = 0;
        this.entries[0] = 0;
        this.retIndices[0] = 0L;
        this.indices.clear();
        int i = 0;
        while (i < this.onSets.length) {
            this.onSets[i].clear();
            this.offSets[i].clear();
            ++i;
        }
        i = 0;
        while (i < this.entries.length) {
            this.entries[i] = 0;
            this.retIndices[i] = 0L;
            ++i;
        }
    }

    void addEntry(int cellIndex, int cand, int penalty, boolean set) {
        this.addEntry(cellIndex, -1, -1, 0, cand, set, 0, 0, 0, 0, 0, penalty);
    }

    void addEntry(int cellIndex, int cand, boolean set) {
        this.addEntry(cellIndex, -1, -1, 0, cand, set, 0, 0, 0, 0, 0, 0);
    }

    void addEntry(int cellIndex, int cand, boolean set, int reverseIndex) {
        this.addEntry(cellIndex, -1, -1, 0, cand, set, reverseIndex, 0, 0, 0, 0, 0);
    }

    void addEntry(int cellIndex, int cand, boolean set, int ri1, int ri2, int ri3, int ri4, int ri5) {
        this.addEntry(cellIndex, -1, -1, 0, cand, set, ri1, ri2, ri3, ri4, ri5, 0);
    }

    void addEntry(int cellIndex1, int alsIndex, int nodeType, int cand, boolean set, int penalty) {
        this.addEntry(cellIndex1, Chain.getSLowerAlsIndex(alsIndex), Chain.getSHigherAlsIndex(alsIndex), nodeType, cand, set, 0, 0, 0, 0, 0, penalty);
    }

    void addEntry(int cellIndex1, int cellIndex2, int cellIndex3, int nodeType, int cand, boolean set, int ri1, int ri2, int ri3, int ri4, int ri5, int penalty) {
        int entry;
        if (this.index >= this.entries.length) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "addEntry(): TableEntry is already full!");
            return;
        }
        if (nodeType == 0 && (set && this.onSets[cand].contains(cellIndex1) || !set && this.offSets[cand].contains(cellIndex1))) {
            return;
        }
        this.entries[this.index] = entry = Chain.makeSEntry(cellIndex1, cellIndex2, cellIndex3, cand, set, nodeType);
        this.retIndices[this.index] = TableEntry.makeSRetIndex(ri1, ri2, ri3, ri4, ri5);
        if (ri1 < this.retIndices.length) {
            this.setDistance(this.index, this.getDistance(ri1) + 1);
        }
        if (nodeType == 0) {
            if (set) {
                this.onSets[cand].add(cellIndex1);
            } else {
                this.offSets[cand].add(cellIndex1);
            }
        }
        int distance = this.getDistance(this.index);
        this.setDistance(this.index, distance += penalty);
        this.indices.put(entry, this.index);
        ++this.index;
    }

    int getEntry(int index) {
        return this.entries[index];
    }

    int getEntryIndex(int cellIndex, boolean set, int cand) {
        Integer ret = (Integer)this.indices.get(Chain.makeSEntry(cellIndex, cand, set));
        if (ret == null) {
            return 0;
        }
        return ret;
    }

    int getEntryIndex(int entry) {
        Integer tmp = (Integer)this.indices.get(entry);
        if (tmp == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "tmp == null: {0}", entry);
        }
        return (Integer)this.indices.get(entry);
    }

    boolean isFull() {
        return this.index == this.entries.length;
    }

    public int getCellIndex(int index) {
        return Chain.getSCellIndex(this.entries[index]);
    }

    public boolean isStrong(int index) {
        return Chain.isSStrong(this.entries[index]);
    }

    public int getCandidate(int index) {
        return Chain.getSCandidate(this.entries[index]);
    }

    public static long makeSRetIndex(long index1, long index2, long index3, long index4, long index5) {
        long tmp = 0L;
        if (index1 > 4096L) {
            index1 = 0L;
        }
        if (index2 > 1023L) {
            index2 = 0L;
        }
        if (index3 > 1023L) {
            index3 = 0L;
        }
        if (index4 > 1023L) {
            index4 = 0L;
        }
        if (index5 > 1023L) {
            index5 = 0L;
        }
        if (index2 > index1) {
            tmp = index2;
            index2 = index1;
            index1 = tmp;
        }
        if (index3 > index1) {
            tmp = index3;
            index3 = index1;
            index1 = tmp;
        }
        if (index4 > index1) {
            tmp = index4;
            index4 = index1;
            index1 = tmp;
        }
        if (index5 > index1) {
            tmp = index5;
            index5 = index1;
            index1 = tmp;
        }
        return (index5 << 42) + (index4 << 32) + (index3 << 22) + (index2 << 12) + index1;
    }

    public static int getSRetIndexAnz(long retIndex) {
        int anz = 1;
        retIndex >>= 12;
        int i = 0;
        while (i < 4) {
            if ((retIndex & 0x3FFL) != 0L) {
                ++anz;
            }
            retIndex >>= 10;
            ++i;
        }
        return anz;
    }

    public int getRetIndexAnz(int index) {
        return TableEntry.getSRetIndexAnz(this.retIndices[index]);
    }

    public static int getSRetIndex(long retIndex, int which) {
        if (which == 0) {
            return (int)(retIndex & 0xFFFL);
        }
        int ret = (int)(retIndex >> which * 10 + 2 & 0x3FFL);
        if (which == 5) {
            ret &= 0x1FF;
        }
        return ret;
    }

    public int getRetIndex(int index, int which) {
        return TableEntry.getSRetIndex(this.retIndices[index], which);
    }

    public void setDistance(int index, int distance) {
        long tmp = distance & 0x1FF;
        int n = index;
        this.retIndices[n] = this.retIndices[n] & 0xE00FFFFFFFFFFFFFL;
        int n2 = index;
        this.retIndices[n2] = this.retIndices[n2] | tmp << 52;
    }

    public int getDistance(int index) {
        return TableEntry.getSRetIndex(this.retIndices[index], 5) & 0x1FF;
    }

    public boolean isExpanded(int index) {
        return (this.retIndices[index] & 0x2000000000000000L) != 0L;
    }

    public void setExpanded(int index) {
        int n = index;
        this.retIndices[n] = this.retIndices[n] | 0x2000000000000000L;
    }

    public boolean isOnTable(int index) {
        return (this.retIndices[index] & 0x4000000000000000L) != 0L;
    }

    public void setOnTable(int index) {
        int n = index;
        this.retIndices[n] = this.retIndices[n] | 0x4000000000000000L;
    }

    public boolean isExtendedTable(int index) {
        return (this.retIndices[index] & Long.MIN_VALUE) != 0L;
    }

    public void setExtendedTable(int index) {
        int n = index;
        this.retIndices[n] = this.retIndices[n] | Long.MIN_VALUE;
    }

    public void setExtendedTable() {
        int n = this.index - 1;
        this.retIndices[n] = this.retIndices[n] | Long.MIN_VALUE;
    }

    public int getNodeType(int index) {
        return Chain.getSNodeType(this.entries[index]);
    }
}

