/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import solver.AbstractSolver;
import solver.SudokuStepFinder;
import sudoku.Candidate;
import sudoku.SolutionStep;
import sudoku.SolutionType;
import sudoku.SudokuSet;

public class TemplateSolver
extends AbstractSolver {
    private List<SolutionStep> steps;
    private SolutionStep globalStep = new SolutionStep(SolutionType.HIDDEN_SINGLE);

    public TemplateSolver(SudokuStepFinder finder) {
        super(finder);
    }

    @Override
    protected SolutionStep getStep(SolutionType type) {
        SolutionStep result = null;
        this.sudoku = this.finder.getSudoku();
        switch (type) {
            case TEMPLATE_SET: {
                this.getTemplateSet(true);
                if (this.steps.size() <= 0) break;
                result = this.steps.get(0);
                break;
            }
            case TEMPLATE_DEL: {
                this.getTemplateDel(true);
                if (this.steps.size() <= 0) break;
                result = this.steps.get(0);
                break;
            }
        }
        return result;
    }

    @Override
    protected boolean doStep(SolutionStep step) {
        boolean handled = true;
        this.sudoku = this.finder.getSudoku();
        switch (step.getType()) {
            case TEMPLATE_SET: {
                int value = step.getValues().get(0);
                for (int index : step.getIndices()) {
                    this.sudoku.setCell(index, value);
                }
                break;
            }
            case TEMPLATE_DEL: {
                for (Candidate cand : step.getCandidatesToDelete()) {
                    this.sudoku.delCandidate(cand.getIndex(), cand.getValue());
                }
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    protected List<SolutionStep> getAllTemplates() {
        this.sudoku = this.finder.getSudoku();
        List<SolutionStep> oldSteps = this.steps;
        this.steps = new ArrayList<SolutionStep>();
        long millis1 = System.currentTimeMillis();
        this.getTemplateSet(false);
        this.getTemplateDel(false);
        millis1 = System.currentTimeMillis() - millis1;
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "getAllTemplates() gesamt: {0}ms", millis1);
        List<SolutionStep> result = this.steps;
        this.steps = oldSteps;
        return result;
    }

    private void getTemplateSet(boolean initSteps) {
        if (initSteps) {
            this.steps = new ArrayList<SolutionStep>();
        }
        SudokuSet setSet = new SudokuSet();
        int i = 1;
        while (i <= 9) {
            setSet.set(this.finder.getSetValueTemplates(true)[i]);
            setSet.andNot(this.finder.getPositions()[i]);
            if (!setSet.isEmpty()) {
                this.globalStep.reset();
                this.globalStep.setType(SolutionType.TEMPLATE_SET);
                this.globalStep.addValue(i);
                int j = 0;
                while (j < setSet.size()) {
                    this.globalStep.addIndex(setSet.get(j));
                    ++j;
                }
                this.steps.add((SolutionStep)this.globalStep.clone());
            }
            ++i;
        }
    }

    private void getTemplateDel(boolean initSteps) {
        if (initSteps) {
            this.steps = new ArrayList<SolutionStep>();
        }
        SudokuSet setSet = new SudokuSet();
        int i = 1;
        while (i <= 9) {
            setSet.set(this.finder.getDelCandTemplates(true)[i]);
            setSet.and(this.finder.getCandidates()[i]);
            if (!setSet.isEmpty()) {
                this.globalStep.reset();
                this.globalStep.setType(SolutionType.TEMPLATE_DEL);
                this.globalStep.addValue(i);
                int j = 0;
                while (j < setSet.size()) {
                    this.globalStep.addCandidateToDelete(setSet.get(j), i);
                    ++j;
                }
                this.steps.add((SolutionStep)this.globalStep.clone());
            }
            ++i;
        }
    }
}

