/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import solver.AbstractSolver;
import solver.SudokuStepFinder;
import sudoku.Candidate;
import sudoku.ClipboardMode;
import sudoku.Options;
import sudoku.SolutionStep;
import sudoku.SolutionType;
import sudoku.Sudoku2;
import sudoku.SudokuSet;
import sudoku.SudokuStatus;

public class UniquenessSolver
extends AbstractSolver {
    private int[] bugConstraints = new int[3];
    private SolutionStep globalStep = new SolutionStep(SolutionType.FULL_HOUSE);
    private List<SolutionStep> steps = new ArrayList<SolutionStep>();
    private int[] rectangles = new int[400];
    private int rectAnz = 0;
    private int[] indexe = new int[4];
    private int[] tmpRect = new int[4];
    private int cand1;
    private int cand2;
    private List<SolutionStep> cachedSteps = new ArrayList<SolutionStep>();
    private int stepNumber = -1;
    private SudokuSet twoCandidates = new SudokuSet();
    private SudokuSet additionalCandidates = new SudokuSet();
    private SudokuSet tmpSet = new SudokuSet();
    private SudokuSet tmpSet1 = new SudokuSet();
    private boolean lastSearchWasUR = false;
    private boolean lastSearchWasAR = false;

    public UniquenessSolver(SudokuStepFinder finder) {
        super(finder);
    }

    @Override
    protected SolutionStep getStep(SolutionType type) {
        SolutionStep result = null;
        this.sudoku = this.finder.getSudoku();
        if (this.sudoku.getStatus() != SudokuStatus.VALID) {
            return null;
        }
        switch (type) {
            case UNIQUENESS_1: 
            case UNIQUENESS_2: 
            case UNIQUENESS_3: 
            case UNIQUENESS_4: 
            case UNIQUENESS_5: 
            case UNIQUENESS_6: 
            case HIDDEN_RECTANGLE: {
                result = this.getUniqueness(type);
                break;
            }
            case AVOIDABLE_RECTANGLE_1: 
            case AVOIDABLE_RECTANGLE_2: {
                if (this.sudoku.getStatusGivens() != SudokuStatus.VALID) {
                    return null;
                }
                result = this.getAvoidableRectangle(type);
                break;
            }
            case BUG_PLUS_1: {
                result = this.getBugPlus1();
                break;
            }
        }
        return result;
    }

    @Override
    protected boolean doStep(SolutionStep step) {
        boolean handled = true;
        this.sudoku = this.finder.getSudoku();
        switch (step.getType()) {
            case UNIQUENESS_1: 
            case UNIQUENESS_2: 
            case UNIQUENESS_3: 
            case UNIQUENESS_4: 
            case UNIQUENESS_5: 
            case UNIQUENESS_6: 
            case BUG_PLUS_1: 
            case HIDDEN_RECTANGLE: 
            case AVOIDABLE_RECTANGLE_1: 
            case AVOIDABLE_RECTANGLE_2: {
                if (step.getCandidatesToDelete().isEmpty()) {
                    System.out.println("ERROR: No candidate to delete!");
                    System.out.println(step.toString(2));
                    System.out.println(this.sudoku.getSudoku(ClipboardMode.LIBRARY));
                }
                for (Candidate cand : step.getCandidatesToDelete()) {
                    if (!this.sudoku.isCandidate(cand.getIndex(), cand.getValue())) {
                        System.out.println("ERROR: " + cand.getIndex() + "/" + cand.getValue());
                        System.out.println(step.toString(2));
                        System.out.println(this.sudoku.getSudoku(ClipboardMode.LIBRARY));
                    }
                    this.sudoku.delCandidate(cand.getIndex(), cand.getValue());
                }
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    private SolutionStep getUniqueness(SolutionType type) {
        if (this.finder.getStepNumber() == this.stepNumber && this.lastSearchWasUR) {
            if (this.cachedSteps.size() > 0) {
                for (SolutionStep step : this.cachedSteps) {
                    if (step.getType() != type) continue;
                    return step;
                }
            }
        } else {
            this.stepNumber = this.finder.getStepNumber();
            this.cachedSteps.clear();
            this.rectAnz = 0;
        }
        this.lastSearchWasUR = true;
        this.lastSearchWasAR = false;
        return this.getAllUniquenessInternal(type, true);
    }

    private SolutionStep getAvoidableRectangle(SolutionType type) {
        if (this.finder.getStepNumber() == this.stepNumber && this.lastSearchWasAR) {
            if (this.cachedSteps.size() > 0) {
                for (SolutionStep step : this.cachedSteps) {
                    if (step.getType() != type) continue;
                    return step;
                }
            }
        } else {
            this.stepNumber = this.finder.getStepNumber();
            this.cachedSteps.clear();
            this.rectAnz = 0;
        }
        this.lastSearchWasUR = false;
        this.lastSearchWasAR = true;
        return this.getAllAvoidableRectangles(type, true);
    }

    protected List<SolutionStep> getAllUniqueness() {
        this.stepNumber = -1;
        this.cachedSteps.clear();
        this.rectAnz = 0;
        this.lastSearchWasAR = false;
        this.lastSearchWasUR = false;
        this.sudoku = this.finder.getSudoku();
        ArrayList<SolutionStep> tmpSteps = new ArrayList<SolutionStep>();
        List<SolutionStep> oldSteps = this.steps;
        this.steps = tmpSteps;
        this.getAllUniquenessInternal(null, false);
        this.getAllAvoidableRectangles(null, false);
        this.steps = oldSteps;
        return tmpSteps;
    }

    private SolutionStep getAllAvoidableRectangles(SolutionType type, boolean onlyOne) {
        int i = 0;
        while (i < 81) {
            if (this.sudoku.getValue(i) != 0 && !this.sudoku.isFixed(i)) {
                this.cand1 = this.sudoku.getValue(i);
                SolutionStep step = this.findUniquenessForStartCell(i, true, type, onlyOne);
                if (step != null && onlyOne) {
                    return step;
                }
                step = this.findUniquenessForStartCell(i, true, type, onlyOne);
                if (step != null && onlyOne) {
                    return step;
                }
            }
            ++i;
        }
        return null;
    }

    private SolutionStep getAllUniquenessInternal(SolutionType type, boolean onlyOne) {
        int i = 0;
        while (i < 81) {
            if (this.sudoku.getAnzCandidates(i) == 2) {
                int[] cands = this.sudoku.getAllCandidates(i);
                this.cand1 = cands[0];
                this.cand2 = cands[1];
                SolutionStep step = this.findUniquenessForStartCell(i, false, type, onlyOne);
                if (step != null && onlyOne) {
                    return step;
                }
            }
            ++i;
        }
        return null;
    }

    private SolutionStep getBugPlus1() {
        int index3 = -1;
        int i = 0;
        while (i < 81) {
            int anz = this.sudoku.getAnzCandidates(i);
            if (anz > 3) {
                return null;
            }
            if (anz == 3) {
                if (index3 != -1) {
                    return null;
                }
                index3 = i;
            }
            ++i;
        }
        if (index3 == -1) {
            return null;
        }
        int cand3 = -1;
        this.bugConstraints[0] = -1;
        this.bugConstraints[1] = -1;
        this.bugConstraints[2] = -1;
        byte[][] free = this.sudoku.getFree();
        int constr = 0;
        while (constr < free.length) {
            int cand = 1;
            while (cand <= 9) {
                byte anz = free[constr][cand];
                if (anz > 3) {
                    return null;
                }
                if (anz == 3) {
                    if (this.bugConstraints[constr / 9] != -1 || cand3 != -1 && cand3 != cand) {
                        return null;
                    }
                    cand3 = cand;
                    this.bugConstraints[constr / 9] = constr;
                }
                ++cand;
            }
            ++constr;
        }
        if (this.sudoku.isCandidate(index3, cand3) && Sudoku2.CONSTRAINTS[index3][0] == this.bugConstraints[0] && Sudoku2.CONSTRAINTS[index3][1] == this.bugConstraints[1] && Sudoku2.CONSTRAINTS[index3][2] == this.bugConstraints[2]) {
            this.globalStep.reset();
            this.globalStep.setType(SolutionType.BUG_PLUS_1);
            int[] candArr = this.sudoku.getAllCandidates(index3);
            int i2 = 0;
            while (i2 < candArr.length) {
                if (candArr[i2] != cand3) {
                    this.globalStep.addCandidateToDelete(index3, candArr[i2]);
                }
                ++i2;
            }
            return (SolutionStep)this.globalStep.clone();
        }
        return null;
    }

    private SolutionStep findUniquenessForStartCell(int index11, boolean avoidable, SolutionType type, boolean onlyOne) {
        boolean allowMissing = Options.getInstance().isAllowUniquenessMissingCandidates();
        int line11 = Sudoku2.getRow(index11);
        int col11 = Sudoku2.getCol(index11);
        int block11 = Sudoku2.getBlock(index11);
        short cell11 = this.sudoku.getCell(index11);
        SudokuSet allowedCand1 = this.finder.getCandidatesAllowed()[this.cand1];
        SudokuSet allowedCand2 = this.finder.getCandidatesAllowed()[this.cand2];
        int[] blockIndices = Sudoku2.BLOCKS[Sudoku2.getBlock(index11)];
        int i = 0;
        while (i < blockIndices.length) {
            int index12;
            if (blockIndices[i] != index11 && (line11 == Sudoku2.getRow(index12 = blockIndices[i]) || col11 == Sudoku2.getCol(index12))) {
                short cell12 = this.sudoku.getCell(index12);
                if (!avoidable && this.sudoku.getValue(index12) == 0 && (!allowMissing && (cell11 & cell12) == cell11 || allowMissing && allowedCand1.contains(index12) && allowedCand2.contains(index12)) || avoidable && this.sudoku.getValue(index12) != 0 && !this.sudoku.isFixed(index12)) {
                    if (avoidable) {
                        this.cand2 = this.sudoku.getValue(index12);
                    }
                    boolean isLines = line11 == Sudoku2.getRow(index12);
                    int[] unit11 = Sudoku2.ALL_UNITS[isLines ? Sudoku2.getCol(index11) + 9 : Sudoku2.getRow(index11)];
                    int[] unit12 = Sudoku2.ALL_UNITS[isLines ? Sudoku2.getCol(index12) + 9 : Sudoku2.getRow(index12)];
                    int j = 0;
                    while (j < unit11.length) {
                        if (Sudoku2.getBlock(unit11[j]) != block11) {
                            int index21 = unit11[j];
                            int index22 = unit12[j];
                            short cell21 = this.sudoku.getCell(index21);
                            short cell22 = this.sudoku.getCell(index22);
                            if ((!avoidable && !allowMissing && (cell21 & cell11) == cell11 && (cell22 & cell11) == cell11 || allowMissing && allowedCand1.contains(index21) && allowedCand1.contains(index22) && allowedCand2.contains(index22) && allowedCand2.contains(index22) || avoidable && (this.sudoku.getValue(index21) == this.cand2 && !this.sudoku.isFixed(index21) && this.sudoku.getValue(index22) == 0 && this.sudoku.isCandidate(index22, this.cand1) && this.sudoku.getAnzCandidates(index22) == 2 || this.sudoku.getValue(index22) == this.cand1 && !this.sudoku.isFixed(index22) && this.sudoku.getValue(index21) == 0 && this.sudoku.isCandidate(index21, this.cand2) && this.sudoku.getAnzCandidates(index21) == 2 || this.sudoku.getValue(index21) == 0 && this.sudoku.isCandidate(index21, this.cand2) && this.sudoku.getAnzCandidates(index21) == 2 && this.sudoku.getValue(index22) == 0 && this.sudoku.isCandidate(index22, this.cand1) && this.sudoku.getAnzCandidates(index22) == 2)) && this.checkRect(index11, index12, index21, index22)) {
                                this.indexe[0] = index11;
                                this.indexe[1] = index12;
                                this.indexe[2] = index21;
                                this.indexe[3] = index22;
                                SolutionStep step = null;
                                step = avoidable ? this.checkAvoidableRectangle(index21, index22, type, onlyOne) : this.checkURForStep(type, onlyOne);
                                if (step != null && onlyOne) {
                                    return step;
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private SolutionStep checkURForStep(SolutionType searchType, boolean onlyOne) {
        int delCand;
        int i2;
        int i1;
        int index3;
        int i;
        this.initCheck(this.indexe);
        SolutionStep step = null;
        int twoSize = this.twoCandidates.size();
        short urMask = (short)(Sudoku2.MASKS[this.cand1] | Sudoku2.MASKS[this.cand2]);
        if (twoSize == 3) {
            this.initStep(SolutionType.UNIQUENESS_1);
            int delIndex = this.additionalCandidates.get(0);
            if (this.sudoku.isCandidate(delIndex, this.cand1)) {
                this.globalStep.addCandidateToDelete(delIndex, this.cand1);
            }
            if (this.sudoku.isCandidate(delIndex, this.cand2)) {
                this.globalStep.addCandidateToDelete(delIndex, this.cand2);
            }
            if (this.globalStep.getCandidatesToDelete().size() > 0) {
                step = (SolutionStep)this.globalStep.clone();
                if (onlyOne) {
                    if (searchType == step.getType()) {
                        return step;
                    }
                    this.cachedSteps.add(step);
                } else {
                    this.steps.add(step);
                }
            }
        }
        if (twoSize == 2 || twoSize == 1) {
            int addMask = 0;
            this.tmpSet.setAll();
            i = 0;
            while (i < this.additionalCandidates.size()) {
                index3 = this.additionalCandidates.get(i);
                if (Sudoku2.ANZ_VALUES[addMask = (int)((short)(addMask | (short)(this.sudoku.getCell(index3) & ~urMask)))] > 1) break;
                this.tmpSet.and(Sudoku2.buddies[index3]);
                ++i;
            }
            if (Sudoku2.ANZ_VALUES[addMask] == 1) {
                short addCand = Sudoku2.CAND_FROM_MASK[addMask];
                this.tmpSet.and(this.finder.getCandidates()[addCand]);
                if (!this.tmpSet.isEmpty()) {
                    SolutionType type = SolutionType.UNIQUENESS_2;
                    int i12 = this.additionalCandidates.get(0);
                    int i22 = this.additionalCandidates.get(1);
                    if (this.additionalCandidates.size() == 3 || Sudoku2.getRow(i12) != Sudoku2.getRow(i22) && Sudoku2.getCol(i12) != Sudoku2.getCol(i22)) {
                        type = SolutionType.UNIQUENESS_5;
                    }
                    this.initStep(type);
                    int i3 = 0;
                    while (i3 < this.tmpSet.size()) {
                        this.globalStep.addCandidateToDelete(this.tmpSet.get(i3), addCand);
                        ++i3;
                    }
                    step = (SolutionStep)this.globalStep.clone();
                    if (onlyOne) {
                        if (searchType == step.getType()) {
                            return step;
                        }
                        this.cachedSteps.add(step);
                    } else {
                        this.steps.add(step);
                    }
                }
            }
        }
        if (twoSize == 2) {
            short u3Cands = 0;
            i = 0;
            while (i < this.additionalCandidates.size()) {
                index3 = this.additionalCandidates.get(i);
                u3Cands = (short)(u3Cands | (short)(this.sudoku.getCell(index3) & ~urMask));
                ++i;
            }
            int i13 = this.additionalCandidates.get(0);
            int i23 = this.additionalCandidates.get(1);
            if (Sudoku2.getRow(i13) == Sudoku2.getRow(i23) && (step = this.checkUniqueness3(1, Sudoku2.ROWS[Sudoku2.getRow(i13)], u3Cands, urMask, searchType, onlyOne)) != null && onlyOne) {
                return step;
            }
            if (Sudoku2.getCol(i13) == Sudoku2.getCol(i23) && (step = this.checkUniqueness3(2, Sudoku2.COLS[Sudoku2.getCol(i13)], u3Cands, urMask, searchType, onlyOne)) != null && onlyOne) {
                return step;
            }
            if (Sudoku2.getBlock(i13) == Sudoku2.getBlock(i23) && (step = this.checkUniqueness3(0, Sudoku2.BLOCKS[Sudoku2.getBlock(i13)], u3Cands, urMask, searchType, onlyOne)) != null && onlyOne) {
                return step;
            }
        }
        if (twoSize == 2) {
            i1 = this.additionalCandidates.get(0);
            i2 = this.additionalCandidates.get(1);
            if (Sudoku2.getRow(i1) == Sudoku2.getRow(i2) || Sudoku2.getCol(i1) == Sudoku2.getCol(i2)) {
                this.tmpSet.setAnd(Sudoku2.buddies[i1], Sudoku2.buddies[i2]);
                delCand = -1;
                this.tmpSet1.setAnd(this.tmpSet, this.finder.getCandidates()[this.cand1]);
                if (this.tmpSet1.isEmpty()) {
                    delCand = this.cand2;
                } else {
                    this.tmpSet1.setAnd(this.tmpSet, this.finder.getCandidates()[this.cand2]);
                    if (this.tmpSet1.isEmpty()) {
                        delCand = this.cand1;
                    }
                }
                if (delCand != -1) {
                    this.initStep(SolutionType.UNIQUENESS_4);
                    if (this.sudoku.isCandidate(i1, delCand)) {
                        this.globalStep.addCandidateToDelete(i1, delCand);
                    }
                    if (this.sudoku.isCandidate(i2, delCand)) {
                        this.globalStep.addCandidateToDelete(i2, delCand);
                    }
                    if (this.globalStep.getCandidatesToDelete().size() > 0) {
                        step = (SolutionStep)this.globalStep.clone();
                        if (onlyOne) {
                            if (searchType == step.getType()) {
                                return step;
                            }
                            this.cachedSteps.add(step);
                        } else {
                            this.steps.add(step);
                        }
                    }
                }
            }
        }
        if (twoSize == 2) {
            i1 = this.additionalCandidates.get(0);
            i2 = this.additionalCandidates.get(1);
            if (Sudoku2.getRow(i1) != Sudoku2.getRow(i2) && Sudoku2.getCol(i1) != Sudoku2.getCol(i2)) {
                this.tmpSet.set(Sudoku2.ROW_TEMPLATES[Sudoku2.getRow(i1)]);
                this.tmpSet.or(Sudoku2.COL_TEMPLATES[Sudoku2.getCol(i1)]);
                this.tmpSet.or(Sudoku2.ROW_TEMPLATES[Sudoku2.getRow(i2)]);
                this.tmpSet.or(Sudoku2.COL_TEMPLATES[Sudoku2.getCol(i2)]);
                this.tmpSet.andNot(this.additionalCandidates);
                this.tmpSet.andNot(this.twoCandidates);
                delCand = -1;
                this.tmpSet1.setAnd(this.tmpSet, this.finder.getCandidates()[this.cand1]);
                if (this.tmpSet1.isEmpty()) {
                    delCand = this.cand1;
                } else {
                    this.tmpSet1.setAnd(this.tmpSet, this.finder.getCandidates()[this.cand2]);
                    if (this.tmpSet1.isEmpty()) {
                        delCand = this.cand2;
                    }
                }
                if (delCand != -1) {
                    this.initStep(SolutionType.UNIQUENESS_6);
                    if (this.sudoku.isCandidate(i1, delCand)) {
                        this.globalStep.addCandidateToDelete(i1, delCand);
                    }
                    if (this.sudoku.isCandidate(i2, delCand)) {
                        this.globalStep.addCandidateToDelete(i2, delCand);
                    }
                    if (this.globalStep.getCandidatesToDelete().size() > 0) {
                        step = (SolutionStep)this.globalStep.clone();
                        if (onlyOne) {
                            if (searchType == step.getType()) {
                                return step;
                            }
                            this.cachedSteps.add(step);
                        } else {
                            this.steps.add(step);
                        }
                    }
                }
            }
        }
        if (twoSize == 2 || twoSize == 1) {
            i1 = this.twoCandidates.get(0);
            i2 = this.twoCandidates.get(1);
            boolean doCheck = true;
            if (twoSize == 2 && (Sudoku2.getRow(i1) == Sudoku2.getRow(i2) || Sudoku2.getCol(i1) == Sudoku2.getCol(i2))) {
                doCheck = false;
            }
            if (doCheck) {
                step = this.checkHiddenRectangle(i1, searchType, onlyOne);
                if (step != null && onlyOne) {
                    return step;
                }
                if (this.twoCandidates.size() == 2 && (step = this.checkHiddenRectangle(i2, searchType, onlyOne)) != null && onlyOne) {
                    return step;
                }
            }
        }
        return null;
    }

    private SolutionStep checkAvoidableRectangle(int index21, int index22, SolutionType type, boolean onlyOne) {
        SolutionStep step = null;
        if (this.sudoku.getValue(index21) != 0 || this.sudoku.getValue(index22) != 0) {
            this.initStep(SolutionType.AVOIDABLE_RECTANGLE_1);
            if (this.sudoku.getValue(index21) != 0) {
                if (this.sudoku.isCandidate(index22, this.cand1)) {
                    this.globalStep.addCandidateToDelete(index22, this.cand1);
                }
            } else if (this.sudoku.isCandidate(index21, this.cand2)) {
                this.globalStep.addCandidateToDelete(index21, this.cand2);
            }
            if (this.globalStep.getCandidatesToDelete().size() > 0) {
                step = (SolutionStep)this.globalStep.clone();
                if (onlyOne) {
                    if (type == SolutionType.AVOIDABLE_RECTANGLE_1) {
                        return step;
                    }
                    this.cachedSteps.add(step);
                } else {
                    this.steps.add(step);
                }
            }
        } else {
            int[] cands = this.sudoku.getAllCandidates(index21);
            int additionalCand = cands[0];
            if (additionalCand == this.cand2) {
                additionalCand = cands[1];
            }
            if (!this.sudoku.isCandidate(index22, additionalCand)) {
                return null;
            }
            this.tmpSet.set(Sudoku2.buddies[index21]);
            this.tmpSet.and(Sudoku2.buddies[index22]);
            this.tmpSet.and(this.finder.getCandidates()[additionalCand]);
            if (this.tmpSet.isEmpty()) {
                return null;
            }
            this.initStep(SolutionType.AVOIDABLE_RECTANGLE_2);
            int i = 0;
            while (i < this.tmpSet.size()) {
                this.globalStep.addCandidateToDelete(this.tmpSet.get(i), additionalCand);
                ++i;
            }
            this.globalStep.addEndoFin(index21, additionalCand);
            this.globalStep.addEndoFin(index22, additionalCand);
            step = (SolutionStep)this.globalStep.clone();
            if (onlyOne) {
                if (type == SolutionType.AVOIDABLE_RECTANGLE_2) {
                    return step;
                }
                this.cachedSteps.add(step);
            } else {
                this.steps.add(step);
            }
        }
        return null;
    }

    private SolutionStep checkHiddenRectangle(int cornerIndex, SolutionType type, boolean onlyOne) {
        SolutionStep step;
        int col1;
        int lineC = Sudoku2.getRow(cornerIndex);
        int colC = Sudoku2.getCol(cornerIndex);
        int i1 = this.additionalCandidates.get(0);
        int i2 = this.additionalCandidates.get(1);
        int line1 = Sudoku2.getRow(i1);
        if (line1 == lineC) {
            line1 = Sudoku2.getRow(i2);
        }
        if ((col1 = Sudoku2.getCol(i1)) == colC) {
            col1 = Sudoku2.getCol(i2);
        }
        if ((step = this.checkCandForHiddenRectangle(line1, col1, this.cand1, this.cand2, type, onlyOne)) != null && onlyOne) {
            return step;
        }
        step = this.checkCandForHiddenRectangle(line1, col1, this.cand2, this.cand1, type, onlyOne);
        if (step != null && onlyOne) {
            return step;
        }
        return null;
    }

    private SolutionStep checkCandForHiddenRectangle(int line, int col, int cand1, int cand2, SolutionType type, boolean onlyOne) {
        this.tmpSet1.setOr(this.twoCandidates, this.additionalCandidates);
        this.tmpSet.set(this.finder.getCandidates()[cand1]);
        this.tmpSet.and(Sudoku2.ROW_TEMPLATES[line]);
        this.tmpSet.andNot(this.tmpSet1);
        if (!this.tmpSet.isEmpty()) {
            return null;
        }
        this.tmpSet.set(this.finder.getCandidates()[cand1]);
        this.tmpSet.and(Sudoku2.COL_TEMPLATES[col]);
        this.tmpSet.andNot(this.tmpSet1);
        if (!this.tmpSet.isEmpty()) {
            return null;
        }
        int delIndex = Sudoku2.getIndex(line, col);
        this.initStep(SolutionType.HIDDEN_RECTANGLE);
        if (this.sudoku.isCandidate(delIndex, cand2)) {
            this.globalStep.addCandidateToDelete(delIndex, cand2);
        }
        if (this.globalStep.getCandidatesToDelete().size() > 0) {
            SolutionStep step = (SolutionStep)this.globalStep.clone();
            if (onlyOne) {
                if (type == step.getType()) {
                    return step;
                }
                this.cachedSteps.add(step);
            } else {
                this.steps.add(step);
            }
        }
        return null;
    }

    private SolutionStep checkUniqueness3(int unitType, int[] unit, short u3Cands, short urMask, SolutionType searchType, boolean onlyOne) {
        SolutionStep step;
        SudokuSet u3Indices = new SudokuSet();
        this.tmpSet.set(this.twoCandidates);
        this.tmpSet.or(this.additionalCandidates);
        int i = 0;
        while (i < unit.length) {
            short cell = this.sudoku.getCell(unit[i]);
            if (cell != 0 && (cell & urMask) == 0 && !this.tmpSet.contains(unit[i])) {
                u3Indices.add(unit[i]);
            }
            ++i;
        }
        if (!u3Indices.isEmpty() && (step = this.checkUniqueness3Recursive(unitType, unit, u3Indices, u3Cands, new SudokuSet(this.additionalCandidates), 0, searchType, onlyOne)) != null && onlyOne) {
            return step;
        }
        return null;
    }

    private SolutionStep checkUniqueness3Recursive(int type, int[] unit, SudokuSet u3Indices, short candsIncluded, SudokuSet indicesIncluded, int startIndex, SolutionType searchType, boolean onlyOne) {
        SolutionStep step = null;
        int i = startIndex;
        while (i < u3Indices.size()) {
            short aktCands = candsIncluded;
            SudokuSet aktIndices = indicesIncluded.clone();
            aktIndices.add(u3Indices.get(i));
            aktCands = (short)(aktCands | this.sudoku.getCell(u3Indices.get(i)));
            if (!(type == 0 && this.isSameLineOrCol(aktIndices) || Sudoku2.ANZ_VALUES[aktCands] != aktIndices.size() - 1)) {
                this.initStep(SolutionType.UNIQUENESS_3);
                int j = 0;
                while (j < unit.length) {
                    short delCands;
                    if (this.sudoku.getValue(unit[j]) == 0 && !aktIndices.contains(unit[j]) && Sudoku2.ANZ_VALUES[delCands = (short)(this.sudoku.getCell(unit[j]) & aktCands)] != 0) {
                        int[] delCandsArray = Sudoku2.POSSIBLE_VALUES[delCands];
                        int k = 0;
                        while (k < delCandsArray.length) {
                            this.globalStep.addCandidateToDelete(unit[j], delCandsArray[k]);
                            ++k;
                        }
                    }
                    ++j;
                }
                if (this.globalStep.getCandidatesToDelete().size() > 0) {
                    int block;
                    int[] aktCandsArray = Sudoku2.POSSIBLE_VALUES[aktCands];
                    int k = 0;
                    while (k < aktCandsArray.length) {
                        int cTmp = aktCandsArray[k];
                        int l = 0;
                        while (l < aktIndices.size()) {
                            if (this.sudoku.isCandidate(aktIndices.get(l), cTmp)) {
                                this.globalStep.addFin(aktIndices.get(l), cTmp);
                            }
                            ++l;
                        }
                        ++k;
                    }
                    if ((type == 1 || type == 2) && (block = this.getBlockForCheck3(aktIndices)) != -1) {
                        int[] unit1 = Sudoku2.BLOCKS[block];
                        int j2 = 0;
                        while (j2 < unit1.length) {
                            short delCands;
                            if (this.sudoku.getValue(unit1[j2]) == 0 && !aktIndices.contains(unit1[j2]) && Sudoku2.ANZ_VALUES[delCands = (short)(this.sudoku.getCell(unit1[j2]) & aktCands)] != 0) {
                                int[] delCandsArray = Sudoku2.POSSIBLE_VALUES[delCands];
                                int k2 = 0;
                                while (k2 < delCandsArray.length) {
                                    this.globalStep.addCandidateToDelete(unit1[j2], delCandsArray[k2]);
                                    ++k2;
                                }
                            }
                            ++j2;
                        }
                    }
                    step = (SolutionStep)this.globalStep.clone();
                    if (onlyOne) {
                        if (searchType == step.getType()) {
                            return step;
                        }
                        this.cachedSteps.add(step);
                    } else {
                        this.steps.add(step);
                    }
                }
            }
            if ((step = this.checkUniqueness3Recursive(type, unit, u3Indices, aktCands, aktIndices, i + 1, searchType, onlyOne)) != null && onlyOne) {
                return step;
            }
            ++i;
        }
        return null;
    }

    private int getBlockForCheck3(SudokuSet aktIndices) {
        if (aktIndices.isEmpty()) {
            return -1;
        }
        int block = Sudoku2.getBlock(aktIndices.get(0));
        int i = 1;
        while (i < aktIndices.size()) {
            if (Sudoku2.getBlock(aktIndices.get(i)) != block) {
                return -1;
            }
            ++i;
        }
        return block;
    }

    private boolean isSameLineOrCol(SudokuSet aktIndices) {
        if (aktIndices.isEmpty()) {
            return false;
        }
        boolean sameLine = true;
        boolean sameCol = true;
        int line = Sudoku2.getRow(aktIndices.get(0));
        int col = Sudoku2.getCol(aktIndices.get(0));
        int i = 1;
        while (i < aktIndices.size()) {
            if (Sudoku2.getRow(aktIndices.get(i)) != line) {
                sameLine = false;
            }
            if (Sudoku2.getCol(aktIndices.get(i)) != col) {
                sameCol = false;
            }
            ++i;
        }
        return sameLine || sameCol;
    }

    private void initStep(SolutionType type) {
        this.globalStep.reset();
        this.globalStep.setType(type);
        if (this.indexe != null) {
            this.globalStep.addValue(this.cand1);
            this.globalStep.addValue(this.cand2);
            this.globalStep.addIndex(this.indexe[0]);
            this.globalStep.addIndex(this.indexe[1]);
            this.globalStep.addIndex(this.indexe[2]);
            this.globalStep.addIndex(this.indexe[3]);
        }
    }

    private void initCheck(int[] indices) {
        this.twoCandidates.clear();
        this.additionalCandidates.clear();
        short mask = (short)(~(Sudoku2.MASKS[this.cand1] | Sudoku2.MASKS[this.cand2]));
        int i = 0;
        while (i < indices.length) {
            short addTemp = (short)(this.sudoku.getCell(indices[i]) & mask);
            if (addTemp == 0) {
                this.twoCandidates.add(indices[i]);
            } else {
                this.additionalCandidates.add(indices[i]);
            }
            ++i;
        }
    }

    private boolean checkRect(int i11, int i12, int i21, int i22) {
        this.tmpRect[0] = i11;
        this.tmpRect[1] = i12;
        this.tmpRect[2] = i21;
        this.tmpRect[3] = i22;
        int i = this.tmpRect.length;
        while (i > 1) {
            boolean changed = false;
            int j = 1;
            while (j < i) {
                if (this.tmpRect[j - 1] > this.tmpRect[j]) {
                    int tmp = this.tmpRect[j - 1];
                    this.tmpRect[j - 1] = this.tmpRect[j];
                    this.tmpRect[j] = tmp;
                    changed = true;
                }
                ++j;
            }
            if (!changed) break;
            --i;
        }
        int rect = ((this.tmpRect[0] * 10 + this.tmpRect[1]) * 10 + this.tmpRect[2]) * 10 + this.tmpRect[3];
        int i2 = 0;
        while (i2 < this.rectAnz) {
            if (this.rectangles[i2] == rect) {
                return false;
            }
            ++i2;
        }
        if (this.rectAnz < this.rectangles.length) {
            this.rectangles[this.rectAnz++] = rect;
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Find Uniqueness: Kein Platz mehr in rectangles!");
        }
        return true;
    }
}

