/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.util.ArrayList;
import java.util.List;
import solver.AbstractSolver;
import solver.SudokuStepFinder;
import sudoku.Candidate;
import sudoku.SolutionStep;
import sudoku.SolutionType;
import sudoku.Sudoku2;
import sudoku.SudokuSet;

public class WingSolver
extends AbstractSolver {
    private SolutionStep globalStep = new SolutionStep(SolutionType.FULL_HOUSE);
    private List<SolutionStep> steps = new ArrayList<SolutionStep>();
    private SudokuSet preCalcSet1 = new SudokuSet();
    private SudokuSet preCalcSet2 = new SudokuSet();
    private SudokuSet elimSet = new SudokuSet();
    private int[] biCells = new int[81];
    private int[] triCells = new int[81];
    private int wIndex1 = -1;
    private int wIndex2 = -1;

    public WingSolver(SudokuStepFinder finder) {
        super(finder);
    }

    @Override
    protected SolutionStep getStep(SolutionType type) {
        SolutionStep result = null;
        this.sudoku = this.finder.getSudoku();
        switch (type) {
            case XY_WING: {
                result = this.getXYWing();
                break;
            }
            case XYZ_WING: {
                result = this.getXYZWing();
                break;
            }
            case W_WING: {
                result = this.getWWing(true);
                break;
            }
        }
        return result;
    }

    @Override
    protected boolean doStep(SolutionStep step) {
        boolean handled = true;
        this.sudoku = this.finder.getSudoku();
        switch (step.getType()) {
            case XY_WING: 
            case XYZ_WING: 
            case W_WING: {
                for (Candidate cand : step.getCandidatesToDelete()) {
                    this.sudoku.delCandidate(cand.getIndex(), cand.getValue());
                }
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    private SolutionStep getXYWing() {
        return this.getWing(false, true);
    }

    private SolutionStep getXYZWing() {
        return this.getWing(true, true);
    }

    protected List<SolutionStep> getAllWings() {
        this.sudoku = this.finder.getSudoku();
        ArrayList<SolutionStep> newSteps = new ArrayList<SolutionStep>();
        List<SolutionStep> oldSteps = this.steps;
        this.steps = newSteps;
        this.getWing(true, false);
        this.getWing(false, false);
        this.getWWing(false);
        this.steps = oldSteps;
        return newSteps;
    }

    private SolutionStep getWing(boolean xyz, boolean onlyOne) {
        int biValueCount = 0;
        int triValueCount = 0;
        int i = 0;
        while (i < 81) {
            if (this.sudoku.getAnzCandidates(i) == 2) {
                this.biCells[biValueCount++] = i;
            }
            if (xyz && this.sudoku.getAnzCandidates(i) == 3) {
                this.triCells[triValueCount++] = i;
            }
            ++i;
        }
        int endIndex = xyz ? triValueCount : biValueCount;
        int[] biTri = xyz ? this.triCells : this.biCells;
        int i2 = 0;
        while (i2 < endIndex) {
            int j = xyz ? 0 : i2 + 1;
            while (j < biValueCount) {
                if (Sudoku2.ANZ_VALUES[this.sudoku.getCell(biTri[i2]) | this.sudoku.getCell(this.biCells[j])] == 3) {
                    int k = j + 1;
                    while (k < biValueCount) {
                        short cell3;
                        short cell2;
                        int index1 = biTri[i2];
                        int index2 = this.biCells[j];
                        int index3 = this.biCells[k];
                        short cell1 = this.sudoku.getCell(index1);
                        if (Sudoku2.ANZ_VALUES[cell1 | (cell2 = this.sudoku.getCell(index2)) | (cell3 = this.sudoku.getCell(index3))] == 3 && cell1 != cell2 && cell2 != cell3 && cell3 != cell1) {
                            int maxTries = xyz ? 1 : 3;
                            int tries = 0;
                            while (tries < maxTries) {
                                short cell;
                                if (tries == 1) {
                                    index1 = this.biCells[j];
                                    index2 = biTri[i2];
                                    cell1 = this.sudoku.getCell(index1);
                                    cell2 = this.sudoku.getCell(index2);
                                } else if (tries == 2) {
                                    index1 = this.biCells[k];
                                    index2 = this.biCells[j];
                                    index3 = biTri[i2];
                                    cell1 = this.sudoku.getCell(index1);
                                    cell2 = this.sudoku.getCell(index2);
                                    cell3 = this.sudoku.getCell(index3);
                                }
                                if (Sudoku2.buddies[index1].contains(index2) && Sudoku2.buddies[index1].contains(index3) && Sudoku2.ANZ_VALUES[cell = (short)(cell2 & cell3)] == 1) {
                                    short candZ = Sudoku2.CAND_FROM_MASK[cell];
                                    this.elimSet.setAnd(Sudoku2.buddies[index2], Sudoku2.buddies[index3]);
                                    this.elimSet.and(this.finder.getCandidates()[candZ]);
                                    if (xyz) {
                                        this.elimSet.and(Sudoku2.buddies[index1]);
                                    }
                                    if (!this.elimSet.isEmpty()) {
                                        this.globalStep.reset();
                                        if (xyz) {
                                            this.globalStep.setType(SolutionType.XYZ_WING);
                                        } else {
                                            this.globalStep.setType(SolutionType.XY_WING);
                                        }
                                        int[] cands = this.sudoku.getAllCandidates(index1);
                                        this.globalStep.addValue(cands[0]);
                                        this.globalStep.addValue(cands[1]);
                                        if (xyz) {
                                            this.globalStep.addValue(cands[2]);
                                        } else {
                                            this.globalStep.addValue(candZ);
                                        }
                                        this.globalStep.addIndex(index1);
                                        this.globalStep.addIndex(index2);
                                        this.globalStep.addIndex(index3);
                                        if (xyz) {
                                            this.globalStep.addFin(index1, candZ);
                                        }
                                        this.globalStep.addFin(index2, candZ);
                                        this.globalStep.addFin(index3, candZ);
                                        int l = 0;
                                        while (l < this.elimSet.size()) {
                                            this.globalStep.addCandidateToDelete(this.elimSet.get(l), candZ);
                                            ++l;
                                        }
                                        SolutionStep step = (SolutionStep)this.globalStep.clone();
                                        if (onlyOne) {
                                            return step;
                                        }
                                        this.steps.add(step);
                                    }
                                }
                                ++tries;
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i2;
        }
        return null;
    }

    private SolutionStep getWWing(boolean onlyOne) {
        int i = 0;
        while (i < this.sudoku.getCells().length) {
            if (this.sudoku.getValue(i) == 0 && this.sudoku.getAnzCandidates(i) == 2) {
                short cell1 = this.sudoku.getCell(i);
                int cand1 = this.sudoku.getAllCandidates(i)[0];
                int cand2 = this.sudoku.getAllCandidates(i)[1];
                this.preCalcSet1.setAnd(Sudoku2.buddies[i], this.finder.getCandidates()[cand1]);
                this.preCalcSet2.setAnd(Sudoku2.buddies[i], this.finder.getCandidates()[cand2]);
                int j = i + 1;
                while (j < this.sudoku.getCells().length) {
                    if (this.sudoku.getCell(j) == cell1) {
                        SolutionStep step;
                        this.elimSet.setAnd(this.preCalcSet1, Sudoku2.buddies[j]);
                        if (!this.elimSet.isEmpty()) {
                            step = this.checkLink(cand1, cand2, i, j, this.elimSet, onlyOne);
                            if (onlyOne && step != null) {
                                return step;
                            }
                        }
                        this.elimSet.setAnd(this.preCalcSet2, Sudoku2.buddies[j]);
                        if (!this.elimSet.isEmpty()) {
                            step = this.checkLink(cand2, cand1, i, j, this.elimSet, onlyOne);
                            if (onlyOne && step != null) {
                                return step;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private SolutionStep checkLink(int cand1, int cand2, int index1, int index2, SudokuSet elimSet, boolean onlyOne) {
        byte[][] free = this.sudoku.getFree();
        int constr = 0;
        while (constr < free.length) {
            if (free[constr][cand2] == 2) {
                boolean sees1 = false;
                boolean sees2 = false;
                int[] indices = Sudoku2.ALL_UNITS[constr];
                int i = 0;
                while (i < indices.length) {
                    int aktIndex = indices[i];
                    if (aktIndex != index1 && aktIndex != index2 && this.sudoku.isCandidate(aktIndex, cand2)) {
                        if (Sudoku2.buddies[aktIndex].contains(index1)) {
                            sees1 = true;
                            this.wIndex1 = aktIndex;
                        } else if (Sudoku2.buddies[aktIndex].contains(index2)) {
                            sees2 = true;
                            this.wIndex2 = aktIndex;
                        }
                    }
                    if (sees1 && sees2) break;
                    ++i;
                }
                if (sees1 && sees2) {
                    SolutionStep step = this.createWWingStep(cand1, cand2, index1, index2, elimSet, onlyOne);
                    if (onlyOne && step != null) {
                        return step;
                    }
                }
            }
            ++constr;
        }
        return null;
    }

    private SolutionStep createWWingStep(int cand1, int cand2, int index1, int index2, SudokuSet elimSet, boolean onlyOne) {
        this.globalStep.reset();
        this.globalStep.setType(SolutionType.W_WING);
        this.globalStep.addValue(cand1);
        this.globalStep.addValue(cand2);
        this.globalStep.addIndex(index1);
        this.globalStep.addIndex(index2);
        this.globalStep.addFin(index1, cand2);
        this.globalStep.addFin(index2, cand2);
        this.globalStep.addFin(this.wIndex1, cand2);
        this.globalStep.addFin(this.wIndex2, cand2);
        int i = 0;
        while (i < elimSet.size()) {
            this.globalStep.addCandidateToDelete(elimSet.get(i), cand1);
            ++i;
        }
        SolutionStep step = (SolutionStep)this.globalStep.clone();
        if (onlyOne) {
            return step;
        }
        this.steps.add(step);
        return null;
    }
}

