/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import java.util.SortedMap;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import sudoku.ColorKuImage;
import sudoku.MainFrame;
import sudoku.Options;
import sudoku.StatusColorPanel;
import sudoku.SudokuPanel;
import sudoku.SudokuSet;
import sudoku.UIColorPalette;
import sudoku.UIColorTools;

public class CellZoomPanel
extends JPanel
implements ActionListener {
    private static final int X_OFFSET = 10;
    private static final int Y_OFFSET = 33;
    private static final int SMALL_GAP = 6;
    private static final int LARGE_GAP = 14;
    private static final int COLOR_PANEL_MAX_HEIGHT = 50;
    private static final int DIFF_SIZE = 1;
    private static final String[] NUMBERS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final int COLOR_BUTTON_COUNT = 12;
    private MainFrame mainFrame;
    private Font buttonFont = null;
    private Font iconFont = null;
    private int buttonFontSize = -1;
    private int defaultButtonFontSize = -1;
    private int defaultButtonHeight = -1;
    private JButton[] setValueButtons = null;
    private JButton[] toggleCandidatesButtons = null;
    private JPanel[] cellPanels = null;
    private Color normButtonForeground = null;
    private Color normButtonBackground = null;
    private SudokuPanel sudokuPanel;
    private int colorImageHeight = -1;
    private Icon[] colorKuIcons = new Icon[9];
    private JPanel chooseColorPanel;
    private JButton jFontButton;
    private JPanel jPanel1;
    private JButton setValueButton1;
    private JButton setValueButton2;
    private JButton setValueButton3;
    private JButton setValueButton4;
    private JButton setValueButton5;
    private JButton setValueButton6;
    private JButton setValueButton7;
    private JButton setValueButton8;
    private JButton setValueButton9;
    private JLabel setValueLabel;
    private JPanel setValuePanel;
    private JLabel titleLabel;
    private JButton toggleCandidatesButton1;
    private JButton toggleCandidatesButton2;
    private JButton toggleCandidatesButton3;
    private JButton toggleCandidatesButton4;
    private JButton toggleCandidatesButton5;
    private JButton toggleCandidatesButton6;
    private JButton toggleCandidatesButton7;
    private JButton toggleCandidatesButton8;
    private JButton toggleCandidatesButton9;
    private JLabel toggleCandidatesLabel;
    private JPanel toggleCandidatesPanel;
    private JPanel radioButtonPanel;
    private ButtonGroup radioButtonGroup;
    private JRadioButton radioButtonDefault;
    private JRadioButton radioButtonColorCells;
    private JRadioButton radioButtonColorCandidates;
    private UIColorPalette colorPalette;
    private UIColorTools colorTools;

    public CellZoomPanel(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.cellPanels = new JPanel[12];
        this.initComponents();
        this.setValueButtons = new JButton[]{this.setValueButton1, this.setValueButton2, this.setValueButton3, this.setValueButton4, this.setValueButton5, this.setValueButton6, this.setValueButton7, this.setValueButton8, this.setValueButton9};
        this.toggleCandidatesButtons = new JButton[]{this.toggleCandidatesButton1, this.toggleCandidatesButton2, this.toggleCandidatesButton3, this.toggleCandidatesButton4, this.toggleCandidatesButton5, this.toggleCandidatesButton6, this.toggleCandidatesButton7, this.toggleCandidatesButton8, this.toggleCandidatesButton9};
        this.normButtonForeground = this.setValueButton1.getForeground();
        this.normButtonBackground = this.setValueButton1.getBackground();
        this.jFontButton.setVisible(false);
        this.buttonFont = this.jFontButton.getFont();
        this.defaultButtonFontSize = this.buttonFontSize = 11;
        this.defaultButtonHeight = 23;
        this.iconFont = new Font(this.buttonFont.getName(), this.buttonFont.getStyle(), this.defaultButtonFontSize - 1);
        int fontSize = 12;
        if (this.getFont().getSize() > 12) {
            fontSize = this.getFont().getSize();
        }
        Font font = this.titleLabel.getFont();
        this.titleLabel.setFont(new Font(font.getName(), 1, fontSize));
        this.calculateLayout();
    }

    private JPanel createColorButtonPanel(int id) {
        StatusColorPanel panel = new StatusColorPanel(id);
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                CellZoomPanel.this.chooseCellColor0PanelMouseClicked(evt);
            }
        });
        GroupLayout group = new GroupLayout(panel);
        panel.setLayout(group);
        group.setHorizontalGroup(group.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 18, Short.MAX_VALUE));
        group.setVerticalGroup(group.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1, Short.MAX_VALUE));
        return panel;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.titleLabel = new JLabel();
        this.setValueLabel = new JLabel();
        this.setValuePanel = new JPanel();
        this.setValueButton1 = new JButton();
        this.setValueButton2 = new JButton();
        this.setValueButton3 = new JButton();
        this.setValueButton4 = new JButton();
        this.setValueButton5 = new JButton();
        this.setValueButton6 = new JButton();
        this.setValueButton7 = new JButton();
        this.setValueButton8 = new JButton();
        this.setValueButton9 = new JButton();
        this.toggleCandidatesLabel = new JLabel();
        this.toggleCandidatesPanel = new JPanel();
        this.toggleCandidatesButton1 = new JButton();
        this.toggleCandidatesButton2 = new JButton();
        this.toggleCandidatesButton3 = new JButton();
        this.toggleCandidatesButton4 = new JButton();
        this.toggleCandidatesButton5 = new JButton();
        this.toggleCandidatesButton6 = new JButton();
        this.toggleCandidatesButton7 = new JButton();
        this.toggleCandidatesButton8 = new JButton();
        this.toggleCandidatesButton9 = new JButton();
        this.chooseColorPanel = new JPanel();
        this.jFontButton = new JButton();
        this.colorPalette = new UIColorPalette(this);
        this.add(this.colorPalette);
        this.colorTools = new UIColorTools();
        this.add(this.colorTools);
        ResourceBundle bundle = ResourceBundle.getBundle("intl/CellZoomPanel");
        String defaultText = bundle.getString("CellZoomPanel.radioButtonDefault.text");
        String colorCandidatesText = bundle.getString("CellZoomPanel.radioButtonColorCandidates.text");
        String colorCellsText = bundle.getString("CellZoomPanel.radioButtonColorCells.text");
        this.radioButtonPanel = new JPanel(new GridLayout(3, 1));
        this.radioButtonPanel.setSize(130, this.colorPalette.getHeight());
        this.radioButtonGroup = new ButtonGroup();
        this.radioButtonDefault = new JRadioButton(defaultText);
        this.radioButtonDefault.setSelected(true);
        this.radioButtonColorCandidates = new JRadioButton(colorCandidatesText);
        this.radioButtonColorCells = new JRadioButton(colorCellsText);
        this.radioButtonDefault.addActionListener(this);
        this.radioButtonColorCells.addActionListener(this);
        this.radioButtonColorCandidates.addActionListener(this);
        this.radioButtonGroup.add(this.radioButtonDefault);
        this.radioButtonGroup.add(this.radioButtonColorCandidates);
        this.radioButtonGroup.add(this.radioButtonColorCells);
        this.radioButtonPanel.add(this.radioButtonDefault);
        this.radioButtonPanel.add(this.radioButtonColorCandidates);
        this.radioButtonPanel.add(this.radioButtonColorCells);
        this.add(this.radioButtonPanel);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                CellZoomPanel.this.formComponentResized(evt);
            }
        });
        this.setLayout(null);
        this.titleLabel.setBackground(new Color(0, 51, 255));
        this.titleLabel.setFont(new Font("Tahoma", 1, 12));
        this.titleLabel.setForeground(new Color(255, 255, 255));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText(bundle.getString("CellZoomPanel.titleLabel.text"));
        this.titleLabel.setOpaque(true);
        this.add(this.titleLabel);
        this.titleLabel.setBounds(0, 0, 63, 15);
        this.setValueLabel.setHorizontalAlignment(0);
        this.setValueLabel.setText(bundle.getString("CellZoomPanel.setValueLabel.text"));
        this.add(this.setValueLabel);
        this.setValueLabel.setBounds(0, 0, 49, 14);
        this.setValuePanel.setLayout(new GridLayout(3, 3));
        this.setValueButton1.setText("1");
        this.setValueButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.setValueButton1ActionPerformed(evt);
            }
        });
        this.setValuePanel.add(this.setValueButton1);
        this.setValueButton2.setText("2");
        this.setValueButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.setValueButton1ActionPerformed(evt);
            }
        });
        this.setValuePanel.add(this.setValueButton2);
        this.setValueButton3.setText("3");
        this.setValueButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.setValueButton1ActionPerformed(evt);
            }
        });
        this.setValuePanel.add(this.setValueButton3);
        this.setValueButton4.setText("4");
        this.setValueButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.setValueButton1ActionPerformed(evt);
            }
        });
        this.setValuePanel.add(this.setValueButton4);
        this.setValueButton5.setText("5");
        this.setValueButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.setValueButton1ActionPerformed(evt);
            }
        });
        this.setValuePanel.add(this.setValueButton5);
        this.setValueButton6.setText("6");
        this.setValueButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.setValueButton1ActionPerformed(evt);
            }
        });
        this.setValuePanel.add(this.setValueButton6);
        this.setValueButton7.setText("7");
        this.setValueButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.setValueButton1ActionPerformed(evt);
            }
        });
        this.setValuePanel.add(this.setValueButton7);
        this.setValueButton8.setText("8");
        this.setValueButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.setValueButton1ActionPerformed(evt);
            }
        });
        this.setValuePanel.add(this.setValueButton8);
        this.setValueButton9.setText("9");
        this.setValueButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.setValueButton1ActionPerformed(evt);
            }
        });
        this.setValuePanel.add(this.setValueButton9);
        this.add(this.setValuePanel);
        this.setValuePanel.setBounds(0, 0, 117, 69);
        this.toggleCandidatesLabel.setHorizontalAlignment(0);
        this.toggleCandidatesLabel.setText(bundle.getString("CellZoomPanel.toggleCandidatesLabel.text"));
        this.add(this.toggleCandidatesLabel);
        this.toggleCandidatesLabel.setBounds(0, 0, 93, 14);
        this.toggleCandidatesPanel.setLayout(new GridLayout(3, 3));
        this.toggleCandidatesButton1.setText("1");
        this.toggleCandidatesButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.toggleCandidatesButton1ActionPerformed(evt);
            }
        });
        this.toggleCandidatesPanel.add(this.toggleCandidatesButton1);
        this.toggleCandidatesButton2.setText("2");
        this.toggleCandidatesButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.toggleCandidatesButton1ActionPerformed(evt);
            }
        });
        this.toggleCandidatesPanel.add(this.toggleCandidatesButton2);
        this.toggleCandidatesButton3.setText("3");
        this.toggleCandidatesButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.toggleCandidatesButton1ActionPerformed(evt);
            }
        });
        this.toggleCandidatesPanel.add(this.toggleCandidatesButton3);
        this.toggleCandidatesButton4.setText("4");
        this.toggleCandidatesButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.toggleCandidatesButton1ActionPerformed(evt);
            }
        });
        this.toggleCandidatesPanel.add(this.toggleCandidatesButton4);
        this.toggleCandidatesButton5.setText("5");
        this.toggleCandidatesButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.toggleCandidatesButton1ActionPerformed(evt);
            }
        });
        this.toggleCandidatesPanel.add(this.toggleCandidatesButton5);
        this.toggleCandidatesButton6.setText("6");
        this.toggleCandidatesButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.toggleCandidatesButton1ActionPerformed(evt);
            }
        });
        this.toggleCandidatesPanel.add(this.toggleCandidatesButton6);
        this.toggleCandidatesButton7.setText("7");
        this.toggleCandidatesButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.toggleCandidatesButton1ActionPerformed(evt);
            }
        });
        this.toggleCandidatesPanel.add(this.toggleCandidatesButton7);
        this.toggleCandidatesButton8.setText("8");
        this.toggleCandidatesButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.toggleCandidatesButton1ActionPerformed(evt);
            }
        });
        this.toggleCandidatesPanel.add(this.toggleCandidatesButton8);
        this.toggleCandidatesButton9.setText("9");
        this.toggleCandidatesButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CellZoomPanel.this.toggleCandidatesButton1ActionPerformed(evt);
            }
        });
        this.toggleCandidatesPanel.add(this.toggleCandidatesButton9);
        this.add(this.toggleCandidatesPanel);
        this.toggleCandidatesPanel.setBounds(0, 0, 117, 69);
        this.chooseColorPanel.setLayout(new GridLayout(2, 6, 1, 1));
        int i = 0;
        while (i < 12) {
            this.cellPanels[i] = this.createColorButtonPanel(i);
            ++i;
        }
        i = 0;
        while (i < 12) {
            this.chooseColorPanel.add(this.cellPanels[i]);
            i += 2;
        }
        i = 1;
        while (i < 12) {
            this.chooseColorPanel.add(this.cellPanels[i]);
            i += 2;
        }
        this.add(this.chooseColorPanel);
        this.chooseColorPanel.setBounds(0, 0, 113, 3);
        this.jFontButton.setText("FontButton");
        this.jFontButton.setEnabled(false);
        this.add(this.jFontButton);
        this.jFontButton.setBounds(29, 130, 110, 23);
    }

    private void formComponentResized(ComponentEvent evt) {
        this.calculateLayout();
        this.printSize();
    }

    private void setValueButton1ActionPerformed(ActionEvent evt) {
        this.setValue((JButton)evt.getSource());
    }

    private void toggleCandidatesButton1ActionPerformed(ActionEvent evt) {
        this.handleCandidateChange((JButton)evt.getSource());
    }

    private void chooseCellColor0PanelMouseClicked(MouseEvent evt) {
        this.handleColorChange((JPanel)evt.getSource(), evt.isControlDown());
    }

    private void handleCandidateChange(JButton button) {
        int candidate = -1;
        int i = 0;
        while (i < this.toggleCandidatesButtons.length) {
            if (button == this.toggleCandidatesButtons[i]) {
                candidate = i + 1;
                break;
            }
            ++i;
        }
        if (this.sudokuPanel != null && candidate != -1) {
            if (this.isDefaultMouse()) {
                this.sudokuPanel.toggleOrRemoveCandidateFromCellZoomPanel(candidate);
            } else {
                this.sudokuPanel.handleColoring(candidate);
            }
        }
    }

    private void setValue(JButton button) {
        int number = -1;
        int i = 0;
        while (i < this.setValueButtons.length) {
            if (button == this.setValueButtons[i]) {
                number = i + 1;
                break;
            }
            ++i;
        }
        if (this.sudokuPanel != null && number != -1) {
            this.sudokuPanel.setCellFromCellZoomPanel(number);
        }
    }

    private void handleColorChange(JPanel panel, boolean isCtrlDown) {
        boolean found = false;
        int colorNumber = -1;
        int i = 0;
        while (i < this.cellPanels.length) {
            if (panel == this.cellPanels[i]) {
                colorNumber = i;
                found = true;
                break;
            }
            ++i;
        }
        if (colorNumber >= 0 && !isCtrlDown) {
            Color color = Options.getInstance().getColoringColors()[colorNumber];
            this.colorPalette.setPrimaryColor(color);
        }
        if (found && this.mainFrame != null) {
            if (isCtrlDown && colorNumber > 0) {
                if (this.isColoringCells()) {
                    this.sudokuPanel.clearCellColor(Options.getInstance().getColoringColors()[colorNumber]);
                } else if (this.isColoringCandidates()) {
                    this.sudokuPanel.clearCandidateColor(Options.getInstance().getColoringColors()[colorNumber]);
                }
            } else if (this.isColoring()) {
                if (this.isColoringCells()) {
                    this.mainFrame.setColoring(this.colorPalette.getPrimaryColor(), true);
                } else if (this.isColoringCandidates()) {
                    this.mainFrame.setColoring(this.colorPalette.getPrimaryColor(), false);
                }
            }
        }
        this.sudokuPanel.repaint();
    }

    public final void calculateLayout() {
        int i;
        int colorPanelGesWidth;
        if (this.defaultButtonHeight == -1) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int y = 33;
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int textHeight = metrics.getHeight();
        int labelHeight = 4 * textHeight;
        int availableVert = height - 33 - 80 - labelHeight;
        int buttonPanelHeight = availableVert * 2 / 6;
        int colorPanelHeight = availableVert / 6;
        if (colorPanelHeight > 50) {
            colorPanelHeight = 50;
        }
        if (buttonPanelHeight > width - 20) {
            buttonPanelHeight = width - 20;
        }
        if (buttonPanelHeight < 120) {
            colorPanelHeight -= 120 - buttonPanelHeight;
            buttonPanelHeight = 120;
        }
        if ((colorPanelGesWidth = colorPanelHeight * 4) > width - 20) {
            colorPanelHeight = (int)((double)(width - 20) / 4.5);
        }
        colorPanelGesWidth = colorPanelHeight * 4;
        int newColorImageHeight = colorPanelHeight * 2 / 3;
        this.titleLabel.setSize(width, textHeight);
        this.setValueLabel.setSize(width - 20, textHeight);
        this.setValueLabel.setLocation(10, y);
        y += textHeight;
        this.setValuePanel.setSize(buttonPanelHeight, buttonPanelHeight);
        this.setValuePanel.setLocation((width - buttonPanelHeight) / 2, y += 6);
        this.setValuePanel.doLayout();
        y += buttonPanelHeight;
        this.toggleCandidatesLabel.setSize(width - 20, textHeight);
        this.toggleCandidatesLabel.setLocation(10, y += 14);
        y += textHeight;
        this.toggleCandidatesPanel.setSize(buttonPanelHeight, buttonPanelHeight);
        this.toggleCandidatesPanel.setLocation((width - buttonPanelHeight) / 2, y += 6);
        this.toggleCandidatesPanel.doLayout();
        y += this.toggleCandidatesPanel.getHeight();
        this.colorPalette.setLocation(this.setValuePanel.getX(), y += 20);
        this.radioButtonPanel.setLocation(this.colorPalette.getX() + this.colorPalette.getWidth() + 10, this.colorPalette.getY());
        y += this.colorPalette.getHeight();
        this.chooseColorPanel.setSize(colorPanelHeight / 2 * 12 / 2, colorPanelHeight);
        this.chooseColorPanel.setLocation(this.setValuePanel.getX(), y += 14);
        this.chooseColorPanel.doLayout();
        this.chooseColorPanel.setSize(colorPanelHeight / 2 * 12 / 2, colorPanelHeight);
        this.colorTools.setSize(colorPanelHeight / 2, colorPanelHeight / 2);
        this.colorTools.setLocation(this.chooseColorPanel.getX() + this.chooseColorPanel.getWidth(), y);
        this.colorTools.doLayout();
        y += colorPanelHeight;
        y += 14;
        int newFontSize = this.defaultButtonFontSize * buttonPanelHeight / (this.defaultButtonHeight * 4);
        if (newFontSize > 0 && newFontSize != this.buttonFontSize) {
            this.buttonFontSize = newFontSize;
            this.buttonFont = new Font(this.buttonFont.getName(), this.buttonFont.getStyle(), this.buttonFontSize);
            this.iconFont = new Font(this.buttonFont.getName(), this.buttonFont.getStyle(), this.buttonFontSize - 1);
            i = 0;
            while (i < this.setValueButtons.length) {
                this.setValueButtons[i].setFont(this.buttonFont);
                this.toggleCandidatesButtons[i].setFont(this.buttonFont);
                ++i;
            }
        }
        if (newColorImageHeight > 0 && Options.getInstance().isShowColorKuAct() && newColorImageHeight != this.colorImageHeight) {
            this.colorImageHeight = newColorImageHeight;
            i = 0;
            while (i < this.colorKuIcons.length) {
                this.colorKuIcons[i] = new ImageIcon(new ColorKuImage(this.colorImageHeight, Options.getInstance().getColorKuColor(i + 1)));
                ++i;
            }
        }
        this.repaint();
    }

    public void update(SudokuSet values, SudokuSet candidates, int index, boolean singleCell, SortedMap<Integer, Color> coloredCells, SortedMap<Integer, Color> coloredCandidates) {
        block16: {
            int i;
            block15: {
                int cand;
                i = 0;
                while (i < this.setValueButtons.length) {
                    this.setValueButtons[i].setText("");
                    this.setValueButtons[i].setEnabled(false);
                    this.setValueButtons[i].setForeground(this.normButtonForeground);
                    this.setValueButtons[i].setBackground(this.normButtonBackground);
                    this.setValueButtons[i].setIcon(null);
                    this.toggleCandidatesButtons[i].setText("");
                    this.toggleCandidatesButtons[i].setEnabled(false);
                    this.toggleCandidatesButtons[i].setForeground(this.normButtonForeground);
                    this.toggleCandidatesButtons[i].setBackground(this.normButtonBackground);
                    this.toggleCandidatesButtons[i].setIcon(null);
                    ++i;
                }
                if (!this.isDefaultMouse()) break block15;
                i = 0;
                while (i < values.size()) {
                    cand = values.get(i) - 1;
                    if (cand >= 0 && cand <= 8) {
                        if (Options.getInstance().isShowColorKuAct()) {
                            this.setValueButtons[cand].setText(null);
                            this.setValueButtons[cand].setIcon(this.colorKuIcons[cand]);
                        } else {
                            this.setValueButtons[cand].setText(NUMBERS[cand]);
                            this.setValueButtons[cand].setIcon(null);
                        }
                        this.setValueButtons[cand].setEnabled(true);
                    }
                    ++i;
                }
                i = 0;
                while (i < candidates.size()) {
                    cand = candidates.get(i) - 1;
                    if (cand >= 0 && cand <= 8) {
                        if (Options.getInstance().isShowColorKuAct()) {
                            this.toggleCandidatesButtons[cand].setText(null);
                            this.toggleCandidatesButtons[cand].setIcon(this.colorKuIcons[cand]);
                        } else {
                            this.toggleCandidatesButtons[cand].setText(NUMBERS[cand]);
                            this.toggleCandidatesButtons[cand].setIcon(null);
                        }
                        this.toggleCandidatesButtons[cand].setEnabled(true);
                    }
                    ++i;
                }
                if (singleCell) {
                    this.toggleCandidatesLabel.setText(ResourceBundle.getBundle("intl/CellZoomPanel").getString("CellZoomPanel.toggleCandidatesLabel.text"));
                    i = 0;
                    while (i < this.toggleCandidatesButtons.length) {
                        this.toggleCandidatesButtons[i].setEnabled(true);
                        ++i;
                    }
                } else {
                    this.toggleCandidatesLabel.setText(ResourceBundle.getBundle("intl/CellZoomPanel").getString("CellZoomPanel.toggleCandidatesLabel.text2"));
                }
                break block16;
            }
            if (coloredCells == null || !this.isColoringCells()) break block16;
            i = 0;
            while (i < candidates.size()) {
                int cand = candidates.get(i);
                if (coloredCandidates.containsKey(index * 10 + cand)) {
                    this.toggleCandidatesButtons[cand - 1].setForeground(this.getPrimaryColor());
                    this.toggleCandidatesButtons[cand - 1].setBackground(this.getPrimaryColor());
                    this.toggleCandidatesButtons[cand - 1].setIcon(this.createImage(this.colorImageHeight, this.getPrimaryColor(), cand));
                    this.toggleCandidatesButtons[cand - 1].setEnabled(true);
                } else {
                    this.toggleCandidatesButtons[cand - 1].setText(NUMBERS[cand - 1]);
                    this.toggleCandidatesButtons[cand - 1].setEnabled(true);
                }
                ++i;
            }
        }
    }

    private ImageIcon createImage(int size, Color color, int cand) {
        if (size > 0) {
            BufferedImage img = new BufferedImage(size, size, 1);
            Graphics2D g = (Graphics2D)((Image)img).getGraphics();
            if (color == null) {
                color = Options.getInstance().getDefaultCellColor();
            }
            g.setColor(color);
            g.fillRect(0, 0, size, size);
            if (cand > 0) {
                if (Options.getInstance().isShowColorKuAct()) {
                    ColorKuImage cImg = new ColorKuImage(size, Options.getInstance().getColorKuColor(cand));
                    g.drawImage((Image)cImg, 0, 0, null);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    g.setFont(this.iconFont);
                    FontMetrics fm = g.getFontMetrics();
                    String str = String.valueOf(cand);
                    int strWidth = fm.stringWidth(str);
                    int strHeight = fm.getAscent();
                    g.setColor(this.normButtonForeground);
                    g.drawString(String.valueOf(cand), (size - strWidth) / 2, (size + strHeight - 2) / 2);
                }
            }
            return new ImageIcon(img);
        }
        return null;
    }

    private void printSize() {
    }

    public void setTitleLabelColors(Color fore, Color back) {
        this.titleLabel.setBackground(back);
        this.titleLabel.setForeground(fore);
    }

    public void setSudokuPanel(SudokuPanel sudokuPanel) {
        this.sudokuPanel = sudokuPanel;
        this.colorPalette.setSudokuPanel(sudokuPanel);
        this.colorTools.setSudokuPanel(sudokuPanel);
    }

    public void swapColors() {
        this.colorPalette.swap();
        this.repaint();
    }

    public boolean isDefaultMouse() {
        return this.radioButtonDefault.isSelected();
    }

    public boolean isColoringCells() {
        return this.radioButtonColorCells.isSelected();
    }

    public boolean isColoringCandidates() {
        return this.radioButtonColorCandidates.isSelected();
    }

    public boolean isColoring() {
        return this.isColoringCells() || this.isColoringCandidates();
    }

    public void setDefaultMouse(boolean enable) {
        if (!this.radioButtonDefault.isSelected() && enable) {
            this.radioButtonDefault.setSelected(true);
        }
    }

    public void setColorCells(boolean enable) {
        if (this.radioButtonColorCells.isSelected() && !enable) {
            this.radioButtonDefault.setSelected(true);
        } else if (!this.radioButtonColorCells.isSelected()) {
            this.radioButtonDefault.setSelected(true);
        }
    }

    public void setColorCandidates(boolean enable) {
        if (this.radioButtonColorCandidates.isSelected() && !enable) {
            this.radioButtonDefault.setSelected(true);
        } else if (!this.radioButtonColorCandidates.isSelected()) {
            this.radioButtonDefault.setSelected(true);
        }
    }

    public Color getPrimaryColor() {
        return this.colorPalette.getPrimaryColor();
    }

    public Color getSecondaryColor() {
        return this.colorPalette.getSecondaryColor();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.radioButtonDefault) {
            this.mainFrame.setColoring(null, false);
        } else if (e.getSource() == this.radioButtonColorCells) {
            this.mainFrame.setColoring(this.getPrimaryColor(), true);
        } else if (e.getSource() == this.radioButtonColorCandidates) {
            this.mainFrame.setColoring(this.getPrimaryColor(), false);
        }
        this.mainFrame.check();
        this.mainFrame.repaint();
    }
}

