/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import solver.SudokuSolver;
import sudoku.Options;
import sudoku.SolutionPanel;
import sudoku.SolutionStep;
import sudoku.StepConfig;
import sudoku.Sudoku2;
import sudoku.SudokuPanel;

public class GuiState {
    private static final boolean DEBUG = false;
    private Sudoku2 sudoku = null;
    private Stack<Sudoku2> undoStack = null;
    private Stack<Sudoku2> redoStack = null;
    private SolutionStep step = null;
    private int chainIndex = -1;
    private SortedMap<Integer, Color> coloringMap = null;
    private SortedMap<Integer, Color> coloringCandidateMap = null;
    private List<SolutionStep> steps;
    private int[] anzSteps;
    private List<String> titels;
    private List<List<SolutionStep>> tabSteps;
    private String name;
    private Date timestamp;
    private SudokuPanel sudokuPanel;
    private SudokuSolver sudokuSolver;
    private SolutionPanel solutionPanel;

    public GuiState() {
    }

    public GuiState(SudokuPanel sudokuPanel, SudokuSolver sudokuSolver, SolutionPanel solutionPanel) {
        this.initialize(sudokuPanel, sudokuSolver, solutionPanel);
    }

    public final void initialize(SudokuPanel sudokuPanel, SudokuSolver sudokuSolver, SolutionPanel solutionPanel) {
        this.sudokuPanel = sudokuPanel;
        this.sudokuSolver = sudokuSolver;
        this.solutionPanel = solutionPanel;
    }

    public void get(boolean copy) {
        if (this.sudokuSolver != null) {
            this.sudokuSolver.getState(this, copy);
        }
        if (this.solutionPanel != null) {
            this.solutionPanel.getState(this, copy);
        }
        if (this.sudokuPanel != null) {
            this.sudokuPanel.getState(this, copy);
        }
    }

    public void set() {
        if (this.sudokuSolver != null) {
            this.sudokuSolver.setState(this);
        }
        if (this.solutionPanel != null) {
            this.solutionPanel.setState(this);
        }
        if (this.sudokuPanel != null) {
            this.sudokuPanel.setState(this);
        }
    }

    public void resetAnzSteps() {
        if (this.steps == null || this.anzSteps == null) {
            Logger.getLogger(GuiState.class.getName()).log(Level.SEVERE, "Trying to reset anzSteps, but attributes have not been set ({0}/{1})!", new Object[]{this.steps, this.anzSteps});
            return;
        }
        StepConfig[] cfg = Options.getInstance().solverSteps;
        int length = cfg.length;
        if (this.anzSteps.length != length) {
            this.anzSteps = new int[length];
        } else {
            int i = 0;
            while (i < this.anzSteps.length) {
                this.anzSteps[i] = 0;
                ++i;
            }
        }
        for (SolutionStep act : this.steps) {
            StepConfig config = act.getType().getStepConfig();
            if (config == null) continue;
            int index = 0;
            index = 0;
            while (index < cfg.length) {
                if (cfg[index] == config) break;
                ++index;
            }
            if (index >= cfg.length) continue;
            int n = index;
            this.anzSteps[n] = this.anzSteps[n] + 1;
        }
    }

    public Sudoku2 getSudoku() {
        return this.sudoku;
    }

    public void setSudoku(Sudoku2 sudoku) {
        this.sudoku = sudoku;
    }

    public Stack<Sudoku2> getUndoStack() {
        return this.undoStack;
    }

    public void setUndoStack(Stack<Sudoku2> undoStack) {
        this.undoStack = undoStack;
    }

    public Stack<Sudoku2> getRedoStack() {
        return this.redoStack;
    }

    public void setRedoStack(Stack<Sudoku2> redoStack) {
        this.redoStack = redoStack;
    }

    public SolutionStep getStep() {
        return this.step;
    }

    public void setStep(SolutionStep step) {
        this.step = step;
    }

    public int getChainIndex() {
        return this.chainIndex;
    }

    public void setChainIndex(int chainIndex) {
        this.chainIndex = chainIndex;
    }

    public SortedMap<Integer, Color> getColoringMap() {
        return this.coloringMap;
    }

    public void setColoringMap(SortedMap<Integer, Color> coloringMap) {
        this.coloringMap = coloringMap;
    }

    public SortedMap<Integer, Color> getColoringCandidateMap() {
        return this.coloringCandidateMap;
    }

    public void setColoringCandidateMap(SortedMap<Integer, Color> coloringCandidateMap) {
        this.coloringCandidateMap = coloringCandidateMap;
    }

    public List<SolutionStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<SolutionStep> steps) {
        this.steps = steps;
    }

    public int[] getAnzSteps() {
        return this.anzSteps;
    }

    public void setAnzSteps(int[] anzSteps) {
        this.anzSteps = anzSteps;
    }

    public List<String> getTitels() {
        return this.titels;
    }

    public void setTitels(List<String> titels) {
        this.titels = titels;
    }

    public List<List<SolutionStep>> getTabSteps() {
        return this.tabSteps;
    }

    public void setTabSteps(List<List<SolutionStep>> tabSteps) {
        if (this.steps == null || this.steps.isEmpty()) {
            this.steps = tabSteps.get(0) != null ? new ArrayList<SolutionStep>((Collection)tabSteps.get(0)) : new ArrayList<SolutionStep>();
        }
        this.tabSteps = tabSteps;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }
}

