/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import sudoku.ColorKuImage;
import sudoku.MainFrame;
import sudoku.Options;
import sudoku.Sudoku2;
import sudoku.SudokuPanel;
import sudoku.SudokuSet;

public class RightClickMenu
extends JPopupMenu
implements ActionListener {
    private static final long serialVersionUID = 2320401834850980638L;
    private MainFrame mainFrame;
    private SudokuPanel sudokuPanel;
    private JMenuItem[] toggleColorItems;
    private JMenuItem[] makeItems = null;
    private JMenuItem[] excludeItems = null;
    private JMenuItem color1aMenuItem;
    private JMenuItem color1bMenuItem;
    private JMenuItem color2aMenuItem;
    private JMenuItem color2bMenuItem;
    private JMenuItem color3aMenuItem;
    private JMenuItem color3bMenuItem;
    private JMenuItem color4aMenuItem;
    private JMenuItem color4bMenuItem;
    private JMenuItem color5aMenuItem;
    private JMenuItem color5bMenuItem;
    private JMenuItem deleteValueMenuItem;
    private JPopupMenu deleteValuePopupMenu;
    private JMenuItem exclude1MenuItem;
    private JMenuItem exclude2MenuItem;
    private JMenuItem exclude3MenuItem;
    private JMenuItem exclude4MenuItem;
    private JMenuItem exclude5MenuItem;
    private JMenuItem exclude6MenuItem;
    private JMenuItem exclude7MenuItem;
    private JMenuItem exclude8MenuItem;
    private JMenuItem exclude9MenuItem;
    private JMenuItem excludeSeveralMenuItem;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JMenuItem make1MenuItem;
    private JMenuItem make2MenuItem;
    private JMenuItem make3MenuItem;
    private JMenuItem make4MenuItem;
    private JMenuItem make5MenuItem;
    private JMenuItem make6MenuItem;
    private JMenuItem make7MenuItem;
    private JMenuItem make8MenuItem;
    private JMenuItem make9MenuItem;

    public RightClickMenu(MainFrame mainFrame, SudokuPanel sudokuPanel) {
        this.mainFrame = mainFrame;
        this.sudokuPanel = sudokuPanel;
        this.initialize();
        this.makeItems = new JMenuItem[]{this.make1MenuItem, this.make2MenuItem, this.make3MenuItem, this.make4MenuItem, this.make5MenuItem, this.make6MenuItem, this.make7MenuItem, this.make8MenuItem, this.make9MenuItem};
        this.excludeItems = new JMenuItem[]{this.exclude1MenuItem, this.exclude2MenuItem, this.exclude3MenuItem, this.exclude4MenuItem, this.exclude5MenuItem, this.exclude6MenuItem, this.exclude7MenuItem, this.exclude8MenuItem, this.exclude9MenuItem};
        this.toggleColorItems = new JMenuItem[]{this.color1aMenuItem, this.color1bMenuItem, this.color2aMenuItem, this.color2bMenuItem, this.color3aMenuItem, this.color3bMenuItem, this.color4aMenuItem, this.color4bMenuItem, this.color5aMenuItem, this.color5bMenuItem};
        this.setColorIconsInPopupMenu();
    }

    private void initialize() {
        this.make1MenuItem = new JMenuItem();
        this.make2MenuItem = new JMenuItem();
        this.make3MenuItem = new JMenuItem();
        this.make4MenuItem = new JMenuItem();
        this.make5MenuItem = new JMenuItem();
        this.make6MenuItem = new JMenuItem();
        this.make7MenuItem = new JMenuItem();
        this.make8MenuItem = new JMenuItem();
        this.make9MenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exclude1MenuItem = new JMenuItem();
        this.exclude2MenuItem = new JMenuItem();
        this.exclude3MenuItem = new JMenuItem();
        this.exclude4MenuItem = new JMenuItem();
        this.exclude5MenuItem = new JMenuItem();
        this.exclude6MenuItem = new JMenuItem();
        this.exclude7MenuItem = new JMenuItem();
        this.exclude8MenuItem = new JMenuItem();
        this.exclude9MenuItem = new JMenuItem();
        this.excludeSeveralMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.color1aMenuItem = new JMenuItem();
        this.color1bMenuItem = new JMenuItem();
        this.color2aMenuItem = new JMenuItem();
        this.color2bMenuItem = new JMenuItem();
        this.color3aMenuItem = new JMenuItem();
        this.color3bMenuItem = new JMenuItem();
        this.color4aMenuItem = new JMenuItem();
        this.color4bMenuItem = new JMenuItem();
        this.color5aMenuItem = new JMenuItem();
        this.color5bMenuItem = new JMenuItem();
        this.deleteValuePopupMenu = new JPopupMenu();
        this.deleteValueMenuItem = new JMenuItem();
        ResourceBundle bundle = ResourceBundle.getBundle("intl/SudokuPanel");
        this.make1MenuItem.setText(bundle.getString("SudokuPanel.popup.make1"));
        this.make1MenuItem.addActionListener(this);
        this.add(this.make1MenuItem);
        this.make2MenuItem.setText(bundle.getString("SudokuPanel.popup.make2"));
        this.make2MenuItem.addActionListener(this);
        this.add(this.make2MenuItem);
        this.make3MenuItem.setText(bundle.getString("SudokuPanel.popup.make3"));
        this.make3MenuItem.addActionListener(this);
        this.add(this.make3MenuItem);
        this.make4MenuItem.setText(bundle.getString("SudokuPanel.popup.make4"));
        this.make4MenuItem.addActionListener(this);
        this.add(this.make4MenuItem);
        this.make5MenuItem.setText(bundle.getString("SudokuPanel.popup.make5"));
        this.make5MenuItem.addActionListener(this);
        this.add(this.make5MenuItem);
        this.make6MenuItem.setText(bundle.getString("SudokuPanel.popup.make6"));
        this.make6MenuItem.addActionListener(this);
        this.add(this.make6MenuItem);
        this.make7MenuItem.setText(bundle.getString("SudokuPanel.popup.make7"));
        this.make7MenuItem.addActionListener(this);
        this.add(this.make7MenuItem);
        this.make8MenuItem.setText(bundle.getString("SudokuPanel.popup.make8"));
        this.make8MenuItem.addActionListener(this);
        this.add(this.make8MenuItem);
        this.make9MenuItem.setText(bundle.getString("SudokuPanel.popup.make9"));
        this.make9MenuItem.addActionListener(this);
        this.add(this.make9MenuItem);
        this.add(this.jSeparator1);
        this.exclude1MenuItem.setText(bundle.getString("SudokuPanel.popup.exclude1"));
        this.exclude1MenuItem.addActionListener(this);
        this.add(this.exclude1MenuItem);
        this.exclude2MenuItem.setText(bundle.getString("SudokuPanel.popup.exclude2"));
        this.exclude2MenuItem.addActionListener(this);
        this.add(this.exclude2MenuItem);
        this.exclude3MenuItem.setText(bundle.getString("SudokuPanel.popup.exclude3"));
        this.exclude3MenuItem.addActionListener(this);
        this.add(this.exclude3MenuItem);
        this.exclude4MenuItem.setText(bundle.getString("SudokuPanel.popup.exclude4"));
        this.exclude4MenuItem.addActionListener(this);
        this.add(this.exclude4MenuItem);
        this.exclude5MenuItem.setText(bundle.getString("SudokuPanel.popup.exclude5"));
        this.exclude5MenuItem.addActionListener(this);
        this.add(this.exclude5MenuItem);
        this.exclude6MenuItem.setText(bundle.getString("SudokuPanel.popup.exclude6"));
        this.exclude6MenuItem.addActionListener(this);
        this.add(this.exclude6MenuItem);
        this.exclude7MenuItem.setText(bundle.getString("SudokuPanel.popup.exclude7"));
        this.exclude7MenuItem.addActionListener(this);
        this.add(this.exclude7MenuItem);
        this.exclude8MenuItem.setText(bundle.getString("SudokuPanel.popup.exclude8"));
        this.exclude8MenuItem.addActionListener(this);
        this.add(this.exclude8MenuItem);
        this.exclude9MenuItem.setText(bundle.getString("SudokuPanel.popup.exclude9"));
        this.exclude9MenuItem.addActionListener(this);
        this.add(this.exclude9MenuItem);
        this.excludeSeveralMenuItem.setText(bundle.getString("SudokuPanel.popup.several"));
        this.excludeSeveralMenuItem.addActionListener(this);
        this.add(this.excludeSeveralMenuItem);
        this.add(this.jSeparator2);
        this.color1aMenuItem.setText(bundle.getString("SudokuPanel.popup.color1a"));
        this.color1aMenuItem.addActionListener(this);
        this.add(this.color1aMenuItem);
        this.color1bMenuItem.setText(bundle.getString("SudokuPanel.popup.color1b"));
        this.color1bMenuItem.addActionListener(this);
        this.add(this.color1bMenuItem);
        this.color2aMenuItem.setText(bundle.getString("SudokuPanel.popup.color2a"));
        this.color2aMenuItem.addActionListener(this);
        this.add(this.color2aMenuItem);
        this.color2bMenuItem.setText(bundle.getString("SudokuPanel.popup.color2b"));
        this.color2bMenuItem.addActionListener(this);
        this.add(this.color2bMenuItem);
        this.color3aMenuItem.setText(bundle.getString("SudokuPanel.popup.color3a"));
        this.color3aMenuItem.addActionListener(this);
        this.add(this.color3aMenuItem);
        this.color3bMenuItem.setText(bundle.getString("SudokuPanel.popup.color3b"));
        this.color3bMenuItem.addActionListener(this);
        this.add(this.color3bMenuItem);
        this.color4aMenuItem.setText(bundle.getString("SudokuPanel.popup.color4a"));
        this.color4aMenuItem.addActionListener(this);
        this.add(this.color4aMenuItem);
        this.color4bMenuItem.setText(bundle.getString("SudokuPanel.popup.color4b"));
        this.color4bMenuItem.addActionListener(this);
        this.add(this.color4bMenuItem);
        this.color5aMenuItem.setText(bundle.getString("SudokuPanel.popup.color5a"));
        this.color5aMenuItem.addActionListener(this);
        this.add(this.color5aMenuItem);
        this.color5bMenuItem.setText(bundle.getString("SudokuPanel.popup.color5b"));
        this.color5bMenuItem.addActionListener(this);
        this.add(this.color5bMenuItem);
        this.deleteValueMenuItem.setText(bundle.getString("SudokuPanel.deleteValueItem.text"));
        this.deleteValueMenuItem.addActionListener(this);
        this.deleteValuePopupMenu.add(this.deleteValueMenuItem);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.make1MenuItem || e.getSource() == this.make2MenuItem || e.getSource() == this.make3MenuItem || e.getSource() == this.make4MenuItem || e.getSource() == this.make5MenuItem || e.getSource() == this.make6MenuItem || e.getSource() == this.make7MenuItem || e.getSource() == this.make8MenuItem || e.getSource() == this.make9MenuItem) {
            this.popupSetCell((JMenuItem)e.getSource());
            this.setVisible(false);
            this.sudokuPanel.repaint();
            return;
        }
        if (e.getSource() == this.exclude1MenuItem || e.getSource() == this.exclude2MenuItem || e.getSource() == this.exclude3MenuItem || e.getSource() == this.exclude4MenuItem || e.getSource() == this.exclude5MenuItem || e.getSource() == this.exclude6MenuItem || e.getSource() == this.exclude7MenuItem || e.getSource() == this.exclude8MenuItem || e.getSource() == this.exclude9MenuItem) {
            this.popupExcludeCandidate((JMenuItem)e.getSource());
            this.setVisible(false);
            this.sudokuPanel.repaint();
            return;
        }
        if (e.getSource() == this.excludeSeveralMenuItem) {
            this.excludeSeveralMenuItemActionPerformed(e);
            this.setVisible(false);
            this.sudokuPanel.repaint();
            return;
        }
        if (e.getSource() == this.color1aMenuItem || e.getSource() == this.color1bMenuItem || e.getSource() == this.color2aMenuItem || e.getSource() == this.color2bMenuItem || e.getSource() == this.color3aMenuItem || e.getSource() == this.color3bMenuItem || e.getSource() == this.color4aMenuItem || e.getSource() == this.color4bMenuItem || e.getSource() == this.color5aMenuItem || e.getSource() == this.color5bMenuItem) {
            this.popupToggleColor((JMenuItem)e.getSource());
            this.sudokuPanel.repaint();
            return;
        }
        if (e.getSource() == this.deleteValueMenuItem) {
            this.popupDeleteValueFromCell();
            this.setVisible(false);
            this.sudokuPanel.repaint();
            return;
        }
    }

    public void setColorIconInPopupMenu(JMenuItem item, Color color, boolean colorKu) {
        if (color == null) {
            item.setIcon(null);
            return;
        }
        try {
            BufferedImage img = null;
            if (colorKu) {
                img = new ColorKuImage(12, color);
            } else {
                img = ImageIO.read(this.getClass().getResource("/img/c_icon.png"));
                Graphics2D gImg = (Graphics2D)img.getGraphics();
                gImg.setColor(color);
                gImg.fillRect(1, 1, 12, 12);
            }
            item.setIcon(new ImageIcon(img));
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error setting color icons in popup menu", ex);
        }
    }

    public final void setColorIconsInPopupMenu() {
        this.setColorIconInPopupMenu(this.color1aMenuItem, Options.getInstance().getColoringColors()[0], false);
        this.setColorIconInPopupMenu(this.color1bMenuItem, Options.getInstance().getColoringColors()[1], false);
        this.setColorIconInPopupMenu(this.color2aMenuItem, Options.getInstance().getColoringColors()[2], false);
        this.setColorIconInPopupMenu(this.color2bMenuItem, Options.getInstance().getColoringColors()[3], false);
        this.setColorIconInPopupMenu(this.color3aMenuItem, Options.getInstance().getColoringColors()[4], false);
        this.setColorIconInPopupMenu(this.color3bMenuItem, Options.getInstance().getColoringColors()[5], false);
        this.setColorIconInPopupMenu(this.color4aMenuItem, Options.getInstance().getColoringColors()[6], false);
        this.setColorIconInPopupMenu(this.color4bMenuItem, Options.getInstance().getColoringColors()[7], false);
        this.setColorIconInPopupMenu(this.color5aMenuItem, Options.getInstance().getColoringColors()[8], false);
        this.setColorIconInPopupMenu(this.color5bMenuItem, Options.getInstance().getColoringColors()[9], false);
    }

    public void setColorkuInPopupMenu(boolean on) {
        if (on) {
            this.setColorIconInPopupMenu(this.make1MenuItem, Options.getInstance().getColorKuColor(1), true);
            this.setColorIconInPopupMenu(this.make2MenuItem, Options.getInstance().getColorKuColor(2), true);
            this.setColorIconInPopupMenu(this.make3MenuItem, Options.getInstance().getColorKuColor(3), true);
            this.setColorIconInPopupMenu(this.make4MenuItem, Options.getInstance().getColorKuColor(4), true);
            this.setColorIconInPopupMenu(this.make5MenuItem, Options.getInstance().getColorKuColor(5), true);
            this.setColorIconInPopupMenu(this.make6MenuItem, Options.getInstance().getColorKuColor(6), true);
            this.setColorIconInPopupMenu(this.make7MenuItem, Options.getInstance().getColorKuColor(7), true);
            this.setColorIconInPopupMenu(this.make8MenuItem, Options.getInstance().getColorKuColor(8), true);
            this.setColorIconInPopupMenu(this.make9MenuItem, Options.getInstance().getColorKuColor(9), true);
            this.setColorIconInPopupMenu(this.exclude1MenuItem, Options.getInstance().getColorKuColor(1), true);
            this.setColorIconInPopupMenu(this.exclude2MenuItem, Options.getInstance().getColorKuColor(2), true);
            this.setColorIconInPopupMenu(this.exclude3MenuItem, Options.getInstance().getColorKuColor(3), true);
            this.setColorIconInPopupMenu(this.exclude4MenuItem, Options.getInstance().getColorKuColor(4), true);
            this.setColorIconInPopupMenu(this.exclude5MenuItem, Options.getInstance().getColorKuColor(5), true);
            this.setColorIconInPopupMenu(this.exclude6MenuItem, Options.getInstance().getColorKuColor(6), true);
            this.setColorIconInPopupMenu(this.exclude7MenuItem, Options.getInstance().getColorKuColor(7), true);
            this.setColorIconInPopupMenu(this.exclude8MenuItem, Options.getInstance().getColorKuColor(8), true);
            this.setColorIconInPopupMenu(this.exclude9MenuItem, Options.getInstance().getColorKuColor(9), true);
            this.excludeSeveralMenuItem.setEnabled(false);
        } else {
            this.setColorIconInPopupMenu(this.make1MenuItem, null, false);
            this.setColorIconInPopupMenu(this.make2MenuItem, null, false);
            this.setColorIconInPopupMenu(this.make3MenuItem, null, false);
            this.setColorIconInPopupMenu(this.make4MenuItem, null, false);
            this.setColorIconInPopupMenu(this.make5MenuItem, null, false);
            this.setColorIconInPopupMenu(this.make6MenuItem, null, false);
            this.setColorIconInPopupMenu(this.make7MenuItem, null, false);
            this.setColorIconInPopupMenu(this.make8MenuItem, null, false);
            this.setColorIconInPopupMenu(this.make9MenuItem, null, false);
            this.setColorIconInPopupMenu(this.exclude1MenuItem, null, false);
            this.setColorIconInPopupMenu(this.exclude2MenuItem, null, false);
            this.setColorIconInPopupMenu(this.exclude3MenuItem, null, false);
            this.setColorIconInPopupMenu(this.exclude4MenuItem, null, false);
            this.setColorIconInPopupMenu(this.exclude5MenuItem, null, false);
            this.setColorIconInPopupMenu(this.exclude6MenuItem, null, false);
            this.setColorIconInPopupMenu(this.exclude7MenuItem, null, false);
            this.setColorIconInPopupMenu(this.exclude8MenuItem, null, false);
            this.setColorIconInPopupMenu(this.exclude9MenuItem, null, false);
            this.excludeSeveralMenuItem.setEnabled(true);
        }
    }

    public void popupExcludeCandidate(JMenuItem menuItem) {
        int candidate = -1;
        int i = 0;
        while (i < this.excludeItems.length) {
            if (this.excludeItems[i] == menuItem) {
                candidate = i + 1;
                break;
            }
            ++i;
        }
        if (candidate != -1) {
            this.sudokuPanel.pushUndo();
            boolean changed = this.sudokuPanel.removeCandidateFromActiveCells(candidate);
            if (changed) {
                this.sudokuPanel.clearRedoStack();
                this.sudokuPanel.checkProgress();
            } else {
                this.sudokuPanel.popUndo();
            }
            this.sudokuPanel.updateCellZoomPanel();
            this.mainFrame.check();
            this.mainFrame.fixFocus();
            this.repaint();
        }
    }

    public void popupToggleColor(JMenuItem menuItem) {
        Color color = null;
        int i = 0;
        while (i < this.toggleColorItems.length) {
            if (this.toggleColorItems[i] == menuItem) {
                color = Options.getInstance().getColoringColors()[i];
                break;
            }
            ++i;
        }
        if (color != null) {
            int aktRow = this.sudokuPanel.getActiveRow();
            int aktCol = this.sudokuPanel.getActiveCol();
            this.sudokuPanel.handleColoring(aktRow, aktCol, -1, color);
            this.sudokuPanel.updateCellZoomPanel();
            this.mainFrame.check();
            this.repaint();
        }
    }

    public void showPopupMenu(int row, int col, int cellSize) {
        if (!Sudoku2.isValidIndex(row, col)) {
            return;
        }
        boolean isSingleCell = this.sudokuPanel.getSelectedCells().isEmpty() || this.sudokuPanel.getSelectedCells().size() == 1 && this.sudokuPanel.getSelectedCells().get(0) == Sudoku2.getIndex(row, col);
        this.jSeparator2.setVisible(true);
        if (this.sudokuPanel.getSudoku().getValue(row, col) != 0 && isSingleCell) {
            if (!this.sudokuPanel.getSudoku().isFixed(row, col)) {
                this.deleteValuePopupMenu.show(this.sudokuPanel, this.sudokuPanel.getX(row, col) + cellSize, this.sudokuPanel.getY(row, col));
            }
            return;
        }
        this.excludeSeveralMenuItem.setVisible(false);
        int i = 1;
        while (i <= 9) {
            this.makeItems[i - 1].setVisible(false);
            this.excludeItems[i - 1].setVisible(false);
            ++i;
        }
        SudokuSet candSet = this.sudokuPanel.collectCandidates(true);
        int i2 = 0;
        while (i2 < candSet.size()) {
            this.makeItems[candSet.get(i2) - 1].setVisible(true);
            ++i2;
        }
        candSet = this.sudokuPanel.collectCandidates(false);
        if (candSet.size() > 1) {
            if (candSet.size() > 2) {
                this.excludeSeveralMenuItem.setVisible(true);
            }
            i2 = 0;
            while (i2 < candSet.size()) {
                this.excludeItems[candSet.get(i2) - 1].setVisible(true);
                ++i2;
            }
        } else {
            this.jSeparator2.setVisible(false);
        }
        this.show(this.sudokuPanel, this.sudokuPanel.getX(row, col) + cellSize, this.sudokuPanel.getY(row, col));
    }

    public void popupSetCell(JMenuItem menuItem) {
        int candidate = -1;
        int i = 0;
        while (i < this.makeItems.length) {
            if (this.makeItems[i] == menuItem) {
                candidate = i + 1;
                break;
            }
            ++i;
        }
        int aktRow = this.sudokuPanel.getActiveRow();
        int aktCol = this.sudokuPanel.getActiveCol();
        if (candidate != -1) {
            this.sudokuPanel.pushUndo();
            boolean changed = false;
            if (this.sudokuPanel.getSelectedCells().isEmpty()) {
                if (this.sudokuPanel.getSudoku().getValue(aktRow, aktCol) == 0) {
                    this.sudokuPanel.setCell(aktRow, aktCol, candidate);
                    changed = true;
                }
            } else {
                for (int index : this.sudokuPanel.getSelectedCells()) {
                    if (this.sudokuPanel.getSudoku().getValue(index) != 0) continue;
                    this.sudokuPanel.getSudoku().setCell(index, candidate);
                    changed = true;
                }
            }
            if (changed) {
                this.sudokuPanel.clearRedoStack();
                this.sudokuPanel.checkProgress();
            } else {
                this.sudokuPanel.popUndo();
            }
            this.sudokuPanel.updateCellZoomPanel();
            this.mainFrame.check();
            this.mainFrame.fixFocus();
            this.repaint();
        }
    }

    public void popupDeleteValueFromCell() {
        this.sudokuPanel.pushUndo();
        boolean changed = false;
        int aktRow = this.sudokuPanel.getActiveRow();
        int aktCol = this.sudokuPanel.getActiveCol();
        if (this.sudokuPanel.getSudoku().getValue(aktRow, aktCol) != 0 && !this.sudokuPanel.getSudoku().isFixed(aktRow, aktCol)) {
            this.sudokuPanel.getSudoku().setCell(aktRow, aktCol, 0);
            changed = true;
        }
        if (changed) {
            this.sudokuPanel.clearRedoStack();
            this.sudokuPanel.checkProgress();
        } else {
            this.sudokuPanel.popUndo();
        }
        this.sudokuPanel.updateCellZoomPanel();
        this.mainFrame.fixFocus();
        this.mainFrame.check();
        this.repaint();
    }

    public void excludeSeveralMenuItemActionPerformed(ActionEvent evt) {
        String input = JOptionPane.showInputDialog(this, ResourceBundle.getBundle("intl/SudokuPanel").getString("SudokuPanel.cmessage"), ResourceBundle.getBundle("intl/SudokuPanel").getString("SudokuPanel.ctitle"), 3);
        if (input != null) {
            this.sudokuPanel.pushUndo();
            boolean changed = false;
            int i = 0;
            while (i < input.length()) {
                char digit = input.charAt(i);
                if (Character.isDigit(digit) && this.sudokuPanel.removeCandidateFromActiveCells(Character.getNumericValue(digit))) {
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                this.sudokuPanel.clearRedoStack();
                this.sudokuPanel.checkProgress();
            } else {
                this.sudokuPanel.popUndo();
            }
            this.sudokuPanel.updateCellZoomPanel();
            this.mainFrame.check();
            this.repaint();
        }
    }

    public void deleteValuePopup(int row, int col, int cellSize) {
        this.deleteValuePopupMenu.show(this, this.sudokuPanel.getX(row, col) + cellSize, this.sudokuPanel.getY(row, col));
    }
}

