/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import generator.SudokuGenerator;
import generator.SudokuGeneratorFactory;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import solver.SudokuSolver;
import solver.SudokuSolverFactory;
import sudoku.ClipboardMode;
import sudoku.DifficultyLevel;
import sudoku.SolutionStep;
import sudoku.SolutionType;
import sudoku.StepType;
import sudoku.Sudoku2;

class SearchForTypeThread
extends Thread {
    private List<StepType> typeList;
    private DifficultyLevel level;
    private int anz = 0;
    private int anzFound = 0;
    private String outFile = null;

    SearchForTypeThread(List<StepType> typeList, DifficultyLevel level, String outFile) {
        this.typeList = typeList;
        this.level = level;
        this.outFile = outFile;
    }

    private void appendPuzzleString(PuzzleType pType, boolean mode1) {
        int mode = mode1 ? pType.isPuzzleMode1 : pType.isPuzzleMode2;
        switch (mode) {
            case -1: {
                break;
            }
            case 3: {
                pType.puzzleString = String.valueOf(pType.puzzleString) + " s";
                break;
            }
            case 1: 
            case 2: {
                pType.puzzleString = String.valueOf(pType.puzzleString) + " ssts";
                break;
            }
            case 0: {
                pType.puzzleString = String.valueOf(pType.puzzleString) + " x";
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        PuzzleType[] puzzleTypes = new PuzzleType[this.typeList.size()];
        StringBuilder pathBuffer = new StringBuilder();
        int index = 0;
        for (StepType tmpType : this.typeList) {
            pathBuffer.append(tmpType.type.getArgName()).append("_");
            puzzleTypes[index] = new PuzzleType(tmpType);
            ++index;
        }
        if (this.level == null) {
            pathBuffer.deleteCharAt(pathBuffer.length() - 1);
        } else {
            pathBuffer.append(this.level.getName());
        }
        if (pathBuffer.length() > 50) {
            pathBuffer.delete(50, pathBuffer.length() - 1);
        }
        pathBuffer.append(".txt");
        if (this.outFile != null) {
            pathBuffer = new StringBuilder(this.outFile);
        }
        this.anz = 0;
        this.anzFound = 0;
        try {
            BufferedWriter out = null;
            if (!pathBuffer.toString().equals("stdout")) {
                out = new BufferedWriter(new FileWriter(pathBuffer.toString(), true));
            }
            SudokuGenerator generator = SudokuGeneratorFactory.getDefaultGeneratorInstance();
            SudokuSolver solver = SudokuSolverFactory.getDefaultSolverInstance();
            new Sudoku2();
            while (!this.isInterrupted()) {
                Sudoku2 newSudoku = generator.generateSudoku(false);
                Sudoku2 clonedSudoku = newSudoku.clone();
                solver.setSudoku(clonedSudoku);
                solver.solve();
                if (this.level != null && (!clonedSudoku.isSolved() || clonedSudoku.getLevel().getOrdinal() != this.level.getOrdinal())) continue;
                if (puzzleTypes.length == 0) {
                    String txt = newSudoku.getSudoku(ClipboardMode.CLUES_ONLY);
                    if (out != null) {
                        out.write(String.valueOf(txt) + " #" + this.level.getName());
                        out.newLine();
                        out.flush();
                    }
                    System.out.println(String.valueOf(txt) + " #" + this.level.getName());
                    ++this.anzFound;
                }
                int i = 0;
                while (i < puzzleTypes.length) {
                    puzzleTypes[i].reset();
                    ++i;
                }
                List<SolutionStep> steps = solver.getSteps();
                int i2 = 0;
                while (i2 < steps.size()) {
                    SolutionType type = steps.get(i2).getType();
                    int j = 0;
                    while (j < puzzleTypes.length) {
                        block38: {
                            block40: {
                                block39: {
                                    block37: {
                                        if (!type.equals((Object)puzzleTypes[j].type.type)) break block37;
                                        int anzCandDel = steps.get(i2).getAnzCandidatesToDelete();
                                        if (puzzleTypes[j].anzCandDel < anzCandDel) {
                                            puzzleTypes[j].anzCandDel = anzCandDel;
                                        }
                                        StringBuilder stepName = new StringBuilder(" " + type.getArgName());
                                        if (type.isFish()) {
                                            if (steps.get(i2).getEndoFins().size() > 0) {
                                                stepName.append("e");
                                            }
                                            if (steps.get(i2).getCannibalistic().size() > 0) {
                                                stepName.append("c");
                                            }
                                        }
                                        stepName.append("(").append(anzCandDel).append(")");
                                        if (!puzzleTypes[j].immediatelyFollowed) {
                                            if (!puzzleTypes[j].typeSeen) {
                                                this.appendPuzzleString(puzzleTypes[j], true);
                                            } else {
                                                this.appendPuzzleString(puzzleTypes[j], false);
                                                puzzleTypes[j].isPuzzleMode2 = -1;
                                            }
                                            puzzleTypes[j].typeSeen = true;
                                            puzzleTypes[j].immediatelyFollowed = true;
                                        }
                                        puzzleTypes[j].puzzleString = String.valueOf(puzzleTypes[j].puzzleString) + stepName.toString();
                                        break block38;
                                    }
                                    puzzleTypes[j].immediatelyFollowed = false;
                                    if (!type.isSingle()) break block39;
                                    if (puzzleTypes[j].typeSeen && puzzleTypes[j].isPuzzleMode2 == -1) {
                                        puzzleTypes[j].isPuzzleMode2 = 3;
                                    }
                                    if (puzzleTypes[j].isPuzzleMode1 == -1) {
                                        puzzleTypes[j].isPuzzleMode1 = 3;
                                    }
                                    break block38;
                                }
                                if (!type.isSSTS()) break block40;
                                if (puzzleTypes[j].typeSeen) {
                                    if (puzzleTypes[j].isPuzzleMode2 == -1 || puzzleTypes[j].isPuzzleMode2 > 2) {
                                        puzzleTypes[j].isPuzzleMode2 = 1;
                                    }
                                    if (puzzleTypes[j].isPuzzleMode1 > 1) {
                                        puzzleTypes[j].isPuzzleMode1 = 1;
                                    }
                                    break block38;
                                } else if (puzzleTypes[j].isPuzzleMode1 == 3 || puzzleTypes[j].isPuzzleMode1 == -1) {
                                    puzzleTypes[j].isPuzzleMode1 = 2;
                                }
                                break block38;
                            }
                            if (puzzleTypes[j].typeSeen) {
                                puzzleTypes[j].isPuzzleMode2 = 0;
                            }
                            puzzleTypes[j].isPuzzleMode1 = 0;
                        }
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < puzzleTypes.length) {
                    block41: {
                        String txt;
                        block42: {
                            txt = null;
                            if (!puzzleTypes[i2].typeSeen || puzzleTypes[i2].isPuzzleMode1 < puzzleTypes[i2].type.puzzleType) break block41;
                            if (puzzleTypes[i2].type.compType == -1) break block42;
                            switch (puzzleTypes[i2].type.compType) {
                                case 0: {
                                    if (puzzleTypes[i2].anzCandDel == puzzleTypes[i2].type.compAnz) break;
                                    break block41;
                                }
                                case 1: {
                                    if (puzzleTypes[i2].anzCandDel < puzzleTypes[i2].type.compAnz) break;
                                    break block41;
                                }
                                case 2: {
                                    if (puzzleTypes[i2].anzCandDel <= puzzleTypes[i2].type.compAnz) break block41;
                                }
                            }
                        }
                        this.appendPuzzleString(puzzleTypes[i2], false);
                        if (txt == null) {
                            txt = newSudoku.getSudoku(ClipboardMode.CLUES_ONLY);
                        }
                        if (out != null) {
                            out.write(String.valueOf(txt) + " #" + puzzleTypes[i2].puzzleString);
                            out.newLine();
                            out.flush();
                        }
                        System.out.println(String.valueOf(txt) + " #" + puzzleTypes[i2].puzzleString);
                        ++this.anzFound;
                    }
                    ++i2;
                }
                ++this.anz;
            }
            if (out == null) return;
            out.close();
            return;
        }
        catch (IOException ex) {
            System.out.println("Error writing sudoku file");
            ex.printStackTrace();
        }
    }

    public int getAnz() {
        return this.anz;
    }

    public int getAnzFound() {
        return this.anzFound;
    }

    private final class PuzzleType {
        StepType type;
        boolean typeSeen = false;
        boolean immediatelyFollowed = false;
        int isPuzzleMode1 = -1;
        int isPuzzleMode2 = -1;
        String puzzleString = "";
        int anzCandDel = 0;

        PuzzleType(StepType type) {
            this.reset();
            this.type = type;
        }

        void reset() {
            this.typeSeen = false;
            this.immediatelyFollowed = false;
            this.isPuzzleMode1 = -1;
            this.isPuzzleMode2 = -1;
            this.puzzleString = "";
            this.anzCandDel = 0;
        }
    }
}

