/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import solver.Als;
import solver.RestrictedCommon;
import sudoku.AlsInSolutionStep;
import sudoku.Candidate;
import sudoku.Chain;
import sudoku.Entity;
import sudoku.Options;
import sudoku.SolutionType;
import sudoku.Sudoku2;
import sudoku.SudokuSet;

public class SolutionStep
implements Comparable<SolutionStep>,
Cloneable {
    private static final String[] entityNames = new String[]{ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.block"), ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.line"), ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.col"), ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.cell")};
    private static final String[] entityShortNames = new String[]{"b", "r", "c", ""};
    private static final DecimalFormat FISH_FORMAT = new DecimalFormat("#00");
    private SolutionType type;
    private SolutionType subType;
    private int entity;
    private int entityNumber;
    private int entity2;
    private int entity2Number;
    private boolean isSiamese;
    private int progressScoreSingles = -1;
    private int progressScoreSinglesOnly = -1;
    private int progressScore = -1;
    private List<Integer> values = new ArrayList<Integer>();
    private List<Integer> indices = new ArrayList<Integer>();
    private List<Candidate> candidatesToDelete = new ArrayList<Candidate>();
    private List<Candidate> cannibalistic = new ArrayList<Candidate>();
    private List<Candidate> fins = new ArrayList<Candidate>();
    private List<Candidate> endoFins = new ArrayList<Candidate>();
    private List<Entity> baseEntities = new ArrayList<Entity>();
    private List<Entity> coverEntities = new ArrayList<Entity>();
    private List<Chain> chains = new ArrayList<Chain>();
    private List<AlsInSolutionStep> alses = new ArrayList<AlsInSolutionStep>();
    private SortedMap<Integer, Integer> colorCandidates = new TreeMap<Integer, Integer>();
    private List<RestrictedCommon> restrictedCommons = new ArrayList<RestrictedCommon>();
    private SudokuSet potentialCannibalisticEliminations = new SudokuSet();
    private SudokuSet potentialEliminations = new SudokuSet();

    public SolutionStep() {
    }

    public SolutionStep(SolutionType type) {
        this.setType(type);
    }

    public Object clone() {
        SolutionStep newStep = null;
        try {
            newStep = (SolutionStep)super.clone();
            newStep.type = this.type;
            newStep.entity = this.entity;
            newStep.entityNumber = this.entityNumber;
            newStep.entity2 = this.entity2;
            newStep.entity2Number = this.entity2Number;
            newStep.isSiamese = this.isSiamese;
            newStep.progressScoreSingles = this.progressScoreSingles;
            newStep.progressScoreSinglesOnly = this.progressScoreSinglesOnly;
            newStep.progressScore = this.progressScore;
            newStep.values = (List)((ArrayList)this.values).clone();
            newStep.indices = (List)((ArrayList)this.indices).clone();
            newStep.candidatesToDelete = (List)((ArrayList)this.candidatesToDelete).clone();
            newStep.cannibalistic = (List)((ArrayList)this.cannibalistic).clone();
            newStep.fins = (List)((ArrayList)this.fins).clone();
            newStep.endoFins = (List)((ArrayList)this.endoFins).clone();
            newStep.baseEntities = (List)((ArrayList)this.baseEntities).clone();
            newStep.coverEntities = (List)((ArrayList)this.coverEntities).clone();
            newStep.chains = (List)((ArrayList)this.chains).clone();
            newStep.alses = (List)((ArrayList)this.alses).clone();
            newStep.colorCandidates = (SortedMap)((TreeMap)this.getColorCandidates()).clone();
            newStep.restrictedCommons = (List)((ArrayList)this.restrictedCommons).clone();
            newStep.potentialCannibalisticEliminations = this.potentialCannibalisticEliminations.clone();
            newStep.potentialEliminations = this.potentialEliminations.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error while cloning", ex);
        }
        return newStep;
    }

    public void reset() {
        this.type = SolutionType.HIDDEN_SINGLE;
        this.entity = 0;
        this.entityNumber = 0;
        this.entity2 = 0;
        this.entity2Number = 0;
        this.isSiamese = false;
        this.progressScoreSingles = -1;
        this.progressScoreSinglesOnly = -1;
        this.progressScore = -1;
        this.values.clear();
        this.indices.clear();
        this.candidatesToDelete.clear();
        this.cannibalistic.clear();
        this.fins.clear();
        this.endoFins.clear();
        this.baseEntities.clear();
        this.coverEntities.clear();
        this.chains.clear();
        this.alses.clear();
        this.colorCandidates.clear();
        this.restrictedCommons.clear();
        this.potentialCannibalisticEliminations.clear();
        this.potentialEliminations.clear();
    }

    public StringBuffer getForcingChainString(Chain chain) {
        return this.getForcingChainString(chain.getChain(), chain.getStart(), chain.getEnd(), true);
    }

    public StringBuffer getForcingChainString(int[] chain, int start, int end, boolean weakLinks) {
        StringBuffer tmp = new StringBuffer();
        boolean inMin = false;
        this.appendForcingChainEntry(tmp, chain[start]);
        int i = start + 1;
        while (i <= end - 1) {
            boolean blank = true;
            if (chain[i] == Integer.MIN_VALUE) {
                tmp.append(")");
                inMin = false;
            } else if (weakLinks || Chain.isSStrong(chain[i]) || chain[i] <= 0 && (chain[i] >= 0 || chain[i + 1] >= 0 || chain[i + 1] == Integer.MIN_VALUE) || Chain.getSNodeType(chain[i]) != 0) {
                if (chain[i] < 0 && !inMin) {
                    tmp.append(" (");
                    inMin = true;
                    blank = false;
                }
                if (chain[i] > 0 && inMin) {
                    tmp.append(")");
                    inMin = false;
                }
                if (blank) {
                    tmp.append(" ");
                }
                this.appendForcingChainEntry(tmp, chain[i]);
            }
            ++i;
        }
        tmp.append(" ");
        this.appendForcingChainEntry(tmp, chain[end]);
        return tmp;
    }

    public void appendForcingChainEntry(StringBuffer buf, int chainEntry) {
        int entry = chainEntry < 0 ? -chainEntry : chainEntry;
        switch (Chain.getSNodeType(entry)) {
            case 0: {
                buf.append(SolutionStep.getCellPrint(Chain.getSCellIndex(entry), false));
                break;
            }
            case 1: {
                buf.append(SolutionStep.getCompactCellPrint(Chain.getSCellIndex(entry), Chain.getSCellIndex2(entry), Chain.getSCellIndex3(entry)));
                break;
            }
            case 2: {
                int alsIndex = Chain.getSCellIndex2(entry);
                if (alsIndex >= 0 && alsIndex < this.alses.size()) {
                    buf.append("ALS:");
                    this.getAls(buf, alsIndex, false);
                    break;
                }
                buf.append("UNKNOWN ALS");
            }
        }
        if (!Chain.isSStrong(entry)) {
            buf.append("<>");
        } else {
            buf.append("=");
        }
        buf.append(Chain.getSCandidate(entry));
    }

    public StringBuffer getChainString(Chain chain) {
        return this.getChainString(chain.getChain(), chain.getStart(), chain.getEnd(), false, true, true, false);
    }

    public StringBuffer getChainString(Chain chain, boolean internalFormat) {
        return this.getChainString(chain.getChain(), chain.getStart(), chain.getEnd(), true, true, true, internalFormat);
    }

    public StringBuffer getChainString(int[] chain, int start, int end, boolean alternate, boolean up) {
        return this.getChainString(chain, start, end, alternate, up, true, false);
    }

    public StringBuffer getChainString(int[] chain, int start, int end, boolean alternate, boolean up, boolean asNiceLoop, boolean internalFormat) {
        StringBuffer tmp = new StringBuffer();
        boolean isStrong = false;
        int lastIndex = -1;
        if (up) {
            int i = start;
            while (i <= end) {
                if (internalFormat) {
                    if (i > start) {
                        tmp.append("-");
                    }
                    tmp.append(chain[i]);
                } else {
                    if (i == start + 1) {
                        isStrong = Chain.isSStrong(chain[i]);
                    } else {
                        boolean bl = isStrong = !isStrong;
                    }
                    if (!asNiceLoop || Chain.getSCellIndex(chain[i]) != lastIndex) {
                        lastIndex = Chain.getSCellIndex(chain[i]);
                        if (i > start) {
                            int cand = Chain.getSCandidate(chain[i]);
                            if (!Chain.isSStrong(chain[i]) || alternate && !isStrong) {
                                tmp.append(" -");
                                tmp.append(cand);
                                tmp.append("- ");
                            } else {
                                tmp.append(" =");
                                tmp.append(cand);
                                tmp.append("= ");
                            }
                        }
                        switch (Chain.getSNodeType(chain[i])) {
                            case 0: {
                                tmp.append(SolutionStep.getCellPrint(Chain.getSCellIndex(chain[i]), false));
                                break;
                            }
                            case 1: {
                                tmp.append(SolutionStep.getCompactCellPrint(Chain.getSCellIndex(chain[i]), Chain.getSCellIndex2(chain[i]), Chain.getSCellIndex3(chain[i])));
                                break;
                            }
                            case 2: {
                                int alsIndex = Chain.getSCellIndex2(chain[i]);
                                if (alsIndex < this.alses.size()) {
                                    tmp.append("ALS:");
                                    this.getAls(tmp, alsIndex, false);
                                    break;
                                }
                                tmp.append("UNKNOWN ALS");
                                break;
                            }
                            default: {
                                tmp.append("INV");
                            }
                        }
                    }
                }
                ++i;
            }
        } else {
            int i = end;
            while (i >= start) {
                if (internalFormat) {
                    if (i > start) {
                        tmp.append("-");
                    }
                    tmp.append(chain[i]);
                } else {
                    if (i == end - 1) {
                        isStrong = Chain.isSStrong(chain[i + 1]);
                    } else {
                        boolean bl = isStrong = !isStrong;
                    }
                    if (Chain.getSCellIndex(chain[i + 1]) != lastIndex) {
                        lastIndex = Chain.getSCellIndex(chain[i + 1]);
                        if (i < end) {
                            int cand = Chain.getSCandidate(chain[i]);
                            if (!Chain.isSStrong(chain[i + 1]) || alternate && !isStrong) {
                                tmp.append(" -");
                                tmp.append(cand);
                                tmp.append("- ");
                            } else {
                                tmp.append(" =");
                                tmp.append(cand);
                                tmp.append("= ");
                            }
                        }
                        switch (Chain.getSNodeType(chain[i])) {
                            case 0: {
                                tmp.append(SolutionStep.getCellPrint(Chain.getSCellIndex(chain[i]), false));
                                break;
                            }
                            case 1: {
                                tmp.append(SolutionStep.getCompactCellPrint(Chain.getSCellIndex(chain[i]), Chain.getSCellIndex2(chain[i]), Chain.getSCellIndex3(chain[i])));
                                break;
                            }
                            case 2: {
                                int alsIndex = Chain.getSCellIndex2(chain[i]);
                                if (alsIndex < this.alses.size()) {
                                    tmp.append("ALS:");
                                    this.getAls(tmp, alsIndex, false);
                                    break;
                                }
                                tmp.append("UNKNOWN ALS");
                            }
                        }
                    }
                }
                --i;
            }
        }
        return tmp;
    }

    public String getValueIndexString() {
        StringBuilder tmp = new StringBuilder();
        int i = 0;
        while (i < this.values.size()) {
            int value = this.values.get(i);
            int j = 0;
            while (j < this.indices.size()) {
                int index = this.indices.get(j);
                tmp.append(value);
                tmp.append(Integer.toString(Sudoku2.getRow(index) + 1));
                tmp.append(Integer.toString(Sudoku2.getCol(index) + 1));
                tmp.append(" ");
                ++j;
            }
            ++i;
        }
        return tmp.toString().trim();
    }

    public String getSingleCandidateString() {
        return String.valueOf(this.getStepName()) + ": " + SolutionStep.getCompactCellPrint(this.indices) + "=" + this.values.get(0);
    }

    public String getCandidateString() {
        return this.getCandidateString(false, false);
    }

    public String getCandidateString(boolean library) {
        return this.getCandidateString(library, false);
    }

    public String getCandidateString(boolean library, boolean statistics) {
        Collections.sort(this.candidatesToDelete);
        this.eliminateDoubleCandidatesToDelete();
        StringBuilder candBuff = new StringBuilder();
        int lastCand = -1;
        StringBuffer delPos = new StringBuffer();
        for (Candidate cand : this.candidatesToDelete) {
            if (cand.getValue() != lastCand) {
                if (lastCand != -1) {
                    candBuff.append("/");
                }
                candBuff.append(cand.getValue());
                lastCand = cand.getValue();
            }
            delPos.append(" ");
            if (!library) continue;
            delPos.append(Integer.toString(cand.getValue())).append(Integer.toString(Sudoku2.getRow(cand.getIndex()) + 1)).append(Integer.toString(Sudoku2.getCol(cand.getIndex()) + 1));
        }
        if (library) {
            return delPos.toString().trim();
        }
        delPos = new StringBuffer();
        this.getCandidatesToDelete(delPos);
        delPos.delete(0, 4);
        if (statistics) {
            return String.valueOf(candBuff.toString()) + " (" + this.getAnzCandidatesToDelete() + ")" + " (0/0)";
        }
        String tmpStepName = this.getStepName();
        if (this.isSiamese) {
            tmpStepName = String.valueOf(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.siamese")) + " " + this.getStepName();
        }
        return String.valueOf(candBuff.toString()) + " (" + this.getAnzCandidatesToDelete() + "):" + delPos.toString() + " (" + tmpStepName + ")";
    }

    private void eliminateDoubleCandidatesToDelete() {
        TreeSet<Candidate> candSet = new TreeSet<Candidate>();
        int i = 0;
        while (i < this.candidatesToDelete.size()) {
            candSet.add(this.candidatesToDelete.get(i));
            ++i;
        }
        this.candidatesToDelete.clear();
        for (Candidate cand : candSet) {
            this.candidatesToDelete.add(cand);
        }
    }

    public static String getCellPrint(int index) {
        return SolutionStep.getCellPrint(index, true);
    }

    public static String getCellPrint(int index, boolean withParen) {
        if (withParen) {
            return "[r" + (Sudoku2.getRow(index) + 1) + "c" + (Sudoku2.getCol(index) + 1) + "]";
        }
        return "r" + (Sudoku2.getRow(index) + 1) + "c" + (Sudoku2.getCol(index) + 1);
    }

    public static String getCompactCellPrint(int index1, int index2, int index3) {
        TreeSet<Integer> tmpSet = new TreeSet<Integer>();
        tmpSet.add(index1);
        tmpSet.add(index2);
        if (index3 != -1) {
            tmpSet.add(index3);
        }
        String result = SolutionStep.getCompactCellPrint(tmpSet);
        return result;
    }

    public static String getCompactCellPrint(SudokuSet set) {
        TreeSet<Integer> tmpSet = new TreeSet<Integer>();
        int i = 0;
        while (i < set.size()) {
            tmpSet.add(set.get(i));
            ++i;
        }
        String result = SolutionStep.getCompactCellPrint(tmpSet);
        return result;
    }

    public static String getCompactCellPrint(List<Integer> indices) {
        return SolutionStep.getCompactCellPrint(indices, 0, indices.size() - 1);
    }

    public static String getCompactCellPrint(List<Integer> indices, int start, int end) {
        TreeSet<Integer> tmpSet = new TreeSet<Integer>();
        int i = start;
        while (i <= end) {
            tmpSet.add(indices.get(i));
            ++i;
        }
        return SolutionStep.getCompactCellPrint(tmpSet);
    }

    public static String getCompactCellPrint(TreeSet<Integer> tmpSet) {
        int index;
        StringBuilder tmp = new StringBuilder();
        boolean first = true;
        while (tmpSet.size() > 0) {
            index = tmpSet.pollFirst();
            int line = Sudoku2.getRow(index);
            int col = Sudoku2.getCol(index);
            int anzLines = 1;
            int anzCols = 1;
            if (first) {
                first = false;
            } else {
                tmp.append(",");
            }
            tmp.append(SolutionStep.getCellPrint(index));
            Iterator<Integer> it = tmpSet.iterator();
            while (it.hasNext()) {
                int pIndex;
                int i1 = it.next();
                int l1 = Sudoku2.getRow(i1);
                int c1 = Sudoku2.getCol(i1);
                if (l1 == line && anzLines == 1) {
                    pIndex = tmp.lastIndexOf("]");
                    tmp.insert(pIndex, c1 + 1);
                    it.remove();
                    ++anzCols;
                    continue;
                }
                if (c1 != col || anzCols != true) continue;
                pIndex = tmp.lastIndexOf("c");
                tmp.insert(pIndex, l1 + 1);
                it.remove();
                ++anzLines;
            }
        }
        index = 0;
        while ((index = tmp.indexOf("[")) != -1) {
            tmp.deleteCharAt(index);
        }
        while ((index = tmp.indexOf("]")) != -1) {
            tmp.deleteCharAt(index);
        }
        return tmp.toString();
    }

    public final void setType(SolutionType type) {
        boolean found = false;
        SolutionType[] solutionTypeArray = SolutionType.values();
        int n = solutionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SolutionType t = solutionTypeArray[n2];
            if (t == type) {
                found = true;
                break;
            }
            ++n2;
        }
        if (!found) {
            throw new RuntimeException(String.valueOf(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.invalid_setType")) + " (" + (Object)((Object)type) + ")");
        }
        this.type = type;
    }

    public void addValue(int value) {
        if (value < 1 || value > 9) {
            throw new RuntimeException(String.valueOf(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.invalid_setValue")) + " (" + value + ")");
        }
        this.values.add(value);
    }

    public void addIndex(int index) {
        if (index < 0 || index > 80) {
            throw new RuntimeException(String.valueOf(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.invalid_setIndex")) + " (" + index + ")");
        }
        this.indices.add(index);
    }

    public void addCandidateToDelete(Candidate cand) {
        this.candidatesToDelete.add(cand);
    }

    public void addCandidateToDelete(int index, int candidate) {
        this.candidatesToDelete.add(new Candidate(index, candidate));
    }

    public void addCannibalistic(Candidate cand) {
        this.cannibalistic.add(cand);
    }

    public void addCannibalistic(int index, int candidate) {
        this.cannibalistic.add(new Candidate(index, candidate));
    }

    public void addFin(int index, int candidate) {
        this.addFin(new Candidate(index, candidate));
    }

    public void addFin(Candidate fin) {
        this.fins.add(fin);
    }

    public void addEndoFin(int index, int candidate) {
        this.endoFins.add(new Candidate(index, candidate));
    }

    public int getAnzCandidatesToDelete() {
        TreeSet<Candidate> tmpSet = new TreeSet<Candidate>();
        int i = 0;
        while (i < this.candidatesToDelete.size()) {
            tmpSet.add(this.candidatesToDelete.get(i));
            ++i;
        }
        int anz = tmpSet.size();
        tmpSet.clear();
        tmpSet = null;
        return anz;
    }

    public int getAnzSet() {
        if (this.type.isSingle()) {
            return 1;
        }
        if ((this.type == SolutionType.FORCING_CHAIN || this.type == SolutionType.FORCING_CHAIN_CONTRADICTION || this.type == SolutionType.FORCING_CHAIN_VERITY || this.type == SolutionType.FORCING_NET || this.type == SolutionType.FORCING_NET_CONTRADICTION || this.type == SolutionType.FORCING_NET_VERITY) && this.indices.size() > 0) {
            return 1;
        }
        if (this.type == SolutionType.TEMPLATE_SET) {
            return this.indices.size();
        }
        return 0;
    }

    public SolutionType getType() {
        return this.type;
    }

    public List<Integer> getValues() {
        return this.values;
    }

    public List<Integer> getIndices() {
        return this.indices;
    }

    public List<Candidate> getCandidatesToDelete() {
        return this.candidatesToDelete;
    }

    public List<Candidate> getCannibalistic() {
        return this.cannibalistic;
    }

    public List<Candidate> getFins() {
        return this.fins;
    }

    public List<Candidate> getEndoFins() {
        return this.endoFins;
    }

    public String getStepName() {
        return this.type.getStepName();
    }

    public static String getStepName(SolutionType type) {
        return type.getStepName();
    }

    public static String getStepName(int type) {
        return SolutionType.values()[type].getStepName();
    }

    public String getEntityName(int name) {
        return entityNames[name];
    }

    public String getEntityShortName(int name) {
        return entityShortNames[name];
    }

    public String getEntityName() {
        return entityNames[this.entity];
    }

    public String getEntityName2() {
        return entityNames[this.entity2];
    }

    public String getEntityShortName() {
        return entityShortNames[this.entity];
    }

    public String getEntityShortNameNumber() {
        if (this.entity == 3) {
            return SolutionStep.getCellPrint(this.entityNumber, false);
        }
        return String.valueOf(entityShortNames[this.entity]) + Integer.toString(this.entityNumber + 1);
    }

    public String getEntityShortName2() {
        return entityShortNames[this.entity2];
    }

    public String toString() {
        return this.toString(2);
    }

    public boolean isGiveUp() {
        return this.type == SolutionType.GIVE_UP;
    }

    public String toString(int art) {
        String str = null;
        int index = 0;
        switch (this.type) {
            case FULL_HOUSE: 
            case HIDDEN_SINGLE: 
            case NAKED_SINGLE: {
                index = this.indices.get(0);
                str = this.getStepName();
                if (art == 1) {
                    str = String.valueOf(str) + ": " + this.values.get(0);
                    break;
                }
                if (art != 2) break;
                str = String.valueOf(str) + ": " + SolutionStep.getCellPrint(index, false) + "=" + this.values.get(0);
                break;
            }
            case HIDDEN_PAIR: 
            case HIDDEN_TRIPLE: 
            case HIDDEN_QUADRUPLE: 
            case NAKED_PAIR: 
            case NAKED_TRIPLE: 
            case NAKED_QUADRUPLE: 
            case LOCKED_PAIR: 
            case LOCKED_TRIPLE: {
                index = this.indices.get(0);
                str = this.getStepName();
                StringBuffer tmp = new StringBuffer(str);
                if (art >= 1) {
                    tmp.append(": ");
                    if (this.type == SolutionType.HIDDEN_PAIR || this.type == SolutionType.NAKED_PAIR || this.type == SolutionType.LOCKED_PAIR) {
                        tmp.append(this.values.get(0));
                        tmp.append(",");
                        tmp.append(this.values.get(1));
                    } else if (this.type == SolutionType.HIDDEN_TRIPLE || this.type == SolutionType.NAKED_TRIPLE || this.type == SolutionType.LOCKED_TRIPLE) {
                        tmp.append(this.values.get(0));
                        tmp.append(",");
                        tmp.append(this.values.get(1));
                        tmp.append(",");
                        tmp.append(this.values.get(2));
                    } else if (this.type == SolutionType.HIDDEN_QUADRUPLE || this.type == SolutionType.NAKED_QUADRUPLE) {
                        tmp.append(this.values.get(0));
                        tmp.append(",");
                        tmp.append(this.values.get(1));
                        tmp.append(",");
                        tmp.append(this.values.get(2));
                        tmp.append(",");
                        tmp.append(this.values.get(3));
                    }
                }
                if (art >= 2) {
                    tmp.append(" ");
                    tmp.append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.in"));
                    tmp.append(" ");
                    tmp.append(SolutionStep.getCompactCellPrint(this.indices));
                    this.getCandidatesToDelete(tmp);
                }
                str = tmp.toString();
                break;
            }
            case LOCKED_CANDIDATES: 
            case LOCKED_CANDIDATES_1: 
            case LOCKED_CANDIDATES_2: {
                str = this.getStepName();
                if (art >= 1) {
                    str = String.valueOf(str) + ": " + this.values.get(0);
                }
                if (art < 2) break;
                str = String.valueOf(str) + " " + ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.in") + " " + this.getEntityShortName() + this.getEntityNumber();
                StringBuffer tmp = new StringBuffer(str);
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case SKYSCRAPER: 
            case TWO_STRING_KITE: 
            case DUAL_TWO_STRING_KITE: {
                str = this.getStepName();
                if (art >= 1) {
                    str = String.valueOf(str) + ": " + this.values.get(0);
                }
                if (art < 2) break;
                str = String.valueOf(str) + " " + ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.in") + " " + SolutionStep.getCompactCellPrint(this.indices, 0, 1);
                if (this.type == SolutionType.DUAL_TWO_STRING_KITE) {
                    str = String.valueOf(str) + "/" + ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.in") + " " + SolutionStep.getCompactCellPrint(this.indices, 4, 5);
                }
                str = String.valueOf(str) + " (" + ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.connected_by") + " " + SolutionStep.getCompactCellPrint(this.indices, 2, 3) + ")";
                StringBuffer tmp = new StringBuffer(str);
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case EMPTY_RECTANGLE: 
            case DUAL_EMPTY_RECTANGLE: {
                str = this.getStepName();
                if (art >= 1) {
                    str = String.valueOf(str) + ": " + this.values.get(0);
                }
                if (art < 2) break;
                str = String.valueOf(str) + " " + ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.in") + " " + this.getEntityShortName() + this.getEntityNumber() + " (" + SolutionStep.getCompactCellPrint(this.indices, 0, 1);
                if (this.type == SolutionType.DUAL_EMPTY_RECTANGLE) {
                    str = String.valueOf(str) + "/" + SolutionStep.getCompactCellPrint(this.indices, 2, 3);
                }
                str = String.valueOf(str) + ")";
                StringBuffer tmp = new StringBuffer(str);
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case W_WING: {
                str = this.getStepName();
                if (art >= 1) {
                    str = String.valueOf(str) + ": " + this.values.get(0) + "/" + this.values.get(1);
                }
                if (art < 2) break;
                StringBuffer tmp = new StringBuffer(str);
                tmp.append(" ");
                tmp.append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.in"));
                tmp.append(" ");
                tmp.append(SolutionStep.getCompactCellPrint(this.indices, 0, 1));
                tmp.append(" ");
                tmp.append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.connected_by"));
                tmp.append(" ");
                tmp.append(this.values.get(1));
                tmp.append(" ");
                tmp.append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.in"));
                tmp.append(" ");
                this.getFinSet(tmp, this.fins, false);
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case XY_WING: 
            case XYZ_WING: {
                str = this.getStepName();
                if (art >= 1) {
                    str = String.valueOf(str) + ": " + this.values.get(0) + "/" + this.values.get(1);
                }
                if (art < 2) break;
                str = String.valueOf(str) + "/" + this.values.get(2) + " " + ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.in") + " " + SolutionStep.getCompactCellPrint(this.indices);
                StringBuffer tmp = new StringBuffer(str);
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case SIMPLE_COLORS: 
            case MULTI_COLORS: 
            case SIMPLE_COLORS_TRAP: 
            case SIMPLE_COLORS_WRAP: 
            case MULTI_COLORS_1: 
            case MULTI_COLORS_2: {
                str = this.getStepName();
                if (art >= 1) {
                    str = String.valueOf(str) + ": " + this.values.get(0);
                }
                if (art < 2) break;
                StringBuffer tmp = new StringBuffer(str);
                this.getColorCellPrint(tmp);
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case X_CHAIN: 
            case XY_CHAIN: 
            case REMOTE_PAIR: 
            case NICE_LOOP: 
            case CONTINUOUS_NICE_LOOP: 
            case DISCONTINUOUS_NICE_LOOP: 
            case GROUPED_NICE_LOOP: 
            case GROUPED_CONTINUOUS_NICE_LOOP: 
            case GROUPED_DISCONTINUOUS_NICE_LOOP: 
            case AIC: 
            case GROUPED_AIC: 
            case TURBOT_FISH: {
                Chain ch;
                str = this.getStepName();
                if (art >= 1) {
                    str = this.type == SolutionType.REMOTE_PAIR ? String.valueOf(str) + ": " + this.values.get(0) + "/" + this.values.get(1) : String.valueOf(str) + ": " + this.getCandidatesToDeleteDigits();
                }
                if (art < 2) break;
                StringBuffer tmpChain = this.getChainString(this.getChains().get(0));
                if (this.type == SolutionType.CONTINUOUS_NICE_LOOP || this.type == SolutionType.GROUPED_CONTINUOUS_NICE_LOOP) {
                    ch = this.getChains().get(0);
                    int start = ch.getStart();
                    int cellIndex = ch.getCellIndex(start);
                    while (ch.getCellIndex(start) == cellIndex) {
                        ++start;
                    }
                    int end = ch.getEnd();
                    cellIndex = ch.getCellIndex(end);
                    while (ch.getCellIndex(end) == cellIndex) {
                        --end;
                    }
                    tmpChain.insert(0, String.valueOf(ch.getCandidate(++end)) + "= ");
                    tmpChain.append(" =").append(ch.getCandidate(start));
                }
                if (this.type == SolutionType.AIC || this.type == SolutionType.GROUPED_AIC || this.type == SolutionType.XY_CHAIN) {
                    ch = this.getChains().get(0);
                    tmpChain.insert(0, String.valueOf(ch.getCandidate(ch.getStart())) + "- ");
                    tmpChain.append(" -").append(ch.getCandidate(ch.getEnd()));
                }
                str = String.valueOf(str) + " " + tmpChain;
                StringBuffer tmp = new StringBuffer(str);
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case FORCING_CHAIN: 
            case FORCING_CHAIN_CONTRADICTION: 
            case FORCING_CHAIN_VERITY: 
            case FORCING_NET: 
            case FORCING_NET_CONTRADICTION: 
            case FORCING_NET_VERITY: {
                str = this.getStepName();
                if (art < 2) break;
                if (this.type == SolutionType.FORCING_CHAIN_CONTRADICTION || this.type == SolutionType.FORCING_NET_CONTRADICTION) {
                    str = String.valueOf(str) + " " + ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.in") + " " + this.getEntityShortNameNumber();
                }
                if (this.indices.size() > 0) {
                    str = String.valueOf(str) + " => " + SolutionStep.getCellPrint(this.indices.get(0), false) + "=" + this.values.get(0);
                } else {
                    StringBuffer tmp = new StringBuffer(str);
                    this.getCandidatesToDelete(tmp);
                    str = tmp.toString();
                }
                int i = 0;
                while (i < this.chains.size()) {
                    str = String.valueOf(str) + "\r\n  " + this.getForcingChainString(this.getChains().get(i));
                    ++i;
                }
                break;
            }
            case UNIQUENESS_1: 
            case UNIQUENESS_2: 
            case UNIQUENESS_3: 
            case UNIQUENESS_4: 
            case UNIQUENESS_5: 
            case UNIQUENESS_6: 
            case HIDDEN_RECTANGLE: 
            case AVOIDABLE_RECTANGLE_1: 
            case AVOIDABLE_RECTANGLE_2: {
                str = this.getStepName();
                if (art >= 1) {
                    str = String.valueOf(str) + ": " + this.values.get(0) + "/" + this.values.get(1);
                }
                if (art < 2) break;
                str = String.valueOf(str) + " in " + SolutionStep.getCompactCellPrint(this.indices);
                StringBuffer tmp = new StringBuffer(str);
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case BUG_PLUS_1: {
                str = this.getStepName();
                if (art < 2) break;
                StringBuffer tmp = new StringBuffer(str);
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case X_WING: 
            case SWORDFISH: 
            case JELLYFISH: 
            case SQUIRMBAG: 
            case WHALE: 
            case LEVIATHAN: 
            case FINNED_X_WING: 
            case FINNED_SWORDFISH: 
            case FINNED_JELLYFISH: 
            case FINNED_SQUIRMBAG: 
            case FINNED_WHALE: 
            case FINNED_LEVIATHAN: 
            case SASHIMI_X_WING: 
            case SASHIMI_SWORDFISH: 
            case SASHIMI_JELLYFISH: 
            case SASHIMI_SQUIRMBAG: 
            case SASHIMI_WHALE: 
            case SASHIMI_LEVIATHAN: 
            case FRANKEN_X_WING: 
            case FRANKEN_SWORDFISH: 
            case FRANKEN_JELLYFISH: 
            case FRANKEN_SQUIRMBAG: 
            case FRANKEN_WHALE: 
            case FRANKEN_LEVIATHAN: 
            case FINNED_FRANKEN_X_WING: 
            case FINNED_FRANKEN_SWORDFISH: 
            case FINNED_FRANKEN_JELLYFISH: 
            case FINNED_FRANKEN_SQUIRMBAG: 
            case FINNED_FRANKEN_WHALE: 
            case FINNED_FRANKEN_LEVIATHAN: 
            case MUTANT_X_WING: 
            case MUTANT_SWORDFISH: 
            case MUTANT_JELLYFISH: 
            case MUTANT_SQUIRMBAG: 
            case MUTANT_WHALE: 
            case MUTANT_LEVIATHAN: 
            case FINNED_MUTANT_X_WING: 
            case FINNED_MUTANT_SWORDFISH: 
            case FINNED_MUTANT_JELLYFISH: 
            case FINNED_MUTANT_SQUIRMBAG: 
            case FINNED_MUTANT_WHALE: 
            case FINNED_MUTANT_LEVIATHAN: 
            case KRAKEN_FISH: 
            case KRAKEN_FISH_TYPE_1: 
            case KRAKEN_FISH_TYPE_2: {
                StringBuffer tmp = new StringBuffer();
                if (this.isSiamese) {
                    tmp.append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.siamese")).append(" ");
                }
                tmp.append(this.getStepName());
                if (art >= 1) {
                    if (this.type.isKrakenFish()) {
                        tmp.append(": ");
                        this.getCandidatesToDelete(tmp);
                        tmp.append("\r\n  ").append(this.subType.getStepName());
                    }
                    tmp.append(": ").append(this.values.get(0));
                }
                if (art >= 2) {
                    tmp.append(" ");
                    this.getEntities(tmp, this.baseEntities, true, false);
                    tmp.append(" ");
                    this.getEntities(tmp, this.coverEntities, true, true);
                    int displayMode = Options.getInstance().getFishDisplayMode();
                    if (this.type.isKrakenFish()) {
                        displayMode = 0;
                    }
                    switch (displayMode) {
                        case 0: {
                            if (this.fins.size() > 0) {
                                tmp.append(" ");
                                this.getFins(tmp, false, true);
                            }
                            if (this.endoFins.size() <= 0) break;
                            tmp.append(" ");
                            this.getFins(tmp, true, true);
                            break;
                        }
                        case 1: {
                            this.getFishStatistics(tmp, false);
                            break;
                        }
                        case 2: {
                            this.getFishStatistics(tmp, true);
                        }
                    }
                    if (!this.type.isKrakenFish()) {
                        this.getCandidatesToDelete(tmp);
                    }
                }
                if (this.type.isKrakenFish()) {
                    int i = 0;
                    while (i < this.chains.size()) {
                        tmp.append("\r\n  ").append(this.getChainString(this.chains.get(i)));
                        ++i;
                    }
                }
                str = tmp.toString();
                break;
            }
            case SUE_DE_COQ: {
                str = this.getStepName();
                StringBuffer tmp = new StringBuffer(String.valueOf(str) + ": ");
                if (art >= 1) {
                    this.getIndexValueSet(tmp);
                    str = tmp.toString();
                }
                if (art < 2) break;
                tmp.append(" (");
                this.getFinSet(tmp, this.fins);
                tmp.append(", ");
                this.getFinSet(tmp, this.endoFins);
                tmp.append(")");
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case ALS_XZ: {
                str = this.getStepName();
                StringBuffer tmp = new StringBuffer(String.valueOf(str) + ": ");
                if (art >= 1) {
                    tmp.append("A=");
                    this.getAls(tmp, 0);
                    str = tmp.toString();
                }
                if (art < 2) break;
                tmp.append(", B=");
                this.getAls(tmp, 1);
                tmp.append(", X=");
                this.getAlsXorZ(tmp, true);
                if (!this.fins.isEmpty()) {
                    tmp.append(", Z=");
                    this.getAlsXorZ(tmp, false);
                }
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case ALS_XY_WING: {
                StringBuffer tmp;
                str = this.getStepName();
                if (art == 1) {
                    tmp = new StringBuffer(String.valueOf(str) + ": ");
                    tmp.append("C=");
                    this.getAls(tmp, 2);
                    str = tmp.toString();
                }
                if (art < 2) break;
                tmp = new StringBuffer(String.valueOf(str) + ": ");
                tmp.append("A=");
                this.getAls(tmp, 0);
                tmp.append(", B=");
                this.getAls(tmp, 1);
                tmp.append(", C=");
                this.getAls(tmp, 2);
                tmp.append(", X,Y=");
                this.getAlsXorZ(tmp, true);
                tmp.append(", Z=");
                this.getAlsXorZ(tmp, false);
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case ALS_XY_CHAIN: {
                StringBuffer tmp;
                str = this.getStepName();
                if (this.restrictedCommons.isEmpty()) {
                    StringBuffer tmp2;
                    if (art == 1) {
                        tmp2 = new StringBuffer(String.valueOf(str) + ": ");
                        tmp2.append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.start")).append("=");
                        this.getAls(tmp2, 0);
                        tmp2.append(", ").append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.end")).append("=");
                        this.getAls(tmp2, this.alses.size() - 1);
                        str = tmp2.toString();
                    }
                    if (art < 2) break;
                    tmp2 = new StringBuffer(String.valueOf(str) + ": ");
                    char alsChar = 'A';
                    boolean first = true;
                    int i = 0;
                    while (i < this.alses.size()) {
                        if (first) {
                            first = false;
                        } else {
                            tmp2.append(", ");
                        }
                        char c = alsChar;
                        alsChar = (char)(c + 1);
                        tmp2.append(c);
                        tmp2.append("=");
                        this.getAls(tmp2, i);
                        ++i;
                    }
                    tmp2.append(", RCs=");
                    this.getAlsXorZ(tmp2, true);
                    tmp2.append(", X=");
                    this.getAlsXorZ(tmp2, false);
                    this.getCandidatesToDelete(tmp2);
                    str = tmp2.toString();
                    break;
                }
                if (art == 1) {
                    tmp = new StringBuffer(String.valueOf(str) + ": ");
                    tmp.append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.start")).append("=");
                    this.getAls(tmp, 0);
                    tmp.append(", ").append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.end")).append("=");
                    this.getAls(tmp, this.alses.size() - 1);
                    str = tmp.toString();
                }
                if (art < 2) break;
                tmp = new StringBuffer(String.valueOf(str) + ": ");
                this.getCandidatesToDeleteDigits(tmp);
                tmp.append("- ");
                int i = 0;
                while (i < this.alses.size()) {
                    this.getAls(tmp, i);
                    if (i < this.restrictedCommons.size()) {
                        this.getRestrictedCommon(this.restrictedCommons.get(i), tmp);
                    }
                    ++i;
                }
                tmp.append(" -");
                this.getCandidatesToDeleteDigits(tmp);
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case DEATH_BLOSSOM: {
                str = this.getStepName();
                StringBuffer tmp = new StringBuffer(String.valueOf(str) + ": ");
                if (art >= 1) {
                    tmp.append(SolutionStep.getCellPrint(this.indices.get(0)));
                    str = tmp.toString();
                }
                if (art < 2) break;
                int i = 0;
                while (i < this.alses.size()) {
                    tmp.append(", ");
                    this.getRestrictedCommon(this.restrictedCommons.get(i), tmp);
                    this.getAls(tmp, i);
                    ++i;
                }
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case TEMPLATE_SET: {
                str = this.getStepName();
                if (art == 1) {
                    str = String.valueOf(str) + ": " + this.values.get(0);
                }
                if (art < 2) break;
                StringBuffer tmp = new StringBuffer(String.valueOf(str) + ": ");
                tmp.append(SolutionStep.getCompactCellPrint(this.indices)).append("=").append(this.values.get(0));
                str = tmp.toString();
                break;
            }
            case TEMPLATE_DEL: {
                str = this.getStepName();
                if (art < 2) break;
                StringBuffer tmp = new StringBuffer(String.valueOf(str) + ": ");
                this.getCandidatesToDelete(tmp);
                str = tmp.toString();
                break;
            }
            case BRUTE_FORCE: {
                str = this.getStepName();
                if (art == 1) {
                    str = String.valueOf(str) + ": " + this.values.get(0);
                }
                if (art < 2) break;
                StringBuffer tmp = new StringBuffer(String.valueOf(str) + ": ");
                tmp.append(SolutionStep.getCompactCellPrint(this.indices)).append("=").append(this.values.get(0));
                str = tmp.toString();
                break;
            }
            case INCOMPLETE: {
                str = ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.incomplete_solution");
                break;
            }
            case GIVE_UP: {
                StringBuffer tmp = new StringBuffer();
                tmp.append(this.getStepName());
                if (art >= 1) {
                    tmp.append(": ").append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.dont_know"));
                }
                str = tmp.toString();
                break;
            }
            default: {
                throw new RuntimeException(String.valueOf(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.invalid_type")) + " (" + (Object)((Object)this.type) + ")!");
            }
        }
        return str;
    }

    private void getFishStatistics(StringBuffer tmp, boolean cells) {
        tmp.append(" ");
        SudokuSet set = new SudokuSet();
        int i = 0;
        while (i < this.indices.size()) {
            set.add(this.indices.get(i));
            ++i;
        }
        set.andNot(this.potentialCannibalisticEliminations);
        this.appendFishData(tmp, set, "V", cells);
        set.clear();
        i = 0;
        while (i < this.fins.size()) {
            set.add(this.fins.get(i).getIndex());
            ++i;
        }
        i = 0;
        while (i < this.endoFins.size()) {
            set.remove(this.endoFins.get(i).getIndex());
            ++i;
        }
        this.appendFishData(tmp, set, "XF", cells);
        set.clear();
        i = 0;
        while (i < this.endoFins.size()) {
            set.add(this.endoFins.get(i).getIndex());
            ++i;
        }
        this.appendFishData(tmp, set, "NF", cells);
        set.clear();
        i = 0;
        while (i < this.candidatesToDelete.size()) {
            set.add(this.candidatesToDelete.get(i).getIndex());
            ++i;
        }
        this.appendFishData(tmp, set, "EE", cells);
        set.clear();
        i = 0;
        while (i < this.cannibalistic.size()) {
            set.add(this.cannibalistic.get(i).getIndex());
            ++i;
        }
        this.appendFishData(tmp, set, "CE", cells);
        set.set(this.potentialEliminations);
        set.or(this.potentialCannibalisticEliminations);
        this.appendFishData(tmp, set, "PE", cells);
    }

    private void appendFishData(StringBuffer tmp, SudokuSet set, String prefix, boolean cells) {
        tmp.append(prefix);
        tmp.append("(");
        if (cells) {
            tmp.append(SolutionStep.getCompactCellPrint(set));
        } else {
            tmp.append(FISH_FORMAT.format(set.size()));
        }
        tmp.append(") ");
    }

    private void getColorCellPrint(StringBuffer tmp) {
        tmp.append(" ");
        StringBuffer[] bufs = new StringBuffer[Options.getInstance().getColoringColors().length];
        for (int index : this.getColorCandidates().keySet()) {
            int color = (Integer)this.getColorCandidates().get(index);
            if (bufs[color] == null) {
                bufs[color] = new StringBuffer();
                bufs[color].append("(");
            } else {
                bufs[color].append(",");
            }
            bufs[color].append(SolutionStep.getCellPrint(index, false));
        }
        int i = 0;
        while (i < bufs.length) {
            if (bufs[i] != null) {
                bufs[i].append(")");
                if (i % 2 != 0) {
                    tmp.append(" / ");
                } else if (i > 0) {
                    tmp.append(", ");
                }
                tmp.append(bufs[i]);
            }
            ++i;
        }
    }

    private void getAlsXorZ(StringBuffer tmp, boolean x) {
        List<Candidate> list = x ? this.endoFins : this.fins;
        TreeSet<Integer> cands = new TreeSet<Integer>();
        int i = 0;
        while (i < list.size()) {
            cands.add(list.get(i).getValue());
            ++i;
        }
        boolean first = true;
        Iterator iterator = cands.iterator();
        while (iterator.hasNext()) {
            int cand = (Integer)iterator.next();
            if (first) {
                first = false;
            } else {
                tmp.append(",");
            }
            tmp.append(cand);
        }
    }

    public static String getAls(Als als) {
        return SolutionStep.getAls(als, true);
    }

    public static String getAls(Als als, boolean withCandidates) {
        StringBuilder tmp = new StringBuilder();
        TreeSet<Integer> set = new TreeSet<Integer>();
        int i = 0;
        while (i < als.indices.size()) {
            set.add(als.indices.get(i));
            ++i;
        }
        tmp.append(SolutionStep.getCompactCellPrint(set));
        if (withCandidates) {
            tmp.append(" {");
            int[] cands = Sudoku2.POSSIBLE_VALUES[als.candidates];
            int i2 = 0;
            while (i2 < cands.length) {
                tmp.append(cands[i2]);
                ++i2;
            }
            tmp.append("}");
        }
        return tmp.toString();
    }

    public void getAls(StringBuffer tmp, int alsIndex) {
        this.getAls(tmp, alsIndex, true);
    }

    public void getAls(StringBuffer tmp, int alsIndex, boolean withCandidates) {
        AlsInSolutionStep als = this.alses.get(alsIndex);
        tmp.append(SolutionStep.getCompactCellPrint(als.getIndices()));
        if (withCandidates) {
            tmp.append(" {");
            for (Integer cand : als.getCandidates()) {
                tmp.append(cand);
            }
            tmp.append("}");
        }
    }

    private void getIndexValueSet(StringBuffer tmp) {
        tmp.append(SolutionStep.getCompactCellPrint(this.indices));
        tmp.append(" - {");
        for (Integer value : this.values) {
            tmp.append(value);
        }
        tmp.append("}");
    }

    private void getFinSet(StringBuffer tmp, List<Candidate> fins) {
        this.getFinSet(tmp, fins, true);
    }

    private void getFinSet(StringBuffer tmp, List<Candidate> fins, boolean withCandidates) {
        TreeSet<Integer> indexes = new TreeSet<Integer>();
        TreeSet<Integer> candidates = new TreeSet<Integer>();
        for (Candidate cand : fins) {
            indexes.add(cand.getIndex());
            candidates.add(cand.getValue());
        }
        Iterator<Comparable<Candidate>> iterator = this.indices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            indexes.remove(index);
        }
        tmp.append(SolutionStep.getCompactCellPrint(indexes));
        if (withCandidates) {
            tmp.append(" - {");
            iterator = candidates.iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                tmp.append(value);
            }
            tmp.append("}");
        }
    }

    public void getEntities(StringBuffer tmp, List<Entity> entities) {
        this.getEntities(tmp, entities, false);
    }

    public void getEntities(StringBuffer tmp, List<Entity> entities, boolean library) {
        this.getEntities(tmp, entities, library, false);
    }

    public void getEntities(StringBuffer tmp, List<Entity> entities, boolean library, boolean checkSiamese) {
        boolean first = true;
        if (!library) {
            tmp.append("(");
        }
        int siameseIndex = entities.size() / 2 - 1;
        int lastEntityName = -1;
        int index = 0;
        for (Entity act : entities) {
            if (first) {
                first = false;
            } else if (!library) {
                tmp.append(", ");
            }
            if (library) {
                if (lastEntityName != act.getEntityName()) {
                    tmp.append(this.getEntityShortName(act.getEntityName()));
                }
                tmp.append(act.getEntityNumber());
            } else {
                tmp.append(this.getEntityName(act.getEntityName())).append(" ").append(act.getEntityNumber());
            }
            lastEntityName = act.getEntityName();
            if (checkSiamese && this.isSiamese && index == siameseIndex) {
                tmp.append("/");
                lastEntityName = -1;
            }
            ++index;
        }
        if (!library) {
            tmp.append(")");
        }
    }

    private void getIndexes(StringBuffer tmp) {
        boolean first = true;
        for (int index : this.indices) {
            if (first) {
                first = false;
            } else {
                tmp.append(", ");
            }
            tmp.append(SolutionStep.getCellPrint(index, false));
        }
    }

    private void getRestrictedCommon(RestrictedCommon rc, StringBuffer tmp) {
        int anz = 0;
        tmp.append(" -");
        if (rc.getActualRC() == 1 || rc.getActualRC() == 3) {
            tmp.append(rc.getCand1());
            ++anz;
        }
        if (rc.getActualRC() == 2 || rc.getActualRC() == 3) {
            tmp.append(rc.getCand2());
            ++anz;
        }
        tmp.append("- ");
    }

    private void getCandidatesToDeleteDigits(StringBuffer tmp) {
        TreeSet<Integer> candSet = new TreeSet<Integer>();
        int i = 0;
        while (i < this.candidatesToDelete.size()) {
            candSet.add(this.candidatesToDelete.get(i).getValue());
            ++i;
        }
        Iterator iterator = candSet.iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            tmp.append(value);
        }
    }

    private String getCandidatesToDeleteDigits() {
        StringBuffer tmp = new StringBuffer();
        this.getCandidatesToDeleteDigits(tmp);
        int compactLength = tmp.length();
        int i = 0;
        while (i < compactLength - 1) {
            tmp.insert(i * 2 + 1, "/");
            ++i;
        }
        return tmp.toString();
    }

    private void getCandidatesToDelete(StringBuffer tmp) {
        tmp.append(" => ");
        ArrayList tmpList = (ArrayList)((ArrayList)this.candidatesToDelete).clone();
        boolean first = true;
        ArrayList<Integer> candList = new ArrayList<Integer>();
        while (tmpList.size() > 0) {
            Candidate firstCand = (Candidate)tmpList.remove(0);
            candList.clear();
            candList.add(firstCand.getIndex());
            Iterator it = tmpList.iterator();
            while (it.hasNext()) {
                Candidate c1 = (Candidate)it.next();
                if (c1.getValue() != firstCand.getValue()) continue;
                candList.add(c1.getIndex());
                it.remove();
            }
            if (first) {
                first = false;
            } else {
                tmp.append(", ");
            }
            tmp.append(SolutionStep.getCompactCellPrint(candList));
            tmp.append("<>");
            tmp.append(firstCand.getValue());
        }
    }

    public void getFins(StringBuffer tmp, boolean endo) {
        this.getFins(tmp, endo, false);
    }

    public void getFins(StringBuffer tmp, boolean endo, boolean library) {
        List<Candidate> list;
        List<Candidate> list2 = list = endo ? this.endoFins : this.fins;
        if (list.isEmpty()) {
            return;
        }
        if (!library) {
            if (list.size() == 1) {
                if (endo) {
                    tmp.append(" ").append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.endofin_in")).append(" ");
                } else {
                    tmp.append(" ").append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.fin_in")).append(" ");
                }
            } else if (endo) {
                tmp.append(" ").append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.endofins_in")).append(" ");
            } else {
                tmp.append(" ").append(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.fins_in")).append(" ");
            }
        }
        String finStr = endo ? "ef" : "f";
        boolean first = true;
        for (Candidate cand : list) {
            if (first) {
                first = false;
            } else if (library) {
                tmp.append(" ");
            } else {
                tmp.append(", ");
            }
            if (library) {
                tmp.append(finStr).append(SolutionStep.getCellPrint(cand.getIndex(), false));
                continue;
            }
            tmp.append(SolutionStep.getCellPrint(cand.getIndex(), false));
        }
    }

    public int getEntity() {
        return this.entity;
    }

    public void setEntity(int entity) {
        if (entity != 0 && entity != 1 && entity != 2 && entity != 3) {
            throw new RuntimeException(String.valueOf(ResourceBundle.getBundle("intl/SolutionStep").getString("SolutionStep.invalid_setEntity")) + " (" + entity + ResourceBundle.getBundle("intl/SolutionStep").getString(")"));
        }
        this.entity = entity;
    }

    public int getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(int entityNumber) {
        this.entityNumber = entityNumber;
    }

    public int getEntity2() {
        return this.entity2;
    }

    public void setEntity2(int entity2) {
        this.entity2 = entity2;
    }

    public int getEntity2Number() {
        return this.entity2Number;
    }

    public void setEntity2Number(int entity2Number) {
        this.entity2Number = entity2Number;
    }

    public void addBaseEntity(int name, int number) {
        this.baseEntities.add(new Entity(name, number));
    }

    public void addBaseEntity(Entity e) {
        this.baseEntities.add(e);
    }

    public void addCoverEntity(int name, int number) {
        this.coverEntities.add(new Entity(name, number));
    }

    public void addCoverEntity(Entity e) {
        this.coverEntities.add(e);
    }

    public void addChain(int start, int end, int[] chain) {
        this.chains.add(new Chain(start, end, chain));
    }

    public void addChain(Chain chain) {
        chain.resetLength();
        this.chains.add(chain);
    }

    public List<Chain> getChains() {
        return this.chains;
    }

    public int getChainLength() {
        int length = 0;
        int i = 0;
        while (i < this.chains.size()) {
            length += this.chains.get(i).getLength(this.alses);
            ++i;
        }
        return length;
    }

    public int getChainAnz() {
        return this.chains.size();
    }

    public boolean isNet() {
        if (this.chains.size() > 0) {
            int i = 0;
            while (i < this.chains.size()) {
                Chain tmp = this.chains.get(i);
                int j = tmp.getStart();
                while (j <= tmp.getEnd()) {
                    if (tmp.getChain()[j] < 0) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    public int getAlsesIndexCount() {
        int count = 0;
        for (AlsInSolutionStep als : this.alses) {
            count += als.getIndices().size();
        }
        return count;
    }

    public List<AlsInSolutionStep> getAlses() {
        return this.alses;
    }

    public AlsInSolutionStep getAls(int index) {
        return this.alses.get(index);
    }

    public void addAls(AlsInSolutionStep newAls) {
        this.alses.add(newAls);
    }

    public void addAls(SudokuSet indices, SudokuSet candidates) {
        AlsInSolutionStep als = new AlsInSolutionStep();
        int i = 0;
        while (i < indices.size()) {
            als.addIndex(indices.get(i));
            ++i;
        }
        i = 0;
        while (i < candidates.size()) {
            als.addCandidate(candidates.get(i));
            ++i;
        }
        this.alses.add(als);
    }

    public void addAls(SudokuSet indices, short candidates) {
        AlsInSolutionStep als = new AlsInSolutionStep();
        int i = 0;
        while (i < indices.size()) {
            als.addIndex(indices.get(i));
            ++i;
        }
        int[] cands = Sudoku2.POSSIBLE_VALUES[candidates];
        int i2 = 0;
        while (i2 < cands.length) {
            als.addCandidate(cands[i2]);
            ++i2;
        }
        this.alses.add(als);
    }

    public void addRestrictedCommon(RestrictedCommon rc) {
        this.restrictedCommons.add(rc);
    }

    public int getAlsIndex(int index, int chainIndex) {
        if (chainIndex == -1) {
            int i = 0;
            while (i < this.alses.size()) {
                if (this.alses.get(i).getIndices().contains(index)) {
                    return i;
                }
                ++i;
            }
        } else {
            Chain chain = this.chains.get(chainIndex);
            int i = chain.getStart();
            while (i <= chain.getEnd()) {
                int alsIndex;
                AlsInSolutionStep als;
                if (chain.getNodeType(i) == 2 && (als = this.alses.get(alsIndex = Chain.getSAlsIndex(chain.getChain()[i]))).getIndices().contains(index)) {
                    return alsIndex;
                }
                ++i;
            }
        }
        return -1;
    }

    public void addColorCandidate(int index, int color) {
        this.getColorCandidates().put(index, color);
    }

    public void addColorCandidates(SudokuSet indices, int color) {
        int i = 0;
        while (i < indices.size()) {
            this.addColorCandidate(indices.get(i), color);
            ++i;
        }
    }

    public boolean isEqual(SolutionStep s) {
        if (!this.isEquivalent(s)) {
            return false;
        }
        if (!this.isEqualInteger(this.values, s.values)) {
            return false;
        }
        if (!this.isEqualInteger(this.indices, s.indices)) {
            return false;
        }
        return this.isEqualCandidate(this.fins, s.fins);
    }

    public boolean isEquivalent(SolutionStep s) {
        if (this.type.isFish() && s.getType().isFish()) {
            return true;
        }
        if (this.type.isKrakenFish() && s.getType().isKrakenFish()) {
            return true;
        }
        if (this.getType() != s.getType()) {
            return false;
        }
        if (this.candidatesToDelete.size() > 0) {
            return this.isEqualCandidate(this.candidatesToDelete, s.candidatesToDelete);
        }
        return this.isEqualInteger(this.indices, s.indices);
    }

    public boolean isSubStep(SolutionStep s) {
        if (s.candidatesToDelete.size() < this.candidatesToDelete.size()) {
            return false;
        }
        for (Candidate cand : this.candidatesToDelete) {
            if (s.candidatesToDelete.contains(cand)) continue;
            return false;
        }
        return true;
    }

    public boolean isSingle() {
        return this.isSingle(this.type);
    }

    public boolean isSingle(SolutionType type) {
        return type == SolutionType.FULL_HOUSE || type == SolutionType.HIDDEN_SINGLE || type == SolutionType.NAKED_SINGLE || type == SolutionType.TEMPLATE_SET;
    }

    public boolean isForcingChainSet() {
        if ((this.type == SolutionType.FORCING_CHAIN || this.type == SolutionType.FORCING_CHAIN_CONTRADICTION || this.type == SolutionType.FORCING_CHAIN_VERITY) && this.indices.size() > 0) {
            return true;
        }
        return (this.type == SolutionType.FORCING_NET || this.type == SolutionType.FORCING_NET_CONTRADICTION || this.type == SolutionType.FORCING_NET_VERITY) && this.indices.size() > 0;
    }

    public int compareChainLengths(SolutionStep o) {
        return this.getChainLength() - o.getChainLength();
    }

    @Override
    public int compareTo(SolutionStep o) {
        int sum1 = 0;
        int sum2 = 0;
        if (this.isSingle(this.type) && !this.isSingle(o.type)) {
            return -1;
        }
        if (!this.isSingle(this.type) && this.isSingle(o.type)) {
            return 1;
        }
        int result = o.candidatesToDelete.size() - this.candidatesToDelete.size();
        if (result != 0) {
            return result;
        }
        if (!this.isEquivalent(o)) {
            int chainDiff = this.compareChainLengths(o);
            if (chainDiff != 0) {
                return chainDiff;
            }
            sum1 = this.getIndexSumme(this.candidatesToDelete);
            sum2 = this.getIndexSumme(o.candidatesToDelete);
            return sum1 - sum2;
        }
        if (this.type.isFish() && o.getType().isFish()) {
            int ret = this.type.compare(o.getType());
            if (ret != 0) {
                return ret;
            }
            ret = this.getCannibalistic().size() - o.getCannibalistic().size();
            if (ret != 0) {
                return ret;
            }
            ret = this.getEndoFins().size() - o.getEndoFins().size();
            if (ret != 0) {
                return ret;
            }
            ret = this.getFins().size() - o.getFins().size();
            if (ret != 0) {
                return ret;
            }
            if (!this.isEqualInteger(this.values, o.values)) {
                sum1 = this.getSumme(this.values);
                sum2 = this.getSumme(o.values);
                return sum1 - sum2;
            }
            return 0;
        }
        if (this.type.isKrakenFish() && o.getType().isKrakenFish()) {
            int ret = this.subType.compare(o.getSubType());
            if (ret != 0) {
                return ret;
            }
            return this.compareChainLengths(o);
        }
        int chainDiff = this.compareChainLengths(o);
        if (chainDiff != 0) {
            return chainDiff;
        }
        if (!this.isEqualInteger(this.values, o.values)) {
            sum1 = this.getSumme(this.values);
            sum2 = this.getSumme(o.values);
            return sum1 - sum2;
        }
        if (!this.isEqualInteger(this.indices, o.indices)) {
            if (this.indices.size() != o.indices.size()) {
                return this.indices.size() - o.indices.size();
            }
            sum1 = this.getSumme(this.indices);
            sum2 = this.getSumme(o.indices);
            return sum2 - sum1;
        }
        return this.type.compare(o.getType());
    }

    public boolean isEqualValues(SolutionStep s) {
        return this.isEqualInteger(this.values, s.getValues());
    }

    private boolean isEqualInteger(List<Integer> l1, List<Integer> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        int anz = l1.size();
        int i = 0;
        while (i < anz) {
            int i1 = l1.get(i);
            boolean found = false;
            int j = 0;
            while (j < anz) {
                int i2 = l2.get(j);
                if (i1 == i2) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEqualCandidate(SolutionStep s) {
        return this.isEqualCandidate(this.candidatesToDelete, s.getCandidatesToDelete());
    }

    private boolean isEqualCandidate(List<Candidate> l1, List<Candidate> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        int anz = l1.size();
        int i = 0;
        while (i < anz) {
            Candidate c1 = l1.get(i);
            boolean found = false;
            int j = 0;
            while (j < anz) {
                Candidate c2 = l2.get(j);
                if (c1.getIndex() == c2.getIndex() && c1.getValue() == c2.getValue()) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getIndexSumme(List<Candidate> list) {
        int sum = 0;
        int offset = 1;
        int i = 0;
        while (i < list.size()) {
            sum += list.get(i).getIndex() * offset + list.get(i).getValue();
            offset += 80;
            ++i;
        }
        return sum;
    }

    public int getSumme(List<Integer> list) {
        int sum = 0;
        int i = 0;
        while (i < list.size()) {
            sum += list.get(i).intValue();
            ++i;
        }
        return sum;
    }

    public int compareCandidatesToDelete(SolutionStep o) {
        int size2;
        int size1 = this.candidatesToDelete.size();
        if (size1 != (size2 = o.candidatesToDelete.size())) {
            return size2 - size1;
        }
        int result = 0;
        int i = 0;
        while (i < size1) {
            Candidate c1 = this.candidatesToDelete.get(i);
            Candidate c2 = o.candidatesToDelete.get(i);
            result = c1.getIndex() * 10 + c1.getValue() - (c2.getIndex() * 10 + c2.getValue());
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    public List<Entity> getBaseEntities() {
        return this.baseEntities;
    }

    public List<Entity> getCoverEntities() {
        return this.coverEntities;
    }

    public void setValues(List<Integer> values) {
        this.values = values;
    }

    public void setIndices(List<Integer> indices) {
        this.indices = indices;
    }

    public void setCandidatesToDelete(List<Candidate> candidatesToDelete) {
        this.candidatesToDelete = candidatesToDelete;
    }

    public void setCannibalistic(List<Candidate> cannibalistic) {
        this.cannibalistic = cannibalistic;
    }

    public void setFins(List<Candidate> fins) {
        this.fins = fins;
    }

    public void setEndoFins(List<Candidate> endoFins) {
        this.endoFins = endoFins;
    }

    public void setBaseEntities(List<Entity> baseEntities) {
        this.baseEntities = baseEntities;
    }

    public void setCoverEntities(List<Entity> coverEntities) {
        this.coverEntities = coverEntities;
    }

    public void setChains(List<Chain> chains) {
        this.chains = chains;
    }

    public void setAlses(List<AlsInSolutionStep> alses) {
        this.alses = alses;
    }

    public SortedMap<Integer, Integer> getColorCandidates() {
        return this.colorCandidates;
    }

    public void setColorCandidates(SortedMap<Integer, Integer> colorCandidates) {
        this.colorCandidates = colorCandidates;
    }

    public SolutionType getSubType() {
        return this.subType;
    }

    public void setSubType(SolutionType subType) {
        this.subType = subType;
    }

    public boolean isIsSiamese() {
        return this.isSiamese;
    }

    public void setIsSiamese(boolean isSiamese) {
        this.isSiamese = isSiamese;
    }

    public List<RestrictedCommon> getRestrictedCommons() {
        return this.restrictedCommons;
    }

    public void setRestrictedCommons(List<RestrictedCommon> restrictedCommons) {
        this.restrictedCommons = restrictedCommons;
    }

    public int getProgressScoreSingles() {
        return this.progressScoreSingles;
    }

    public void setProgressScoreSingles(int progressScoreSingles) {
        this.progressScoreSingles = progressScoreSingles;
    }

    public int getProgressScoreSinglesOnly() {
        return this.progressScoreSinglesOnly;
    }

    public void setProgressScoreSinglesOnly(int progressScoreSinglesOnly) {
        this.progressScoreSinglesOnly = progressScoreSinglesOnly;
    }

    public int getProgressScore() {
        return this.progressScore;
    }

    public void setProgressScore(int progressScore) {
        this.progressScore = progressScore;
    }

    public SudokuSet getPotentialCannibalisticEliminations() {
        return this.potentialCannibalisticEliminations;
    }

    public void setPotentialCannibalisticEliminations(SudokuSet potentialCannibalisticEliminations) {
        this.potentialCannibalisticEliminations = potentialCannibalisticEliminations;
    }

    public SudokuSet getPotentialEliminations() {
        return this.potentialEliminations;
    }

    public void setPotentialEliminations(SudokuSet potentialEliminations) {
        this.potentialEliminations = potentialEliminations;
    }
}

