/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.util.List;
import sudoku.SolutionType;

class StepType {
    static final int UNDEFINED = -1;
    static final int EQUAL = 0;
    static final int LT = 1;
    static final int GT = 2;
    SolutionType type;
    int puzzleType = 0;
    boolean isRemove = false;
    int compType = -1;
    int compAnz = 0;

    private StepType(SolutionType type, int puzzleType, boolean isRemove, int compType, int compAnz) {
        this.type = type;
        this.puzzleType = puzzleType;
        this.isRemove = isRemove;
        this.compType = compType;
        this.compAnz = compAnz;
    }

    public String toString() {
        char compChar = '-';
        switch (this.compType) {
            case 0: {
                compChar = '=';
                break;
            }
            case 1: {
                compChar = '<';
                break;
            }
            case 2: {
                compChar = '>';
            }
        }
        if (this.compType != -1) {
            return String.valueOf(this.type.getStepName()) + " (" + this.puzzleType + ", " + compChar + this.compAnz + ")";
        }
        return String.valueOf(this.type.getStepName()) + " (" + this.puzzleType + ", -)";
    }

    public static void parseTypeStr(List<StepType> stepList, String inputStr) {
        int puzzleType = 0;
        boolean isRemove = false;
        int compType = -1;
        int compAnz = 0;
        if ((inputStr = inputStr.toLowerCase()).startsWith("-")) {
            isRemove = true;
            inputStr = inputStr.substring(1);
        }
        String compStr = null;
        String typeStr = null;
        int compIndex = -1;
        compIndex = inputStr.indexOf(43);
        int typeIndex = inputStr.indexOf(58);
        if (typeIndex == -1 && compIndex != -1) {
            compStr = inputStr.substring(compIndex + 1);
            inputStr = inputStr.substring(0, compIndex);
        } else if (typeIndex != -1 && compIndex == -1) {
            typeStr = inputStr.substring(typeIndex);
            inputStr = inputStr.substring(0, typeIndex);
        } else if (typeIndex != -1 && compIndex != -1) {
            if (typeIndex < compIndex) {
                compStr = inputStr.substring(compIndex + 1);
                typeStr = inputStr.substring(typeIndex, compIndex);
                inputStr = inputStr.substring(0, typeIndex);
            } else {
                typeStr = inputStr.substring(typeIndex);
                compStr = inputStr.substring(compIndex + 1, typeIndex);
                inputStr = inputStr.substring(0, compIndex);
            }
        }
        puzzleType = 0;
        if (typeStr != null) {
            if (typeStr.length() < 2) {
                System.out.println("Puzzle type missing (assuming '0')!");
            } else {
                char typeModeChar = typeStr.charAt(1);
                switch (typeModeChar) {
                    case '0': {
                        puzzleType = 0;
                        break;
                    }
                    case '1': {
                        puzzleType = 1;
                        break;
                    }
                    case '2': {
                        puzzleType = 2;
                        break;
                    }
                    case '3': {
                        puzzleType = 3;
                        break;
                    }
                    default: {
                        System.out.println("Invalid puzzle type: " + typeModeChar + " (assuming '0')");
                    }
                }
            }
        }
        if (compStr != null) {
            if (compStr.length() < 2) {
                System.out.println("Invalid comparison spec - ignored!");
            } else {
                switch (compStr.charAt(0)) {
                    case 'e': {
                        compType = 0;
                        break;
                    }
                    case 'l': {
                        compType = 1;
                        break;
                    }
                    case 'g': {
                        compType = 2;
                        break;
                    }
                    default: {
                        System.out.println("Invalid comparison mode: " + compStr.charAt(0) + " (ignored)");
                    }
                }
                if (compType != -1) {
                    String compAnzStr = compStr.substring(1);
                    try {
                        compAnz = Integer.parseInt(compAnzStr);
                    }
                    catch (NumberFormatException ex) {
                        System.out.println("Invalid comparison digit: " + compAnzStr + " (comparison ignored)");
                        compType = -1;
                    }
                }
            }
        }
        SolutionType type = null;
        SolutionType[] values = SolutionType.values();
        int j = 0;
        while (j < values.length) {
            if (values[j].getArgName().equals(inputStr)) {
                type = values[j];
            }
            ++j;
        }
        if (type == null) {
            if (inputStr.equals("all")) {
                SolutionType[] solutionTypeArray = SolutionType.values();
                int n = solutionTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SolutionType tmpType = solutionTypeArray[n2];
                    if (!tmpType.isSingle()) {
                        StepType.addDeleteStepInList(stepList, new StepType(tmpType, puzzleType, isRemove, compType, compAnz));
                    }
                    ++n2;
                }
            } else if (inputStr.equals("nssts")) {
                SolutionType[] solutionTypeArray = SolutionType.values();
                int n = solutionTypeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    SolutionType tmpType = solutionTypeArray[n3];
                    if (!tmpType.isSingle() && !tmpType.isSSTS()) {
                        StepType.addDeleteStepInList(stepList, new StepType(tmpType, puzzleType, isRemove, compType, compAnz));
                    }
                    ++n3;
                }
            } else if (inputStr.equals("nssts1")) {
                SolutionType[] solutionTypeArray = SolutionType.values();
                int n = solutionTypeArray.length;
                int n4 = 0;
                while (n4 < n) {
                    SolutionType tmpType = solutionTypeArray[n4];
                    if (!(tmpType.isSingle() || tmpType.isSSTS() || tmpType.equals((Object)SolutionType.TWO_STRING_KITE) || tmpType.equals((Object)SolutionType.SKYSCRAPER) || tmpType.equals((Object)SolutionType.BUG_PLUS_1) || tmpType.equals((Object)SolutionType.EMPTY_RECTANGLE) || tmpType.equals((Object)SolutionType.W_WING) || tmpType.equals((Object)SolutionType.UNIQUENESS_1) || tmpType.equals((Object)SolutionType.XYZ_WING) || tmpType.equals((Object)SolutionType.REMOTE_PAIR))) {
                        StepType.addDeleteStepInList(stepList, new StepType(tmpType, puzzleType, isRemove, compType, compAnz));
                    }
                    ++n4;
                }
            } else {
                System.out.println("Invalid step name: " + inputStr + " (ignored!)");
            }
        } else {
            StepType.addDeleteStepInList(stepList, new StepType(type, puzzleType, isRemove, compType, compAnz));
        }
    }

    private static void addDeleteStepInList(List<StepType> stepList, StepType step) {
        if (step.type == null) {
            return;
        }
        boolean found = false;
        int i = 0;
        while (i < stepList.size()) {
            StepType tmpStep = stepList.get(i);
            if (tmpStep.type == step.type && tmpStep.puzzleType == step.puzzleType) {
                found = true;
                if (step.isRemove) {
                    stepList.remove(i);
                    --i;
                }
            }
            ++i;
        }
        if (step.isRemove) {
            if (!found) {
                System.out.println("Could not remove step " + step.type.getArgName() + ":" + step.puzzleType + ": was not set yet.");
            }
        } else {
            stepList.add(step);
        }
    }
}

