/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.util.TreeSet;
import sudoku.AlsInSolutionStep;
import sudoku.Candidate;
import sudoku.Chain;
import sudoku.ClipboardMode;
import sudoku.DifficultyLevel;
import sudoku.Options;
import sudoku.SolutionStep;
import sudoku.SolutionType;
import sudoku.SudokuCell;
import sudoku.SudokuSet;
import sudoku.SudokuSetBase;

public class Sudoku {
    private static final int[][] COLS;
    private static final int CPL = 9;
    private SudokuSetBase[] possiblePositions = new SudokuSetBase[10];
    private SudokuSetBase[] allowedPositions = new SudokuSetBase[10];
    private SudokuSet[] positions = new SudokuSet[10];
    private SudokuCell[] cells = new SudokuCell[81];
    private DifficultyLevel level;
    private int score;
    private String initialState = null;

    static {
        int[][] nArrayArray = new int[9][];
        int[] nArray = new int[9];
        nArray[1] = 9;
        nArray[2] = 18;
        nArray[3] = 27;
        nArray[4] = 36;
        nArray[5] = 45;
        nArray[6] = 54;
        nArray[7] = 63;
        nArray[8] = 72;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{1, 10, 19, 28, 37, 46, 55, 64, 73};
        nArrayArray[2] = new int[]{2, 11, 20, 29, 38, 47, 56, 65, 74};
        nArrayArray[3] = new int[]{3, 12, 21, 30, 39, 48, 57, 66, 75};
        nArrayArray[4] = new int[]{4, 13, 22, 31, 40, 49, 58, 67, 76};
        nArrayArray[5] = new int[]{5, 14, 23, 32, 41, 50, 59, 68, 77};
        nArrayArray[6] = new int[]{6, 15, 24, 33, 42, 51, 60, 69, 78};
        nArrayArray[7] = new int[]{7, 16, 25, 34, 43, 52, 61, 70, 79};
        nArrayArray[8] = new int[]{8, 17, 26, 35, 44, 53, 62, 71, 80};
        COLS = nArrayArray;
    }

    public Sudoku() {
        int i = 0;
        while (i <= 9) {
            this.allowedPositions[i] = new SudokuSet(true);
            this.allowedPositions[i].setAll();
            this.possiblePositions[i] = new SudokuSet(true);
            this.possiblePositions[i].setAll();
            this.positions[i] = new SudokuSet();
            ++i;
        }
        i = 0;
        while (i < this.cells.length) {
            this.cells[i] = new SudokuCell();
            ++i;
        }
    }

    public SudokuCell[] getCells() {
        return this.cells;
    }

    public void setCells(SudokuCell[] cells) {
        this.cells = cells;
    }

    public DifficultyLevel getLevel() {
        return this.level;
    }

    public void setLevel(DifficultyLevel level) {
        this.level = level;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public SudokuSetBase[] getPossiblePositions() {
        return this.possiblePositions;
    }

    public void setPossiblePositions(SudokuSetBase[] possiblePositions) {
        this.possiblePositions = possiblePositions;
    }

    public SudokuSetBase[] getAllowedPositions() {
        return this.allowedPositions;
    }

    public void setAllowedPositions(SudokuSetBase[] allowedPositions) {
        this.allowedPositions = allowedPositions;
    }

    public SudokuSet[] getPositions() {
        return this.positions;
    }

    public void setPositions(SudokuSet[] positions) {
        this.positions = positions;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    public String getSudoku(ClipboardMode mode, SolutionStep step) {
        Object object;
        String dot = Options.getInstance().isUseZeroInsteadOfDot() ? "0" : ".";
        StringBuilder out = new StringBuilder();
        if (mode == ClipboardMode.LIBRARY) {
            if (step == null) {
                out.append(":0000:x:");
            } else {
                String type = step.getType().getLibraryType();
                if (step.getType().isFish() && step.isIsSiamese()) {
                    type = String.valueOf(type) + "1";
                }
                out.append(":").append(type).append(":");
                TreeSet<Integer> candToDeleteSet = new TreeSet<Integer>();
                if (step.getType().useCandToDelInLibraryFormat()) {
                    for (Candidate cand : step.getCandidatesToDelete()) {
                        candToDeleteSet.add(cand.getValue());
                    }
                }
                if (candToDeleteSet.isEmpty()) {
                    int i = 0;
                    while (i < step.getValues().size()) {
                        candToDeleteSet.add(step.getValues().get(i));
                        ++i;
                    }
                }
                object = candToDeleteSet.iterator();
                while (object.hasNext()) {
                    int cand = (Integer)object.next();
                    out.append(cand);
                }
                out.append(":");
            }
        }
        if (mode == ClipboardMode.CLUES_ONLY || mode == ClipboardMode.VALUES_ONLY || mode == ClipboardMode.LIBRARY) {
            object = this.cells;
            int cand = this.cells.length;
            int candToDeleteSet = 0;
            while (candToDeleteSet < cand) {
                SudokuCell cell = object[candToDeleteSet];
                if (cell.getValue() == 0 || mode == ClipboardMode.CLUES_ONLY && !cell.isIsFixed()) {
                    out.append(dot);
                } else {
                    if (mode == ClipboardMode.LIBRARY && !cell.isIsFixed()) {
                        out.append("+");
                    }
                    out.append(Integer.toString(cell.getValue()));
                }
                ++candToDeleteSet;
            }
        }
        if (mode == ClipboardMode.PM_GRID || mode == ClipboardMode.PM_GRID_WITH_STEP) {
            StringBuilder[] cellBuffers = new StringBuilder[this.cells.length];
            int i = 0;
            while (i < this.cells.length) {
                cellBuffers[i] = new StringBuilder();
                if (this.cells[i].getValue() != 0) {
                    cellBuffers[i].append(String.valueOf(this.cells[i].getValue()));
                } else {
                    String candString = this.cells[i].getCandidateString(1);
                    if (candString.isEmpty()) {
                        candString = dot;
                    }
                    cellBuffers[i].append(candString);
                }
                ++i;
            }
            if (mode == ClipboardMode.PM_GRID_WITH_STEP && step != null) {
                int index4;
                int index2;
                boolean[] cellsWithExtraChar = new boolean[this.cells.length];
                object = step.getIndices().iterator();
                while (object.hasNext()) {
                    int index3 = (Integer)object.next();
                    this.insertOrReplaceChar(cellBuffers[index3], '*');
                    cellsWithExtraChar[index3] = true;
                }
                if (SolutionType.isFish(step.getType()) || step.getType() == SolutionType.W_WING) {
                    for (Candidate cand : step.getFins()) {
                        index2 = cand.getIndex();
                        this.insertOrReplaceChar(cellBuffers[index2], '#');
                        cellsWithExtraChar[index2] = true;
                    }
                }
                if (SolutionType.isFish(step.getType())) {
                    for (Candidate cand : step.getEndoFins()) {
                        index2 = cand.getIndex();
                        this.insertOrReplaceChar(cellBuffers[index2], '@');
                        cellsWithExtraChar[index2] = true;
                    }
                }
                for (Chain chain : step.getChains()) {
                    int i2 = chain.getStart();
                    while (i2 <= chain.getEnd()) {
                        if (chain.getNodeType(i2) != 2) {
                            index4 = chain.getCellIndex(i2);
                            this.insertOrReplaceChar(cellBuffers[index4], '*');
                            cellsWithExtraChar[index4] = true;
                            if (chain.getNodeType(i2) == 1) {
                                index4 = Chain.getSCellIndex2(chain.getChain()[i2]);
                                if (index4 != -1) {
                                    this.insertOrReplaceChar(cellBuffers[index4], '*');
                                    cellsWithExtraChar[index4] = true;
                                }
                                if ((index4 = Chain.getSCellIndex3(chain.getChain()[i2])) != -1) {
                                    this.insertOrReplaceChar(cellBuffers[index4], '*');
                                    cellsWithExtraChar[index4] = true;
                                }
                            }
                        }
                        ++i2;
                    }
                }
                char alsChar = 'A';
                for (AlsInSolutionStep als : step.getAlses()) {
                    for (int index4 : als.getIndices()) {
                        this.insertOrReplaceChar(cellBuffers[index4], alsChar);
                        cellsWithExtraChar[index4] = true;
                    }
                    alsChar = (char)(alsChar + 1);
                }
                for (Candidate cand : step.getCandidatesToDelete()) {
                    index4 = cand.getIndex();
                    char candidate = Character.forDigit(cand.getValue(), 10);
                    int i3 = 0;
                    while (i3 < cellBuffers[index4].length()) {
                        if (cellBuffers[index4].charAt(i3) == candidate && (i3 == 0 || i3 > 0 && cellBuffers[index4].charAt(i3 - 1) != '-')) {
                            cellBuffers[index4].insert(i3, '-');
                            if (i3 == 0) {
                                cellsWithExtraChar[index4] = true;
                            }
                        }
                        ++i3;
                    }
                }
                int i4 = 0;
                while (i4 < cellsWithExtraChar.length) {
                    if (cellsWithExtraChar[i4]) {
                        int[] indices = COLS[Sudoku.getCol(i4)];
                        int j = 0;
                        while (j < indices.length) {
                            if (Character.isDigit(cellBuffers[indices[j]].charAt(0))) {
                                cellBuffers[indices[j]].insert(0, ' ');
                            }
                            ++j;
                        }
                    }
                    ++i4;
                }
            }
            int[] fieldLengths = new int[COLS.length];
            int i5 = 0;
            while (i5 < cellBuffers.length) {
                int col = Sudoku.getCol(i5);
                if (cellBuffers[i5].length() > fieldLengths[col]) {
                    fieldLengths[col] = cellBuffers[i5].length();
                }
                ++i5;
            }
            i5 = 0;
            while (i5 < fieldLengths.length) {
                int n = i5++;
                fieldLengths[n] = fieldLengths[n] + 2;
            }
            i5 = 0;
            while (i5 < 9) {
                if (i5 % 3 == 0) {
                    this.writeLine(out, i5, fieldLengths, null, true);
                }
                this.writeLine(out, i5, fieldLengths, cellBuffers, false);
                ++i5;
            }
            this.writeLine(out, 9, fieldLengths, null, true);
            if (mode == ClipboardMode.PM_GRID_WITH_STEP && step != null) {
                out.append(step.toString(2));
            }
        }
        if (mode == ClipboardMode.LIBRARY) {
            int type = 1;
            boolean first = true;
            out.append(":");
            int i = 0;
            while (i < this.cells.length) {
                SudokuCell cell = this.cells[i];
                if (cell.getValue() == 0) {
                    int j = 1;
                    while (j <= 9) {
                        if (cell.isCandidate(2, j) && !cell.isCandidate(type, j)) {
                            if (first) {
                                first = false;
                            } else {
                                out.append(" ");
                            }
                            out.append(Integer.toString(j)).append(Integer.toString(i / 9 + 1)).append(Integer.toString(i % 9 + 1));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (step == null) {
                out.append("::");
            } else {
                String candString = step.getCandidateString(true);
                out.append(":").append(candString).append(":");
                if (candString.isEmpty()) {
                    out.append(step.getValueIndexString());
                }
                out.append(":");
                if (step.getType().isSimpleChainOrLoop()) {
                    out.append(step.getChainLength() - 1);
                }
            }
        }
        return out.toString();
    }

    private void insertOrReplaceChar(StringBuilder buffer, char ch) {
        if (Character.isDigit(buffer.charAt(0))) {
            buffer.insert(0, ch);
        } else {
            buffer.replace(0, 1, Character.toString(ch));
        }
    }

    private void writeLine(StringBuilder out, int line, int[] fieldLengths, StringBuilder[] cellBuffers, boolean drawOutline) {
        if (drawOutline) {
            char leftRight = '.';
            char middle = '.';
            if (line == 3 || line == 6) {
                leftRight = ':';
                middle = '+';
            } else if (line == 9) {
                leftRight = '\'';
                middle = '\'';
            }
            out.append(leftRight);
            int i = 0;
            while (i < fieldLengths[0] + fieldLengths[1] + fieldLengths[2]) {
                out.append('-');
                ++i;
            }
            out.append(middle);
            i = 0;
            while (i < fieldLengths[3] + fieldLengths[4] + fieldLengths[5]) {
                out.append('-');
                ++i;
            }
            out.append(middle);
            i = 0;
            while (i < fieldLengths[6] + fieldLengths[7] + fieldLengths[8]) {
                out.append('-');
                ++i;
            }
            out.append(leftRight);
        } else {
            int i = line * 9;
            while (i < (line + 1) * 9) {
                if (i % 3 == 0) {
                    out.append("|");
                    if (i % 9 != 8) {
                        out.append(' ');
                    }
                } else {
                    out.append(' ');
                }
                int tmp = fieldLengths[Sudoku.getCol(i)];
                out.append((CharSequence)cellBuffers[i]);
                tmp -= cellBuffers[i].length();
                int j = 0;
                while (j < tmp - 1) {
                    out.append(' ');
                    ++j;
                }
                ++i;
            }
            out.append('|');
        }
        out.append("\r\n");
    }

    private static int getCol(int index) {
        return index % 9;
    }
}

