/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import generator.SudokuGenerator;
import generator.SudokuGeneratorFactory;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import sudoku.AlsInSolutionStep;
import sudoku.Candidate;
import sudoku.Chain;
import sudoku.ClipboardMode;
import sudoku.DifficultyLevel;
import sudoku.Options;
import sudoku.SolutionStep;
import sudoku.SolutionType;
import sudoku.SudokuSet;
import sudoku.SudokuSetBase;
import sudoku.SudokuSinglesQueue;
import sudoku.SudokuStatus;

public class Sudoku2
implements Cloneable {
    private static final boolean DEBUG = false;
    public static final int LENGTH = 81;
    public static final int UNITS = 9;
    public static final int BLOCK = 0;
    public static final int ROW = 1;
    public static final int COL = 2;
    public static final int CELL = 3;
    public static final int[][] ROWS;
    public static final int[][] COLS;
    public static final int[][] BLOCKS;
    public static final int[][] ALL_UNITS;
    public static final int[][] ROW_BLOCK_UNITS;
    public static final int[][] COL_BLOCK_UNITS;
    private static final int[] BLOCK_FROM_INDEX;
    public static final int[] CONSTRAINT_TYPE_FROM_CONSTRAINT;
    public static final int[] CONSTRAINT_NUMBER_FROM_CONSTRAINT;
    public static final short[] MASKS;
    public static final short MAX_MASK = 511;
    public static final int[][] POSSIBLE_VALUES;
    public static final int[] ANZ_VALUES;
    public static int[][] CONSTRAINTS;
    public static final short[] CAND_FROM_MASK;
    public static SudokuSetBase[] templates;
    public static SudokuSet[] buddies;
    public static long[] buddiesM1;
    public static long[] buddiesM2;
    public static SudokuSetBase[][] groupedBuddies;
    public static long[][] groupedBuddiesM1;
    public static long[][] groupedBuddiesM2;
    public static SudokuSet[] ROW_TEMPLATES;
    public static SudokuSet[] COL_TEMPLATES;
    public static SudokuSet[] BLOCK_TEMPLATES;
    public static SudokuSet[] ROW_BLOCK_TEMPLATES;
    public static SudokuSet[] COL_BLOCK_TEMPLATES;
    public static SudokuSet[] ALL_CONSTRAINTS_TEMPLATES;
    public static long[] ALL_CONSTRAINTS_TEMPLATES_M1;
    public static long[] ALL_CONSTRAINTS_TEMPLATES_M2;
    private short[] cells = new short[81];
    private short[] userCells = new short[81];
    private byte[][] free = new byte[ALL_UNITS.length][10];
    private int unsolvedCellsAnz;
    private int[] values = new int[81];
    private boolean[] fixed = new boolean[81];
    private int[] solution = new int[81];
    private boolean solutionSet = false;
    private DifficultyLevel level = null;
    private int score;
    private String initialState = null;
    private SudokuStatus status = SudokuStatus.EMPTY;
    private SudokuStatus statusGivens = SudokuStatus.EMPTY;
    private SudokuSinglesQueue nsQueue = new SudokuSinglesQueue();
    private SudokuSinglesQueue hsQueue = new SudokuSinglesQueue();

    static {
        int[][] nArrayArray = new int[9][];
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17};
        nArrayArray[2] = new int[]{18, 19, 20, 21, 22, 23, 24, 25, 26};
        nArrayArray[3] = new int[]{27, 28, 29, 30, 31, 32, 33, 34, 35};
        nArrayArray[4] = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44};
        nArrayArray[5] = new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53};
        nArrayArray[6] = new int[]{54, 55, 56, 57, 58, 59, 60, 61, 62};
        nArrayArray[7] = new int[]{63, 64, 65, 66, 67, 68, 69, 70, 71};
        nArrayArray[8] = new int[]{72, 73, 74, 75, 76, 77, 78, 79, 80};
        ROWS = nArrayArray;
        int[][] nArrayArray2 = new int[9][];
        int[] nArray2 = new int[9];
        nArray2[1] = 9;
        nArray2[2] = 18;
        nArray2[3] = 27;
        nArray2[4] = 36;
        nArray2[5] = 45;
        nArray2[6] = 54;
        nArray2[7] = 63;
        nArray2[8] = 72;
        nArrayArray2[0] = nArray2;
        nArrayArray2[1] = new int[]{1, 10, 19, 28, 37, 46, 55, 64, 73};
        nArrayArray2[2] = new int[]{2, 11, 20, 29, 38, 47, 56, 65, 74};
        nArrayArray2[3] = new int[]{3, 12, 21, 30, 39, 48, 57, 66, 75};
        nArrayArray2[4] = new int[]{4, 13, 22, 31, 40, 49, 58, 67, 76};
        nArrayArray2[5] = new int[]{5, 14, 23, 32, 41, 50, 59, 68, 77};
        nArrayArray2[6] = new int[]{6, 15, 24, 33, 42, 51, 60, 69, 78};
        nArrayArray2[7] = new int[]{7, 16, 25, 34, 43, 52, 61, 70, 79};
        nArrayArray2[8] = new int[]{8, 17, 26, 35, 44, 53, 62, 71, 80};
        COLS = nArrayArray2;
        int[][] nArrayArray3 = new int[9][];
        int[] nArray3 = new int[9];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 9;
        nArray3[4] = 10;
        nArray3[5] = 11;
        nArray3[6] = 18;
        nArray3[7] = 19;
        nArray3[8] = 20;
        nArrayArray3[0] = nArray3;
        nArrayArray3[1] = new int[]{3, 4, 5, 12, 13, 14, 21, 22, 23};
        nArrayArray3[2] = new int[]{6, 7, 8, 15, 16, 17, 24, 25, 26};
        nArrayArray3[3] = new int[]{27, 28, 29, 36, 37, 38, 45, 46, 47};
        nArrayArray3[4] = new int[]{30, 31, 32, 39, 40, 41, 48, 49, 50};
        nArrayArray3[5] = new int[]{33, 34, 35, 42, 43, 44, 51, 52, 53};
        nArrayArray3[6] = new int[]{54, 55, 56, 63, 64, 65, 72, 73, 74};
        nArrayArray3[7] = new int[]{57, 58, 59, 66, 67, 68, 75, 76, 77};
        nArrayArray3[8] = new int[]{60, 61, 62, 69, 70, 71, 78, 79, 80};
        BLOCKS = nArrayArray3;
        ALL_UNITS = new int[][]{ROWS[0], ROWS[1], ROWS[2], ROWS[3], ROWS[4], ROWS[5], ROWS[6], ROWS[7], ROWS[8], COLS[0], COLS[1], COLS[2], COLS[3], COLS[4], COLS[5], COLS[6], COLS[7], COLS[8], BLOCKS[0], BLOCKS[1], BLOCKS[2], BLOCKS[3], BLOCKS[4], BLOCKS[5], BLOCKS[6], BLOCKS[7], BLOCKS[8]};
        ROW_BLOCK_UNITS = new int[][]{ROWS[0], ROWS[1], ROWS[2], ROWS[3], ROWS[4], ROWS[5], ROWS[6], ROWS[7], ROWS[8], BLOCKS[0], BLOCKS[1], BLOCKS[2], BLOCKS[3], BLOCKS[4], BLOCKS[5], BLOCKS[6], BLOCKS[7], BLOCKS[8]};
        COL_BLOCK_UNITS = new int[][]{COLS[0], COLS[1], COLS[2], COLS[3], COLS[4], COLS[5], COLS[6], COLS[7], COLS[8], BLOCKS[0], BLOCKS[1], BLOCKS[2], BLOCKS[3], BLOCKS[4], BLOCKS[5], BLOCKS[6], BLOCKS[7], BLOCKS[8]};
        int[] nArray4 = new int[81];
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[5] = 1;
        nArray4[6] = 2;
        nArray4[7] = 2;
        nArray4[8] = 2;
        nArray4[12] = 1;
        nArray4[13] = 1;
        nArray4[14] = 1;
        nArray4[15] = 2;
        nArray4[16] = 2;
        nArray4[17] = 2;
        nArray4[21] = 1;
        nArray4[22] = 1;
        nArray4[23] = 1;
        nArray4[24] = 2;
        nArray4[25] = 2;
        nArray4[26] = 2;
        nArray4[27] = 3;
        nArray4[28] = 3;
        nArray4[29] = 3;
        nArray4[30] = 4;
        nArray4[31] = 4;
        nArray4[32] = 4;
        nArray4[33] = 5;
        nArray4[34] = 5;
        nArray4[35] = 5;
        nArray4[36] = 3;
        nArray4[37] = 3;
        nArray4[38] = 3;
        nArray4[39] = 4;
        nArray4[40] = 4;
        nArray4[41] = 4;
        nArray4[42] = 5;
        nArray4[43] = 5;
        nArray4[44] = 5;
        nArray4[45] = 3;
        nArray4[46] = 3;
        nArray4[47] = 3;
        nArray4[48] = 4;
        nArray4[49] = 4;
        nArray4[50] = 4;
        nArray4[51] = 5;
        nArray4[52] = 5;
        nArray4[53] = 5;
        nArray4[54] = 6;
        nArray4[55] = 6;
        nArray4[56] = 6;
        nArray4[57] = 7;
        nArray4[58] = 7;
        nArray4[59] = 7;
        nArray4[60] = 8;
        nArray4[61] = 8;
        nArray4[62] = 8;
        nArray4[63] = 6;
        nArray4[64] = 6;
        nArray4[65] = 6;
        nArray4[66] = 7;
        nArray4[67] = 7;
        nArray4[68] = 7;
        nArray4[69] = 8;
        nArray4[70] = 8;
        nArray4[71] = 8;
        nArray4[72] = 6;
        nArray4[73] = 6;
        nArray4[74] = 6;
        nArray4[75] = 7;
        nArray4[76] = 7;
        nArray4[77] = 7;
        nArray4[78] = 8;
        nArray4[79] = 8;
        nArray4[80] = 8;
        BLOCK_FROM_INDEX = nArray4;
        int[] nArray5 = new int[27];
        nArray5[0] = 1;
        nArray5[1] = 1;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArray5[5] = 1;
        nArray5[6] = 1;
        nArray5[7] = 1;
        nArray5[8] = 1;
        nArray5[9] = 2;
        nArray5[10] = 2;
        nArray5[11] = 2;
        nArray5[12] = 2;
        nArray5[13] = 2;
        nArray5[14] = 2;
        nArray5[15] = 2;
        nArray5[16] = 2;
        nArray5[17] = 2;
        CONSTRAINT_TYPE_FROM_CONSTRAINT = nArray5;
        CONSTRAINT_NUMBER_FROM_CONSTRAINT = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        short[] sArray = new short[10];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[3] = 4;
        sArray[4] = 8;
        sArray[5] = 16;
        sArray[6] = 32;
        sArray[7] = 64;
        sArray[8] = 128;
        sArray[9] = 256;
        MASKS = sArray;
        POSSIBLE_VALUES = new int[512][];
        ANZ_VALUES = new int[512];
        CONSTRAINTS = new int[81][3];
        CAND_FROM_MASK = new short[512];
        templates = new SudokuSetBase[46656];
        buddies = new SudokuSet[81];
        buddiesM1 = new long[81];
        buddiesM2 = new long[81];
        groupedBuddies = new SudokuSetBase[11][256];
        groupedBuddiesM1 = new long[11][256];
        groupedBuddiesM2 = new long[11][256];
        ROW_TEMPLATES = new SudokuSet[ROWS.length];
        COL_TEMPLATES = new SudokuSet[COLS.length];
        BLOCK_TEMPLATES = new SudokuSet[BLOCKS.length];
        ROW_BLOCK_TEMPLATES = new SudokuSet[ROW_BLOCK_UNITS.length];
        COL_BLOCK_TEMPLATES = new SudokuSet[COL_BLOCK_UNITS.length];
        ALL_CONSTRAINTS_TEMPLATES = new SudokuSet[ALL_UNITS.length];
        ALL_CONSTRAINTS_TEMPLATES_M1 = new long[ALL_UNITS.length];
        ALL_CONSTRAINTS_TEMPLATES_M2 = new long[ALL_UNITS.length];
        long ticks = System.currentTimeMillis();
        Sudoku2.initBuddies();
        ticks = System.currentTimeMillis() - ticks;
        ticks = System.currentTimeMillis();
        Sudoku2.initTemplates();
        ticks = System.currentTimeMillis() - ticks;
        ticks = System.currentTimeMillis();
        Sudoku2.initGroupedBuddies();
        ticks = System.currentTimeMillis() - ticks;
        Sudoku2.POSSIBLE_VALUES[0] = new int[0];
        Sudoku2.ANZ_VALUES[0] = 0;
        int[] temp = new int[9];
        int i = 1;
        while (i <= 511) {
            int index = 0;
            int mask = 1;
            int j = 1;
            while (j <= 511) {
                if ((i & mask) != 0) {
                    temp[index++] = j;
                }
                mask <<= 1;
                ++j;
            }
            Sudoku2.POSSIBLE_VALUES[i] = new int[index];
            System.arraycopy(temp, 0, POSSIBLE_VALUES[i], 0, index);
            Sudoku2.ANZ_VALUES[i] = index;
            ++i;
        }
        int index = 0;
        int row = 0;
        while (row < 9) {
            int boxBase = 18 + row / 3 * 3;
            int col = 9;
            while (col < 18) {
                Sudoku2.CONSTRAINTS[index][0] = row;
                Sudoku2.CONSTRAINTS[index][1] = col;
                Sudoku2.CONSTRAINTS[index][2] = boxBase + col / 3 % 3;
                ++index;
                ++col;
            }
            ++row;
        }
        int i2 = 1;
        while (i2 < CAND_FROM_MASK.length) {
            short s;
            int j = -1;
            do {
                s = (short)(j + 1);
                j = s;
            } while ((i2 & MASKS[s]) == 0);
            Sudoku2.CAND_FROM_MASK[i2] = j;
            ++i2;
        }
    }

    public Sudoku2() {
        this.clearSudoku();
    }

    public Sudoku2 clone() {
        Sudoku2 newSudoku = null;
        try {
            newSudoku = (Sudoku2)super.clone();
            newSudoku.cells = (short[])this.cells.clone();
            newSudoku.userCells = (short[])this.userCells.clone();
            newSudoku.values = (int[])this.values.clone();
            newSudoku.solution = (int[])this.solution.clone();
            newSudoku.fixed = (boolean[])this.fixed.clone();
            newSudoku.free = new byte[this.free.length][];
            int i = 0;
            while (i < this.free.length) {
                newSudoku.free[i] = (byte[])this.free[i].clone();
                ++i;
            }
            if (this.initialState != null) {
                newSudoku.initialState = this.initialState;
            }
            newSudoku.nsQueue = this.nsQueue.clone();
            newSudoku.hsQueue = this.hsQueue.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error while cloning", ex);
        }
        return newSudoku;
    }

    public void set(Sudoku2 src) {
        System.arraycopy(src.cells, 0, this.cells, 0, 81);
        System.arraycopy(src.userCells, 0, this.userCells, 0, 81);
        System.arraycopy(src.values, 0, this.values, 0, 81);
        System.arraycopy(src.solution, 0, this.solution, 0, 81);
        System.arraycopy(src.fixed, 0, this.fixed, 0, 81);
        int i = 0;
        while (i < this.free.length) {
            System.arraycopy(src.free[i], 0, this.free[i], 0, 10);
            ++i;
        }
        this.unsolvedCellsAnz = src.unsolvedCellsAnz;
        this.solutionSet = src.solutionSet;
        this.score = src.score;
        this.level = src.level;
        if (src.initialState != null) {
            this.initialState = src.initialState;
        }
        this.status = src.status;
        this.statusGivens = src.statusGivens;
        this.nsQueue.set(src.nsQueue);
        this.hsQueue.set(src.hsQueue);
    }

    public void setBS(Sudoku2 src) {
        this.cells = Arrays.copyOf(src.cells, this.cells.length);
        this.values = Arrays.copyOf(src.values, this.values.length);
        int i = 0;
        while (i < this.free.length) {
            this.free[i] = Arrays.copyOf(src.free[i], this.free[i].length);
            ++i;
        }
        this.unsolvedCellsAnz = src.unsolvedCellsAnz;
        this.nsQueue.clear();
        this.hsQueue.clear();
    }

    public final void resetCandidates() {
        int i = 0;
        while (i < this.cells.length) {
            this.cells[i] = 0;
            this.userCells[i] = 0;
            ++i;
        }
        this.rebuildAllCandidates();
    }

    public final void clearSudoku() {
        int i = 0;
        while (i < this.cells.length) {
            this.cells[i] = 511;
            this.userCells[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.free.length) {
            int j = 1;
            while (j < this.free[i].length) {
                this.free[i][j] = 9;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.values.length) {
            this.values[i] = 0;
            this.solution[i] = 0;
            this.fixed[i] = false;
            ++i;
        }
        this.unsolvedCellsAnz = 81;
        this.initialState = null;
        this.solutionSet = false;
        this.status = SudokuStatus.EMPTY;
        this.statusGivens = SudokuStatus.EMPTY;
        this.nsQueue.clear();
        this.hsQueue.clear();
    }

    public void resetSudoku() {
        if (this.initialState != null) {
            this.setSudoku(this.initialState, true);
        }
    }

    public void setSudoku(String init) {
        this.setSudoku(init, true);
    }

    public void setSudoku(String init, boolean saveInitialState) {
        int i;
        String tmpStr;
        int anzDoppelpunkt;
        this.clearSudoku();
        if (init == null) {
            return;
        }
        String lineEnd = null;
        int[][] cands = new int[9][9];
        if (init.contains("\r\n")) {
            lineEnd = "\r\n";
        } else if (init.contains("\r")) {
            lineEnd = "\r";
        } else if (init.contains("\n")) {
            lineEnd = "\n";
        }
        String[] lines = null;
        lines = lineEnd != null ? init.split(lineEnd) : new String[]{init};
        int anzLines = lines.length;
        boolean libraryFormat = false;
        String libraryCandStr = null;
        if (anzLines == 1 && ((anzDoppelpunkt = this.getAnzPatternInString(init, ":")) == 6 || anzDoppelpunkt == 7)) {
            libraryFormat = true;
            String[] libLines = init.split(":");
            lines[0] = libLines[3];
            libraryCandStr = libLines.length >= 5 ? libLines[4] : "";
        }
        if (anzLines == 1 && lines[0].contains("#") && (tmpStr = lines[0].substring(0, lines[0].indexOf("#")).trim()).length() >= 81) {
            lines[0] = tmpStr;
        }
        if (anzLines == 1 && this.getAnzPatternInString(init, ",") >= 6) {
            String[] gsfLines = init.split(",");
            lines[0] = gsfLines[4];
        }
        boolean[] solvedButNotGivens = new boolean[81];
        if (libraryFormat) {
            StringBuilder tmp = new StringBuilder(lines[0]);
            int i2 = 0;
            while (i2 < tmp.length()) {
                char ch = tmp.charAt(i2);
                if (ch == '+') {
                    solvedButNotGivens[i2] = true;
                    tmp.deleteCharAt(i2);
                    if (i2 >= 0) {
                        --i2;
                    }
                }
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < lines.length) {
            if (lines[i3] != null) {
                char ch;
                StringBuilder tmp = new StringBuilder(lines[i3].trim());
                int tmpIndex = -1;
                while ((tmpIndex = tmp.indexOf("---")) >= 0) {
                    char ch2;
                    if (tmpIndex > 0 && !Character.isDigit(ch2 = tmp.charAt(tmpIndex - 1)) && ch2 != ' ' && ch2 != '|') {
                        --tmpIndex;
                    }
                    int endIndex = tmpIndex + 1;
                    while (endIndex < tmp.length() && tmp.charAt(endIndex) == '-') {
                        ++endIndex;
                    }
                    if (endIndex < tmp.length() - 1 && !Character.isDigit(ch = tmp.charAt(endIndex + 1)) && ch != ' ' && ch != '|') {
                        ++endIndex;
                    }
                    tmp.delete(tmpIndex, endIndex + 1);
                }
                int j = 0;
                while (j < tmp.length()) {
                    ch = tmp.charAt(j);
                    if (ch == '|') {
                        tmp.setCharAt(j, ' ');
                    } else if (!Character.isDigit(ch) && ch != '.' && ch != ' ') {
                        tmp.deleteCharAt(j);
                        if (j >= 0) {
                            --j;
                        }
                    }
                    ++j;
                }
                int index = 0;
                while ((index = tmp.indexOf("  ")) != -1) {
                    tmp.deleteCharAt(index);
                }
                lines[i3] = tmp.toString().trim();
                if (lines[i3].length() == 0) {
                    int j2 = i3;
                    while (j2 < lines.length - 1) {
                        lines[j2] = lines[j2 + 1];
                        ++j2;
                    }
                    lines[lines.length - 1] = null;
                    --anzLines;
                    --i3;
                }
            }
            ++i3;
        }
        if (anzLines == 10) {
            --anzLines;
        }
        boolean logAgain = false;
        boolean ssGivensRead = false;
        String ssGivens = null;
        boolean ssCellsRead = false;
        String ssCells = null;
        while (anzLines > 9 && anzLines % 9 == 0) {
            if (!ssGivensRead) {
                ssGivens = this.getSSString(lines);
                ssGivensRead = true;
                ssCellsRead = true;
                ssCells = ssGivens;
            } else {
                ssCells = this.getSSString(lines);
                ssCellsRead = true;
            }
            logAgain = true;
            int i4 = 9;
            while (i4 < anzLines) {
                lines[i4 - 9] = lines[i4];
                if (i4 >= anzLines - 9) {
                    lines[i4] = null;
                }
                ++i4;
            }
            anzLines -= 9;
        }
        if (logAgain) {
            // empty if block
        }
        int sRow = 0;
        int sCol = 0;
        int sIndex = 0;
        boolean singleDigits = true;
        boolean isPmGrid = false;
        String sInit = lines[0];
        int i5 = 1;
        while (i5 < anzLines) {
            sInit = String.valueOf(sInit) + " " + lines[i5];
            ++i5;
        }
        if (sInit.length() > 81) {
            singleDigits = false;
        }
        if (sInit.length() > 162) {
            isPmGrid = true;
        }
        while (sIndex < sInit.length()) {
            char ch = sInit.charAt(sIndex);
            while (sIndex < sInit.length() && !Character.isDigit(ch) && ch != '.') {
                ch = sInit.charAt(++sIndex);
            }
            if (sIndex >= sInit.length()) break;
            if (isPmGrid) {
                if (ch == '.' || ch == '0') {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Invalid character: {0}", Character.valueOf(ch));
                    cands[sRow][sCol] = 0;
                    ++sIndex;
                } else if (singleDigits) {
                    cands[sRow][sCol] = Integer.parseInt(sInit.substring(sIndex, sIndex + 1));
                    ++sIndex;
                } else {
                    int endIndex = sInit.indexOf(" ", sIndex);
                    if (endIndex < 0) {
                        endIndex = sInit.length();
                    }
                    cands[sRow][sCol] = Integer.parseInt(sInit.substring(sIndex, endIndex));
                    sIndex = endIndex;
                }
            } else {
                if (Character.isDigit(ch) && Character.digit(ch, 10) > 0) {
                    boolean given = true;
                    if (libraryFormat) {
                        given = !solvedButNotGivens[sRow * 9 + sCol];
                    }
                    this.setCell(sRow, sCol, Character.digit(ch, 10), given);
                }
                ++sIndex;
            }
            if (++sCol != 9) continue;
            sCol = 0;
            ++sRow;
        }
        if (isPmGrid) {
            int[] cands1 = new int[10];
            int row = 0;
            while (row < cands.length) {
                int col = 0;
                while (col < cands[row].length) {
                    Arrays.fill(cands1, 0);
                    int sum = cands[row][col];
                    while (sum > 0) {
                        cands1[sum % 10] = 1;
                        sum /= 10;
                    }
                    int cellIndex = Sudoku2.getIndex(row, col);
                    int i6 = 1;
                    while (i6 < cands1.length) {
                        if (cands1[i6] == 0 && this.isCandidate(cellIndex, i6)) {
                            this.setCandidate(row, col, i6, false);
                        } else if (cands1[i6] == 1 && !this.isCandidate(cellIndex, i6)) {
                            this.setCandidate(row, col, i6, true);
                        }
                        ++i6;
                    }
                    ++col;
                }
                ++row;
            }
            i = 0;
            while (i < this.values.length) {
                if (this.getAnzCandidates(i) == 1) {
                    if (ssCellsRead) {
                        char ch = ssCells.charAt(i);
                        if (ch != '0' && ch != '.') {
                            this.setCell(i, Character.digit(ch, 10), true);
                        }
                    } else {
                        int j = 1;
                        while (j <= 9) {
                            if (this.isCandidate(i, j)) {
                                int count = 0;
                                int k = 0;
                                while (k < buddies[i].size()) {
                                    int buddyIndex = buddies[i].get(k);
                                    if (this.values[buddyIndex] == 0 && this.isCandidate(buddyIndex, j)) {
                                        ++count;
                                        break;
                                    }
                                    ++k;
                                }
                                if (count == 0) {
                                    this.setCell(i, j, true);
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        if (libraryFormat && libraryCandStr.length() > 0) {
            String[] candArr = libraryCandStr.split(" ");
            i = 0;
            while (i < candArr.length) {
                if (candArr[i].length() != 0) {
                    int candPos = Integer.parseInt(candArr[i]);
                    int col = candPos % 10;
                    int row = (candPos /= 10) % 10;
                    this.setCandidate(row - 1, col - 1, candPos /= 10, false);
                }
                ++i;
            }
        }
        if (ssGivensRead) {
            this.setGivens(ssGivens);
        }
        if (saveInitialState) {
            this.setInitialState(this.getSudoku(ClipboardMode.LIBRARY));
        }
        this.status = SudokuStatus.VALID;
        this.statusGivens = SudokuStatus.VALID;
    }

    private String getSSString(String[] lines) {
        StringBuilder ssTemp = new StringBuilder();
        int i = 0;
        while (i < 9) {
            ssTemp.append(lines[i]);
            ++i;
        }
        i = 0;
        while (i < ssTemp.length()) {
            char ch = ssTemp.charAt(i);
            if (!Character.isDigit(ch) && ch != '.') {
                ssTemp.deleteCharAt(i);
                --i;
            }
            ++i;
        }
        return ssTemp.toString();
    }

    public boolean checkUserCands() {
        if (!this.solutionSet) {
            return false;
        }
        int i = 0;
        while (i < 81) {
            if (this.values[i] == 0 && (this.userCells[i] & MASKS[this.solution[i]]) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getAnzCandidates(int index) {
        return ANZ_VALUES[this.cells[index]];
    }

    public int[] getAllCandidates(int index) {
        return POSSIBLE_VALUES[this.cells[index]];
    }

    public int[] getAllCandidates(int index, boolean user) {
        if (user) {
            return POSSIBLE_VALUES[this.userCells[index]];
        }
        return this.getAllCandidates(index);
    }

    public int getAnzCandidates(int index, boolean user) {
        if (user) {
            return ANZ_VALUES[this.userCells[index]];
        }
        return this.getAnzCandidates(index);
    }

    private int getAnzPatternInString(String str, String pattern) {
        int anzPattern = 0;
        int index = -1;
        while ((index = str.indexOf(pattern, index + 1)) >= 0) {
            ++anzPattern;
        }
        return anzPattern;
    }

    public void rebuildInternalData() {
        this.nsQueue.clear();
        this.hsQueue.clear();
        int i = 0;
        while (i < this.free.length) {
            int j = 0;
            while (j < this.free[i].length) {
                this.free[i][j] = 0;
                ++j;
            }
            ++i;
        }
        int anz = 0;
        int index = 0;
        while (index < this.values.length) {
            if (this.values[index] != 0) {
                this.cells[index] = 0;
            } else {
                ++anz;
                int[] cands = POSSIBLE_VALUES[this.cells[index]];
                int i2 = 0;
                while (i2 < cands.length) {
                    int j = 0;
                    while (j < CONSTRAINTS[index].length) {
                        byte[] byArray = this.free[CONSTRAINTS[index][j]];
                        int n = cands[i2];
                        byArray[n] = (byte)(byArray[n] + 1);
                        ++j;
                    }
                    ++i2;
                }
                if (ANZ_VALUES[this.cells[index]] == 1) {
                    this.addNakedSingle(index, CAND_FROM_MASK[this.cells[index]]);
                }
            }
            ++index;
        }
        this.unsolvedCellsAnz = anz;
        int i3 = 0;
        while (i3 < this.free.length) {
            int j = 1;
            while (j <= 9) {
                if (this.free[i3][j] == 1) {
                    while (!this.addHiddenSingle(i3, j)) {
                    }
                }
                ++j;
            }
            ++i3;
        }
    }

    public boolean checkSudoku() {
        this.rebuildInternalData();
        int index = 0;
        while (index < this.values.length) {
            if (this.values[index] != 0) {
                if (!this.isValidValue(index, this.values[index])) {
                    return false;
                }
                if (this.solutionSet && this.solution[index] != this.values[index]) {
                    return false;
                }
            } else {
                int[] cands = POSSIBLE_VALUES[this.cells[index]];
                int i = 0;
                while (i < cands.length) {
                    if (!this.isValidValue(index, cands[i])) {
                        return false;
                    }
                    ++i;
                }
                if (this.solutionSet && !this.isCandidate(index, this.solution[index])) {
                    return false;
                }
            }
            ++index;
        }
        return true;
    }

    public String getSudoku(ClipboardMode mode) {
        return this.getSudoku(mode, null);
    }

    public String getSudoku(ClipboardMode mode, SolutionStep step) {
        String dot = Options.getInstance().isUseZeroInsteadOfDot() ? "0" : ".";
        StringBuilder out = new StringBuilder();
        if (mode == ClipboardMode.LIBRARY) {
            if (step == null) {
                out.append(":0000:x:");
            } else {
                String type = step.getType().getLibraryType();
                if (step.getType().isFish() && step.isIsSiamese()) {
                    type = String.valueOf(type) + "1";
                }
                out.append(":").append(type).append(":");
                TreeSet<Integer> candToDeleteSet = new TreeSet<Integer>();
                if (step.getType().useCandToDelInLibraryFormat()) {
                    for (Candidate cand : step.getCandidatesToDelete()) {
                        candToDeleteSet.add(cand.getValue());
                    }
                }
                if (candToDeleteSet.isEmpty()) {
                    int i = 0;
                    while (i < step.getValues().size()) {
                        candToDeleteSet.add(step.getValues().get(i));
                        ++i;
                    }
                }
                Iterator<Candidate> iterator = candToDeleteSet.iterator();
                while (iterator.hasNext()) {
                    int cand = (Integer)((Object)iterator.next());
                    out.append(cand);
                }
                out.append(":");
            }
        }
        if (mode == ClipboardMode.CLUES_ONLY || mode == ClipboardMode.VALUES_ONLY || mode == ClipboardMode.LIBRARY) {
            int i = 0;
            while (i < 81) {
                if (this.getValue(i) == 0 || mode == ClipboardMode.CLUES_ONLY && !this.isFixed(i)) {
                    out.append(dot);
                } else {
                    if (mode == ClipboardMode.LIBRARY && !this.isFixed(i)) {
                        out.append("+");
                    }
                    out.append(Integer.toString(this.getValue(i)));
                }
                ++i;
            }
        }
        if (mode == ClipboardMode.PM_GRID || mode == ClipboardMode.PM_GRID_WITH_STEP || mode == ClipboardMode.CLUES_ONLY_FORMATTED || mode == ClipboardMode.VALUES_ONLY_FORMATTED) {
            Iterator<Cloneable> candString;
            StringBuilder[] cellBuffers = new StringBuilder[this.cells.length];
            int i = 0;
            while (i < this.cells.length) {
                cellBuffers[i] = new StringBuilder();
                int value = this.getValue(i);
                if (mode == ClipboardMode.CLUES_ONLY_FORMATTED && !this.isFixed(i)) {
                    value = 0;
                }
                if (value != 0) {
                    cellBuffers[i].append(String.valueOf(value));
                } else {
                    candString = "";
                    if (mode != ClipboardMode.CLUES_ONLY_FORMATTED && mode != ClipboardMode.VALUES_ONLY_FORMATTED) {
                        candString = this.getCandidateString(i);
                    }
                    if (((String)((Object)candString)).isEmpty()) {
                        candString = dot;
                    }
                    cellBuffers[i].append((String)((Object)candString));
                }
                ++i;
            }
            if (mode == ClipboardMode.PM_GRID_WITH_STEP && step != null) {
                int index4;
                int index2;
                boolean[] cellsWithExtraChar = new boolean[this.cells.length];
                candString = step.getIndices().iterator();
                while (candString.hasNext()) {
                    int index3 = (Integer)candString.next();
                    this.insertOrReplaceChar(cellBuffers[index3], '*');
                    cellsWithExtraChar[index3] = true;
                }
                if (SolutionType.isFish(step.getType()) || step.getType() == SolutionType.W_WING) {
                    for (Candidate cand : step.getFins()) {
                        index2 = cand.getIndex();
                        this.insertOrReplaceChar(cellBuffers[index2], '#');
                        cellsWithExtraChar[index2] = true;
                    }
                }
                if (SolutionType.isFish(step.getType())) {
                    for (Candidate cand : step.getEndoFins()) {
                        index2 = cand.getIndex();
                        this.insertOrReplaceChar(cellBuffers[index2], '@');
                        cellsWithExtraChar[index2] = true;
                    }
                }
                for (Chain chain : step.getChains()) {
                    int i2 = chain.getStart();
                    while (i2 <= chain.getEnd()) {
                        if (chain.getNodeType(i2) != 2) {
                            index4 = chain.getCellIndex(i2);
                            this.insertOrReplaceChar(cellBuffers[index4], '*');
                            cellsWithExtraChar[index4] = true;
                            if (chain.getNodeType(i2) == 1) {
                                index4 = Chain.getSCellIndex2(chain.getChain()[i2]);
                                if (index4 != -1) {
                                    this.insertOrReplaceChar(cellBuffers[index4], '*');
                                    cellsWithExtraChar[index4] = true;
                                }
                                if ((index4 = Chain.getSCellIndex3(chain.getChain()[i2])) != -1) {
                                    this.insertOrReplaceChar(cellBuffers[index4], '*');
                                    cellsWithExtraChar[index4] = true;
                                }
                            }
                        }
                        ++i2;
                    }
                }
                char alsChar = 'A';
                for (AlsInSolutionStep als : step.getAlses()) {
                    for (int index4 : als.getIndices()) {
                        this.insertOrReplaceChar(cellBuffers[index4], alsChar);
                        cellsWithExtraChar[index4] = true;
                    }
                    alsChar = (char)(alsChar + 1);
                }
                for (Candidate cand : step.getCandidatesToDelete()) {
                    index4 = cand.getIndex();
                    char candidate = Character.forDigit(cand.getValue(), 10);
                    int i3 = 0;
                    while (i3 < cellBuffers[index4].length()) {
                        if (cellBuffers[index4].charAt(i3) == candidate && (i3 == 0 || i3 > 0 && cellBuffers[index4].charAt(i3 - 1) != '-')) {
                            cellBuffers[index4].insert(i3, '-');
                            if (i3 == 0) {
                                cellsWithExtraChar[index4] = true;
                            }
                        }
                        ++i3;
                    }
                }
                int i4 = 0;
                while (i4 < cellsWithExtraChar.length) {
                    if (cellsWithExtraChar[i4]) {
                        int[] indices = COLS[Sudoku2.getCol(i4)];
                        int j = 0;
                        while (j < indices.length) {
                            if (Character.isDigit(cellBuffers[indices[j]].charAt(0))) {
                                cellBuffers[indices[j]].insert(0, ' ');
                            }
                            ++j;
                        }
                    }
                    ++i4;
                }
            }
            int[] fieldLengths = new int[COLS.length];
            int i5 = 0;
            while (i5 < cellBuffers.length) {
                int col = Sudoku2.getCol(i5);
                if (cellBuffers[i5].length() > fieldLengths[col]) {
                    fieldLengths[col] = cellBuffers[i5].length();
                }
                ++i5;
            }
            i5 = 0;
            while (i5 < fieldLengths.length) {
                int n = i5++;
                fieldLengths[n] = fieldLengths[n] + 2;
            }
            String separator = System.getProperty("line.separator");
            int i6 = 0;
            while (i6 < 9) {
                if (i6 % 3 == 0) {
                    this.writeLine(out, i6, fieldLengths, null, true, separator);
                }
                this.writeLine(out, i6, fieldLengths, cellBuffers, false, separator);
                ++i6;
            }
            this.writeLine(out, 9, fieldLengths, null, true, separator);
            if (mode == ClipboardMode.PM_GRID_WITH_STEP && step != null) {
                out.append(step.toString(2));
            }
        }
        if (mode == ClipboardMode.LIBRARY) {
            boolean first = true;
            out.append(":");
            int i = 0;
            while (i < this.cells.length) {
                if (this.getValue(i) == 0) {
                    int j = 1;
                    while (j <= 9) {
                        if (this.isValidValue(i, j) && !this.isCandidate(i, j)) {
                            if (first) {
                                first = false;
                            } else {
                                out.append(" ");
                            }
                            out.append(Integer.toString(j)).append(Integer.toString(i / 9 + 1)).append(Integer.toString(i % 9 + 1));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (step == null) {
                out.append("::");
            } else {
                String candString = step.getCandidateString(true);
                out.append(":").append(candString).append(":");
                if (candString.isEmpty()) {
                    out.append(step.getValueIndexString());
                }
                out.append(":");
                if (step.getType().isSimpleChainOrLoop()) {
                    out.append(step.getChainLength() - 1);
                }
            }
        }
        return out.toString();
    }

    private void insertOrReplaceChar(StringBuilder buffer, char ch) {
        if (Character.isDigit(buffer.charAt(0))) {
            buffer.insert(0, ch);
        } else {
            buffer.replace(0, 1, Character.toString(ch));
        }
    }

    private void writeLine(StringBuilder out, int row, int[] fieldLengths, StringBuilder[] cellBuffers, boolean drawOutline, String separator) {
        if (drawOutline) {
            char leftRight = '.';
            char middle = '.';
            if (row == 3 || row == 6) {
                leftRight = ':';
                middle = '+';
            } else if (row == 9) {
                leftRight = '\'';
                middle = '\'';
            }
            out.append(leftRight);
            int i = 0;
            while (i < fieldLengths[0] + fieldLengths[1] + fieldLengths[2]) {
                out.append('-');
                ++i;
            }
            out.append(middle);
            i = 0;
            while (i < fieldLengths[3] + fieldLengths[4] + fieldLengths[5]) {
                out.append('-');
                ++i;
            }
            out.append(middle);
            i = 0;
            while (i < fieldLengths[6] + fieldLengths[7] + fieldLengths[8]) {
                out.append('-');
                ++i;
            }
            out.append(leftRight);
        } else {
            int i = row * 9;
            while (i < (row + 1) * 9) {
                if (i % 3 == 0) {
                    out.append("|");
                    if (i % 9 != 8) {
                        out.append(' ');
                    }
                } else {
                    out.append(' ');
                }
                int tmp = fieldLengths[Sudoku2.getCol(i)];
                out.append((CharSequence)cellBuffers[i]);
                tmp -= cellBuffers[i].length();
                int j = 0;
                while (j < tmp - 1) {
                    out.append(' ');
                    ++j;
                }
                ++i;
            }
            out.append('|');
        }
        out.append(separator);
    }

    public int getValue(int row, int col) {
        return this.getValue(Sudoku2.getIndex(row, col));
    }

    public int getValue(int index) {
        return this.values[index];
    }

    public int getSolution(int row, int col) {
        return this.getSolution(Sudoku2.getIndex(row, col));
    }

    public int getSolution(int index) {
        if (!this.solutionSet) {
            return 0;
        }
        return this.solution[index];
    }

    public boolean isFixed(int row, int col) {
        return this.isFixed(Sudoku2.getIndex(row, col));
    }

    public boolean isFixed(int index) {
        return this.fixed[index];
    }

    public void setIsFixed(int index, boolean isFixed) {
        this.fixed[index] = isFixed;
    }

    public boolean isCandidate(int row, int col, int cand) {
        return this.isCandidate(Sudoku2.getIndex(row, col), cand);
    }

    public boolean isCandidate(int index, int cand) {
        return (this.cells[index] & MASKS[cand]) != 0;
    }

    public boolean isCandidate(int row, int col, int cand, boolean user) {
        return this.isCandidate(Sudoku2.getIndex(row, col), cand, user);
    }

    public boolean isCandidate(int index, int cand, boolean user) {
        if (user) {
            return (this.userCells[index] & MASKS[cand]) != 0;
        }
        return this.isCandidate(index, cand);
    }

    public boolean isCandidateValid(int index, int value, boolean user) {
        return this.isCandidate(index, value, user) && this.isValidValue(index, value);
    }

    public static boolean isValidIndex(int row, int col) {
        return row >= 0 && row < 9 && col >= 0 && col < 9;
    }

    public boolean areCandidatesValid(int index, boolean[] candidates, boolean user) {
        if (this.values[index] != 0) {
            return false;
        }
        if (candidates[candidates.length - 1]) {
            return this.getAnzCandidates(index) == 2;
        }
        if (!Options.getInstance().isUseOrInsteadOfAndForFilter()) {
            int i = 1;
            while (i < candidates.length - 1) {
                if (candidates[i] && !this.isCandidate(index, i, user)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int i = 1;
        while (i < candidates.length) {
            if (candidates[i] && this.isCandidate(index, i, user)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getCandidateString(int index) {
        StringBuilder tmp = new StringBuilder();
        int[] cands = POSSIBLE_VALUES[this.cells[index]];
        int i = 0;
        while (i < cands.length) {
            tmp.append(cands[i]);
            ++i;
        }
        return tmp.toString();
    }

    public void getCandidateSet(int row, int col, SudokuSet candSet) {
        this.getCandidateSet(Sudoku2.getIndex(row, col), candSet);
    }

    public void getCandidateSet(int index, SudokuSet candSet) {
        candSet.set(this.cells[index] << 1);
    }

    public boolean delCandidate(int index, int value) {
        return this.setCandidate(index, value, false);
    }

    public boolean delCandidate(int index, int value, boolean user) {
        return this.setCandidate(index, value, false, user);
    }

    public void setCandidate(int index, int value) {
        this.setCandidate(index, value, true);
    }

    public boolean setCandidate(int row, int col, int value, boolean set) {
        return this.setCandidate(Sudoku2.getIndex(row, col), value, set);
    }

    public boolean setCandidate(int index, int value, boolean set) {
        block15: {
            block14: {
                if (!set) break block14;
                if ((this.cells[index] & MASKS[value]) != 0) break block15;
                int n = index;
                this.cells[n] = (short)(this.cells[n] | MASKS[value]);
                int newAnz = ANZ_VALUES[this.cells[index]];
                if (newAnz == 1) {
                    this.addNakedSingle(index, value);
                } else if (newAnz == 2) {
                    this.nsQueue.deleteNakedSingle(index);
                }
                int i = 0;
                while (i < CONSTRAINTS[index].length) {
                    byte[] byArray = this.free[CONSTRAINTS[index][i]];
                    int n2 = value;
                    byArray[n2] = (byte)(byArray[n2] + 1);
                    byte newFree = byArray[n2];
                    if (newFree == 1) {
                        this.addHiddenSingle(CONSTRAINTS[index][i], value);
                    } else if (newFree == 2) {
                        this.hsQueue.deleteHiddenSingle(CONSTRAINTS[index][i], value);
                    }
                    ++i;
                }
                break block15;
            }
            if ((this.cells[index] & MASKS[value]) != 0) {
                int n = index;
                this.cells[n] = (short)(this.cells[n] & ~MASKS[value]);
                if (this.cells[index] == 0) {
                    return false;
                }
                if (ANZ_VALUES[this.cells[index]] == 1) {
                    this.addNakedSingle(index, CAND_FROM_MASK[this.cells[index]]);
                }
                int i = 0;
                while (i < CONSTRAINTS[index].length) {
                    byte[] byArray = this.free[CONSTRAINTS[index][i]];
                    int n3 = value;
                    byArray[n3] = (byte)(byArray[n3] - 1);
                    byte newFree = byArray[n3];
                    if (newFree == 1) {
                        this.addHiddenSingle(CONSTRAINTS[index][i], value);
                    } else if (newFree == 0) {
                        this.hsQueue.deleteHiddenSingle(CONSTRAINTS[index][i], value);
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    public boolean setCandidate(int index, int value, boolean set, boolean user) {
        boolean ret = this.setCandidate(index, value, set);
        if (user) {
            if (set) {
                int n = index;
                this.userCells[n] = (short)(this.userCells[n] | MASKS[value]);
            } else {
                int n = index;
                this.userCells[n] = (short)(this.userCells[n] & ~MASKS[value]);
            }
        }
        return ret;
    }

    public boolean setCell(int row, int col, int value) {
        return this.setCell(Sudoku2.getIndex(row, col), value);
    }

    public boolean setCell(int index, int value) {
        return this.setCell(index, value, false, true);
    }

    public boolean setCell(int row, int col, int value, boolean isFixed) {
        return this.setCell(Sudoku2.getIndex(row, col), value, isFixed, true);
    }

    public boolean setCell(int index, int value, boolean isFixed) {
        return this.setCell(index, value, isFixed, true);
    }

    public boolean setCell(int index, int value, boolean isFixed, boolean user) {
        if (this.values[index] == value) {
            return true;
        }
        boolean valid = true;
        int oldValue = this.values[index];
        this.values[index] = value;
        this.fixed[index] = isFixed;
        if (value != 0) {
            int[] cands = POSSIBLE_VALUES[this.cells[index]];
            this.cells[index] = 0;
            if (user) {
                this.userCells[index] = 0;
            }
            --this.unsolvedCellsAnz;
            int i = 0;
            while (i < buddies[index].size()) {
                int buddyIndex = buddies[index].get(i);
                if (!this.setCandidate(buddyIndex, value, false)) {
                    valid = false;
                }
                if (user) {
                    int n = buddyIndex;
                    this.userCells[n] = (short)(this.userCells[n] & ~MASKS[value]);
                }
                ++i;
            }
            i = 0;
            while (i < cands.length) {
                int cand = cands[i];
                int j = 0;
                while (j < CONSTRAINTS[index].length) {
                    int constr = CONSTRAINTS[index][j];
                    byte[] byArray = this.free[constr];
                    int n = cand;
                    byArray[n] = (byte)(byArray[n] - 1);
                    byte newFree = byArray[n];
                    if (newFree == 1 && value != cand) {
                        this.addHiddenSingle(constr, cand);
                    } else if (newFree == 0 && cand != value) {
                        valid = false;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int cand = 1;
            while (cand <= 9) {
                if (this.isValidValue(index, cand)) {
                    this.setCandidate(index, cand);
                }
                ++cand;
            }
            int i = 0;
            while (i < buddies[index].size()) {
                int buddyIndex = buddies[index].get(i);
                if (this.getValue(buddyIndex) == 0 && this.isValidValue(buddyIndex, oldValue)) {
                    this.setCandidate(buddyIndex, oldValue);
                }
                ++i;
            }
            this.rebuildInternalData();
        }
        return valid;
    }

    public void setCellBS(int index, int value) {
        this.values[index] = value;
        this.cells[index] = 0;
        int i = 0;
        while (i < buddies[index].size()) {
            int buddyIndex;
            int n = buddyIndex = buddies[index].get(i);
            this.cells[n] = (short)(this.cells[n] & ~MASKS[value]);
            ++i;
        }
    }

    public boolean isValidValue(int row, int col, int value) {
        return this.isValidValue(Sudoku2.getIndex(row, col), value);
    }

    public boolean isValidValue(int index, int value) {
        int i = 0;
        while (i < buddies[index].size()) {
            if (this.values[buddies[index].get(i)] == value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int getRow(int index) {
        return index / 9;
    }

    public static int getCol(int index) {
        return index % 9;
    }

    public static int getBlock(int index) {
        return BLOCK_FROM_INDEX[index];
    }

    public static int getIndex(int row, int col) {
        return row * 9 + col;
    }

    public boolean isSolved() {
        return this.unsolvedCellsAnz == 0;
    }

    public int getSolvedCellsAnz() {
        return 81 - this.unsolvedCellsAnz;
    }

    public int getFixedCellsAnz() {
        int anz = 0;
        int i = 0;
        while (i < this.fixed.length) {
            if (this.fixed[i]) {
                ++anz;
            }
            ++i;
        }
        return anz;
    }

    public int getUnsolvedCandidatesAnz() {
        int anz = 0;
        int i = 0;
        while (i < this.cells.length) {
            anz += ANZ_VALUES[this.cells[i]];
            ++i;
        }
        return anz;
    }

    private static void initBuddies() {
        int j;
        if (buddies[0] != null) {
            return;
        }
        int i = 0;
        while (i < 81) {
            Sudoku2.buddies[i] = new SudokuSet();
            j = 0;
            while (j < 81) {
                if (i != j && (Sudoku2.getRow(i) == Sudoku2.getRow(j) || Sudoku2.getCol(i) == Sudoku2.getCol(j) || Sudoku2.getBlock(i) == Sudoku2.getBlock(j))) {
                    buddies[i].add(j);
                }
                ++j;
            }
            Sudoku2.buddiesM1[i] = buddies[i].getMask1();
            Sudoku2.buddiesM2[i] = buddies[i].getMask2();
            ++i;
        }
        i = 0;
        while (i < 9) {
            Sudoku2.ROW_TEMPLATES[i] = new SudokuSet();
            j = 0;
            while (j < ROWS[i].length) {
                ROW_TEMPLATES[i].add(ROWS[i][j]);
                ++j;
            }
            Sudoku2.ROW_BLOCK_TEMPLATES[i] = ROW_TEMPLATES[i];
            Sudoku2.ALL_CONSTRAINTS_TEMPLATES[i] = ROW_TEMPLATES[i];
            Sudoku2.COL_TEMPLATES[i] = new SudokuSet();
            j = 0;
            while (j < COLS[i].length) {
                COL_TEMPLATES[i].add(COLS[i][j]);
                ++j;
            }
            Sudoku2.COL_BLOCK_TEMPLATES[i] = COL_TEMPLATES[i];
            Sudoku2.ALL_CONSTRAINTS_TEMPLATES[i + 9] = COL_TEMPLATES[i];
            Sudoku2.BLOCK_TEMPLATES[i] = new SudokuSet();
            j = 0;
            while (j < BLOCKS[i].length) {
                BLOCK_TEMPLATES[i].add(BLOCKS[i][j]);
                ++j;
            }
            Sudoku2.ROW_BLOCK_TEMPLATES[i + 9] = BLOCK_TEMPLATES[i];
            Sudoku2.COL_BLOCK_TEMPLATES[i + 9] = BLOCK_TEMPLATES[i];
            Sudoku2.ALL_CONSTRAINTS_TEMPLATES[i + 18] = BLOCK_TEMPLATES[i];
            ++i;
        }
        i = 0;
        while (i < ALL_CONSTRAINTS_TEMPLATES.length) {
            Sudoku2.ALL_CONSTRAINTS_TEMPLATES_M1[i] = ALL_CONSTRAINTS_TEMPLATES[i].getMask1();
            Sudoku2.ALL_CONSTRAINTS_TEMPLATES_M2[i] = ALL_CONSTRAINTS_TEMPLATES[i].getMask2();
            ++i;
        }
    }

    private static void initGroupedBuddies() {
        int i = 0;
        while (i < 11) {
            Sudoku2.initGroupForGroupedBuddies(i * 8, groupedBuddies[i]);
            ++i;
        }
        i = 0;
        while (i < groupedBuddies.length) {
            int j = 0;
            while (j < groupedBuddies[i].length) {
                Sudoku2.groupedBuddiesM1[i][j] = groupedBuddies[i][j].getMask1();
                Sudoku2.groupedBuddiesM2[i][j] = groupedBuddies[i][j].getMask2();
                ++j;
            }
            ++i;
        }
    }

    private static void initGroupForGroupedBuddies(int groupOffset, SudokuSetBase[] groupArray) {
        SudokuSet groupSet = new SudokuSet();
        int i = 0;
        while (i < 256) {
            groupSet.clear();
            int mask = 1;
            int j = 0;
            while (j < 8) {
                if ((i & mask) != 0 && groupOffset + j + 1 <= 81) {
                    groupSet.add(groupOffset + j);
                }
                mask <<= 1;
                ++j;
            }
            SudokuSetBase buddiesSet = new SudokuSetBase(true);
            int j2 = 0;
            while (j2 < groupSet.size()) {
                buddiesSet.and(buddies[groupSet.get(j2)]);
                ++j2;
            }
            groupArray[i] = buddiesSet;
            ++i;
        }
    }

    public static void getBuddies(SudokuSetBase cells, SudokuSetBase buddiesOut) {
        int mIndex;
        int j;
        int i;
        buddiesOut.setAll();
        if (cells.mask1 != 0L) {
            i = 0;
            j = 0;
            while (i < 8) {
                mIndex = (int)(cells.mask1 >> j & 0xFFL);
                buddiesOut.and(groupedBuddies[i][mIndex]);
                ++i;
                j += 8;
            }
        }
        if (cells.mask2 != 0L) {
            i = 8;
            j = 0;
            while (i < 11) {
                mIndex = (int)(cells.mask2 >> j & 0xFFL);
                buddiesOut.and(groupedBuddies[i][mIndex]);
                ++i;
                j += 8;
            }
        }
    }

    public static void getBuddies(long mask1, long mask2, SudokuSetBase buddiesOut) {
        int mIndex;
        int j;
        int i;
        long outM1 = -1L;
        long outM2 = 131071L;
        if (mask1 != 0L) {
            i = 0;
            j = 0;
            while (i < 8) {
                mIndex = (int)(mask1 >> j & 0xFFL);
                outM1 &= groupedBuddiesM1[i][mIndex];
                outM2 &= groupedBuddiesM2[i][mIndex];
                ++i;
                j += 8;
            }
        }
        if (mask2 != 0L) {
            i = 8;
            j = 0;
            while (i < 11) {
                mIndex = (int)(mask2 >> j & 0xFFL);
                outM1 &= groupedBuddiesM1[i][mIndex];
                outM2 &= groupedBuddiesM2[i][mIndex];
                ++i;
                j += 8;
            }
        }
        buddiesOut.set(outM1, outM2);
    }

    private static void initTemplates() {
        try {
            long ticks = System.currentTimeMillis();
            ObjectInputStream in = new ObjectInputStream(Sudoku2.class.getResourceAsStream("/templates.dat"));
            templates = (SudokuSetBase[])in.readObject();
            in.close();
            ticks = System.currentTimeMillis() - ticks;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int i = 0;
        while (i < ROWS.length) {
            int j = 0;
            while (j < ROWS[i].length) {
                ROW_TEMPLATES[i].add(ROWS[i][j]);
                COL_TEMPLATES[i].add(COLS[i][j]);
                BLOCK_TEMPLATES[i].add(BLOCKS[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public void setNoClues() {
        int i = 0;
        while (i < this.fixed.length) {
            this.fixed[i] = false;
            ++i;
        }
        this.setStatusGivens(SudokuStatus.INVALID);
    }

    public void setGivens(String givens) {
        int i = 0;
        while (i < givens.length()) {
            char ch = givens.charAt(i);
            this.fixed[i] = Character.isDigit(ch) && ch != '0';
            ++i;
        }
        Sudoku2 act = new Sudoku2();
        act.set(this);
        SudokuGenerator generator = SudokuGeneratorFactory.getDefaultGeneratorInstance();
        int anzSol = generator.getNumberOfSolutions(act, 1);
        this.setStatusGivens(anzSol);
    }

    private void addNakedSingle(int index, int value) {
        this.nsQueue.addSingle(index, value);
    }

    private boolean addHiddenSingle(int constraint, int value) {
        int i = 0;
        while (i < ALL_UNITS[constraint].length) {
            int hsIndex = ALL_UNITS[constraint][i];
            if (this.isCandidate(hsIndex, value)) {
                this.hsQueue.addSingle(hsIndex, value);
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public DifficultyLevel getLevel() {
        return this.level;
    }

    public void setLevel(DifficultyLevel level) {
        this.level = level;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    public int[] getValues() {
        return this.values;
    }

    public void setValues(int[] values) {
        this.values = values;
    }

    public int[] getSolution() {
        return this.solution;
    }

    public void setSolution(int[] solution) {
        this.solution = solution;
        this.solutionSet = true;
    }

    public boolean isSolutionSet() {
        return this.solutionSet;
    }

    public void setSolutionSet(boolean solutionSet) {
        this.solutionSet = solutionSet;
    }

    public boolean[] getFixed() {
        return this.fixed;
    }

    public void setFixed(boolean[] fixed) {
        this.fixed = fixed;
    }

    public short getCell(int index) {
        return this.cells[index];
    }

    public short[] getCells() {
        return this.cells;
    }

    public void setCells(short[] cells) {
        this.cells = cells;
    }

    public short[] getUserCells() {
        return this.userCells;
    }

    public void setUserCells(short[] userCells) {
        this.userCells = userCells;
    }

    public byte[][] getFree() {
        return this.free;
    }

    public void setFree(byte[][] free) {
        this.free = free;
    }

    public int getUnsolvedCellsAnz() {
        return this.unsolvedCellsAnz;
    }

    public void setUnsolvedCellsAnz(int unsolvedCellsAnz) {
        this.unsolvedCellsAnz = unsolvedCellsAnz;
    }

    public SudokuSinglesQueue getNsQueue() {
        return this.nsQueue;
    }

    public void setNsQueue(SudokuSinglesQueue nsQueue) {
        this.nsQueue = nsQueue;
    }

    public SudokuSinglesQueue getHsQueue() {
        return this.hsQueue;
    }

    public void setHsQueue(SudokuSinglesQueue hsQueue) {
        this.hsQueue = hsQueue;
    }

    public SudokuStatus getStatus() {
        return this.status;
    }

    public void setStatus(SudokuStatus status) {
        this.status = status;
    }

    public void setStatus(int numberOfSolutions) {
        switch (numberOfSolutions) {
            case 0: {
                this.status = SudokuStatus.INVALID;
                break;
            }
            case 1: {
                this.status = SudokuStatus.VALID;
                break;
            }
            default: {
                this.status = SudokuStatus.MULTIPLE_SOLUTIONS;
            }
        }
    }

    public SudokuStatus getStatusGivens() {
        return this.statusGivens;
    }

    public void setStatusGivens(SudokuStatus statusGivens) {
        this.statusGivens = statusGivens;
    }

    public void setStatusGivens(int numberOfSolutions) {
        switch (numberOfSolutions) {
            case 0: {
                this.statusGivens = SudokuStatus.INVALID;
                break;
            }
            case 1: {
                this.statusGivens = SudokuStatus.VALID;
                break;
            }
            default: {
                this.statusGivens = SudokuStatus.MULTIPLE_SOLUTIONS;
            }
        }
    }

    public boolean userCandidatesEmpty() {
        int i = 0;
        while (i < this.userCells.length) {
            if (this.userCells[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void switchToAllCandidates() {
        int i = 0;
        while (i < this.userCells.length) {
            if (this.values[i] == 0 && this.solution[i] != 0) {
                int n = i;
                this.userCells[n] = (short)(this.userCells[n] | MASKS[this.solution[i]]);
            }
            ++i;
        }
        System.arraycopy(this.userCells, 0, this.cells, 0, 81);
        this.rebuildInternalData();
    }

    public void rebuildAllCandidates() {
        int i = 0;
        while (i < this.cells.length) {
            if (this.values[i] != 0) {
                this.cells[i] = 0;
            } else {
                int cand = 1;
                while (cand <= 9) {
                    if (this.isValidValue(i, cand)) {
                        int n = i;
                        this.cells[n] = (short)(this.cells[n] | MASKS[cand]);
                    }
                    ++cand;
                }
            }
            ++i;
        }
        this.rebuildInternalData();
    }

    public void printSinglesQueues() {
        System.out.println("Naked Singles:\r\n");
        System.out.println(this.nsQueue);
        System.out.println("Hidden Singles:\r\n");
        System.out.println(this.hsQueue);
    }

    public short getRemainingCandidates() {
        short result = 0;
        int i = 0;
        while (i < this.cells.length) {
            if (this.values[i] == 0) {
                result = (short)(result | this.cells[i]);
            }
            ++i;
        }
        return result;
    }
}

