/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class SudokuConsoleFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private StreamHandler consoleHandler = null;
    private JButton closeButton;
    private JTextArea consoleTextArea;
    private JScrollPane jScrollPane1;

    public SudokuConsoleFrame() {
        this.initComponents();
        PrintStream newOut = new PrintStream(new ConsoleOutputStream());
        System.setOut(newOut);
        System.setErr(newOut);
        this.consoleHandler = new StreamHandler(newOut, new SimpleFormatter());
        Logger rootLogger = Logger.getLogger("");
        rootLogger.addHandler(this.consoleHandler);
        rootLogger.setLevel(Level.CONFIG);
        this.getRootPane().setDefaultButton(this.closeButton);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.consoleTextArea = new JTextArea();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(3);
        ResourceBundle bundle = ResourceBundle.getBundle("intl/SudokuConsoleFrame");
        this.setTitle(bundle.getString("SudokuConsoleFrame.title"));
        this.consoleTextArea.setColumns(20);
        this.consoleTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.consoleTextArea);
        this.closeButton.setText(bundle.getString("SudokuConsoleForm.closeButton.text"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SudokuConsoleFrame.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 803, Short.MAX_VALUE).addComponent(this.closeButton, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 346, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addContainerGap()));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        System.exit(0);
    }

    public void setIn() {
        System.setIn(new ConsoleInputStream());
    }

    class ConsoleInputStream
    extends InputStream {
        ConsoleInputStream() {
        }

        @Override
        public int read() throws IOException {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(SudokuConsoleFrame.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                break;
            }
        }
    }

    class ConsoleOutputStream
    extends OutputStream {
        private byte[] littlebuf = new byte[1];

        ConsoleOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.littlebuf[0] = (byte)b;
            String s = new String(this.littlebuf, 0, 1);
            SudokuConsoleFrame.this.consoleTextArea.append(s);
            SudokuConsoleFrame.this.consoleTextArea.setCaretPosition(SudokuConsoleFrame.this.consoleTextArea.getText().length());
        }

        @Override
        public void write(byte[] b) throws IOException {
            String s = new String(b, 0, b.length);
            SudokuConsoleFrame.this.consoleTextArea.append(s);
            SudokuConsoleFrame.this.consoleTextArea.setCaretPosition(SudokuConsoleFrame.this.consoleTextArea.getText().length());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String s = new String(b, off, len);
            SudokuConsoleFrame.this.consoleTextArea.append(s);
            SudokuConsoleFrame.this.consoleTextArea.setCaretPosition(SudokuConsoleFrame.this.consoleTextArea.getText().length());
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

