/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import generator.SudokuGenerator;
import generator.SudokuGeneratorFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.GroupLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.w3c.dom.Node;
import solver.SudokuSolver;
import solver.SudokuSolverFactory;
import solver.SudokuStepFinder;
import sudoku.AlsInSolutionStep;
import sudoku.Candidate;
import sudoku.CellZoomPanel;
import sudoku.Chain;
import sudoku.ClipboardMode;
import sudoku.ColorKuImage;
import sudoku.DifficultyType;
import sudoku.GameMode;
import sudoku.GuiState;
import sudoku.MainFrame;
import sudoku.Options;
import sudoku.ProgressChecker;
import sudoku.RightClickMenu;
import sudoku.SolutionStep;
import sudoku.SolutionType;
import sudoku.Sudoku2;
import sudoku.SudokuSet;
import sudoku.SudokuSetBase;
import sudoku.SudokuStatus;
import sudoku.SudokuUtil;

public class SudokuPanel
extends JPanel
implements Printable {
    private static final long serialVersionUID = 1L;
    private static BufferedImage[] colorKuImagesSmall = new BufferedImage[11];
    private static BufferedImage[] colorKuImagesLarge = new BufferedImage[9];
    private static final int DEFAULT_DOUBLE_CLICK_SPEED = 500;
    private static final int DELTA = 5;
    private static final int DELTA_RAND = 5;
    private static final int[] KEY_CODES = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private boolean showCandidates = Options.getInstance().isShowCandidates();
    private boolean showWrongValues = Options.getInstance().isShowWrongValues();
    private boolean showDeviations = Options.getInstance().isShowDeviations();
    private boolean invalidCells = Options.getInstance().isInvalidCells();
    private boolean showInvalidOrPossibleCells = false;
    private boolean[] showHintCellValues = new boolean[11];
    private boolean showAllCandidatesAkt = false;
    private boolean showAllCandidates = false;
    private int delta = 5;
    private int deltaRand = 5;
    private Font valueFont;
    private Font candidateFont;
    private int candidateHeight;
    private Font bigFont;
    private Font smallFont;
    private Sudoku2 sudoku;
    private SudokuSolver solver;
    private SudokuGenerator generator;
    private MainFrame mainFrame;
    private CellZoomPanel cellZoomPanel;
    private SolutionStep step;
    private int chainIndex = -1;
    private List<Integer> alsToShow = new ArrayList<Integer>();
    private Rectangle gridRegion = new Rectangle();
    private float strokeWidth = 1.0f;
    private float boxStrokeWidth = 1.0f;
    private int strokeWidthInt = 1;
    private int oldWidth;
    private int cellSize;
    private Graphics2D g2;
    private CubicCurve2D.Double cubicCurve = new CubicCurve2D.Double();
    private Polygon arrow = new Polygon();
    private Stroke arrowStroke = new BasicStroke(1.5f, 1, 1);
    private Stroke strongLinkStroke = new BasicStroke(1.5f, 1, 1);
    private Stroke weakLinkStroke = new BasicStroke(1.5f, 1, 1, 10.0f, new float[]{5.0f}, 0.0f);
    private List<Point2D.Double> points = new ArrayList<Point2D.Double>(200);
    private double arrowLengthFactor = 0.16666666666666666;
    private double arrowHeightFactor = 0.3333333333333333;
    private int shiftRow = -1;
    private int shiftCol = -1;
    private Stack<Sudoku2> undoStack = new Stack();
    private Stack<Sudoku2> redoStack = new Stack();
    private SortedMap<Integer, Color> coloringMap = new TreeMap<Integer, Color>();
    private SortedMap<Integer, Color> coloringCandidateMap = new TreeMap<Integer, Color>();
    private Cursor colorCursor = null;
    private Cursor colorCursorShift = null;
    private Cursor oldCursor = null;
    private ArrayList<Integer> cellSelection = new ArrayList();
    private boolean[] dragCellSelection = new boolean[82];
    private ProgressChecker progressChecker = null;
    private Timer deleteCursorTimer = new Timer(Options.getInstance().getDeleteCursorDisplayLength(), null);
    private long lastCursorChanged = -1L;
    private RightClickMenu rightClickMenu = null;
    private boolean[] remainingCandidates = new boolean[9];
    public int lastPressedRow = -1;
    public int lastPressedCol = -1;
    public int lastPressedCandidate = -1;
    private int lastClickedRow = -1;
    private int lastClickedCol = -1;
    private int lastClickedCandidate = -1;
    private long lastClickedTime = 0L;
    private long doubleClickSpeed = -1L;
    private Candidate lastCandidateMouseOn = new Candidate();
    private boolean isCtrlDown;
    private Point lastMousePosition = new Point();
    private int lastHighlightedDigit = 0;
    private boolean isColoringVisible = true;

    public SudokuPanel(MainFrame mf) {
        this.mainFrame = mf;
        this.sudoku = new Sudoku2();
        this.sudoku.clearSudoku();
        this.setShowCandidates(Options.getInstance().isShowCandidates());
        this.generator = SudokuGeneratorFactory.getDefaultGeneratorInstance();
        this.solver = SudokuSolverFactory.getDefaultSolverInstance();
        this.solver.setSudoku(this.sudoku.clone());
        this.solver.solve();
        this.progressChecker = new ProgressChecker(this.mainFrame);
        this.isCtrlDown = false;
        this.setActiveCell(4, 4);
        this.clearDragSelection();
        this.initComponents();
        this.rightClickMenu = new RightClickMenu(mf, this);
        this.rightClickMenu.setColorIconsInPopupMenu();
        this.updateCellZoomPanel();
        this.calculateGridRegion(this.getBounds(), false, false);
        this.deleteCursorTimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SudokuPanel.this.deleteCursorTimer.stop();
                SudokuPanel.this.lastCursorChanged = System.currentTimeMillis() - (long)Options.getInstance().getDeleteCursorDisplayLength() - 100L;
                SudokuPanel.this.repaint();
            }
        });
        Object cs = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        if (cs instanceof Integer) {
            this.doubleClickSpeed = ((Integer)cs).intValue();
        }
        if (this.doubleClickSpeed == -1L) {
            this.doubleClickSpeed = 500L;
        }
    }

    private void clearDragSelection() {
        Arrays.fill(this.dragCellSelection, false);
    }

    public int getFirstRow() {
        if (this.cellSelection.isEmpty()) {
            return -1;
        }
        int index = this.cellSelection.get(0);
        return Sudoku2.getRow(index);
    }

    public int getFirstCol() {
        if (this.cellSelection.isEmpty()) {
            return -1;
        }
        int index = this.cellSelection.get(0);
        return Sudoku2.getCol(index);
    }

    public int getCellSelectionSize() {
        return this.cellSelection.size();
    }

    public int getActiveRow() {
        if (this.cellSelection.isEmpty()) {
            return -1;
        }
        int index = this.cellSelection.get(this.cellSelection.size() - 1);
        return Sudoku2.getRow(index);
    }

    public int getActiveCol() {
        if (this.cellSelection.isEmpty()) {
            return -1;
        }
        int index = this.cellSelection.get(this.cellSelection.size() - 1);
        return Sudoku2.getCol(index);
    }

    public Integer getActiveCell() {
        if (this.cellSelection.isEmpty()) {
            return null;
        }
        return new Integer(Sudoku2.getIndex(this.getActiveRow(), this.getActiveCol()));
    }

    public void setActiveCell(int index) {
        Integer intObj = new Integer(index);
        if (Options.getInstance().isDeleteCursorDisplay() && this.cellZoomPanel != null && !this.cellZoomPanel.isColoring()) {
            this.deleteCursorTimer.stop();
            this.lastCursorChanged = System.currentTimeMillis();
            this.deleteCursorTimer.setDelay(Options.getInstance().getDeleteCursorDisplayLength());
            this.deleteCursorTimer.setInitialDelay(Options.getInstance().getDeleteCursorDisplayLength());
            this.deleteCursorTimer.start();
        }
        if (this.cellSelection.contains(intObj)) {
            this.cellSelection.remove(intObj);
        }
        this.cellSelection.add(intObj);
        this.mainFrame.updateCellSelectionStatus();
    }

    public void setActiveCell(int row, int col) {
        this.setActiveCell(Sudoku2.getIndex(row, col));
    }

    public void clearSelection(int lastCell) {
        this.cellSelection.clear();
        this.setActiveCell(lastCell);
    }

    public void clearSelection(int row, int col) {
        this.clearSelection(Sudoku2.getIndex(row, col));
    }

    public void clearSelection() {
        if (this.cellSelection.isEmpty()) {
            System.out.println("Error: SudokuPanel.clearSelection is empty...");
        }
        Integer lastCell = this.cellSelection.get(this.cellSelection.size() - 1);
        this.cellSelection.clear();
        this.setActiveCell(lastCell);
    }

    public void resetKeyState() {
        this.isCtrlDown = false;
    }

    private void initComponents() {
        this.rightClickMenu = new RightClickMenu(this.mainFrame, this);
        this.setBackground(new Color(255, 255, 255));
        this.setMinimumSize(new Dimension(300, 300));
        this.setPreferredSize(new Dimension(600, 600));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent evt) {
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                SudokuPanel.this.onMouseDown(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SudokuPanel.this.onMouseUp(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SudokuPanel.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SudokuPanel.this.lastCandidateMouseOn = null;
                SudokuPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                SudokuPanel.this.lastMousePosition = e.getPoint();
                int row = SudokuPanel.this.getRow(e.getPoint());
                int col = SudokuPanel.this.getCol(e.getPoint());
                int index = Sudoku2.getIndex(row, col);
                SudokuPanel.this.updateCandidateMouseHighlight(e.getPoint());
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (!Sudoku2.isValidIndex(row, col)) {
                    return;
                }
                if (SudokuPanel.this.cellZoomPanel.isColoring()) {
                    return;
                }
                if (!SudokuPanel.this.dragCellSelection[index]) {
                    ((SudokuPanel)SudokuPanel.this).dragCellSelection[index] = true;
                    if (SudokuPanel.this.cellSelection.contains(index)) {
                        SudokuPanel.this.cellSelection.remove((Object)index);
                    } else {
                        SudokuPanel.this.cellSelection.add(index);
                    }
                }
                SudokuPanel.this.setActiveCell(row, col);
                SudokuPanel.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                SudokuPanel.this.lastMousePosition = e.getPoint();
                SudokuPanel.this.updateCandidateMouseHighlight(e.getPoint());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SudokuPanel.this.onKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                SudokuPanel.this.onKeyReleased(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 600, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 600, Short.MAX_VALUE));
    }

    private Rectangle calculateGridRegion(Rectangle bounds, boolean isPrint, boolean withBorder) {
        int width = bounds.height < bounds.width ? bounds.height : bounds.width;
        int height = bounds.width < bounds.height ? bounds.width : bounds.height;
        this.strokeWidth = 0.002f * (float)width;
        if (width > 1000) {
            this.strokeWidth *= 1.5f;
        }
        this.boxStrokeWidth = (float)((double)this.strokeWidth * Options.getInstance().getBoxLineFactor());
        this.strokeWidthInt = Math.round(this.boxStrokeWidth / 2.0f);
        this.delta = bounds.width / 100;
        this.deltaRand = bounds.width / 100;
        if (this.deltaRand < this.strokeWidthInt) {
            this.deltaRand = this.strokeWidthInt;
        }
        if (Options.getInstance().getDrawMode() == 1) {
            this.delta = 0;
        }
        this.cellSize = (width - 4 * this.delta - 2 * this.deltaRand) / 9;
        width = height = this.cellSize * 9 + 4 * this.delta;
        int sx = (bounds.width - width) / 2;
        int sy = (bounds.height - height) / 2;
        if (isPrint && withBorder) {
            sy = 0;
        }
        return new Rectangle(sx, sy, width, height);
    }

    public boolean isOnGrid(Point point) {
        return point.x >= this.gridRegion.x && point.x < this.gridRegion.x + this.gridRegion.width && point.y >= this.gridRegion.y && point.y < this.gridRegion.y + this.gridRegion.height;
    }

    private void updateCandidateMouseHighlight(Point mouse) {
        if (this.showCandidateHighlight()) {
            int row = this.getRow(mouse);
            int col = this.getCol(mouse);
            int candidate = this.getCandidate(mouse, row, col);
            int index = Sudoku2.getIndex(row, col);
            if (Sudoku2.isValidIndex(row, col)) {
                Candidate mouseOn = new Candidate(index, candidate);
                if (this.lastCandidateMouseOn != mouseOn) {
                    this.lastCandidateMouseOn = mouseOn;
                    this.repaint();
                }
            } else if (this.lastCandidateMouseOn != null) {
                this.lastCandidateMouseOn = null;
                this.repaint();
            }
        }
    }

    private void updateAutoHighlight(int row, int col) {
        int value;
        if (Options.getInstance().isAutoHighlighting() && (value = this.sudoku.getValue(row, col)) != 0 && value != this.lastHighlightedDigit) {
            this.setShowHintCellValue(value);
            this.setShowInvalidOrPossibleCells(true);
            this.lastHighlightedDigit = value;
        }
    }

    private void onKeyReleased(KeyEvent evt) {
        this.handleKeysReleased(evt);
        this.updateCellZoomPanel();
        this.mainFrame.fixFocus();
    }

    private void onKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        switch (keyCode) {
            case 27: {
                this.mainFrame.coloringPanelClicked(null);
                this.clearRegion();
                if (this.step == null) break;
                this.mainFrame.abortStep();
                break;
            }
            default: {
                this.handleKeys(evt);
            }
        }
        this.updateCellZoomPanel();
        this.mainFrame.fixFocus();
    }

    private void onMouseDown(MouseEvent evt) {
        this.lastMousePosition = evt.getPoint();
        this.lastPressedRow = this.getRow(evt.getPoint());
        this.lastPressedCol = this.getCol(evt.getPoint());
        this.lastPressedCandidate = this.getCandidate(evt.getPoint(), this.lastPressedRow, this.lastPressedCol);
        this.clearDragSelection();
        Integer index = Sudoku2.getIndex(this.lastPressedRow, this.lastPressedCol);
        boolean isLeftClick = evt.getButton() == 1;
        boolean isRightClick = evt.getButton() == 3;
        boolean rightClickOutsideSelection = !this.cellSelection.contains((int)index) && isRightClick;
        boolean onGrid = this.isOnGrid(evt.getPoint());
        if (!onGrid) {
            this.clearSelection();
            this.clearDragSelection();
            this.updateCellZoomPanel();
        } else if (rightClickOutsideSelection || this.cellZoomPanel.isColoring()) {
            if (rightClickOutsideSelection) {
                this.setActiveCell(this.lastPressedRow, this.lastPressedCol);
            }
            this.clearSelection();
            this.clearDragSelection();
        } else if (isLeftClick) {
            if (!this.isCtrlDown) {
                this.updateAutoHighlight(this.lastPressedRow, this.lastPressedCol);
                this.setActiveCell(this.lastPressedRow, this.lastPressedCol);
                this.clearSelection();
                this.clearDragSelection();
            } else if (this.cellSelection.contains(index) && this.cellSelection.size() > 1) {
                this.cellSelection.remove(index);
                int lastCellSelection = this.cellSelection.get(this.cellSelection.size() - 1);
                this.setActiveCell(Sudoku2.getRow(lastCellSelection), Sudoku2.getCol(lastCellSelection));
            } else if (!this.cellSelection.contains(index)) {
                this.cellSelection.add(index);
                this.setActiveCell(index);
            }
        }
        this.repaint();
    }

    private void onMouseUp(MouseEvent evt) {
        boolean isDoubleClick;
        this.lastMousePosition = evt.getPoint();
        int row = this.getRow(evt.getPoint());
        int col = this.getCol(evt.getPoint());
        int candidate = this.getCandidate(evt.getPoint(), row, col);
        boolean onGrid = this.isOnGrid(evt.getPoint());
        if (!onGrid) {
            this.lastPressedRow = -1;
            this.lastPressedCol = -1;
            this.lastPressedCandidate = -1;
            this.clearSelection();
            this.clearDragSelection();
            this.updateCellZoomPanel();
            this.lastPressedRow = -1;
            this.lastPressedCol = -1;
            this.lastPressedCandidate = -1;
            return;
        }
        long ticks = System.currentTimeMillis();
        boolean bl = isDoubleClick = this.lastClickedTime != -1L && ticks - this.lastClickedTime <= this.doubleClickSpeed && row == this.lastClickedRow && col == this.lastClickedCol && candidate == this.lastClickedCandidate;
        if (isDoubleClick) {
            this.handleMouseClicked(evt, true);
            this.lastClickedTime = -1L;
        } else {
            this.handleMouseClicked(evt, false);
            this.lastClickedTime = ticks;
        }
        this.lastClickedRow = row;
        this.lastClickedCol = col;
        this.lastClickedCandidate = candidate;
    }

    boolean onRightClick(MouseClickDTO dto) {
        boolean change = false;
        if (Options.getInstance().isSingleClickMode()) {
            if (this.cellSelection.contains(Sudoku2.getIndex(dto.row, dto.col))) {
                if (dto.candidate != -1) {
                    change = this.toggleCandidateInAktCells(dto.candidate);
                }
            } else {
                this.setActiveCell(dto.row, dto.col);
                this.clearRegion();
                if (this.sudoku.getValue(dto.row, dto.col) != 0 && !this.sudoku.isFixed(dto.row, dto.col)) {
                    this.rightClickMenu.deleteValuePopup(dto.row, dto.col, this.cellSize);
                } else {
                    int showHintCellValue = this.getShowHintCellValue();
                    if (!(dto.candidate != -1 && this.sudoku.isCandidate(dto.row, dto.col, dto.candidate, !this.showCandidates) || showHintCellValue == 0)) {
                        if (this.showDeviations && this.sudoku.isSolutionSet() && dto.candidate == this.sudoku.getSolution(this.getActiveRow(), this.getActiveCol())) {
                            this.toggleCandidateInCell(this.getActiveRow(), this.getActiveCol(), dto.candidate);
                        } else {
                            this.toggleCandidateInCell(this.getActiveRow(), this.getActiveCol(), showHintCellValue);
                        }
                    } else if (dto.candidate != -1) {
                        this.toggleCandidateInCell(this.getActiveRow(), this.getActiveCol(), dto.candidate);
                    }
                    change = true;
                }
            }
        } else {
            this.rightClickMenu.showPopupMenu(dto.row, dto.col, this.cellSize);
        }
        return change;
    }

    boolean onSingleLeftClick(MouseClickDTO dto, int index) {
        if (dto.ctrlPressed) {
            return false;
        }
        if (dto.shiftPressed) {
            if (Options.getInstance().isUseShiftForRegionSelect()) {
                this.selectRegion(dto.row, dto.col);
            } else if (dto.candidate != -1) {
                if (this.sudoku.isCandidate(index, dto.candidate, !this.showCandidates)) {
                    this.sudoku.setCandidate(index, dto.candidate, false, !this.showCandidates);
                } else {
                    this.sudoku.setCandidate(index, dto.candidate, true, !this.showCandidates);
                }
                this.clearRegion();
                return true;
            }
            return false;
        }
        if (!Options.getInstance().isSingleClickMode() && !this.cellSelection.contains(Sudoku2.getIndex(dto.row, dto.col)) || Options.getInstance().isSingleClickMode()) {
            this.setActiveCell(dto.row, dto.col);
            this.clearRegion();
        }
        if (Options.getInstance().isSingleClickMode()) {
            if (this.sudoku.getValue(index) == 0) {
                if (this.cellSelection.isEmpty()) {
                    int showHintCellValue = this.getShowHintCellValue();
                    if (this.sudoku.getAnzCandidates(index, !this.showCandidates) == 1) {
                        int actCand = this.sudoku.getAllCandidates(index, !this.showCandidates)[0];
                        this.setCell(dto.row, dto.col, actCand);
                        return true;
                    }
                    if (showHintCellValue != 0 && this.isHiddenSingle(showHintCellValue, dto.row, dto.col)) {
                        this.setCell(dto.row, dto.col, showHintCellValue);
                        return true;
                    }
                    if (dto.candidate != -1) {
                        if (this.sudoku.isCandidate(index, dto.candidate, !this.showCandidates)) {
                            this.setCell(dto.row, dto.col, dto.candidate);
                        }
                        return true;
                    }
                } else if (dto.candidate == -1 || !this.sudoku.isCandidate(index, dto.candidate, !this.showCandidates)) {
                    this.setActiveCell(dto.row, dto.col);
                    this.clearRegion();
                } else if (dto.candidate != -1) {
                    ArrayList<Integer> cells = new ArrayList<Integer>();
                    for (int selIndex : this.cellSelection) {
                        if (this.sudoku.getValue(selIndex) != 0 || !this.sudoku.isCandidate(selIndex, dto.candidate, !this.showCandidates)) continue;
                        cells.add(selIndex);
                    }
                    for (int cellIndex : cells) {
                        this.setCell(Sudoku2.getRow(cellIndex), Sudoku2.getCol(cellIndex), dto.candidate);
                    }
                }
            } else {
                this.setActiveCell(dto.row, dto.col);
                this.clearRegion();
            }
            return true;
        }
        return false;
    }

    boolean onDoubleLeftClick(MouseClickDTO dto, int index) {
        if (dto.ctrlPressed) {
            if (dto.candidate != -1) {
                if (this.sudoku.isCandidate(index, dto.candidate, !this.showCandidates)) {
                    this.sudoku.setCandidate(index, dto.candidate, false, !this.showCandidates);
                } else {
                    this.sudoku.setCandidate(index, dto.candidate, true, !this.showCandidates);
                }
                this.clearRegion();
                return true;
            }
        } else if (this.sudoku.getValue(index) == 0) {
            int showHintCellValue = this.getShowHintCellValue();
            if (this.sudoku.getAnzCandidates(index, !this.showCandidates) == 1) {
                int actCand = this.sudoku.getAllCandidates(index, !this.showCandidates)[0];
                this.setCell(dto.row, dto.col, actCand);
                this.setCandidateFilterByGiven(dto.row, dto.col);
                return true;
            }
            if (showHintCellValue != 0 && this.isHiddenSingle(showHintCellValue, dto.row, dto.col)) {
                this.setCell(dto.row, dto.col, showHintCellValue);
                this.setCandidateFilterByGiven(dto.row, dto.col);
                return true;
            }
            if (dto.candidate != -1) {
                if (this.sudoku.isCandidate(index, dto.candidate, !this.showCandidates)) {
                    this.setCell(dto.row, dto.col, dto.candidate);
                    this.setCandidateFilterByGiven(dto.row, dto.col);
                }
                return true;
            }
        } else if (!this.sudoku.isFixed(index)) {
            this.setCell(dto.row, dto.col, 0);
            this.setCandidateFilterByGiven(dto.row, dto.col);
            return true;
        }
        return false;
    }

    void setCandidateFilterByGiven(int row, int col) {
        if (Options.getInstance().isAutoHighlighting()) {
            int value = this.sudoku.getValue(row, col);
            if (value != 0) {
                this.setShowHintCellValue(value);
                this.setShowInvalidOrPossibleCells(true);
                this.showHintCellValues[value] = true;
                this.lastHighlightedDigit = value;
            } else {
                this.resetShowHintCellValues();
                this.setShowInvalidOrPossibleCells(false);
                this.lastHighlightedDigit = 0;
                this.mainFrame.repaint();
            }
        }
    }

    boolean onLeftClick(MouseClickDTO dto) {
        boolean change = false;
        int index = Sudoku2.getIndex(dto.row, dto.col);
        change = dto.isDoubleClick ? this.onDoubleLeftClick(dto, index) : this.onSingleLeftClick(dto, index);
        return change;
    }

    void onColoring(MouseClickDTO dto) {
        if (this.cellZoomPanel.isColoringCells()) {
            if (dto.isCellClicked) {
                this.handleColoring(dto.row, dto.col, -1, this.cellZoomPanel.getPrimaryColor());
            }
        } else if (this.cellZoomPanel.isColoringCandidates() && dto.candidate != -1 && dto.isCandidateClicked) {
            this.handleColoring(dto.row, dto.col, dto.candidate, this.cellZoomPanel.getPrimaryColor());
        }
    }

    private void handleMouseClicked(MouseEvent evt, boolean isDoubleClick) {
        MouseClickDTO dto = new MouseClickDTO(evt, this, isDoubleClick);
        boolean changed = false;
        this.undoStack.push(this.sudoku.clone());
        if (dto.isValidCellIndex) {
            if (dto.isRightClick) {
                changed = this.onRightClick(dto);
            } else if (this.cellZoomPanel.isColoring()) {
                this.onColoring(dto);
            } else if (dto.isLeftClick) {
                changed = this.onLeftClick(dto);
            }
            if (changed) {
                this.redoStack.clear();
                this.checkProgress();
            } else {
                this.undoStack.pop();
            }
            this.updateCellZoomPanel();
            this.mainFrame.check();
            this.repaint();
        }
    }

    public void saveState() {
        this.undoStack.push(this.sudoku.clone());
        this.mainFrame.check();
        this.repaint();
    }

    public void pushUndo() {
        this.undoStack.push(this.sudoku.clone());
    }

    public void popUndo() {
        this.undoStack.pop();
    }

    public void clearRedoStack() {
        this.redoStack.clear();
    }

    public ArrayList<Integer> getSelectedCells() {
        return this.cellSelection;
    }

    public void getState(GuiState state, boolean copy) {
        state.setChainIndex(this.chainIndex);
        state.setUndoStack((Stack)this.undoStack.clone());
        state.setRedoStack((Stack)this.redoStack.clone());
        state.setColoringMap((SortedMap)((TreeMap)this.coloringMap).clone());
        state.setColoringCandidateMap((SortedMap)((TreeMap)this.coloringCandidateMap).clone());
        state.setSudoku(this.sudoku);
        state.setStep(this.step);
        if (copy) {
            state.setSudoku(this.sudoku.clone());
            if (this.step != null) {
                state.setStep((SolutionStep)this.step.clone());
            }
        }
    }

    public void setState(GuiState state) {
        this.chainIndex = state.getChainIndex();
        if (state.getUndoStack() != null) {
            this.undoStack = state.getUndoStack();
        } else {
            this.undoStack.clear();
        }
        if (state.getRedoStack() != null) {
            this.redoStack = state.getRedoStack();
        } else {
            this.redoStack.clear();
        }
        if (state.getColoringMap() != null) {
            this.coloringMap = state.getColoringMap();
        } else {
            this.coloringMap.clear();
        }
        if (state.getColoringCandidateMap() != null) {
            this.coloringCandidateMap = state.getColoringCandidateMap();
        } else {
            this.coloringCandidateMap.clear();
        }
        this.sudoku = state.getSudoku();
        this.sudoku.checkSudoku();
        this.step = state.getStep();
        this.updateCellZoomPanel();
        this.checkProgress();
        this.mainFrame.check();
        this.repaint();
    }

    private void checkShowAllCandidates(int modifiers, int keyCode) {
        boolean oldShowAllCandidatesAkt = this.showAllCandidatesAkt;
        this.showAllCandidatesAkt = false;
        if ((modifiers & 0x40) != 0 && (modifiers & 0x80) != 0) {
            this.showAllCandidatesAkt = true;
        }
        boolean oldShowAllCandidates = this.showAllCandidates;
        this.showAllCandidates = false;
        if ((modifiers & 0x40) != 0 && (modifiers & 0x200) != 0) {
            this.showAllCandidates = true;
        }
        if (oldShowAllCandidatesAkt != this.showAllCandidatesAkt || oldShowAllCandidates != this.showAllCandidates) {
            this.repaint();
        }
    }

    public void handleKeysReleased(KeyEvent evt) {
        int modifiers = evt.getModifiersEx();
        int keyCode = 0;
        if (evt.getKeyCode() == 17) {
            this.isCtrlDown = false;
            this.clearLastCandidateMouseOn();
            this.repaint();
        }
        this.checkShowAllCandidates(modifiers, keyCode);
        if (this.cellZoomPanel.isColoring() && this.getCursor() == this.colorCursorShift) {
            this.setCursor(this.colorCursor);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void handleKeys(KeyEvent evt) {
        changed = false;
        this.undoStack.push(this.sudoku.clone());
        keyCode = evt.getKeyCode();
        modifiers = evt.getModifiersEx();
        this.checkShowAllCandidates(modifiers, keyCode);
        if (!this.isCtrlDown && evt.getKeyCode() == 17) {
            this.isCtrlDown = true;
            this.updateCandidateMouseHighlight(this.lastMousePosition);
        }
        if (this.cellZoomPanel.isColoring() && (modifiers & 64) != 0 && this.getCursor() == this.colorCursor) {
            this.setCursor(this.colorCursorShift);
        }
        if (Character.isDigit(keyChar = evt.getKeyChar())) {
            keyCode = SudokuPanel.KEY_CODES[keyChar - 48];
        }
        number = 0;
        clearSelectedRegion = true;
        switch (keyCode) {
            case 40: {
                if ((modifiers & 128) != 0 && (modifiers & 64) != 0 && this.getShowHintCellValue() != 0) {
                    index = this.findNextHintCandidate(this.getFirstRow(), this.getFirstCol(), keyCode);
                    this.setActiveCell(Sudoku2.getRow(index), Sudoku2.getCol(index));
                } else if (this.getActiveRow() < 8) {
                    this.setActiveCell(this.getActiveRow() + 1, this.getActiveCol());
                    if ((modifiers & 128) != 0) {
                        while (this.getActiveRow() < 8 && this.sudoku.getValue(this.getActiveRow(), this.getActiveCol()) != 0) {
                            this.setActiveCell(this.getActiveRow() + 1, this.getActiveCol());
                        }
                    } else if ((modifiers & 64) != 0) {
                        this.setShift();
                        this.selectRegion(this.shiftRow, this.shiftCol);
                        clearSelectedRegion = false;
                    }
                } else if (this.getActiveRow() == 8) {
                    this.setActiveCell(0, this.getActiveCol());
                }
                if (!clearSelectedRegion) break;
                this.clearRegion();
                break;
            }
            case 38: {
                if ((modifiers & 128) != 0 && (modifiers & 64) != 0 && this.getShowHintCellValue() != 0) {
                    index = this.findNextHintCandidate(this.getFirstRow(), this.getFirstCol(), keyCode);
                    this.setActiveCell(Sudoku2.getRow(index), Sudoku2.getCol(index));
                } else if (this.getActiveRow() > 0) {
                    this.setActiveCell(this.getActiveRow() - 1, this.getActiveCol());
                    if ((modifiers & 128) != 0) {
                        while (this.getActiveRow() > 0 && this.sudoku.getValue(this.getActiveRow(), this.getActiveCol()) != 0) {
                            this.setActiveCell(this.getActiveRow() - 1, this.getActiveCol());
                        }
                    } else if ((modifiers & 64) != 0) {
                        this.setShift();
                        this.selectRegion(this.shiftRow, this.shiftCol);
                        clearSelectedRegion = false;
                    }
                } else if (this.getActiveRow() == 0) {
                    this.setActiveCell(8, this.getActiveCol());
                }
                if (!clearSelectedRegion) break;
                this.clearRegion();
                break;
            }
            case 39: {
                if ((modifiers & 128) != 0 && (modifiers & 64) != 0 && this.getShowHintCellValue() != 0) {
                    index = this.findNextHintCandidate(this.getFirstRow(), this.getFirstCol(), keyCode);
                    this.setActiveCell(Sudoku2.getRow(index), Sudoku2.getCol(index));
                } else if (this.getActiveCol() < 8) {
                    this.setActiveCell(this.getActiveRow(), this.getActiveCol() + 1);
                    if ((modifiers & 128) != 0) {
                        while (this.getActiveCol() < 8 && this.sudoku.getValue(this.getActiveRow(), this.getActiveCol()) != 0) {
                            this.setActiveCell(this.getActiveRow(), this.getActiveCol() + 1);
                        }
                    } else if ((modifiers & 64) != 0) {
                        this.setShift();
                        this.selectRegion(this.shiftRow, this.shiftCol);
                        clearSelectedRegion = false;
                    }
                } else if (this.getActiveCol() == 8) {
                    this.setActiveCell(this.getActiveRow(), 0);
                }
                if (!clearSelectedRegion) break;
                this.clearRegion();
                break;
            }
            case 37: {
                if ((modifiers & 128) != 0 && (modifiers & 64) != 0 && this.getShowHintCellValue() != 0) {
                    index = this.findNextHintCandidate(this.getFirstRow(), this.getFirstCol(), keyCode);
                    this.setActiveCell(Sudoku2.getRow(index), Sudoku2.getCol(index));
                } else if (this.getActiveCol() > 0) {
                    this.setActiveCell(this.getActiveRow(), this.getActiveCol() - 1);
                    if ((modifiers & 128) != 0) {
                        while (this.getActiveCol() > 0 && this.sudoku.getValue(this.getActiveRow(), this.getActiveCol()) != 0) {
                            this.setActiveCell(this.getActiveRow(), this.getActiveCol() - 1);
                        }
                    } else if ((modifiers & 64) != 0) {
                        this.setShift();
                        this.selectRegion(this.shiftRow, this.shiftCol);
                        clearSelectedRegion = false;
                    }
                } else if (this.getActiveCol() == 0) {
                    this.setActiveCell(this.getActiveRow(), 8);
                }
                if (!clearSelectedRegion) break;
                this.clearRegion();
                break;
            }
            case 36: {
                if ((modifiers & 64) != 0) {
                    this.setShift();
                    if ((modifiers & 128) != 0) {
                        this.shiftRow = 0;
                    } else {
                        this.shiftCol = 0;
                    }
                    this.selectRegion(this.shiftRow, this.shiftCol);
                    clearSelectedRegion = false;
                } else if ((modifiers & 128) != 0) {
                    this.setActiveCell(0, this.getActiveCol());
                } else {
                    this.setActiveCell(this.getActiveRow(), 0);
                }
                if (!clearSelectedRegion) break;
                this.clearRegion();
                break;
            }
            case 35: {
                if ((modifiers & 64) != 0) {
                    this.setShift();
                    if ((modifiers & 128) != 0) {
                        this.shiftRow = 8;
                    } else {
                        this.shiftCol = 8;
                    }
                    this.selectRegion(this.shiftRow, this.shiftCol);
                    clearSelectedRegion = false;
                } else if ((modifiers & 128) != 0) {
                    this.setActiveCell(8, this.getActiveCol());
                } else {
                    this.setActiveCell(this.getActiveRow(), 8);
                }
                if (!clearSelectedRegion) break;
                this.clearRegion();
                break;
            }
            case 10: {
                index = Sudoku2.getIndex(this.getActiveRow(), this.getActiveCol());
                if (this.sudoku.getValue(index) != 0) break;
                showHintCellValue = this.getShowHintCellValue();
                if (this.sudoku.getAnzCandidates(index, this.showCandidates == false) == 1) {
                    actCand = this.sudoku.getAllCandidates(index, this.showCandidates == false)[0];
                    this.setCell(this.getActiveRow(), this.getActiveCol(), actCand);
                    changed = true;
                    break;
                }
                if (showHintCellValue == 0 || !this.isHiddenSingle(showHintCellValue, this.getActiveRow(), this.getActiveCol())) break;
                this.setCell(this.getActiveRow(), this.getActiveCol(), showHintCellValue);
                changed = true;
                break;
            }
            case 57: 
            case 105: {
                ++number;
            }
            case 56: 
            case 104: {
                ++number;
            }
            case 55: 
            case 103: {
                ++number;
            }
            case 54: 
            case 102: {
                ++number;
            }
            case 53: 
            case 101: {
                ++number;
            }
            case 52: 
            case 100: {
                ++number;
            }
            case 51: 
            case 99: {
                ++number;
            }
            case 50: 
            case 98: {
                ++number;
            }
            case 49: 
            case 97: {
                ++number;
                if ((modifiers & 128) != 0) ** GOTO lbl197
                if (!this.cellSelection.isEmpty()) ** GOTO lbl181
                this.setCell(this.getActiveRow(), this.getActiveCol(), number);
                this.setCandidateFilterByGiven(this.getActiveRow(), this.getActiveCol());
                if (!this.mainFrame.isInputMode() || !Options.getInstance().isEditModeAutoAdvance()) ** GOTO lbl195
                if (this.getActiveCol() >= 8) ** GOTO lbl178
                this.setActiveCell(this.getActiveRow(), this.getActiveCol() + 1);
                ** GOTO lbl195
lbl178:
                // 1 sources

                if (this.getActiveRow() >= 8) ** GOTO lbl195
                this.setActiveCell(this.getActiveRow() + 1, 0);
                ** GOTO lbl195
lbl181:
                // 1 sources

                cells = new ArrayList<Integer>(this.cellSelection);
                activeIndex = new Integer(Sudoku2.getIndex(this.getActiveRow(), this.getActiveCol()));
                if (!cells.contains(activeIndex)) {
                    cells.add(activeIndex);
                }
                if (cells.size() == 1) {
                    this.setCell(this.getActiveRow(), this.getActiveCol(), number);
                    this.setCandidateFilterByGiven(this.getActiveRow(), this.getActiveCol());
                } else {
                    var11_21 = cells.iterator();
                    while (var11_21.hasNext()) {
                        index = (Integer)var11_21.next();
                        this.setCell(Sudoku2.getRow(index), Sudoku2.getCol(index), number);
                    }
                }
lbl195:
                // 6 sources

                changed = true;
                break;
lbl197:
                // 1 sources

                if (this.cellSelection.isEmpty()) {
                    this.toggleCandidateInCell(this.getActiveRow(), this.getActiveCol(), number);
                    changed = true;
                    break;
                }
                changed = this.toggleCandidateInAktCells(number);
                break;
            }
            case 8: 
            case 48: 
            case 96: 
            case 127: {
                if ((modifiers & 128) != 0) break;
                if (this.sudoku.getValue(this.getActiveRow(), this.getActiveCol()) != 0 && !this.sudoku.isFixed(this.getActiveRow(), this.getActiveCol())) {
                    this.sudoku.setCell(this.getActiveRow(), this.getActiveCol(), 0);
                    this.setCandidateFilterByGiven(this.getActiveRow(), this.getActiveCol());
                    changed = true;
                }
                if (!this.mainFrame.isInputMode() || !Options.getInstance().isEditModeAutoAdvance()) break;
                if (this.getActiveCol() < 8) {
                    this.setActiveCell(this.getActiveRow(), this.getActiveCol() + 1);
                    break;
                }
                if (this.getActiveRow() >= 8) break;
                this.setActiveCell(this.getActiveRow() + 1, 0);
                break;
            }
            case 121: {
                if ((modifiers & 512) != 0) break;
                if (this.showHintCellValues[10]) {
                    this.showHintCellValues[10] = false;
                    this.resetShowHintCellValues();
                    break;
                }
                this.showHintCellValues[10] = true;
                this.resetShowHintCellValues();
                this.setShowHintCellValue(10);
                this.checkIsShowInvalidOrPossibleCells();
                break;
            }
            case 120: {
                ++number;
            }
            case 119: {
                ++number;
            }
            case 118: {
                ++number;
            }
            case 117: {
                ++number;
            }
            case 116: {
                ++number;
            }
            case 115: {
                ++number;
            }
            case 114: {
                ++number;
            }
            case 113: {
                ++number;
            }
            case 112: {
                ++number;
                if ((modifiers & 512) != 0) break;
                if ((modifiers & 128) != 0) {
                    this.showHintCellValues[number] = this.showHintCellValues[number] == false;
                    this.showHintCellValues[10] = false;
                } else {
                    if ((modifiers & 64) != 0) {
                        this.invalidCells = this.invalidCells == false;
                    }
                    this.setShowHintCellValue(number);
                }
                this.checkIsShowInvalidOrPossibleCells();
                break;
            }
            case 32: {
                candidate = this.getShowHintCellValue();
                if (!this.isShowInvalidOrPossibleCells() || candidate == 0) break;
                changed = this.toggleCandidateInAktCells(candidate);
                break;
            }
            case 88: {
                this.cellZoomPanel.swapColors();
                break;
            }
            case 69: {
                ++number;
            }
            case 68: {
                ++number;
            }
            case 67: {
                ++number;
            }
            case 66: {
                ++number;
            }
            case 65: {
                if ((modifiers & 512) != 0 || (modifiers & 8192) != 0 || (modifiers & 128) != 0 || (modifiers & 256) != 0) break;
                number *= 2;
                if ((modifiers & 64) != 0) {
                    ++number;
                }
                this.handleColoring(-1, Options.getInstance().getColoringColors()[number]);
                break;
            }
            case 82: {
                this.clearColoring();
                break;
            }
            default: {
                rem = this.sudoku.getRemainingCandidates();
                ch = evt.getKeyChar();
                if (ch != '<' && ch != '>' && ch != ',' && ch != '.') break;
                v0 = isUp = ch == '>' || ch == '.';
                if (!this.isShowInvalidOrPossibleCells()) break;
                cand = 0;
                i = 1;
                while (i < this.showHintCellValues.length - 1) {
                    if (this.showHintCellValues[i]) {
                        cand = i;
                        if (!isUp) break;
                    }
                    ++i;
                }
                count = 0;
                do {
                    if (isUp) {
                        if (++cand <= 9) continue;
                        cand = 1;
                        continue;
                    }
                    if (--cand >= 1) continue;
                    cand = 9;
                } while (++count < 8 && (Sudoku2.MASKS[cand] & rem) == 0);
                if (count >= 8) break;
                this.setShowHintCellValue(cand);
                this.checkIsShowInvalidOrPossibleCells();
            }
        }
        if (changed) {
            this.redoStack.clear();
            this.checkProgress();
        } else {
            this.undoStack.pop();
        }
        this.updateCellZoomPanel();
        this.mainFrame.check();
        this.repaint();
    }

    private void clearRegion() {
        this.clearSelection();
        this.shiftRow = -1;
        this.shiftCol = -1;
        Integer index = Sudoku2.getIndex(this.getActiveRow(), this.getActiveCol());
        if (!this.cellSelection.contains(index)) {
            this.setActiveCell(index);
        }
    }

    private void selectRegion(int row, int col) {
        Integer startIndex = Sudoku2.getIndex(this.getFirstRow(), this.getFirstCol());
        Integer endIndex = Sudoku2.getIndex(this.getActiveRow(), this.getActiveCol());
        if (row != this.getActiveRow() || col != this.getActiveCol()) {
            int cStart = col < this.getActiveCol() ? col : this.getActiveCol();
            int rStart = row < this.getActiveRow() ? row : this.getActiveRow();
            int cEnd = cStart + Math.abs(col - this.getActiveCol());
            int rEnd = rStart + Math.abs(row - this.getActiveRow());
            this.cellSelection.clear();
            this.cellSelection.add(startIndex);
            int c = cStart;
            while (c <= cEnd) {
                int r = rStart;
                while (r <= rEnd) {
                    Integer cv = Sudoku2.getIndex(r, c);
                    if (!this.cellSelection.contains(cv)) {
                        this.cellSelection.add(cv);
                    }
                    ++r;
                }
                ++c;
            }
            this.setActiveCell(endIndex);
        }
    }

    private void setShift() {
        if (this.shiftRow == -1) {
            this.shiftRow = this.getFirstRow();
            this.shiftCol = this.getFirstCol();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int findNextHintCandidate(int row, int col, int mode) {
        int index = Sudoku2.getIndex(row, col);
        int showHintCellValue = this.getShowHintCellValue();
        if (showHintCellValue == 0) {
            return index;
        }
        switch (mode) {
            case 40: {
                if (++row == 9) {
                    row = 0;
                    if (++col == 9) {
                        return index;
                    }
                }
                int i = col;
                block6: while (true) {
                    int j;
                    if (i >= 9) {
                        return index;
                    }
                    int n = j = i == col ? row : 0;
                    while (true) {
                        if (j >= 9) {
                            ++i;
                            continue block6;
                        }
                        if (this.sudoku.getValue(j, i) == 0 && this.sudoku.isCandidate(j, i, showHintCellValue, !this.showCandidates)) {
                            return Sudoku2.getIndex(j, i);
                        }
                        ++j;
                    }
                    break;
                }
            }
            case 38: {
                if (--row < 0) {
                    row = 8;
                    if (--col < 0) {
                        return index;
                    }
                }
                int i = col;
                block8: while (true) {
                    int j;
                    if (i < 0) {
                        return index;
                    }
                    int n = j = i == col ? row : 8;
                    while (true) {
                        if (j < 0) {
                            --i;
                            continue block8;
                        }
                        if (this.sudoku.getValue(j, i) == 0 && this.sudoku.isCandidate(j, i, showHintCellValue, !this.showCandidates)) {
                            return Sudoku2.getIndex(j, i);
                        }
                        --j;
                    }
                    break;
                }
            }
            case 37: {
                if (--index < 0) {
                    return index + 1;
                }
                while (true) {
                    if (index < 0) {
                        if (index >= 0) return index;
                        return Sudoku2.getIndex(row, col);
                    }
                    if (this.sudoku.getValue(index) == 0 && this.sudoku.isCandidate(index, showHintCellValue, !this.showCandidates)) {
                        return index;
                    }
                    --index;
                }
            }
            case 39: {
                if (++index >= this.sudoku.getCells().length) {
                    return index - 1;
                }
                while (true) {
                    if (index >= this.sudoku.getCells().length) {
                        if (index < this.sudoku.getCells().length) return index;
                        return Sudoku2.getIndex(row, col);
                    }
                    if (this.sudoku.getValue(index) == 0 && this.sudoku.isCandidate(index, showHintCellValue, !this.showCandidates)) {
                        return index;
                    }
                    ++index;
                }
            }
        }
        return index;
    }

    public void clearCandidateColors() {
        this.coloringCandidateMap.clear();
        this.coloringCandidateMap.clear();
        this.updateCellZoomPanel();
        this.mainFrame.check();
    }

    public void clearCellColors() {
        this.coloringMap.clear();
        this.coloringMap.clear();
        this.updateCellZoomPanel();
        this.mainFrame.check();
    }

    public void clearColoring() {
        this.coloringMap.clear();
        this.coloringCandidateMap.clear();
        this.updateCellZoomPanel();
        this.mainFrame.check();
    }

    public void handleColoring(int candidate, Color color) {
        if (this.cellSelection.isEmpty()) {
            this.handleColoring(this.getActiveRow(), this.getActiveCol(), candidate, color);
        } else {
            for (int index : this.cellSelection) {
                this.handleColoring(Sudoku2.getRow(index), Sudoku2.getCol(index), candidate, color);
            }
        }
    }

    public Color getActiveColor() {
        if (this.cellZoomPanel.isDefaultMouse()) {
            return null;
        }
        return this.cellZoomPanel.getPrimaryColor();
    }

    public void handleColoring(int candidate) {
        this.handleColoring(this.getActiveRow(), this.getActiveCol(), candidate, this.cellZoomPanel.getPrimaryColor());
        this.updateCellZoomPanel();
        this.mainFrame.fixFocus();
        this.repaint();
    }

    public void handleColoring(int row, int col, int candidate, Color color) {
        if (!Options.getInstance().isColorValues() && this.sudoku.getValue(row, col) != 0) {
            return;
        }
        SortedMap<Integer, Color> map = this.coloringMap;
        int key = Sudoku2.getIndex(row, col);
        if (candidate != -1) {
            key = key * 10 + candidate;
            map = this.coloringCandidateMap;
        }
        if (map.containsKey(key) && map.get(key) == color) {
            map.remove(key);
        } else {
            map.put(key, color);
        }
        this.updateCellZoomPanel();
    }

    public void setCellFromCellZoomPanel(int number) {
        this.undoStack.push(this.sudoku.clone());
        if (this.cellSelection.isEmpty()) {
            this.setCell(this.getActiveRow(), this.getActiveCol(), number);
        } else {
            for (int index : this.cellSelection) {
                this.setCell(Sudoku2.getRow(index), Sudoku2.getCol(index), number);
            }
        }
        this.updateCellZoomPanel();
        this.mainFrame.check();
        this.repaint();
    }

    public void setCell(int row, int col, int number) {
        int index = Sudoku2.getIndex(row, col);
        if (!this.sudoku.isFixed(index) && this.sudoku.getValue(index) != number) {
            if (this.sudoku.getValue(index) != 0) {
                this.sudoku.setCell(row, col, 0);
            }
            this.sudoku.setCell(row, col, number);
            this.repaint();
            if (this.sudoku.isSolved() && Options.getInstance().isShowSudokuSolved()) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("intl/MainFrame").getString("MainFrame.sudoku_solved"), ResourceBundle.getBundle("intl/MainFrame").getString("MainFrame.congratulations"), 1);
            }
        }
    }

    private boolean toggleCandidateInAktCells(int candidate) {
        boolean changed = false;
        if (this.cellSelection.isEmpty()) {
            this.toggleCandidateInCell(this.getActiveRow(), this.getActiveCol(), candidate);
            return true;
        }
        boolean candPresent = false;
        for (int index : this.cellSelection) {
            if (this.sudoku.getValue(index) != 0 || !this.sudoku.isCandidate(index, candidate, !this.showCandidates)) continue;
            candPresent = true;
            break;
        }
        for (int index : this.cellSelection) {
            if (candPresent) {
                if (this.sudoku.getValue(index) != 0 || !this.sudoku.isCandidate(index, candidate, !this.showCandidates)) continue;
                this.sudoku.setCandidate(index, candidate, false, !this.showCandidates);
                changed = true;
                continue;
            }
            if (this.sudoku.getValue(index) != 0 || this.sudoku.isCandidate(index, candidate, !this.showCandidates)) continue;
            this.sudoku.setCandidate(index, candidate, true, !this.showCandidates);
            changed = true;
        }
        this.updateCellZoomPanel();
        return changed;
    }

    private void toggleCandidateInCell(int row, int col, int candidate) {
        int index = Sudoku2.getIndex(row, col);
        if (this.sudoku.getValue(index) == 0) {
            if (this.sudoku.isCandidate(index, candidate, !this.showCandidates)) {
                this.sudoku.setCandidate(index, candidate, false, !this.showCandidates);
            } else {
                this.sudoku.setCandidate(index, candidate, true, !this.showCandidates);
            }
        }
        this.updateCellZoomPanel();
    }

    public BufferedImage getSudokuImage(int size) {
        return this.getSudokuImage(size, false);
    }

    public BufferedImage getSudokuImage(int size, boolean allBlack) {
        Graphics2D g;
        BufferedImage fileImage = new BufferedImage(size, size, 5);
        this.g2 = g = fileImage.createGraphics();
        this.g2.setColor(Color.WHITE);
        this.g2.fillRect(0, 0, size, size);
        this.drawPage(size, size, true, false, allBlack, 1.0);
        return fileImage;
    }

    public void printSudoku(Graphics2D g, int x, int y, int size, boolean allBlack, double scale) {
        Graphics2D oldG2 = this.g2;
        this.g2 = g;
        AffineTransform trans = g.getTransform();
        g.translate(x, y);
        this.g2.setColor(Color.WHITE);
        this.g2.fillRect(0, 0, size, size);
        this.drawPage(size, size, true, true, allBlack, scale);
        g.setTransform(trans);
        this.g2 = oldG2;
    }

    public void saveSudokuAsPNG(File file, int size, int dpi) {
        BufferedImage fileImage = this.getSudokuImage(size);
        this.writePNG(fileImage, dpi, file);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D printG2 = (Graphics2D)graphics;
        double scale = SudokuUtil.adjustGraphicsForPrinting(printG2);
        printG2.translate((int)(pageFormat.getImageableX() * scale), (int)(pageFormat.getImageableY() * scale));
        int printWidth = (int)(pageFormat.getImageableWidth() * scale);
        int printHeight = (int)(pageFormat.getImageableHeight() * scale);
        Font tmpFont = Options.getInstance().getBigFont();
        this.bigFont = new Font(tmpFont.getName(), tmpFont.getStyle(), (int)((double)tmpFont.getSize() * scale));
        tmpFont = Options.getInstance().getSmallFont();
        this.smallFont = new Font(tmpFont.getName(), tmpFont.getStyle(), (int)((double)tmpFont.getSize() * scale));
        printG2.setFont(this.bigFont);
        String title = "Hodoku - v2.3.1";
        FontMetrics metrics = printG2.getFontMetrics();
        int textWidth = metrics.stringWidth(title);
        int textHeight = metrics.getHeight();
        int y = 2 * textHeight;
        printG2.drawString(title, (printWidth - textWidth) / 2, textHeight);
        printG2.setFont(this.smallFont);
        if (this.sudoku != null && this.sudoku.getLevel() != null) {
            title = String.valueOf(this.sudoku.getLevel().getName()) + " (" + this.sudoku.getScore() + ")";
            metrics = printG2.getFontMetrics();
            textWidth = metrics.stringWidth(title);
            textHeight = metrics.getHeight();
            printG2.drawString(title, (printWidth - textWidth) / 2, y);
            y += textHeight;
        }
        printG2.translate(0, y);
        this.g2 = printG2;
        this.drawPage(printWidth, printHeight, true, true, false, scale);
        return 0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.g2 = (Graphics2D)g;
        this.drawPage(this.getBounds().width, this.getBounds().height, false, true, false, 1.0);
    }

    private void drawPage(int totalWidth, int totalHeight, boolean isPrint, boolean withBorder, boolean allBlack, double scale) {
        FontMetrics cm;
        int oldCandidateHeight;
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.lastCursorChanged == -1L) {
            this.lastCursorChanged = System.currentTimeMillis();
        }
        this.gridRegion = this.calculateGridRegion(new Rectangle(0, 0, totalWidth, totalHeight), isPrint, withBorder);
        int colorKuCellSize = (int)((double)this.cellSize * 0.9);
        Font tmpFont = Options.getInstance().getDefaultValueFont();
        if (!(this.valueFont == null || this.valueFont.getName().equals(tmpFont.getName()) && this.valueFont.getStyle() == tmpFont.getStyle() && this.valueFont.getSize() == (int)((double)this.cellSize * Options.getInstance().getValueFontFactor()))) {
            this.valueFont = new Font(tmpFont.getName(), tmpFont.getStyle(), (int)((double)this.cellSize * Options.getInstance().getValueFontFactor()));
        }
        tmpFont = Options.getInstance().getDefaultCandidateFont();
        if (!(this.candidateFont == null || this.candidateFont.getName().equals(tmpFont.getName()) && this.candidateFont.getStyle() == tmpFont.getStyle() && this.candidateFont.getSize() == (int)((double)this.cellSize * Options.getInstance().getCandidateFontFactor()))) {
            oldCandidateHeight = this.candidateHeight;
            this.candidateFont = new Font(tmpFont.getName(), tmpFont.getStyle(), (int)((double)this.cellSize * Options.getInstance().getCandidateFontFactor()));
            cm = this.getFontMetrics(this.candidateFont);
            this.candidateHeight = (int)((double)(cm.getAscent() - cm.getDescent()) * 1.3);
            if (this.candidateHeight != oldCandidateHeight) {
                this.resetColorKuImages();
            }
        }
        if (this.oldWidth != this.gridRegion.width) {
            oldCandidateHeight = this.candidateHeight;
            this.oldWidth = this.gridRegion.width;
            this.valueFont = new Font(Options.getInstance().getDefaultValueFont().getName(), Options.getInstance().getDefaultValueFont().getStyle(), (int)((double)this.cellSize * Options.getInstance().getValueFontFactor()));
            this.candidateFont = new Font(Options.getInstance().getDefaultCandidateFont().getName(), Options.getInstance().getDefaultCandidateFont().getStyle(), (int)((double)this.cellSize * Options.getInstance().getCandidateFontFactor()));
            cm = this.getFontMetrics(this.candidateFont);
            this.candidateHeight = (int)((double)(cm.getAscent() - cm.getDescent()) * 1.3);
            if (this.candidateHeight != oldCandidateHeight) {
                this.resetColorKuImages();
            }
        }
        double dx = 0.0;
        double dy = 0.0;
        double dcx = 0.0;
        double dcy = 0.0;
        double ddy = 0.0;
        int row = 0;
        while (row < 9) {
            int col = 0;
            while (col < 9) {
                int ccy;
                int ccx;
                boolean isCellBivalue;
                boolean isSelected;
                this.g2.setColor(Options.getInstance().getDefaultCellColor());
                if (Sudoku2.getBlock(Sudoku2.getIndex(row, col)) % 2 != 0) {
                    this.g2.setColor(Options.getInstance().getAlternateCellColor());
                }
                int cellIndex = Sudoku2.getIndex(row, col);
                boolean bl = isSelected = row == this.getActiveRow() && col == this.getActiveCol() || this.cellSelection.contains(cellIndex);
                if (isSelected && this.cellSelection.size() == 1 && Options.getInstance().isDeleteCursorDisplay() && System.currentTimeMillis() - this.lastCursorChanged > (long)Options.getInstance().getDeleteCursorDisplayLength()) {
                    isSelected = false;
                }
                if (isSelected && !isPrint && !Options.getInstance().isOnlySmallCursors()) {
                    this.setColor(this.g2, allBlack, Options.getInstance().getAktCellColor());
                }
                boolean candidateValid = false;
                if (this.showInvalidOrPossibleCells && this.showCandidates) {
                    candidateValid = this.sudoku.areCandidatesValid(cellIndex, this.showHintCellValues, false);
                }
                boolean isHighlightingBivalue = this.showHintCellValues[10];
                boolean bl2 = isCellBivalue = this.sudoku.getAllCandidates(cellIndex).length == 2;
                if (this.isShowInvalidOrPossibleCells()) {
                    if (!this.isInvalidCells() || isHighlightingBivalue) {
                        if (this.sudoku.getValue(cellIndex) == 0 && candidateValid && !Options.getInstance().isOnlySmallFilters()) {
                            this.setColor(this.g2, allBlack, Options.getInstance().getPossibleCellColor());
                        } else if (Options.getInstance().isHighlightingGivens() && this.sudoku.getValue(cellIndex) != 0 && this.showHintCellValues[this.sudoku.getValue(cellIndex)]) {
                            this.setColor(this.g2, allBlack, Options.getInstance().getPossibleFixedCellColor());
                        }
                    }
                    if (this.isInvalidCells() && (this.sudoku.getValue(cellIndex) != 0 || this.showInvalidOrPossibleCells && !candidateValid)) {
                        this.setColor(this.g2, allBlack, Options.getInstance().getInvalidCellColor());
                    }
                }
                if (this.coloringMap.containsKey(cellIndex) && (this.sudoku.getValue(cellIndex) == 0 || Options.getInstance().isColorValues()) && this.isColoringVisible) {
                    this.setColor(this.g2, allBlack, (Color)this.coloringMap.get(cellIndex));
                }
                int cellX = this.getX(row, col);
                int cellY = this.getY(row, col);
                this.g2.fillRect(cellX, cellY, this.cellSize, this.cellSize);
                if (isSelected && !isPrint && this.g2.getColor() != Options.getInstance().getAktCellColor()) {
                    this.setColor(this.g2, allBlack, Options.getInstance().getAktCellColor());
                    int frameSize = (int)((double)this.cellSize * Options.getInstance().getCursorFrameSize());
                    if (row != this.getActiveRow() || col != this.getActiveCol()) {
                        frameSize = frameSize / 2 + 1;
                    }
                    this.g2.fillRect(cellX, cellY, this.cellSize, frameSize + 1);
                    this.g2.fillRect(cellX, cellY, frameSize + 1, this.cellSize);
                    this.g2.fillRect(cellX + this.cellSize - frameSize, cellY, frameSize, this.cellSize);
                    this.g2.fillRect(cellX, cellY + this.cellSize - frameSize, this.cellSize, frameSize);
                }
                if (this.showCandidateHighlight() && this.lastCandidateMouseOn != null && this.lastCandidateMouseOn.getIndex() >= 0 && this.lastCandidateMouseOn.getIndex() < 81) {
                    int cellColumn = this.lastCandidateMouseOn.getIndex() % 9;
                    int cellRow = this.lastCandidateMouseOn.getIndex() / 9;
                    if (row == cellRow && col == cellColumn && this.sudoku.getValue(this.lastCandidateMouseOn.getIndex()) == 0) {
                        int startX = this.getX(cellRow, cellColumn);
                        int startY = this.getY(cellRow, cellColumn);
                        double third = (double)this.cellSize / 3.0;
                        double shiftX = (double)((this.lastCandidateMouseOn.getValue() - 1) % 3) * third;
                        double shiftY = (double)((this.lastCandidateMouseOn.getValue() - 1) / 3) * third;
                        FontMetrics cm2 = this.getFontMetrics(this.candidateFont);
                        this.g2.setFont(this.candidateFont);
                        int candidate = this.lastCandidateMouseOn.getValue();
                        int cw = (int)(third - (double)this.g2.getFontMetrics().stringWidth(Integer.toString(candidate)));
                        int ch = (int)((double)(cm2.getAscent() - cm2.getDescent()) * 1.3);
                        ccx = (int)Math.round((double)startX + shiftX + third / 2.0 - (double)cw / 2.0);
                        ccy = (int)Math.round((double)startY + shiftY + third / 2.0 - (double)ch / 2.0);
                        dcx = (third - (double)this.g2.getFontMetrics().stringWidth("8")) / 2.0;
                        dcy = (third + (double)this.g2.getFontMetrics().getAscent() - (double)this.g2.getFontMetrics().getDescent()) / 2.0;
                        if (!this.sudoku.isCandidate(this.lastCandidateMouseOn.getIndex(), this.lastCandidateMouseOn.getValue())) {
                            this.g2.setColor(new Color(0.2f, 0.2f, 0.2f, 0.3f));
                            this.g2.drawString(Integer.toString(candidate), (int)Math.round((double)startX + dcx + shiftX), (int)Math.round((double)startY + dcy + shiftY));
                        }
                        this.g2.setColor(new Color(0.1f, 0.3f, 0.8f, 0.1f));
                        this.g2.fillRect(ccx, ccy, cw, ch);
                        this.g2.setColor(new Color(0.1f, 0.3f, 0.8f, 0.2f));
                        this.g2.drawRect(ccx, ccy, cw, ch);
                    }
                }
                int startX = this.getX(row, col);
                int startY = this.getY(row, col);
                Color offColor = null;
                int offCand = 0;
                if (this.sudoku.getValue(cellIndex) != 0) {
                    this.setColor(this.g2, allBlack, Options.getInstance().getCellValueColor());
                    if (this.sudoku.isFixed(cellIndex)) {
                        this.setColor(this.g2, allBlack, Options.getInstance().getCellFixedValueColor());
                    } else if (this.isShowWrongValues() && !this.sudoku.isValidValue(row, col, this.sudoku.getValue(cellIndex))) {
                        offColor = Options.getInstance().getColorKuColor(10);
                        offCand = 10;
                        this.setColor(this.g2, allBlack, Options.getInstance().getWrongValueColor());
                    } else if (this.isShowDeviations() && this.sudoku.isSolutionSet() && this.sudoku.getValue(cellIndex) != this.sudoku.getSolution(cellIndex)) {
                        offColor = Options.getInstance().getColorKuColor(11);
                        offCand = 11;
                        this.setColor(this.g2, allBlack, Options.getInstance().getDeviationColor());
                    }
                    this.g2.setFont(this.valueFont);
                    dx = (double)(this.cellSize - this.g2.getFontMetrics().stringWidth("8")) / 2.0;
                    dy = (double)(this.cellSize + this.g2.getFontMetrics().getAscent() - this.g2.getFontMetrics().getDescent()) / 2.0;
                    int value = this.sudoku.getValue(cellIndex);
                    if (Options.getInstance().isShowColorKuAct()) {
                        this.drawColorBox(value, this.g2, this.getX(row, col) + (this.cellSize - colorKuCellSize) / 2, this.getY(row, col) + (this.cellSize - colorKuCellSize) / 2, colorKuCellSize, true);
                        if (offColor != null) {
                            this.setColor(this.g2, allBlack, offColor);
                            this.g2.drawString("X", (int)((double)startX + dx), (int)((double)startY + dy));
                        }
                    } else {
                        this.g2.drawString(Integer.toString(value), (int)((double)startX + dx), (int)((double)startY + dy));
                    }
                } else {
                    boolean userCandidates;
                    this.g2.setFont(this.candidateFont);
                    boolean bl3 = userCandidates = !this.showCandidates;
                    if (this.showAllCandidates || this.showAllCandidatesAkt && row == this.getActiveRow() && col == this.getActiveCol()) {
                        userCandidates = false;
                    }
                    double third = (double)this.cellSize / 3.0;
                    dcx = (third - (double)this.g2.getFontMetrics().stringWidth("8")) / 2.0;
                    dcy = (third + (double)this.g2.getFontMetrics().getAscent() - (double)this.g2.getFontMetrics().getDescent()) / 2.0;
                    ddy = (double)(this.g2.getFontMetrics().getAscent() - this.g2.getFontMetrics().getDescent()) * Options.getInstance().getHintBackFactor();
                    int i = 1;
                    while (i <= 9) {
                        offColor = null;
                        if (this.sudoku.isCandidate(cellIndex, i, userCandidates) || this.showCandidates && this.showDeviations && this.sudoku.isSolutionSet() && i == this.sudoku.getSolution(cellIndex)) {
                            boolean isFilteringBivalueCandidates;
                            Color hintColor = null;
                            Color candColor = null;
                            candColor = Options.getInstance().getCandidateColor();
                            double shiftX = (double)((i - 1) % 3) * third;
                            double shiftY = (double)((i - 1) / 3) * third;
                            if (Options.getInstance().isShowColorKuAct()) {
                                ccx = (int)Math.round((double)startX + shiftX + third / 2.0 - (double)this.candidateHeight / 2.0);
                                ccy = (int)Math.round((double)startY + shiftY + third / 2.0 - (double)this.candidateHeight / 2.0);
                                this.drawColorBox(i, this.g2, ccx, ccy, this.candidateHeight, false);
                            }
                            if (this.step != null) {
                                int alsIndex;
                                int index = Sudoku2.getIndex(row, col);
                                if (this.step.getIndices().indexOf(index) >= 0 && this.step.getValues().indexOf(i) >= 0) {
                                    hintColor = Options.getInstance().getHintCandidateBackColor();
                                    candColor = Options.getInstance().getHintCandidateColor();
                                }
                                if ((alsIndex = this.step.getAlsIndex(index, this.chainIndex)) != -1 && (this.chainIndex == -1 && !this.step.getType().isKrakenFish() || this.alsToShow.contains(alsIndex))) {
                                    hintColor = Options.getInstance().getHintCandidateAlsBackColors()[alsIndex % Options.getInstance().getHintCandidateAlsBackColors().length];
                                    candColor = Options.getInstance().getHintCandidateAlsColors()[alsIndex % Options.getInstance().getHintCandidateAlsColors().length];
                                }
                                int k = 0;
                                while (k < this.step.getChains().size()) {
                                    if (!(this.step.getType().isKrakenFish() && this.chainIndex == -1 || this.chainIndex != -1 && k != this.chainIndex)) {
                                        Iterator<Candidate> chain = this.step.getChains().get(k);
                                        int j = ((Chain)((Object)chain)).getStart();
                                        while (j <= ((Chain)((Object)chain)).getEnd()) {
                                            if (((Chain)((Object)chain)).getChain()[j] != Integer.MIN_VALUE) {
                                                int chainEntry = Math.abs(((Chain)((Object)chain)).getChain()[j]);
                                                int index1 = -1;
                                                int index2 = -1;
                                                int index3 = -1;
                                                if (Chain.getSNodeType(chainEntry) == 0) {
                                                    index1 = Chain.getSCellIndex(chainEntry);
                                                }
                                                if (Chain.getSNodeType(chainEntry) == 1) {
                                                    index1 = Chain.getSCellIndex(chainEntry);
                                                    index2 = Chain.getSCellIndex2(chainEntry);
                                                    index3 = Chain.getSCellIndex3(chainEntry);
                                                }
                                                if ((index == index1 || index == index2 || index == index3) && Chain.getSCandidate(chainEntry) == i) {
                                                    if (Chain.isSStrong(chainEntry)) {
                                                        hintColor = Options.getInstance().getHintCandidateBackColor();
                                                        candColor = Options.getInstance().getHintCandidateColor();
                                                    } else {
                                                        hintColor = Options.getInstance().getHintCandidateFinBackColor();
                                                        candColor = Options.getInstance().getHintCandidateFinColor();
                                                    }
                                                }
                                            }
                                            ++j;
                                        }
                                    }
                                    ++k;
                                }
                                for (Candidate cand : this.step.getFins()) {
                                    if (cand.getIndex() != index || cand.getValue() != i) continue;
                                    hintColor = Options.getInstance().getHintCandidateFinBackColor();
                                    candColor = Options.getInstance().getHintCandidateFinColor();
                                }
                                for (Candidate cand : this.step.getEndoFins()) {
                                    if (cand.getIndex() != index || cand.getValue() != i) continue;
                                    hintColor = Options.getInstance().getHintCandidateEndoFinBackColor();
                                    candColor = Options.getInstance().getHintCandidateEndoFinColor();
                                }
                                if (this.step.getValues().contains(i) && this.step.getColorCandidates().containsKey(index)) {
                                    hintColor = Options.getInstance().getColoringColors()[(Integer)this.step.getColorCandidates().get(index)];
                                    candColor = Options.getInstance().getCandidateColor();
                                }
                                for (Candidate cand : this.step.getCandidatesToDelete()) {
                                    if (cand.getIndex() != index || cand.getValue() != i) continue;
                                    hintColor = Options.getInstance().getHintCandidateDeleteBackColor();
                                    candColor = Options.getInstance().getHintCandidateDeleteColor();
                                }
                                for (Candidate cand : this.step.getCannibalistic()) {
                                    if (cand.getIndex() != index || cand.getValue() != i) continue;
                                    hintColor = Options.getInstance().getHintCandidateCannibalisticBackColor();
                                    candColor = Options.getInstance().getHintCandidateCannibalisticColor();
                                }
                            }
                            if (this.isShowWrongValues() && !this.sudoku.isCandidateValid(cellIndex, i, userCandidates)) {
                                offColor = Options.getInstance().getColorKuColor(10);
                                offCand = 10;
                                candColor = Options.getInstance().getWrongValueColor();
                            }
                            if (!this.sudoku.isCandidate(cellIndex, i, userCandidates) && this.isShowDeviations() && this.sudoku.isSolutionSet() && i == this.sudoku.getSolution(cellIndex)) {
                                offColor = Options.getInstance().getColorKuColor(11);
                                offCand = 11;
                                candColor = Options.getInstance().getDeviationColor();
                            }
                            boolean isFilteringCandidates = this.isShowInvalidOrPossibleCells() && !this.isInvalidCells() && this.showHintCellValues[i] && Options.getInstance().isOnlySmallFilters();
                            boolean bl4 = isFilteringBivalueCandidates = this.sudoku.getValue(cellIndex) == 0 && Options.getInstance().isOnlySmallFilters() && isHighlightingBivalue && isCellBivalue;
                            if (candidateValid && (isFilteringCandidates || isFilteringBivalueCandidates)) {
                                if (isFilteringCandidates) {
                                    this.setColor(this.g2, allBlack, Options.getInstance().getPossibleCellColor());
                                } else if (isFilteringBivalueCandidates) {
                                    this.setColor(this.g2, allBlack, Options.getInstance().getPossibleCellColor());
                                }
                                this.g2.fillRect((int)Math.round((double)startX + shiftX + third / 2.0 - ddy / 2.0), (int)Math.round((double)startY + shiftY + third / 2.0 - ddy / 2.0), (int)Math.round(ddy), (int)Math.round(ddy));
                            }
                            Color coloringColor = null;
                            if (this.isColoringVisible && this.coloringCandidateMap.containsKey(cellIndex * 10 + i)) {
                                coloringColor = (Color)this.coloringCandidateMap.get(cellIndex * 10 + i);
                            }
                            if (coloringColor != null) {
                                this.setColor(this.g2, allBlack, coloringColor);
                                this.g2.fillRect((int)Math.round((double)startX + shiftX + third / 2.0 - ddy / 2.0), (int)Math.round((double)startY + shiftY + third / 2.0 - ddy / 2.0), (int)Math.round(ddy), (int)Math.round(ddy));
                            }
                            if (hintColor != null) {
                                this.setColor(this.g2, allBlack, hintColor);
                                this.g2.fillOval((int)Math.round((double)startX + shiftX + third / 2.0 - ddy / 2.0), (int)Math.round((double)startY + shiftY + third / 2.0 - ddy / 2.0), (int)Math.round(ddy), (int)Math.round(ddy));
                            }
                            this.setColor(this.g2, allBlack, candColor);
                            if (!Options.getInstance().isShowColorKuAct()) {
                                this.g2.drawString(Integer.toString(i), (int)Math.round((double)startX + dcx + shiftX), (int)Math.round((double)startY + dcy + shiftY));
                            } else if (offColor != null) {
                                int ccx2 = (int)Math.round((double)startX + shiftX + third / 2.0 - (double)this.candidateHeight / 2.0);
                                int ccy2 = (int)Math.round((double)startY + shiftY + third / 2.0 - (double)this.candidateHeight / 2.0);
                                this.drawColorBox(offCand, this.g2, ccx2, ccy2, this.candidateHeight, false);
                            }
                        }
                        ++i;
                    }
                }
                ++col;
            }
            ++row;
        }
        switch (Options.getInstance().getDrawMode()) {
            case 0: {
                if (allBlack) {
                    this.g2.setStroke(new BasicStroke(this.strokeWidth / 2.0f));
                } else {
                    this.g2.setStroke(new BasicStroke(this.strokeWidth));
                }
                this.setColor(this.g2, allBlack, Options.getInstance().getInnerGridColor());
                this.drawBlockLine(this.delta + this.gridRegion.x, 1 * this.delta + this.gridRegion.y, true);
                this.drawBlockLine(this.delta + this.gridRegion.x, 2 * this.delta + this.gridRegion.y + 3 * this.cellSize, true);
                this.drawBlockLine(this.delta + this.gridRegion.x, 3 * this.delta + this.gridRegion.y + 6 * this.cellSize, true);
                this.setColor(this.g2, allBlack, Options.getInstance().getGridColor());
                this.g2.setStroke(new BasicStroke(this.boxStrokeWidth));
                this.g2.drawRect(this.gridRegion.x, this.gridRegion.y, this.gridRegion.width, this.gridRegion.height);
                int i = 0;
                while (i < 3) {
                    this.g2.drawRect((i + 1) * this.delta + this.gridRegion.x + i * 3 * this.cellSize, 1 * this.delta + this.gridRegion.y, 3 * this.cellSize, 3 * this.cellSize);
                    this.g2.drawRect((i + 1) * this.delta + this.gridRegion.x + i * 3 * this.cellSize, 2 * this.delta + this.gridRegion.y + 3 * this.cellSize, 3 * this.cellSize, 3 * this.cellSize);
                    this.g2.drawRect((i + 1) * this.delta + this.gridRegion.x + i * 3 * this.cellSize, 3 * this.delta + this.gridRegion.y + 6 * this.cellSize, 3 * this.cellSize, 3 * this.cellSize);
                    ++i;
                }
                break;
            }
            case 1: {
                if (allBlack) {
                    this.g2.setStroke(new BasicStroke(this.strokeWidth / 2.0f));
                } else {
                    this.g2.setStroke(new BasicStroke(this.strokeWidth));
                }
                this.setColor(this.g2, allBlack, Options.getInstance().getInnerGridColor());
                this.drawBlockLine(this.delta + this.gridRegion.x, 1 * this.delta + this.gridRegion.y, false);
                this.drawBlockLine(this.delta + this.gridRegion.x, 2 * this.delta + this.gridRegion.y + 3 * this.cellSize, false);
                this.drawBlockLine(this.delta + this.gridRegion.x, 3 * this.delta + this.gridRegion.y + 6 * this.cellSize, false);
                this.setColor(this.g2, allBlack, Options.getInstance().getGridColor());
                this.g2.setStroke(new BasicStroke(this.boxStrokeWidth));
                this.g2.drawRect(this.gridRegion.x, this.gridRegion.y, this.gridRegion.width, this.gridRegion.height);
                int i = 0;
                while (i < 3) {
                    this.g2.drawLine(this.gridRegion.x, this.gridRegion.y + i * 3 * this.cellSize, this.gridRegion.x + 9 * this.cellSize, this.gridRegion.y + i * 3 * this.cellSize);
                    this.g2.drawLine(this.gridRegion.x + i * 3 * this.cellSize, this.gridRegion.y, this.gridRegion.x + i * 3 * this.cellSize, this.gridRegion.y + 9 * this.cellSize);
                    ++i;
                }
                break;
            }
        }
        if (this.step != null && !this.step.getChains().isEmpty()) {
            int i;
            this.points.clear();
            int ci = 0;
            while (ci < this.step.getChainAnz()) {
                if (!(this.step.getType().isKrakenFish() && this.chainIndex == -1 || this.chainIndex != -1 && this.chainIndex != ci)) {
                    Chain chain = this.step.getChains().get(ci);
                    i = chain.getStart();
                    while (i <= chain.getEnd()) {
                        int che = Math.abs(chain.getChain()[i]);
                        this.points.add(this.getCandKoord(Chain.getSCellIndex(che), Chain.getSCandidate(che), this.cellSize));
                        if (Chain.getSNodeType(che) == 1) {
                            int indexC = Chain.getSCellIndex2(che);
                            if (indexC != -1) {
                                this.points.add(this.getCandKoord(indexC, Chain.getSCandidate(che), this.cellSize));
                            }
                            if ((indexC = Chain.getSCellIndex3(che)) != -1) {
                                this.points.add(this.getCandKoord(indexC, Chain.getSCandidate(che), this.cellSize));
                            }
                        }
                        ++i;
                    }
                }
                ++ci;
            }
            for (Candidate cand : this.step.getCandidatesToDelete()) {
                this.points.add(this.getCandKoord(cand.getIndex(), cand.getValue(), this.cellSize));
            }
            int ai = 0;
            while (ai < this.step.getAlses().size()) {
                if (!(this.step.getType().isKrakenFish() && this.chainIndex == -1 || this.chainIndex != -1 && !this.alsToShow.contains(ai))) {
                    AlsInSolutionStep als = this.step.getAlses().get(ai);
                    i = 0;
                    while (i < als.getIndices().size()) {
                        int index = als.getIndices().get(i);
                        int[] cands = this.sudoku.getAllCandidates(index);
                        int j = 0;
                        while (j < cands.length) {
                            this.points.add(this.getCandKoord(index, cands[j], this.cellSize));
                            ++j;
                        }
                        ++i;
                    }
                }
                ++ai;
            }
            ci = 0;
            while (ci < this.step.getChainAnz()) {
                if (!(this.step.getType().isKrakenFish() && this.chainIndex == -1 || this.chainIndex != -1 && ci != this.chainIndex)) {
                    Chain chain = this.step.getChains().get(ci);
                    this.drawChain(this.g2, chain, this.cellSize, ddy, allBlack);
                }
                ++ci;
            }
        }
    }

    private void setColor(Graphics2D g2, boolean allBlack, Color color) {
        if (allBlack) {
            g2.setColor(Color.BLACK);
        } else {
            g2.setColor(color);
        }
    }

    private void drawChain(Graphics2D g2, Chain chain, int cellSize, double ddy, boolean allBlack) {
        int[] ch = chain.getChain();
        ArrayList<Point2D.Double> points1 = new ArrayList<Point2D.Double>(chain.getEnd() + 1);
        int i = 0;
        while (i <= chain.getEnd()) {
            if (i < chain.getStart()) {
                points1.add(null);
            } else {
                int che = Math.abs(ch[i]);
                points1.add(this.getCandKoord(Chain.getSCellIndex(che), Chain.getSCandidate(che), cellSize));
            }
            ++i;
        }
        Stroke oldStroke = g2.getStroke();
        int oldChe = 0;
        int oldIndex = 0;
        int index = 0;
        int i2 = chain.getStart();
        while (i2 < chain.getEnd()) {
            if (ch[i2 + 1] != Integer.MIN_VALUE) {
                index = i2;
                int che = Math.abs(ch[i2]);
                int che1 = Math.abs(ch[i2 + 1]);
                if (ch[i2] > 0 && ch[i2 + 1] < 0) {
                    oldChe = che;
                    oldIndex = i2;
                }
                if (ch[i2] == Integer.MIN_VALUE && ch[i2 + 1] < 0) {
                    che = oldChe;
                    index = oldIndex;
                }
                if (ch[i2] < 0 && ch[i2 + 1] > 0) {
                    che = oldChe;
                    index = oldIndex;
                }
                if (Chain.getSCellIndex(che) != Chain.getSCellIndex(che1)) {
                    this.setColor(g2, allBlack, Options.getInstance().getArrowColor());
                    if (Chain.isSStrong(che1)) {
                        g2.setStroke(this.strongLinkStroke);
                    } else {
                        g2.setStroke(this.weakLinkStroke);
                    }
                    this.drawArrow(g2, index, i2 + 1, cellSize, ddy, points1);
                }
            }
            ++i2;
        }
        g2.setStroke(oldStroke);
    }

    private void drawArrow(Graphics2D g2, int index1, int index2, int cellSize, double ddy, List<Point2D.Double> points1) {
        Point2D.Double p1 = (Point2D.Double)points1.get(index1).clone();
        Point2D.Double p2 = (Point2D.Double)points1.get(index2).clone();
        double length = p1.distance(p2);
        double deltaX = p2.x - p1.x;
        double deltaY = p2.y - p1.y;
        double alpha = Math.atan2(deltaY, deltaX);
        this.adjustEndPoints(p1, p2, alpha, ddy);
        double epsilon = 0.1;
        double dx1 = deltaX;
        double dy1 = deltaY;
        boolean doesIntersect = false;
        int i = 0;
        while (i < this.points.size()) {
            if (!this.points.get(i).equals(points1.get(index1)) && !this.points.get(i).equals(points1.get(index2))) {
                Point2D.Double point = this.points.get(i);
                double dx2 = point.x - p1.x;
                double dy2 = point.y - p1.y;
                if (Math.signum(dx1) == Math.signum(dx2) && Math.signum(dy1) == Math.signum(dy2) && Math.abs(dx2) <= Math.abs(dx1) && Math.abs(dy2) <= Math.abs(dy1) && (dx1 == 0.0 || dy1 == 0.0 || Math.abs(dx1 / dy1 - dx2 / dy2) < epsilon)) {
                    doesIntersect = true;
                    break;
                }
            }
            ++i;
        }
        if (length < 2.0 * ddy) {
            doesIntersect = true;
        }
        double aAlpha = alpha;
        if (doesIntersect) {
            double bezierLength = 20.0;
            if (length < 2.0 * ddy) {
                bezierLength = length / 4.0;
            }
            this.rotatePoint(points1.get(index1), p1, -0.7853981633974483);
            this.rotatePoint(points1.get(index2), p2, 0.7853981633974483);
            aAlpha = alpha - 0.7853981633974483;
            double bX1 = p1.x + bezierLength * Math.cos(aAlpha);
            double bY1 = p1.y + bezierLength * Math.sin(aAlpha);
            aAlpha = alpha + 0.7853981633974483;
            double bX2 = p2.x - bezierLength * Math.cos(aAlpha);
            double bY2 = p2.y - bezierLength * Math.sin(aAlpha);
            this.cubicCurve.setCurve(p1.x, p1.y, bX1, bY1, bX2, bY2, p2.x, p2.y);
            g2.draw(this.cubicCurve);
        } else {
            g2.drawLine((int)Math.round(p1.x), (int)Math.round(p1.y), (int)Math.round(p2.x), (int)Math.round(p2.y));
        }
        g2.setStroke(this.arrowStroke);
        double arrowLength = (double)cellSize * this.arrowLengthFactor;
        double arrowHeight = arrowLength * this.arrowHeightFactor;
        if (length > arrowLength * 2.0 + ddy) {
            double sin = Math.sin(aAlpha);
            double cos = Math.cos(aAlpha);
            double aX = p2.x - cos * arrowLength;
            double aY = p2.y - sin * arrowLength;
            if (doesIntersect) {
                double aXTemp = 0.0;
                double aYTemp = 0.0;
                double eps = Double.MAX_VALUE;
                double[] tmpPoints = new double[6];
                PathIterator pIt = this.cubicCurve.getPathIterator(null, 0.01);
                while (!pIt.isDone()) {
                    int type = pIt.currentSegment(tmpPoints);
                    double dist = p2.distance(tmpPoints[0], tmpPoints[1]);
                    if (Math.abs(dist - arrowLength) < eps) {
                        eps = Math.abs(dist - arrowLength);
                        aXTemp = tmpPoints[0];
                        aYTemp = tmpPoints[1];
                    }
                    pIt.next();
                }
                aX = aXTemp;
                aY = aYTemp;
                aAlpha = Math.atan2(p2.y - aY, p2.x - aX);
                sin = Math.sin(aAlpha);
                cos = Math.cos(aAlpha);
            }
            double daX = sin * arrowHeight;
            double daY = cos * arrowHeight;
            this.arrow.reset();
            this.arrow.addPoint((int)Math.round(aX - daX), (int)Math.round(aY + daY));
            this.arrow.addPoint((int)Math.round(p2.x), (int)Math.round(p2.y));
            this.arrow.addPoint((int)Math.round(aX + daX), (int)Math.round(aY - daY));
            g2.fill(this.arrow);
            g2.draw(this.arrow);
        }
    }

    private void rotatePoint(Point2D.Double p1, Point2D.Double p2, double angle) {
        p2.x -= p1.x;
        p2.y -= p1.y;
        double sinAngle = Math.sin(angle);
        double cosAngle = Math.cos(angle);
        double xact = p2.x;
        double yact = p2.y;
        p2.x = xact * cosAngle - yact * sinAngle;
        p2.y = xact * sinAngle + yact * cosAngle;
        p2.x += p1.x;
        p2.y += p1.y;
    }

    private void adjustEndPoints(Point2D.Double p1, Point2D.Double p2, double alpha, double ddy) {
        double tmpDelta = ddy / 2.0 + 4.0;
        int pX = (int)(tmpDelta * Math.cos(alpha));
        int pY = (int)(tmpDelta * Math.sin(alpha));
        p1.x += (double)pX;
        p1.y += (double)pY;
        p2.x -= (double)pX;
        p2.y -= (double)pY;
    }

    private Point2D.Double getCandKoord(int index, int cand, int cellSize) {
        double third = cellSize / 3;
        double startX = this.getX(Sudoku2.getRow(index), Sudoku2.getCol(index));
        double startY = this.getY(Sudoku2.getRow(index), Sudoku2.getCol(index));
        double shiftX = (double)((cand - 1) % 3) * third;
        double shiftY = (double)((cand - 1) / 3) * third;
        double x = startX + shiftX + third / 2.0;
        double y = startY + shiftY + third / 2.0;
        return new Point2D.Double(x, y);
    }

    public int getX(int row, int col) {
        int x = col * this.cellSize + this.delta + this.gridRegion.x;
        if (col > 2) {
            x += this.delta;
        }
        if (col > 5) {
            x += this.delta;
        }
        return x;
    }

    public int getY(int row, int col) {
        int y = row * this.cellSize + this.delta + this.gridRegion.y;
        if (row > 2) {
            y += this.delta;
        }
        if (row > 5) {
            y += this.delta;
        }
        return y;
    }

    private int getRow(Point p) {
        double tmp = p.y - this.gridRegion.y - this.delta;
        if (tmp >= (double)(3 * this.cellSize) && tmp <= (double)(3 * this.cellSize + this.delta) || tmp >= (double)(6 * this.cellSize + this.delta) && tmp <= (double)(6 * this.cellSize + 2 * this.delta)) {
            return -1;
        }
        if (tmp > (double)(3 * this.cellSize)) {
            tmp -= (double)this.delta;
        }
        if (tmp > (double)(6 * this.cellSize)) {
            tmp -= (double)this.delta;
        }
        return (int)Math.ceil(tmp / (double)this.cellSize - 1.0);
    }

    private int getCol(Point p) {
        double tmp = p.x - this.gridRegion.x - this.delta;
        if (tmp >= (double)(3 * this.cellSize) && tmp <= (double)(3 * this.cellSize + this.delta) || tmp >= (double)(6 * this.cellSize + this.delta) && tmp <= (double)(6 * this.cellSize + 2 * this.delta)) {
            return -1;
        }
        if (tmp > (double)(3 * this.cellSize)) {
            tmp -= (double)this.delta;
        }
        if (tmp > (double)(6 * this.cellSize)) {
            tmp -= (double)this.delta;
        }
        return (int)Math.ceil(tmp / (double)this.cellSize - 1.0);
    }

    public int getCandidate(Point p, int row, int col) {
        double cs3;
        if (row < 0 || col < 0) {
            return -1;
        }
        double startX = this.gridRegion.x + col * this.cellSize;
        if (col > 2) {
            startX += (double)this.delta;
        }
        if (col > 5) {
            startX += (double)this.delta;
        }
        double startY = this.gridRegion.y + row * this.cellSize;
        if (row > 2) {
            startY += (double)this.delta;
        }
        if (row > 5) {
            startY += (double)this.delta;
        }
        int candidate = -1;
        double dx = cs3 = (double)this.cellSize / 3.0;
        double leftDx = 0.0;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                double sx = startX + (double)i * cs3 + leftDx;
                double sy = startY + (double)j * cs3 + leftDx;
                if ((double)p.x >= sx && (double)p.x <= sx + dx && (double)p.y >= sy && (double)p.y <= sy + dx) {
                    candidate = j * 3 + i + 1;
                    return candidate;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public void setActiveColor(Color color) {
        if (color == null) {
            if (this.oldCursor != null) {
                this.setCursor(this.oldCursor);
                this.colorCursor = null;
                this.colorCursorShift = null;
            }
        } else {
            if (this.oldCursor == null) {
                this.oldCursor = this.getCursor();
            }
            this.createColorCursors();
            this.setCursor(this.colorCursor);
        }
        this.clearRegion();
        this.updateCellZoomPanel();
    }

    public void resetActiveColor() {
        Color temp = this.getActiveColor();
        this.setActiveColor(null);
        this.setActiveColor(temp);
    }

    private void drawBlockLine(int x, int y, boolean withRect) {
        this.drawBlock(x, y, withRect);
        this.drawBlock(x + 3 * this.cellSize + this.delta, y, withRect);
        this.drawBlock(x + 6 * this.cellSize + 2 * this.delta, y, withRect);
    }

    private void drawBlock(int x, int y, boolean withRect) {
        if (withRect) {
            this.g2.drawRect(x, y, 3 * this.cellSize, 3 * this.cellSize);
        }
        this.g2.drawLine(x, y + 1 * this.cellSize, x + 3 * this.cellSize, y + 1 * this.cellSize);
        this.g2.drawLine(x, y + 2 * this.cellSize, x + 3 * this.cellSize, y + 2 * this.cellSize);
        this.g2.drawLine(x + 1 * this.cellSize, y, x + 1 * this.cellSize, y + 3 * this.cellSize);
        this.g2.drawLine(x + 2 * this.cellSize, y, x + 2 * this.cellSize, y + 3 * this.cellSize);
    }

    public Sudoku2 getSudoku() {
        return this.sudoku;
    }

    public boolean isShowCandidates() {
        return this.showCandidates;
    }

    public final void setShowCandidates(boolean showCandidates) {
        this.showCandidates = showCandidates;
        this.repaint();
    }

    public boolean isShowWrongValues() {
        return this.showWrongValues;
    }

    public void setShowWrongValues(boolean showWrongValues) {
        this.showWrongValues = showWrongValues;
        this.repaint();
    }

    public boolean undoPossible() {
        return this.undoStack.size() > 0;
    }

    public boolean redoPossible() {
        return this.redoStack.size() > 0;
    }

    public void undo() {
        if (this.undoPossible()) {
            this.redoStack.push(this.sudoku);
            this.sudoku = this.undoStack.pop();
            this.updateCellZoomPanel();
            this.checkProgress();
            this.mainFrame.setCurrentLevel(this.sudoku.getLevel());
            this.mainFrame.setCurrentScore(this.sudoku.getScore());
            this.mainFrame.check();
            this.repaint();
        }
    }

    public void redo() {
        if (this.redoPossible()) {
            this.undoStack.push(this.sudoku);
            this.sudoku = this.redoStack.pop();
            this.updateCellZoomPanel();
            this.checkProgress();
            this.mainFrame.setCurrentLevel(this.sudoku.getLevel());
            this.mainFrame.setCurrentScore(this.sudoku.getScore());
            this.mainFrame.check();
            this.repaint();
        }
    }

    public void clearUndoRedo() {
        this.undoStack.clear();
        this.redoStack.clear();
    }

    public void setSudoku(Sudoku2 newSudoku) {
        this.setSudoku(newSudoku.getSudoku(ClipboardMode.PM_GRID, null), false);
    }

    public void setSudoku(Sudoku2 newSudoku, boolean alreadySolved) {
        this.setSudoku(newSudoku.getSudoku(ClipboardMode.PM_GRID, null), alreadySolved);
    }

    public void setSudoku(String init) {
        this.setSudoku(init, false);
    }

    public void setSudoku(String init, boolean alreadySolved) {
        this.step = null;
        this.setChainInStep(-1);
        this.undoStack.clear();
        this.redoStack.clear();
        this.coloringMap.clear();
        this.resetShowHintCellValues();
        this.clearSelection();
        this.clearDragSelection();
        this.cellSelection.clear();
        this.cellSelection.add(new Integer(Sudoku2.getIndex(4, 4)));
        this.isCtrlDown = false;
        this.lastPressedRow = -1;
        this.lastPressedCol = -1;
        this.lastPressedCandidate = -1;
        this.lastClickedRow = -1;
        this.lastClickedCol = -1;
        this.lastClickedCandidate = -1;
        this.lastClickedTime = -1L;
        this.shiftRow = -1;
        this.shiftCol = -1;
        this.lastHighlightedDigit = 0;
        this.isColoringVisible = true;
        if (init == null || init.length() == 0) {
            this.sudoku = new Sudoku2();
        } else {
            int anzSolutions;
            this.sudoku.setSudoku(init);
            this.sudoku.setLevel(Options.getInstance().getDifficultyLevels()[DifficultyType.EASY.ordinal()]);
            this.sudoku.setScore(0);
            Sudoku2 tmpSudoku = this.sudoku.clone();
            if (!alreadySolved) {
                this.getSolver().setSudoku(tmpSudoku);
            }
            if ((anzSolutions = this.generator.getNumberOfSolutions(this.sudoku, 1)) == 0) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("intl/SudokuPanel").getString("SudokuPanel.no_solution"), ResourceBundle.getBundle("intl/SudokuPanel").getString("SudokuPanel.invalid_puzzle"), 0);
                this.sudoku.setStatus(SudokuStatus.INVALID);
            } else if (anzSolutions > 1) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("intl/SudokuPanel").getString("SudokuPanel.multiple_solutions"), ResourceBundle.getBundle("intl/SudokuPanel").getString("SudokuPanel.invalid_puzzle"), 0);
                this.sudoku.setStatus(SudokuStatus.MULTIPLE_SOLUTIONS);
            } else if (!this.sudoku.checkSudoku()) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("intl/SudokuPanel").getString("SudokuPanel.wrong_values"), ResourceBundle.getBundle("intl/SudokuPanel").getString("SudokuPanel.invalid_puzzle"), 0);
                this.sudoku.setStatus(SudokuStatus.INVALID);
            } else {
                this.sudoku.setStatus(SudokuStatus.VALID);
                if (this.sudoku.getFixedCellsAnz() > 17) {
                    Sudoku2 fixedOnly = new Sudoku2();
                    fixedOnly.setSudoku(this.sudoku.getSudoku(ClipboardMode.CLUES_ONLY));
                    int anzFixedSol = this.generator.getNumberOfSolutions(fixedOnly, 1);
                    this.sudoku.setStatusGivens(anzFixedSol);
                }
                if (!alreadySolved) {
                    tmpSudoku.setStatus(SudokuStatus.VALID);
                    tmpSudoku.setStatusGivens(this.sudoku.getStatusGivens());
                    tmpSudoku.setSolution(this.sudoku.getSolution());
                    this.getSolver().solve(true);
                }
                this.sudoku.setLevel(this.getSolver().getSudoku().getLevel());
                this.sudoku.setScore(this.getSolver().getSudoku().getScore());
            }
        }
        this.updateCellZoomPanel();
        if (this.mainFrame != null) {
            this.mainFrame.setCurrentLevel(this.sudoku.getLevel());
            this.mainFrame.setCurrentScore(this.sudoku.getScore());
            this.mainFrame.check();
        }
        this.repaint();
    }

    public String getSudokuString(ClipboardMode mode) {
        return this.sudoku.getSudoku(mode, this.step);
    }

    public SudokuSolver getSolver() {
        return this.solver;
    }

    public void solveUpTo() {
        SolutionStep actStep = null;
        boolean changed = false;
        this.undoStack.push(this.sudoku.clone());
        GameMode gm = Options.getInstance().getGameMode();
        while ((actStep = this.solver.getHint(this.sudoku, false)) != null) {
            if (actStep.isGiveUp() || (gm == GameMode.PLAYING ? !actStep.getType().getStepConfig().isEnabledProgress() : actStep.getType().getStepConfig().isEnabledTraining())) break;
            this.getSolver().doStep(this.sudoku, actStep);
            changed = true;
        }
        if (changed) {
            this.redoStack.clear();
        } else {
            this.undoStack.pop();
        }
        this.step = null;
        this.setChainInStep(-1);
        this.updateCellZoomPanel();
        this.checkProgress();
        this.mainFrame.check();
        this.repaint();
    }

    public SolutionStep getNextStep(boolean singlesOnly) {
        this.step = this.solver.getHint(this.sudoku, singlesOnly);
        this.setChainInStep(-1);
        this.repaint();
        return this.step;
    }

    public void setStep(SolutionStep step) {
        this.step = step;
        this.setChainInStep(-1);
        this.repaint();
    }

    public SolutionStep getStep() {
        return this.step;
    }

    public void setChainInStep(int chainIndex) {
        if (this.step == null) {
            chainIndex = -1;
        } else if (this.step.getType().isKrakenFish() && chainIndex > -1) {
            --chainIndex;
        }
        if (chainIndex >= 0 && chainIndex > this.step.getChainAnz() - 1) {
            chainIndex = -1;
        }
        this.chainIndex = chainIndex;
        this.alsToShow.clear();
        if (chainIndex != -1) {
            Chain chain = this.step.getChains().get(chainIndex);
            int i = chain.getStart();
            while (i <= chain.getEnd()) {
                if (chain.getNodeType(i) == 2) {
                    this.alsToShow.add(Chain.getSAlsIndex(chain.getChain()[i]));
                }
                ++i;
            }
        }
        this.repaint();
    }

    public void doStep() {
        if (this.step != null) {
            this.undoStack.push(this.sudoku.clone());
            this.redoStack.clear();
            this.getSolver().doStep(this.sudoku, this.step);
            this.step = null;
            this.setChainInStep(-1);
            this.updateCellZoomPanel();
            this.checkProgress();
            this.mainFrame.check();
            this.repaint();
            if (this.sudoku.isSolved() && Options.getInstance().isShowSudokuSolved()) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("intl/MainFrame").getString("MainFrame.sudoku_solved"), ResourceBundle.getBundle("intl/MainFrame").getString("MainFrame.congratulations"), 1);
            }
        }
    }

    public void abortStep() {
        this.step = null;
        this.setChainInStep(-1);
        this.repaint();
    }

    public int getSolvedCellsAnz() {
        return this.sudoku.getSolvedCellsAnz();
    }

    public void setNoClues() {
        this.sudoku.setNoClues();
        this.repaint();
    }

    public boolean isInvalidCells() {
        return this.invalidCells;
    }

    public void setInvalidCells(boolean invalidCells) {
        this.invalidCells = invalidCells;
    }

    public boolean isShowInvalidOrPossibleCells() {
        return this.showInvalidOrPossibleCells;
    }

    public void setShowInvalidOrPossibleCells(boolean showInvalidOrPossibleCells) {
        this.showInvalidOrPossibleCells = showInvalidOrPossibleCells;
    }

    public boolean[] getShowHintCellValues() {
        return this.showHintCellValues;
    }

    public void setShowHintCellValues(boolean[] showHintCellValues) {
        this.showHintCellValues = showHintCellValues;
    }

    public void setShowHintCellValue(int candidate) {
        if (candidate == 10) {
            int i = 0;
            while (i < this.showHintCellValues.length - 1) {
                this.showHintCellValues[i] = false;
                ++i;
            }
            this.showHintCellValues[10] = !this.showHintCellValues[10];
        } else {
            this.showHintCellValues[10] = false;
            int i = 0;
            while (i < this.showHintCellValues.length - 1) {
                this.showHintCellValues[i] = i == candidate ? !this.showHintCellValues[i] : false;
                ++i;
            }
        }
    }

    public void resetShowHintCellValues() {
        int i = 1;
        while (i < this.showHintCellValues.length) {
            this.showHintCellValues[i] = false;
            ++i;
        }
        this.showInvalidOrPossibleCells = false;
    }

    public boolean isShowDeviations() {
        return this.showDeviations;
    }

    public void setShowDeviations(boolean showDeviations) {
        this.showDeviations = showDeviations;
        this.mainFrame.check();
        this.repaint();
    }

    private void writePNG(BufferedImage bi, int dpi, File file) {
        Iterator<ImageWriter> i = ImageIO.getImageWritersByFormatName("png");
        if (i.hasNext()) {
            ImageWriter imageWriter = i.next();
            ImageWriteParam param = imageWriter.getDefaultWriteParam();
            ImageTypeSpecifier its = new ImageTypeSpecifier(bi.getColorModel(), bi.getSampleModel());
            IIOMetadata iomd = imageWriter.getDefaultImageMetadata(its, param);
            String formatName = "javax_imageio_png_1.0";
            Node node = iomd.getAsTree(formatName);
            int dpiRes = (int)((double)dpi / 2.54 * 100.0);
            IIOMetadataNode res = new IIOMetadataNode("pHYs");
            res.setAttribute("pixelsPerUnitXAxis", String.valueOf(dpiRes));
            res.setAttribute("pixelsPerUnitYAxis", String.valueOf(dpiRes));
            res.setAttribute("unitSpecifier", "meter");
            node.appendChild(res);
            try {
                iomd.setFromTree(formatName, node);
            }
            catch (IIOInvalidTreeException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), ResourceBundle.getBundle("intl/SudokuPanel").getString("SudokuPanel.error"), 0);
            }
            IIOImage iioimage = new IIOImage(bi, null, iomd);
            try {
                FileImageOutputStream out = new FileImageOutputStream(file);
                imageWriter.setOutput(out);
                imageWriter.write(iioimage);
                out.close();
                String companionFileName = file.getPath();
                if (companionFileName.toLowerCase().endsWith(".png")) {
                    companionFileName = companionFileName.substring(0, companionFileName.length() - 4);
                }
                companionFileName = String.valueOf(companionFileName) + ".txt";
                PrintWriter cOut = new PrintWriter(new BufferedWriter(new FileWriter(companionFileName)));
                cOut.println(this.getSudokuString(ClipboardMode.CLUES_ONLY));
                cOut.println(this.getSudokuString(ClipboardMode.LIBRARY));
                cOut.println(this.getSudokuString(ClipboardMode.PM_GRID));
                if (this.step != null) {
                    cOut.println(this.getSudokuString(ClipboardMode.PM_GRID_WITH_STEP));
                }
                cOut.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), ResourceBundle.getBundle("intl/SudokuPanel").getString("SudokuPanel.error"), 0);
            }
        }
    }

    public void updateColorCursor() {
        this.createColorCursors();
        this.setCursor(this.colorCursor);
    }

    private void createColorCursors() {
        try {
            Point cursorHotSpot = new Point(2, 4);
            BufferedImage img1 = ImageIO.read(this.getClass().getResource("/img/c_color.png"));
            Graphics2D gImg1 = (Graphics2D)img1.getGraphics();
            gImg1.setColor(this.cellZoomPanel.getPrimaryColor());
            gImg1.fillRect(19, 18, 12, 12);
            this.colorCursor = Toolkit.getDefaultToolkit().createCustomCursor(img1, cursorHotSpot, "c_strong");
            BufferedImage img2 = ImageIO.read(this.getClass().getResource("/img/c_color.png"));
            Graphics2D gImg2 = (Graphics2D)img2.getGraphics();
            gImg2.setColor(this.cellZoomPanel.getPrimaryColor());
            gImg2.fillRect(19, 18, 12, 12);
            this.colorCursorShift = Toolkit.getDefaultToolkit().createCustomCursor(img2, cursorHotSpot, "c_weak");
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error creating color cursors", ex);
        }
    }

    private boolean isHiddenSingle(int candidate, int row, int col) {
        this.sudoku.rebuildInternalData();
        SudokuStepFinder finder = SudokuSolverFactory.getDefaultSolverInstance().getStepFinder();
        List<SolutionStep> steps = finder.findAllHiddenSingles(this.sudoku);
        for (SolutionStep act : steps) {
            if (act.getType() != SolutionType.HIDDEN_SINGLE || act.getValues().get(0) != candidate || act.getIndices().get(0) != Sudoku2.getIndex(row, col)) continue;
            return true;
        }
        return false;
    }

    private boolean showCandidateHighlight() {
        return Options.getInstance().isShowCandidateHighlight();
    }

    public SudokuSet collectCandidates(boolean intersection) {
        SudokuSet resultSet = new SudokuSet();
        SudokuSet tmpSet = new SudokuSet();
        if (intersection) {
            resultSet.setAll();
        }
        if (this.cellSelection.isEmpty()) {
            if (this.sudoku.getValue(this.getActiveRow(), this.getActiveCol()) == 0) {
                this.sudoku.getCandidateSet(this.getActiveRow(), this.getActiveCol(), tmpSet);
                if (intersection) {
                    resultSet.and(tmpSet);
                } else {
                    resultSet.or(tmpSet);
                }
            }
        } else {
            boolean emptyCellsOnly = true;
            for (int index : this.cellSelection) {
                if (this.sudoku.getValue(index) != 0) continue;
                emptyCellsOnly = false;
                this.sudoku.getCandidateSet(index, tmpSet);
                if (intersection) {
                    resultSet.and(tmpSet);
                    continue;
                }
                resultSet.or(tmpSet);
            }
            if (intersection && emptyCellsOnly) {
                resultSet.clear();
            }
        }
        return resultSet;
    }

    public boolean removeCandidateFromActiveCells(int candidate) {
        boolean changed = false;
        if (this.cellSelection.isEmpty()) {
            int index = Sudoku2.getIndex(this.getActiveRow(), this.getActiveCol());
            if (this.sudoku.getValue(index) == 0 && this.sudoku.isCandidate(index, candidate, !this.showCandidates)) {
                this.sudoku.setCandidate(index, candidate, false, !this.showCandidates);
                changed = true;
            }
        } else {
            for (int index : this.cellSelection) {
                if (this.sudoku.getValue(index) != 0 || !this.sudoku.isCandidate(index, candidate, !this.showCandidates)) continue;
                this.sudoku.setCandidate(index, candidate, false, !this.showCandidates);
                changed = true;
            }
        }
        return changed;
    }

    public void toggleOrRemoveCandidateFromCellZoomPanel(int candidate) {
        if (candidate != -1) {
            this.undoStack.push(this.sudoku.clone());
            boolean changed = false;
            if (this.cellSelection.isEmpty()) {
                int index = Sudoku2.getIndex(this.getActiveRow(), this.getActiveCol());
                if (this.sudoku.isCandidate(index, candidate, !this.showCandidates)) {
                    this.sudoku.setCandidate(index, candidate, false, !this.showCandidates);
                } else {
                    this.sudoku.setCandidate(index, candidate, true, !this.showCandidates);
                }
                changed = true;
            } else {
                changed = this.removeCandidateFromActiveCells(candidate);
            }
            if (changed) {
                this.redoStack.clear();
                this.checkProgress();
            } else {
                this.undoStack.pop();
            }
            this.updateCellZoomPanel();
            this.mainFrame.check();
            this.repaint();
        }
    }

    public CellZoomPanel getCellZoomPanel() {
        return this.cellZoomPanel;
    }

    public void setCellZoomPanel(CellZoomPanel cellZoomPanel) {
        this.cellZoomPanel = cellZoomPanel;
    }

    public void clearCellColor(Color colorNumber) {
        int i = 0;
        while (i < 81) {
            SortedMap<Integer, Color> map = this.coloringMap;
            if (map.containsKey(i) && map.get(i) == colorNumber) {
                map.remove(i);
            }
            ++i;
        }
        this.updateCellZoomPanel();
        this.repaint();
    }

    public void clearCandidateColor(Color colorNumber) {
        SortedMap<Integer, Color> map = this.coloringCandidateMap;
        int index = 0;
        while (index < 81) {
            int candidate = 1;
            while (candidate <= 9) {
                int key = index * 10 + candidate;
                if (map.containsKey(key) && map.get(key) == colorNumber) {
                    map.remove(key);
                }
                ++candidate;
            }
            ++index;
        }
        this.updateCellZoomPanel();
        this.repaint();
    }

    public void updateCellZoomPanel() {
        boolean singleCell;
        if (this.cellZoomPanel == null) {
            return;
        }
        if (this.cellZoomPanel.isColoring()) {
            this.cellZoomPanel.update(SudokuSetBase.EMPTY_SET, SudokuSetBase.EMPTY_SET, 0, true, null, null);
            return;
        }
        int index = Sudoku2.getIndex(this.getActiveRow(), this.getActiveCol());
        boolean bl = singleCell = this.cellSelection.isEmpty() && this.sudoku.getValue(index) == 0;
        if (this.cellZoomPanel.isDefaultMouse()) {
            if (this.sudoku.getValue(index) != 0 && this.cellSelection.isEmpty()) {
                this.cellZoomPanel.update(SudokuSetBase.EMPTY_SET, SudokuSetBase.EMPTY_SET, index, singleCell, null, null);
            } else {
                SudokuSet valueSet = this.collectCandidates(true);
                SudokuSet candSet = this.collectCandidates(false);
                this.cellZoomPanel.update(valueSet, candSet, index, singleCell, null, null);
            }
        } else if (!this.cellSelection.isEmpty() || this.cellSelection.isEmpty() && this.sudoku.getValue(index) != 0) {
            this.cellZoomPanel.update(SudokuSetBase.EMPTY_SET, SudokuSetBase.EMPTY_SET, index, singleCell, null, null);
        } else {
            SudokuSet valueSet = this.collectCandidates(true);
            SudokuSet candSet = this.collectCandidates(false);
            this.cellZoomPanel.update(valueSet, candSet, index, singleCell, this.coloringMap, this.coloringCandidateMap);
        }
    }

    public void setGivens(String givens) {
        this.undoStack.push(this.sudoku.clone());
        this.sudoku.setGivens(givens);
        this.updateCellZoomPanel();
        this.repaint();
        this.mainFrame.check();
    }

    public void checkProgress() {
        int anz = this.sudoku.getSolvedCellsAnz();
        if (anz == 0) {
            this.sudoku.setStatus(SudokuStatus.EMPTY);
            this.sudoku.setStatusGivens(SudokuStatus.EMPTY);
        } else if (anz <= 17) {
            this.sudoku.setStatus(SudokuStatus.INVALID);
            this.sudoku.setStatusGivens(SudokuStatus.INVALID);
        } else if (this.sudoku.checkSudoku()) {
            int anzSol = this.generator.getNumberOfSolutions(this.sudoku, 1000);
            this.sudoku.setStatus(anzSol);
            if (anzSol == 1) {
                this.progressChecker.startCheck(this.sudoku);
            }
        }
    }

    private int getShowHintCellValue() {
        int value = 0;
        int i = 1;
        while (i < this.showHintCellValues.length - 1) {
            if (this.showHintCellValues[i]) {
                if (value == 0) {
                    value = i;
                } else {
                    return 0;
                }
            }
            ++i;
        }
        return value;
    }

    public void checkIsShowInvalidOrPossibleCells() {
        this.showInvalidOrPossibleCells = false;
        int i = 1;
        while (i < this.showHintCellValues.length) {
            if (this.showHintCellValues[i]) {
                this.showInvalidOrPossibleCells = true;
            }
            ++i;
        }
    }

    public void setColorIconsInPopupMenu() {
        this.rightClickMenu.setColorIconsInPopupMenu();
    }

    public void setShowColorKu() {
        this.rightClickMenu.setColorkuInPopupMenu(Options.getInstance().isShowColorKuAct());
        this.cellZoomPanel.calculateLayout();
        this.updateCellZoomPanel();
        this.repaint();
    }

    public void setColorsVisible(boolean isVisible) {
        this.isColoringVisible = isVisible;
    }

    public void resetColorKuImages() {
        int i = 0;
        while (i < colorKuImagesLarge.length) {
            SudokuPanel.colorKuImagesLarge[i] = null;
            SudokuPanel.colorKuImagesSmall[i] = null;
            ++i;
        }
    }

    private void drawColorBox(int n, Graphics gc, int cx, int cy, int boxSize, boolean large) {
        BufferedImage[] images = null;
        images = large ? colorKuImagesLarge : colorKuImagesSmall;
        if (images[0] == null || images[0].getWidth() != boxSize) {
            int i = 0;
            while (i < images.length) {
                images[i] = new ColorKuImage(boxSize, Options.getInstance().getColorKuColor(i + 1));
                ++i;
            }
        }
        gc.drawImage(images[n - 1], cx, cy, null);
    }

    public boolean[] getRemainingCandidates() {
        int i = 0;
        while (i < this.remainingCandidates.length) {
            this.remainingCandidates[i] = false;
            ++i;
        }
        if (this.isShowCandidates()) {
            int[] cands = Sudoku2.POSSIBLE_VALUES[this.sudoku.getRemainingCandidates()];
            int i2 = 0;
            while (i2 < cands.length) {
                this.remainingCandidates[cands[i2] - 1] = true;
                ++i2;
            }
        }
        return this.remainingCandidates;
    }

    public void clearLastCandidateMouseOn() {
        this.lastCandidateMouseOn = null;
    }

    class MouseClickDTO {
        public int row;
        public int col;
        public int candidate;
        public boolean ctrlPressed;
        public boolean shiftPressed;
        public boolean isValidCellIndex;
        public boolean isLeftClick;
        public boolean isMiddleClick;
        public boolean isRightClick;
        public boolean isCellClicked;
        public boolean isCandidateClicked;
        public boolean isDoubleClick;

        MouseClickDTO(MouseEvent e, SudokuPanel panel, boolean isDoubleClick) {
            this.row = panel.getRow(e.getPoint());
            this.col = panel.getCol(e.getPoint());
            this.candidate = panel.getCandidate(e.getPoint(), this.row, this.col);
            this.ctrlPressed = (e.getModifiersEx() & 0x80) != 0;
            this.shiftPressed = (e.getModifiersEx() & 0x40) != 0;
            this.isValidCellIndex = Sudoku2.isValidIndex(this.row, this.col);
            this.isLeftClick = e.getButton() == 1;
            this.isMiddleClick = e.getButton() == 2;
            this.isRightClick = e.getButton() == 3;
            this.isCellClicked = this.row == panel.lastPressedRow && this.col == panel.lastPressedCol;
            this.isCandidateClicked = this.isCellClicked && this.candidate == panel.lastPressedCandidate;
            this.isDoubleClick = isDoubleClick;
        }
    }
}

