/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import sudoku.SudokuSet;

public class SudokuSetBase
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final SudokuSet EMPTY_SET = new SudokuSet();
    public static final long[] MASKS = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L, 0x100000000000000L, 0x200000000000000L, 0x400000000000000L, 0x800000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x4000000000000000L, Long.MIN_VALUE};
    public static final long MAX_MASK1 = -1L;
    public static final long MAX_MASK2 = 131071L;
    protected long mask1 = 0L;
    protected long mask2 = 0L;
    protected boolean initialized = true;

    public SudokuSetBase() {
    }

    public SudokuSetBase(SudokuSetBase init) {
        this.set(init);
    }

    public SudokuSetBase(boolean full) {
        if (full) {
            this.setAll();
        }
    }

    public SudokuSetBase clone() {
        SudokuSetBase newSet = null;
        try {
            newSet = (SudokuSetBase)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error while cloning", ex);
        }
        return newSet;
    }

    public boolean isEmpty() {
        return this.mask1 == 0L && this.mask2 == 0L;
    }

    public void add(int value) {
        if (value >= 64) {
            this.mask2 |= MASKS[value - 64];
        } else {
            this.mask1 |= MASKS[value];
        }
        this.initialized = false;
    }

    public void remove(int value) {
        if (value >= 64) {
            this.mask2 &= MASKS[value - 64] ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            this.mask1 &= MASKS[value] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.initialized = false;
    }

    public final void set(SudokuSetBase set) {
        this.mask1 = set.mask1;
        this.mask2 = set.mask2;
        this.initialized = false;
    }

    public void set(int[] data) {
        this.mask1 = 0L;
        this.mask2 = 0L;
        this.initialized = false;
        int i = 0;
        while (i < data.length) {
            this.add(data[i]);
            ++i;
        }
    }

    public void set(long m1, long m2) {
        this.mask1 = m1;
        this.mask2 = m2;
        this.initialized = false;
    }

    public void set(int data) {
        this.mask1 = data;
        this.mask2 = 0L;
        this.initialized = false;
    }

    public boolean contains(int value) {
        if (value >= 64) {
            return (this.mask2 & MASKS[value - 64]) != 0L;
        }
        return (this.mask1 & MASKS[value]) != 0L;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SudokuSetBase)) {
            return false;
        }
        SudokuSetBase s = (SudokuSetBase)o;
        return this.mask1 == s.mask1 && this.mask2 == s.mask2;
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + (int)(this.mask1 ^ this.mask1 >>> 32);
        hash = 71 * hash + (int)(this.mask2 ^ this.mask2 >>> 32);
        return hash;
    }

    public void clear() {
        this.mask2 = 0L;
        this.mask1 = 0L;
        this.initialized = false;
    }

    public final void setAll() {
        this.mask1 = -1L;
        this.mask2 = 131071L;
        this.initialized = false;
    }

    public boolean intersects(SudokuSetBase b) {
        return (this.mask1 & b.mask1) != 0L || (this.mask2 & b.mask2) != 0L;
    }

    public boolean intersects(SudokuSetBase b, SudokuSetBase c) {
        boolean result = false;
        long mask = this.mask1 & b.mask1;
        if (mask != 0L) {
            result = true;
            c.mask1 |= mask;
            c.initialized = false;
        }
        if ((mask = this.mask2 & b.mask2) != 0L) {
            result = true;
            c.mask2 |= mask;
            c.initialized = false;
        }
        return result;
    }

    public boolean contains(SudokuSetBase b) {
        return (b.mask1 & (this.mask1 ^ 0xFFFFFFFFFFFFFFFFL)) == 0L && (b.mask2 & (this.mask2 ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    public void or(SudokuSetBase b) {
        this.mask1 |= b.mask1;
        this.mask2 |= b.mask2;
        this.initialized = false;
    }

    public void orNot(SudokuSetBase set) {
        this.mask1 |= set.mask1 ^ 0xFFFFFFFFFFFFFFFFL;
        this.mask2 |= set.mask2 ^ 0xFFFFFFFFFFFFFFFFL;
        this.initialized = false;
    }

    public void and(SudokuSetBase set) {
        this.mask1 &= set.mask1;
        this.mask2 &= set.mask2;
        this.initialized = false;
    }

    public void andNot(SudokuSetBase set) {
        this.mask1 &= set.mask1 ^ 0xFFFFFFFFFFFFFFFFL;
        this.mask2 &= set.mask2 ^ 0xFFFFFFFFFFFFFFFFL;
        this.initialized = false;
    }

    public boolean andEquals(SudokuSetBase set) {
        long m1 = this.mask1 & set.mask1;
        long m2 = this.mask2 & set.mask2;
        return m1 == this.mask1 && m2 == this.mask2;
    }

    public boolean andNotEquals(SudokuSetBase set) {
        long m1 = this.mask1 & (set.mask1 ^ 0xFFFFFFFFFFFFFFFFL);
        long m2 = this.mask2 & (set.mask2 ^ 0xFFFFFFFFFFFFFFFFL);
        return m1 == this.mask1 && m2 == this.mask2;
    }

    public boolean andEmpty(SudokuSetBase set) {
        long m1 = this.mask1 & set.mask1;
        long m2 = this.mask2 & set.mask2;
        return m1 == 0L && m2 == 0L;
    }

    public void not() {
        this.mask1 ^= 0xFFFFFFFFFFFFFFFFL;
        this.mask2 = (this.mask2 ^ 0xFFFFFFFFFFFFFFFFL) & 0x1FFFFL;
        this.initialized = false;
    }

    public void orAndAnd(SudokuSetBase s1, SudokuSetBase s2) {
        this.mask1 |= s1.mask1 & s2.mask1;
        this.mask2 |= s1.mask2 & s2.mask2;
        this.initialized = false;
    }

    public void setAnd(SudokuSetBase s1, SudokuSetBase s2) {
        this.mask1 = s1.mask1 & s2.mask1;
        this.mask2 = s1.mask2 & s2.mask2;
        this.initialized = false;
    }

    public static boolean andEmpty(SudokuSetBase s1, SudokuSetBase s2) {
        return (s1.mask1 & s2.mask1) == 0L && (s1.mask2 & s2.mask2) == 0L;
    }

    public void setOr(SudokuSetBase s1, SudokuSetBase s2) {
        this.mask1 = s1.mask1 | s2.mask1;
        this.mask2 = s1.mask2 | s2.mask2;
        this.initialized = false;
    }

    protected String pM(long mask) {
        return Long.toHexString(mask);
    }

    public String toString() {
        int[] values = new int[81];
        int anz = 0;
        int index = 0;
        int i = 0;
        while (i < 64) {
            if ((this.mask1 & MASKS[i]) != 0L) {
                values[index++] = i;
            }
            ++i;
        }
        i = 0;
        while (i < 17) {
            if ((this.mask2 & MASKS[i]) != 0L) {
                values[index++] = i + 64;
            }
            ++i;
        }
        this.initialized = true;
        anz = index;
        if (anz == 0) {
            return "empty!";
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append(Integer.toString(values[0]));
        int i2 = 1;
        while (i2 < anz) {
            tmp.append(" ").append(Integer.toString(values[i2]));
            ++i2;
        }
        tmp.append(" ").append(this.pM(this.mask1)).append("/").append(this.pM(this.mask2));
        return tmp.toString();
    }

    public long getMask1() {
        return this.mask1;
    }

    public void setMask1(long mask1) {
        this.mask1 = mask1;
    }

    public long getMask2() {
        return this.mask2;
    }

    public void setMask2(long mask2) {
        this.mask2 = mask2;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

