/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.util.logging.Level;
import java.util.logging.Logger;
import sudoku.Sudoku2;

public class SudokuSinglesQueue
implements Cloneable {
    private int[] indices = new int[243];
    private int[] values = new int[243];
    private int putIndex = 0;
    private int getIndex = 0;
    private int iterateIndex = 0;

    public SudokuSinglesQueue clone() {
        SudokuSinglesQueue newSudokuSinglesQueue = null;
        try {
            newSudokuSinglesQueue = (SudokuSinglesQueue)super.clone();
            newSudokuSinglesQueue.indices = (int[])this.indices.clone();
            newSudokuSinglesQueue.values = (int[])this.values.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error while cloning", ex);
        }
        return newSudokuSinglesQueue;
    }

    public void set(SudokuSinglesQueue src) {
        System.arraycopy(src.indices, 0, this.indices, 0, this.indices.length);
        System.arraycopy(src.values, 0, this.values, 0, this.values.length);
        this.getIndex = src.getIndex;
        this.putIndex = src.putIndex;
        this.iterateIndex = src.iterateIndex;
    }

    public boolean isEmpty() {
        return this.getIndex >= this.putIndex;
    }

    public void addSingle(int index, int value) {
        this.indices[this.putIndex] = index;
        this.values[this.putIndex++] = value;
    }

    public int getSingle() {
        if (this.getIndex >= this.putIndex) {
            return -1;
        }
        int ret = this.getIndex++;
        if (this.getIndex >= this.putIndex) {
            this.putIndex = 0;
            this.getIndex = 0;
        }
        return ret;
    }

    public int getIndex(int queueIndex) {
        return this.indices[queueIndex];
    }

    public int getValue(int queueIndex) {
        return this.values[queueIndex];
    }

    public int getFirstIndex() {
        this.iterateIndex = this.getIndex;
        return this.getNextIndex();
    }

    public int getNextIndex() {
        if (this.iterateIndex >= this.putIndex) {
            return -1;
        }
        return this.iterateIndex++;
    }

    public void deleteNakedSingle(int index) {
        int i = this.getIndex;
        while (i < this.putIndex) {
            if (this.indices[i] == index) {
                int j = i + 1;
                while (j < this.putIndex) {
                    this.indices[j - 1] = this.indices[j];
                    this.values[j - 1] = this.values[j];
                    ++j;
                }
                --this.putIndex;
                break;
            }
            ++i;
        }
    }

    public void deleteHiddenSingle(int constraint, int value) {
        int i = this.getIndex;
        while (i < this.putIndex) {
            int actIndex = this.indices[i];
            if (this.values[i] == value && (Sudoku2.CONSTRAINTS[actIndex][0] == constraint || Sudoku2.CONSTRAINTS[actIndex][1] == constraint || Sudoku2.CONSTRAINTS[actIndex][2] == constraint)) {
                int j = i + 1;
                while (j < this.putIndex) {
                    this.indices[j - 1] = this.indices[j];
                    this.values[j - 1] = this.values[j];
                    ++j;
                }
                --this.putIndex;
                break;
            }
            ++i;
        }
    }

    public void clear() {
        this.putIndex = 0;
        this.getIndex = 0;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("Singles Queue START\r\n");
        int i = this.getIndex;
        while (i < this.putIndex) {
            tmp.append("   ").append(this.indices[i]).append("/").append(this.values[i]).append("\r\n");
            ++i;
        }
        tmp.append("Singles Queue END\r\n");
        return tmp.toString();
    }
}

