/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import sudoku.CellZoomPanel;
import sudoku.Options;
import sudoku.SudokuPanel;
import sudoku.UIBorderedImagePanel;

public class UIColorPalette
extends JPanel
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = -7096778906107607575L;
    private static final int DEFAULT_BUTTON_SIZE = 42;
    private static final int PANEL_SIZE = 63;
    private UIBorderedImagePanel primaryColor;
    private UIBorderedImagePanel secondaryColor;
    private UIBorderedImagePanel switchColor;
    private UIBorderedImagePanel resetButton;
    private JDialog dialog;
    private JButton dialogButtonOK;
    private JButton dialogButtonCancel;
    private JButton dialogButtonReset;
    private Color initialColor;
    private Color selectedColor;
    private JColorChooser colorChooser;
    private SudokuPanel sudokuPanel;
    private CellZoomPanel cellZoomPanel;

    UIColorPalette(CellZoomPanel cellZoomPanel) {
        super(true);
        this.setSize(63, 63);
        this.setLayout(null);
        this.cellZoomPanel = cellZoomPanel;
        ResourceBundle bundle = ResourceBundle.getBundle("intl/UIColorPalette");
        this.dialog = null;
        this.dialogButtonOK = new JButton(bundle.getString("dialogButtonOK.text"));
        this.dialogButtonCancel = new JButton(bundle.getString("dialogButtonCancel.text"));
        this.dialogButtonReset = new JButton(bundle.getString("dialogButtonReset.text"));
        this.initialColor = Color.white;
        this.selectedColor = Color.white;
        this.colorChooser = new JColorChooser(this.initialColor);
        this.dialogButtonOK.addActionListener(this);
        this.dialogButtonCancel.addActionListener(this);
        this.dialogButtonReset.addActionListener(this);
        this.primaryColor = new UIBorderedImagePanel();
        this.primaryColor.setBackground(Options.DEFAULT_PRIMARY_COLOR);
        this.primaryColor.setSize(42, 42);
        this.primaryColor.setLocation(0, 0);
        this.primaryColor.setToolTipText(bundle.getString("primaryColor.tooltip"));
        this.primaryColor.addMouseListener(this);
        this.add(this.primaryColor);
        this.secondaryColor = new UIBorderedImagePanel();
        this.secondaryColor.setBackground(Options.DEFAULT_SECONDARY_COLOR);
        this.secondaryColor.setSize(42, 42);
        this.secondaryColor.setLocation(21, 21);
        this.secondaryColor.setToolTipText(bundle.getString("secondaryColor.tooltip"));
        this.secondaryColor.addMouseListener(this);
        this.add(this.secondaryColor);
        Image switchImage = new ImageIcon(this.getClass().getResource("/img/swap_color_arrow.png")).getImage();
        Image resetImage = new ImageIcon(this.getClass().getResource("/img/reset.png")).getImage();
        int offset = 63 - switchImage.getWidth(null);
        this.switchColor = new UIBorderedImagePanel(switchImage);
        this.switchColor.setLocation(offset, 0);
        this.switchColor.setToolTipText(bundle.getString("switchColor.tooltip"));
        this.switchColor.addMouseListener(this);
        this.add(this.switchColor);
        this.resetButton = new UIBorderedImagePanel(resetImage);
        this.resetButton.setLocation(0, offset);
        this.resetButton.setBorderVisible(true);
        this.resetButton.setToolTipText(bundle.getString("resetButton.tooltip"));
        this.resetButton.addMouseListener(this);
        this.add(this.resetButton);
    }

    public void setPrimaryColor(Color color) {
        this.primaryColor.setBackground(color);
    }

    public Color getPrimaryColor() {
        return this.primaryColor.getBackground();
    }

    public Color getSecondaryColor() {
        return this.secondaryColor.getBackground();
    }

    public void swap() {
        Color temp = this.secondaryColor.getBackground();
        this.secondaryColor.setBackground(this.primaryColor.getBackground());
        this.primaryColor.setBackground(temp);
        if (this.cellZoomPanel.isColoring()) {
            this.sudokuPanel.updateColorCursor();
        }
        this.repaint();
    }

    private void clearColor(Color c) {
        if (this.cellZoomPanel.isColoringCells()) {
            this.sudokuPanel.clearCellColor(c);
        } else if (this.cellZoomPanel.isColoringCandidates()) {
            this.sudokuPanel.clearCandidateColor(c);
        }
    }

    private void clearAllColors() {
        this.sudokuPanel.clearColoring();
        this.sudokuPanel.repaint();
    }

    private Color showColorChooserDialog(Color currentColor) {
        this.initialColor = currentColor;
        this.selectedColor = currentColor;
        this.colorChooser.setColor(currentColor);
        Object[] buttons = new JButton[]{this.dialogButtonOK, this.dialogButtonCancel, this.dialogButtonReset};
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(this.colorChooser);
        optionPane.setMessageType(-1);
        optionPane.setOptions(buttons);
        optionPane.setOptionType(1);
        optionPane.setInitialValue(buttons[0]);
        optionPane.setInitialSelectionValue(this.dialogButtonOK);
        ResourceBundle bundle = ResourceBundle.getBundle("intl/UIColorPalette");
        this.dialog = optionPane.createDialog(bundle.getString("optionPane.title"));
        this.dialog.setVisible(true);
        return this.selectedColor;
    }

    public void setSudokuPanel(SudokuPanel sudokuPanel) {
        this.sudokuPanel = sudokuPanel;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.dialogButtonOK) {
            this.selectedColor = this.colorChooser.getColor();
            this.dialog.setVisible(false);
        } else if (e.getSource() == this.dialogButtonCancel) {
            this.dialog.setVisible(false);
        } else if (e.getSource() == this.dialogButtonReset) {
            this.selectedColor = this.initialColor;
            this.colorChooser.setColor(this.initialColor);
        } else {
            this.dialog.setVisible(false);
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.primaryColor) {
            if (e.isControlDown()) {
                this.clearColor(this.primaryColor.getBackground());
            } else {
                this.primaryColor.setBackground(this.showColorChooserDialog(this.primaryColor.getBackground()));
                if (!this.cellZoomPanel.isDefaultMouse()) {
                    this.sudokuPanel.updateColorCursor();
                }
            }
            this.repaint();
        } else if (e.getSource() == this.secondaryColor) {
            if (e.isControlDown()) {
                this.clearColor(this.secondaryColor.getBackground());
            } else {
                this.secondaryColor.setBackground(this.showColorChooserDialog(this.secondaryColor.getBackground()));
                if (!this.cellZoomPanel.isDefaultMouse()) {
                    this.sudokuPanel.updateColorCursor();
                }
            }
            this.repaint();
        } else if (e.getSource() == this.switchColor) {
            this.swap();
        } else if (e.getSource() == this.resetButton) {
            this.clearAllColors();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

