/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import sudoku.ClipboardMode;
import sudoku.SudokuPanel;

public class UIExportLine
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 2164682681182463141L;
    private JLabel label;
    private JTextField textField;
    private JButton copyButton;
    private SudokuPanel sudokuPanel;

    public UIExportLine(SudokuPanel sudokuPanel) {
        this.sudokuPanel = sudokuPanel;
        ResourceBundle bundle = ResourceBundle.getBundle("intl/UIExportLine");
        this.setVisible(false);
        this.setLocation(200, 200);
        this.setLayout(new FlowLayout());
        this.setTitle(bundle.getString("UIExportLine.title"));
        this.setResizable(false);
        this.label = new JLabel(bundle.getString("UIExportLine.label.text"));
        this.add((Component)this.label, 0);
        this.textField = new JTextField();
        this.textField.setPreferredSize(new Dimension(200, 32));
        this.add((Component)this.textField, 1);
        this.copyButton = new JButton(bundle.getString("UIExportLine.copyButton.text"));
        this.copyButton.addActionListener(this);
        this.add((Component)this.copyButton, 2);
        this.revalidate();
        this.pack();
        this.repaint();
    }

    @Override
    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        if (isVisible) {
            String line = this.sudokuPanel.getSudokuString(ClipboardMode.VALUES_ONLY);
            this.textField.setText(line);
            this.textField.selectAll();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.copyButton) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(this.textField.getText());
            clipboard.setContents(stringSelection, null);
            this.textField.setText("");
            this.setVisible(false);
        }
    }
}

