/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import sudoku.MainFrame;

public class UIImportLine
extends JFrame
implements ActionListener,
WindowListener,
KeyListener {
    private static final long serialVersionUID = 8648013595000698919L;
    private JLabel label;
    private JTextField textField;
    private JButton okButton;
    private MainFrame mainFrame;

    public UIImportLine(MainFrame mainFrame) {
        ResourceBundle bundle = ResourceBundle.getBundle("intl/UIImportLine");
        this.setVisible(false);
        this.setLocation(200, 200);
        this.setLayout(new FlowLayout());
        this.setTitle(bundle.getString("UIImportLine.title"));
        this.setResizable(false);
        this.mainFrame = mainFrame;
        this.label = new JLabel(bundle.getString("UIImportLine.label.text"));
        this.add((Component)this.label, 0);
        this.textField = new JTextField();
        this.textField.setPreferredSize(new Dimension(200, 32));
        this.textField.addKeyListener(this);
        this.add((Component)this.textField, 1);
        this.okButton = new JButton(bundle.getString("UIImportLine.okButton.text"));
        this.okButton.addActionListener(this);
        this.add((Component)this.okButton, 2);
        this.addWindowListener(this);
        this.revalidate();
        this.pack();
        this.repaint();
    }

    public void focusCursor() {
        this.textField.requestFocus();
    }

    private void importLine() {
        boolean wasImported = this.mainFrame.loadFromImportLine(this.textField.getText());
        if (wasImported) {
            this.textField.setText("");
            this.setVisible(false);
            this.mainFrame.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.importLine();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.textField.setText("");
        this.setVisible(false);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.importLine();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

