/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import sudoku.MainFrame;
import sudoku.RelativeLayout;

public class UIQuickBrowse
extends JFrame {
    private static final long serialVersionUID = -983785287111188756L;
    JPanel importLinesPanel;
    JPanel navigationPanel;
    JComboBox<String> comboBox;
    MainFrame mainFrame;
    ResourceBundle bundle;

    public UIQuickBrowse(MainFrame mainFrame) {
        this.setLayout(new FlowLayout());
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setVisible(false);
        this.mainFrame = mainFrame;
        this.bundle = ResourceBundle.getBundle("intl/UIQuickBrowse");
        this.setTitle(this.bundle.getString("title"));
        this.initUI(400, 200);
    }

    private void initUI(int w, int h) {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.importLinesPanel = this.createImportLinesPanel(w, h);
        panel.add((Component)this.importLinesPanel, constraints);
        constraints.gridy = 1;
        this.navigationPanel = this.createNavigationPanel();
        panel.add((Component)this.navigationPanel, constraints);
        this.add(panel);
        this.pack();
    }

    private String[] splitIntoLines(String text) {
        ArrayList<String> lines = new ArrayList<String>();
        StringReader stringReader = new StringReader(text);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        String line = "";
        try {
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return new String[0];
        }
        String[] asArray = new String[lines.size()];
        lines.toArray(asArray);
        return asArray;
    }

    private boolean cleanAndValidateLines(String[] lines) {
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            String[] tokens = line.split(" ");
            String importLine = tokens[0];
            if (!MainFrame.ValidateImportLine(importLine)) {
                return false;
            }
            lines[i] = importLine;
            ++i;
        }
        return true;
    }

    private void onUpdate(JTextArea textArea, JPanel panel) {
        String[] lines = this.splitIntoLines(textArea.getText());
        if (this.cleanAndValidateLines(lines)) {
            this.comboBox.removeAllItems();
            this.comboBox.setModel(new DefaultComboBoxModel<String>(lines));
            this.navigationPanel.setPreferredSize(new Dimension(panel.getWidth(), this.navigationPanel.getHeight()));
            this.mainFrame.loadFromImportLine(this.comboBox.getItemAt(0));
            this.repaint();
        }
    }

    private JPanel createImportLinesPanel(int w, int h) {
        final JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("import_lines")), BorderFactory.createEmptyBorder(0, 0, 0, 0)), panel.getBorder()));
        final JTextArea textArea = new JTextArea();
        textArea.setLineWrap(false);
        JScrollPane textAreaScrollPane = new JScrollPane(textArea);
        textAreaScrollPane.setVerticalScrollBarPolicy(22);
        textAreaScrollPane.setPreferredSize(new Dimension(w, h));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridwidth = 3;
        constraints.weightx = 1.0;
        constraints.gridy = 0;
        constraints.gridx = 0;
        panel.add((Component)textAreaScrollPane, constraints);
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.weightx = 0.3;
        constraints.gridy = 1;
        constraints.insets.top = 10;
        JButton buttonLoad = new JButton(this.bundle.getString("btn_load"));
        buttonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                int choice = chooser.showOpenDialog(null);
                if (choice == 0) {
                    File file = chooser.getSelectedFile();
                    try {
                        byte[] fileBuffer = Files.readAllBytes(file.toPath());
                        String text = new String(fileBuffer);
                        textArea.setText(text);
                        UIQuickBrowse.this.onUpdate(textArea, panel);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        return;
                    }
                }
            }
        });
        constraints.gridx = 0;
        panel.add((Component)buttonLoad, constraints);
        JButton buttonImport = new JButton(this.bundle.getString("btn_import"));
        buttonImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIQuickBrowse.this.onUpdate(textArea, panel);
            }
        });
        constraints.gridx = 1;
        panel.add((Component)buttonImport, constraints);
        JButton buttonClear = new JButton(this.bundle.getString("btn_clear"));
        buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                textArea.setText("");
                UIQuickBrowse.this.comboBox.removeAllItems();
                UIQuickBrowse.this.repaint();
            }
        });
        constraints.gridx = 2;
        panel.add((Component)buttonClear, constraints);
        return panel;
    }

    private void scrollComboBoxIndex(int amount, JComboBox<String> comboBox) {
        if (comboBox.getItemCount() < 1 || amount == 0) {
            return;
        }
        int index = comboBox.getSelectedIndex() + amount;
        if (index < 0) {
            index = 0;
        } else if (index >= comboBox.getItemCount()) {
            index = comboBox.getItemCount() - 1;
        }
        this.mainFrame.loadFromImportLine(comboBox.getItemAt(index));
        comboBox.setSelectedIndex(index);
    }

    private JPanel createNavigationPanel() {
        RelativeLayout layout = new RelativeLayout(0);
        layout.setFill(true);
        JPanel panel = new JPanel();
        panel.setLayout(layout);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("navigation")), BorderFactory.createEmptyBorder(0, 0, 0, 0)), panel.getBorder()));
        JButton leftBtn = new JButton("<");
        leftBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIQuickBrowse.this.scrollComboBoxIndex(-1, UIQuickBrowse.this.comboBox);
            }
        });
        this.comboBox = new JComboBox();
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UIQuickBrowse.this.comboBox.getSelectedIndex() >= 0 && UIQuickBrowse.this.comboBox.getSelectedIndex() < UIQuickBrowse.this.comboBox.getItemCount()) {
                    UIQuickBrowse.this.mainFrame.loadFromImportLine(UIQuickBrowse.this.comboBox.getItemAt(UIQuickBrowse.this.comboBox.getSelectedIndex()));
                }
            }
        });
        this.comboBox.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                UIQuickBrowse.this.scrollComboBoxIndex(e.getWheelRotation(), UIQuickBrowse.this.comboBox);
            }
        });
        JButton rightBtn = new JButton(">");
        rightBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIQuickBrowse.this.scrollComboBoxIndex(1, UIQuickBrowse.this.comboBox);
            }
        });
        panel.add((Component)leftBtn, new Float(10.0f));
        panel.add(this.comboBox, new Float(80.0f));
        panel.add((Component)rightBtn, new Float(10.0f));
        return panel;
    }
}

