/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2024 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.io;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ObjectInputStreamProxy extends java.io.ObjectInputStream {

    jail.java.io.ObjectInputStream peer;

    public static class GetFieldProxy extends java.io.ObjectInputStream.GetField {

        jail.java.io.ObjectInputStream.GetField peer;

        public GetFieldProxy(jail.java.io.ObjectInputStream.GetField peer) {
            this.peer = peer;
        }

        public ObjectStreamClass getObjectStreamClass() {
            return ObjectStreamClassPeer.fromJail(peer.getObjectStreamClass());
        }

        public boolean defaulted(String name) throws IOException {
            return peer.defaulted(name);
        }

        public boolean get(String name, boolean val) throws IOException {
            return peer.get(name, val);
        }

        public byte get(String name, byte val) throws IOException {
            return peer.get(name, val);
        }

        public char get(String name, char val) throws IOException {
            return peer.get(name, val);
        }

        public short get(String name, short val) throws IOException {
            return peer.get(name, val);
        }

        public int get(String name, int val) throws IOException {
            return peer.get(name, val);
        }

        public long get(String name, long val) throws IOException {
            return peer.get(name, val);
        }

        public float get(String name, float val) throws IOException {
            return peer.get(name, val);
        }

        public double get(String name, double val) throws IOException {
            return peer.get(name, val);
        }

        public Object get(String name, Object val) throws IOException {
            return peer.get(name, val);
        }
    }

    public static ObjectInputStreamProxy create(final jail.java.io.ObjectInputStream peer) throws IOException {
        Object r = AccessController.doPrivileged(new PrivilegedAction(){
            @Override
            public Object run() {
                try {
                    return new ObjectInputStreamProxy(peer);
                } catch (IOException e) {
                    return e;
                }
            }
        });
        if (r instanceof IOException) {
            throw (IOException)r;
        }
        return (ObjectInputStreamProxy)r;
    }

    private ObjectInputStreamProxy(jail.java.io.ObjectInputStream peer) throws IOException {
        super();
        this.peer = peer;
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        return peer.readObject();
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        return peer.readObject();
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException
    {
        peer.defaultReadObject();
    }

    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException
    {
        return new GetFieldProxy(peer.readFields());
    }

    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException
    {
        peer.registerValidation(obj, prio);
    }

    public int read() throws IOException {
        return peer.read();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        return peer.read(buf,off,len);
    }

    public int available() throws IOException {
        return peer.available();
    }

    public void close() throws IOException {
        peer.close();
    }

    public boolean readBoolean() throws IOException {
        return peer.readBoolean();
    }

    public byte readByte() throws IOException  {
        return peer.readByte();
    }

    public int readUnsignedByte()  throws IOException {
        return peer.readUnsignedByte();
    }

    public char readChar()  throws IOException {
        return peer.readChar();
    }

    public short readShort()  throws IOException {
        return peer.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return peer.readUnsignedShort();
    }

    public int readInt()  throws IOException {
        return peer.readInt();
    }

    public long readLong()  throws IOException {
        return peer.readLong();
    }

    public float readFloat() throws IOException {
        return peer.readFloat();
    }

    public double readDouble() throws IOException {
        return peer.readDouble();
    }

    public void readFully(byte[] buf) throws IOException {
        peer.readFully(buf);
    }

    public void readFully(byte[] buf, int off, int len) throws IOException {
        peer.readFully(buf, off, len);
    }

    public int skipBytes(int len) throws IOException {
        return peer.skipBytes(len);
    }

    public String readLine() throws IOException {
        return peer.readLine();
    }

    public String readUTF() throws IOException {
        return peer.readUTF();
    }

}
