/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2024 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.lang;

import java.security.AccessController;
import java.security.PrivilegedAction;

import blues.AccessibleClassLoader;
import blues.ClientClassLoader;

public class Reflection {

    public static Class getCallerClass() {
        return AccessibleClassLoader.getStack()[AccessibleClassLoader.STACK_OFFSET+2];
    }

    public static java.lang.ClassLoader getCallerClassLoader() {
        Class clazz = getCallerClass();
        return ClassLoaderPeer.getClassLoader(clazz);
    }

    private static boolean equalsOrStartsWith(String what,String with) {
    	if (what.equals(with)==true) return true;
    	if (what.startsWith(with)==false) return false;
    	if (what.charAt(with.length())=='.') return true;
    	return false;
    }

    public static ClassLoader latestUserDefinedLoader() {
    	Class[] callers = AccessibleClassLoader.getStack();

    	ClassLoader myLoader = Reflection.class.getClassLoader();
    	ClassLoader javaLoader = java.io.Serializable.class.getClassLoader();
    	ClassLoader bluesLoader = ClientClassLoader.class.getClassLoader();

    	for (int i=AccessibleClassLoader.STACK_OFFSET;i<callers.length;i++) {
    		ClassLoader loader = callers[i].getClassLoader();

    		if ((loader==null) ||
    			(loader==javaLoader) ||
    			(loader==bluesLoader)) continue;

    		if (loader!=myLoader) {
    			return loader;
    		}

    		Package p = callers[i].getPackage();
    		if (p==null) return loader;

    		String packageName = p.getName();
    		if (equalsOrStartsWith(packageName,"jail.java")) continue;
    		if (equalsOrStartsWith(packageName,"impl.java")) continue;
    		if (equalsOrStartsWith(packageName,"glue.java")) continue;
    		return loader;
    	}

    	return null;
    }


}
