/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.AudioModel;
import org.tinymediamanager.jsonrpc.api.model.LibraryModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;

public final class AudioLibrary {

    public static class SetSongDetails
    extends AbstractCall<String> {
        public static final String API_TYPE = "AudioLibrary.SetSongDetails";

        public SetSongDetails(Integer songid, String title, String[] artist, String[] albumartist, String[] genre, Integer year, Integer rating, String album, Integer track, Integer disc, Integer duration, String comment, String musicbrainztrackid, String musicbrainzartistid, String musicbrainzalbumid, String musicbrainzalbumartistid, Integer playcount, String lastplayed) {
            this.addParameter("songid", songid);
            this.addParameter("title", title);
            this.addParameter("artist", artist);
            this.addParameter("albumartist", albumartist);
            this.addParameter("genre", genre);
            this.addParameter("year", year);
            this.addParameter("rating", rating);
            this.addParameter("album", album);
            this.addParameter("track", track);
            this.addParameter("disc", disc);
            this.addParameter("duration", duration);
            this.addParameter("comment", comment);
            this.addParameter("musicbrainztrackid", musicbrainztrackid);
            this.addParameter("musicbrainzartistid", musicbrainzartistid);
            this.addParameter("musicbrainzalbumid", musicbrainzalbumid);
            this.addParameter("musicbrainzalbumartistid", musicbrainzalbumartistid);
            this.addParameter("playcount", playcount);
            this.addParameter("lastplayed", lastplayed);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetArtistDetails
    extends AbstractCall<String> {
        public static final String API_TYPE = "AudioLibrary.SetArtistDetails";

        public SetArtistDetails(Integer artistid, String artist, String[] instrument, String[] style, String[] mood, String born, String formed, String description, String[] genre, String died, String disbanded, String ... yearsactive) {
            this.addParameter("artistid", artistid);
            this.addParameter("artist", artist);
            this.addParameter("instrument", instrument);
            this.addParameter("style", style);
            this.addParameter("mood", mood);
            this.addParameter("born", born);
            this.addParameter("formed", formed);
            this.addParameter("description", description);
            this.addParameter("genre", genre);
            this.addParameter("died", died);
            this.addParameter("disbanded", disbanded);
            this.addParameter("yearsactive", yearsactive);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetAlbumDetails
    extends AbstractCall<String> {
        public static final String API_TYPE = "AudioLibrary.SetAlbumDetails";

        public SetAlbumDetails(Integer albumid, String title, String[] artist, String description, String[] genre, String[] theme, String[] mood, String[] style, String type, String albumlabel, Integer rating, Integer year) {
            this.addParameter("albumid", albumid);
            this.addParameter("title", title);
            this.addParameter("artist", artist);
            this.addParameter("description", description);
            this.addParameter("genre", genre);
            this.addParameter("theme", theme);
            this.addParameter("mood", mood);
            this.addParameter("style", style);
            this.addParameter("type", type);
            this.addParameter("albumlabel", albumlabel);
            this.addParameter("rating", rating);
            this.addParameter("year", year);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Scan
    extends AbstractCall<String> {
        public static final String API_TYPE = "AudioLibrary.Scan";

        public Scan(String directory) {
            this.addParameter("directory", directory);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetSongs
    extends AbstractCall<AudioModel.SongDetail> {
        public static final String API_TYPE = "AudioLibrary.GetSongs";
        public static final String RESULT = "songs";

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, FilterGenreId filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, FilterGenre filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, FilterArtistId filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, FilterArtist filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, FilterAlbumId filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, FilterAlbum filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, ListModel.SongFilter filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Sort sort, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetSongs(FilterGenreId filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, FilterGenreId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(Boolean includesingles, String ... properties) {
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Sort sort, Boolean includesingles, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(FilterGenreId filter, Boolean includesingles, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, FilterGenreId filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(FilterGenre filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, FilterGenre filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(FilterGenre filter, Boolean includesingles, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, FilterGenre filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(FilterArtistId filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, FilterArtistId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Sort sort, FilterArtistId filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, FilterArtistId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(FilterArtistId filter, Boolean includesingles, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, FilterArtistId filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(FilterArtist filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, FilterArtist filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Sort sort, FilterArtist filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, FilterArtist filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(FilterArtist filter, Boolean includesingles, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, FilterArtist filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(FilterAlbumId filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, FilterAlbumId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Sort sort, FilterAlbumId filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, FilterAlbumId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(FilterAlbumId filter, Boolean includesingles, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, FilterAlbumId filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(FilterAlbum filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, FilterAlbum filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Sort sort, FilterAlbum filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, FilterAlbum filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(FilterAlbum filter, Boolean includesingles, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, FilterAlbum filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.SongFilter filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.SongFilter filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Sort sort, ListModel.SongFilter filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.Sort sort, ListModel.SongFilter filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.SongFilter filter, Boolean includesingles, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetSongs(ListModel.Limits limits, ListModel.SongFilter filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<AudioModel.SongDetail> parseMany(JsonNode node) {
            ArrayNode songs = this.parseResults(node, RESULT);
            if (songs != null) {
                ArrayList<AudioModel.SongDetail> ret = new ArrayList<AudioModel.SongDetail>(songs.size());
                for (int i = 0; i < songs.size(); ++i) {
                    ObjectNode item = (ObjectNode)songs.get(i);
                    ret.add(new AudioModel.SongDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<AudioModel.SongDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static class FilterAlbum
        extends AbstractModel {
            public static final String ALBUM = "album";
            public final String album;

            public FilterAlbum(String album) {
                this.album = album;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ALBUM, this.album);
                return node;
            }
        }

        public static class FilterAlbumId
        extends AbstractModel {
            public static final String ALBUMID = "albumid";
            public final Integer albumid;

            public FilterAlbumId(Integer albumid) {
                this.albumid = albumid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ALBUMID, this.albumid);
                return node;
            }
        }

        public static class FilterArtist
        extends AbstractModel {
            public static final String ARTIST = "artist";
            public final String artist;

            public FilterArtist(String artist) {
                this.artist = artist;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ARTIST, this.artist);
                return node;
            }
        }

        public static class FilterArtistId
        extends AbstractModel {
            public static final String ARTISTID = "artistid";
            public final Integer artistid;

            public FilterArtistId(Integer artistid) {
                this.artistid = artistid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ARTISTID, this.artistid);
                return node;
            }
        }

        public static class FilterGenre
        extends AbstractModel {
            public static final String GENRE = "genre";
            public final String genre;

            public FilterGenre(String genre) {
                this.genre = genre;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENRE, this.genre);
                return node;
            }
        }

        public static class FilterGenreId
        extends AbstractModel {
            public static final String GENREID = "genreid";
            public final Integer genreid;

            public FilterGenreId(Integer genreid) {
                this.genreid = genreid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENREID, this.genreid);
                return node;
            }
        }
    }

    public static class GetSongDetails
    extends AbstractCall<AudioModel.SongDetail> {
        public static final String API_TYPE = "AudioLibrary.GetSongDetails";
        public static final String RESULT = "songdetails";

        public GetSongDetails(Integer songid, String ... properties) {
            this.addParameter("songid", songid);
            this.addParameter("properties", properties);
        }

        @Override
        protected AudioModel.SongDetail parseOne(JsonNode node) {
            return new AudioModel.SongDetail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetRecentlyPlayedSongs
    extends AbstractCall<AudioModel.SongDetail> {
        public static final String API_TYPE = "AudioLibrary.GetRecentlyPlayedSongs";
        public static final String RESULT = "songs";

        public GetRecentlyPlayedSongs(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetRecentlyPlayedSongs(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetRecentlyPlayedSongs(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<AudioModel.SongDetail> parseMany(JsonNode node) {
            ArrayNode songs = this.parseResults(node, RESULT);
            if (songs != null) {
                ArrayList<AudioModel.SongDetail> ret = new ArrayList<AudioModel.SongDetail>(songs.size());
                for (int i = 0; i < songs.size(); ++i) {
                    ObjectNode item = (ObjectNode)songs.get(i);
                    ret.add(new AudioModel.SongDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<AudioModel.SongDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetRecentlyPlayedAlbums
    extends AbstractCall<AudioModel.AlbumDetail> {
        public static final String API_TYPE = "AudioLibrary.GetRecentlyPlayedAlbums";
        public static final String RESULT = "albums";

        public GetRecentlyPlayedAlbums(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetRecentlyPlayedAlbums(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetRecentlyPlayedAlbums(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<AudioModel.AlbumDetail> parseMany(JsonNode node) {
            ArrayNode albums = this.parseResults(node, RESULT);
            if (albums != null) {
                ArrayList<AudioModel.AlbumDetail> ret = new ArrayList<AudioModel.AlbumDetail>(albums.size());
                for (int i = 0; i < albums.size(); ++i) {
                    ObjectNode item = (ObjectNode)albums.get(i);
                    ret.add(new AudioModel.AlbumDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<AudioModel.AlbumDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetRecentlyAddedSongs
    extends AbstractCall<AudioModel.SongDetail> {
        public static final String API_TYPE = "AudioLibrary.GetRecentlyAddedSongs";
        public static final String RESULT = "songs";

        public GetRecentlyAddedSongs(Integer albumlimit, ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("albumlimit", albumlimit);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedSongs(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedSongs(Integer albumlimit, String ... properties) {
            this.addParameter("albumlimit", albumlimit);
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedSongs(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedSongs(Integer albumlimit, ListModel.Limits limits, String ... properties) {
            this.addParameter("albumlimit", albumlimit);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedSongs(ListModel.Sort sort, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedSongs(Integer albumlimit, ListModel.Sort sort, String ... properties) {
            this.addParameter("albumlimit", albumlimit);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<AudioModel.SongDetail> parseMany(JsonNode node) {
            ArrayNode songs = this.parseResults(node, RESULT);
            if (songs != null) {
                ArrayList<AudioModel.SongDetail> ret = new ArrayList<AudioModel.SongDetail>(songs.size());
                for (int i = 0; i < songs.size(); ++i) {
                    ObjectNode item = (ObjectNode)songs.get(i);
                    ret.add(new AudioModel.SongDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<AudioModel.SongDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetRecentlyAddedAlbums
    extends AbstractCall<AudioModel.AlbumDetail> {
        public static final String API_TYPE = "AudioLibrary.GetRecentlyAddedAlbums";
        public static final String RESULT = "albums";

        public GetRecentlyAddedAlbums(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedAlbums(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetRecentlyAddedAlbums(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<AudioModel.AlbumDetail> parseMany(JsonNode node) {
            ArrayNode albums = this.parseResults(node, RESULT);
            if (albums != null) {
                ArrayList<AudioModel.AlbumDetail> ret = new ArrayList<AudioModel.AlbumDetail>(albums.size());
                for (int i = 0; i < albums.size(); ++i) {
                    ObjectNode item = (ObjectNode)albums.get(i);
                    ret.add(new AudioModel.AlbumDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<AudioModel.AlbumDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetGenres
    extends AbstractCall<LibraryModel.GenreDetail> {
        public static final String API_TYPE = "AudioLibrary.GetGenres";
        public static final String RESULT = "genres";

        public GetGenres(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetGenres(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetGenres(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<LibraryModel.GenreDetail> parseMany(JsonNode node) {
            ArrayNode genres = this.parseResults(node, RESULT);
            if (genres != null) {
                ArrayList<LibraryModel.GenreDetail> ret = new ArrayList<LibraryModel.GenreDetail>(genres.size());
                for (int i = 0; i < genres.size(); ++i) {
                    ObjectNode item = (ObjectNode)genres.get(i);
                    ret.add(new LibraryModel.GenreDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<LibraryModel.GenreDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetArtists
    extends AbstractCall<AudioModel.ArtistDetail> {
        public static final String API_TYPE = "AudioLibrary.GetArtists";
        public static final String RESULT = "artists";

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, ListModel.Sort sort, FilterAlbumId filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, ListModel.Sort sort, FilterAlbum filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, ListModel.Sort sort, FilterSongId filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, ListModel.Sort sort, ListModel.ArtistFilter filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Sort sort, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Sort sort, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetArtists(FilterGenreId filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, FilterGenreId filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Limits limits, FilterGenreId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, FilterGenreId filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(FilterGenre filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, FilterGenre filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Limits limits, FilterGenre filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, FilterGenre filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(FilterAlbumId filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, FilterAlbumId filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Limits limits, FilterAlbumId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, FilterAlbumId filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Sort sort, FilterAlbumId filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Sort sort, FilterAlbumId filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(FilterAlbum filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, FilterAlbum filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Limits limits, FilterAlbum filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, FilterAlbum filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Sort sort, FilterAlbum filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Sort sort, FilterAlbum filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(FilterSongId filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, FilterSongId filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Limits limits, FilterSongId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, FilterSongId filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Sort sort, FilterSongId filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Sort sort, FilterSongId filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.ArtistFilter filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.ArtistFilter filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Limits limits, ListModel.ArtistFilter filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Limits limits, ListModel.ArtistFilter filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(ListModel.Sort sort, ListModel.ArtistFilter filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetArtists(Boolean albumartistsonly, ListModel.Sort sort, ListModel.ArtistFilter filter, String ... properties) {
            this.addParameter("albumartistsonly", albumartistsonly);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<AudioModel.ArtistDetail> parseMany(JsonNode node) {
            ArrayNode artists = this.parseResults(node, RESULT);
            if (artists != null) {
                ArrayList<AudioModel.ArtistDetail> ret = new ArrayList<AudioModel.ArtistDetail>(artists.size());
                for (int i = 0; i < artists.size(); ++i) {
                    ObjectNode item = (ObjectNode)artists.get(i);
                    ret.add(new AudioModel.ArtistDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<AudioModel.ArtistDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static class FilterSongId
        extends AbstractModel {
            public static final String SONGID = "songid";
            public final Integer songid;

            public FilterSongId(Integer songid) {
                this.songid = songid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(SONGID, this.songid);
                return node;
            }
        }

        public static class FilterAlbum
        extends AbstractModel {
            public static final String ALBUM = "album";
            public final String album;

            public FilterAlbum(String album) {
                this.album = album;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ALBUM, this.album);
                return node;
            }
        }

        public static class FilterAlbumId
        extends AbstractModel {
            public static final String ALBUMID = "albumid";
            public final Integer albumid;

            public FilterAlbumId(Integer albumid) {
                this.albumid = albumid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ALBUMID, this.albumid);
                return node;
            }
        }

        public static class FilterGenre
        extends AbstractModel {
            public static final String GENRE = "genre";
            public final String genre;

            public FilterGenre(String genre) {
                this.genre = genre;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENRE, this.genre);
                return node;
            }
        }

        public static class FilterGenreId
        extends AbstractModel {
            public static final String GENREID = "genreid";
            public final Integer genreid;

            public FilterGenreId(Integer genreid) {
                this.genreid = genreid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENREID, this.genreid);
                return node;
            }
        }
    }

    public static class GetArtistDetails
    extends AbstractCall<AudioModel.ArtistDetail> {
        public static final String API_TYPE = "AudioLibrary.GetArtistDetails";
        public static final String RESULT = "artistdetails";

        public GetArtistDetails(Integer artistid, String ... properties) {
            this.addParameter("artistid", artistid);
            this.addParameter("properties", properties);
        }

        @Override
        protected AudioModel.ArtistDetail parseOne(JsonNode node) {
            return new AudioModel.ArtistDetail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetAlbums
    extends AbstractCall<AudioModel.AlbumDetail> {
        public static final String API_TYPE = "AudioLibrary.GetAlbums";
        public static final String RESULT = "albums";

        public GetAlbums(ListModel.Limits limits, ListModel.Sort sort, FilterGenreId filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, ListModel.Sort sort, FilterGenre filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, ListModel.Sort sort, FilterArtistId filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, ListModel.Sort sort, FilterArtist filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, ListModel.Sort sort, ListModel.AlbumFilter filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Sort sort, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetAlbums(FilterGenreId filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, FilterGenreId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, ListModel.Sort sort, FilterGenreId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(Boolean includesingles, String ... properties) {
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Sort sort, Boolean includesingles, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, ListModel.Sort sort, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(FilterGenreId filter, Boolean includesingles, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, FilterGenreId filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(FilterGenre filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, FilterGenre filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, ListModel.Sort sort, FilterGenre filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(FilterGenre filter, Boolean includesingles, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, FilterGenre filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(FilterArtistId filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, FilterArtistId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Sort sort, FilterArtistId filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, ListModel.Sort sort, FilterArtistId filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(FilterArtistId filter, Boolean includesingles, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, FilterArtistId filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(FilterArtist filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, FilterArtist filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Sort sort, FilterArtist filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, ListModel.Sort sort, FilterArtist filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(FilterArtist filter, Boolean includesingles, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, FilterArtist filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.AlbumFilter filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, ListModel.AlbumFilter filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Sort sort, ListModel.AlbumFilter filter, String ... properties) {
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, ListModel.Sort sort, ListModel.AlbumFilter filter, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.AlbumFilter filter, Boolean includesingles, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        public GetAlbums(ListModel.Limits limits, ListModel.AlbumFilter filter, Boolean includesingles, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("includesingles", includesingles);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<AudioModel.AlbumDetail> parseMany(JsonNode node) {
            ArrayNode albums = this.parseResults(node, RESULT);
            if (albums != null) {
                ArrayList<AudioModel.AlbumDetail> ret = new ArrayList<AudioModel.AlbumDetail>(albums.size());
                for (int i = 0; i < albums.size(); ++i) {
                    ObjectNode item = (ObjectNode)albums.get(i);
                    ret.add(new AudioModel.AlbumDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<AudioModel.AlbumDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static class FilterArtist
        extends AbstractModel {
            public static final String ARTIST = "artist";
            public final String artist;

            public FilterArtist(String artist) {
                this.artist = artist;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ARTIST, this.artist);
                return node;
            }
        }

        public static class FilterArtistId
        extends AbstractModel {
            public static final String ARTISTID = "artistid";
            public final Integer artistid;

            public FilterArtistId(Integer artistid) {
                this.artistid = artistid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ARTISTID, this.artistid);
                return node;
            }
        }

        public static class FilterGenre
        extends AbstractModel {
            public static final String GENRE = "genre";
            public final String genre;

            public FilterGenre(String genre) {
                this.genre = genre;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENRE, this.genre);
                return node;
            }
        }

        public static class FilterGenreId
        extends AbstractModel {
            public static final String GENREID = "genreid";
            public final Integer genreid;

            public FilterGenreId(Integer genreid) {
                this.genreid = genreid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENREID, this.genreid);
                return node;
            }
        }
    }

    public static class GetAlbumDetails
    extends AbstractCall<AudioModel.AlbumDetail> {
        public static final String API_TYPE = "AudioLibrary.GetAlbumDetails";
        public static final String RESULT = "albumdetails";

        public GetAlbumDetails(Integer albumid, String ... properties) {
            this.addParameter("albumid", albumid);
            this.addParameter("properties", properties);
        }

        @Override
        protected AudioModel.AlbumDetail parseOne(JsonNode node) {
            return new AudioModel.AlbumDetail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Export
    extends AbstractCall<String> {
        public static final String API_TYPE = "AudioLibrary.Export";

        public Export(OptionsPath options) {
            this.addParameter("options", (AbstractModel)options);
        }

        public Export(OptionsImagesOverwrite options) {
            this.addParameter("options", (AbstractModel)options);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static class OptionsImagesOverwrite
        extends AbstractModel {
            public static final String IMAGES = "images";
            public static final String OVERWRITE = "overwrite";
            public final Boolean images;
            public final Boolean overwrite;

            public OptionsImagesOverwrite(Boolean images, Boolean overwrite) {
                this.images = images;
                this.overwrite = overwrite;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(IMAGES, this.images);
                node.put(OVERWRITE, this.overwrite);
                return node;
            }
        }

        public static class OptionsPath
        extends AbstractModel {
            public static final String PATH = "path";
            public final String path;

            public OptionsPath(String path) {
                this.path = path;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(PATH, this.path);
                return node;
            }
        }
    }

    public static class Clean
    extends AbstractCall<String> {
        public static final String API_TYPE = "AudioLibrary.Clean";

        public Clean(Boolean showdialogs) {
            this.addParameter("showdialogs", showdialogs);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

