/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.PlaylistModel;

public final class Playlist {

    public static class Swap
    extends AbstractCall<String> {
        public static final String API_TYPE = "Playlist.Swap";

        public Swap(Integer playlistid, Integer position1, Integer position2) {
            this.addParameter("playlistid", playlistid);
            this.addParameter("position1", position1);
            this.addParameter("position2", position2);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Remove
    extends AbstractCall<String> {
        public static final String API_TYPE = "Playlist.Remove";

        public Remove(Integer playlistid, Integer position) {
            this.addParameter("playlistid", playlistid);
            this.addParameter("position", position);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Insert
    extends AbstractCall<String> {
        public static final String API_TYPE = "Playlist.Insert";

        public Insert(Integer playlistid, Integer position, PlaylistModel.Item item) {
            this.addParameter("playlistid", playlistid);
            this.addParameter("position", position);
            this.addParameter("item", (AbstractModel)item);
        }

        public Insert(Integer playlistid, Integer position, PlaylistModel.Item ... item) {
            this.addParameter("playlistid", playlistid);
            this.addParameter("position", position);
            this.addParameter("item", item);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetProperties
    extends AbstractCall<PlaylistModel.PropertyValue> {
        public static final String API_TYPE = "Playlist.GetProperties";

        public GetProperties(Integer playlistid, String ... properties) {
            this.addParameter("playlistid", playlistid);
            this.addParameter("properties", properties);
        }

        @Override
        protected PlaylistModel.PropertyValue parseOne(JsonNode node) {
            return new PlaylistModel.PropertyValue(node);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetPlaylists
    extends AbstractCall<GetPlaylistsResult> {
        public static final String API_TYPE = "Playlist.GetPlaylists";

        @Override
        protected ArrayList<GetPlaylistsResult> parseMany(JsonNode node) {
            ArrayNode results = (ArrayNode)node;
            if (results != null) {
                ArrayList<GetPlaylistsResult> ret = new ArrayList<GetPlaylistsResult>(results.size());
                for (int i = 0; i < results.size(); ++i) {
                    ObjectNode item = (ObjectNode)results.get(i);
                    ret.add(new GetPlaylistsResult((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<GetPlaylistsResult>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static class GetPlaylistsResult
        extends AbstractModel {
            public static final String PLAYLISTID = "playlistid";
            public static final String TYPE = "type";
            public final Integer playlistid;
            public final String type;

            public GetPlaylistsResult(Integer playlistid, String type) {
                this.playlistid = playlistid;
                this.type = type;
            }

            public GetPlaylistsResult(JsonNode node) {
                this.playlistid = GetPlaylistsResult.parseInt(node, PLAYLISTID);
                this.type = GetPlaylistsResult.parseString(node, TYPE);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(PLAYLISTID, this.playlistid);
                node.put(TYPE, this.type);
                return node;
            }

            static List<GetPlaylistsResult> getPlaylistGetPlaylistsResultList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<GetPlaylistsResult> l = new ArrayList<GetPlaylistsResult>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new GetPlaylistsResult(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<GetPlaylistsResult>(0);
            }

            public static interface Type {
                public static final String UNKNOWN = "unknown";
                public static final String VIDEO = "video";
                public static final String AUDIO = "audio";
                public static final String PICTURE = "picture";
                public static final String MIXED = "mixed";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "video", "audio", "picture", "mixed"));
            }
        }
    }

    public static class GetItems
    extends AbstractCall<ListModel.AllItems> {
        public static final String API_TYPE = "Playlist.GetItems";
        public static final String RESULT = "items";

        public GetItems(Integer playlistid, ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("playlistid", playlistid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetItems(Integer playlistid, String ... properties) {
            this.addParameter("playlistid", playlistid);
            this.addParameter("properties", properties);
        }

        public GetItems(Integer playlistid, ListModel.Limits limits, String ... properties) {
            this.addParameter("playlistid", playlistid);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetItems(Integer playlistid, ListModel.Sort sort, String ... properties) {
            this.addParameter("playlistid", playlistid);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<ListModel.AllItems> parseMany(JsonNode node) {
            ArrayNode items = this.parseResults(node, RESULT);
            if (items != null) {
                ArrayList<ListModel.AllItems> ret = new ArrayList<ListModel.AllItems>(items.size());
                for (int i = 0; i < items.size(); ++i) {
                    ObjectNode item = (ObjectNode)items.get(i);
                    ret.add(new ListModel.AllItems((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<ListModel.AllItems>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class Clear
    extends AbstractCall<String> {
        public static final String API_TYPE = "Playlist.Clear";

        public Clear(Integer playlistid) {
            this.addParameter("playlistid", playlistid);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Add
    extends AbstractCall<String> {
        public static final String API_TYPE = "Playlist.Add";

        public Add(Integer playlistid, PlaylistModel.Item item) {
            this.addParameter("playlistid", playlistid);
            this.addParameter("item", (AbstractModel)item);
        }

        public Add(Integer playlistid, PlaylistModel.Item ... item) {
            this.addParameter("playlistid", playlistid);
            this.addParameter("item", item);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

