/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.TexturesModel;

public final class Textures {

    public static class RemoveTexture
    extends AbstractCall<String> {
        public static final String API_TYPE = "Textures.RemoveTexture";

        public RemoveTexture(Integer textureid) {
            this.addParameter("textureid", textureid);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetTextures
    extends AbstractCall<TexturesModel.TextureDetail> {
        public static final String API_TYPE = "Textures.GetTextures";
        public static final String RESULT = "textures";

        public GetTextures(ListModel.TextureFilter filter, String ... properties) {
            this.addParameter("filter", (AbstractModel)filter);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<TexturesModel.TextureDetail> parseMany(JsonNode node) {
            ArrayNode textures = this.parseResults(node, RESULT);
            if (textures != null) {
                ArrayList<TexturesModel.TextureDetail> ret = new ArrayList<TexturesModel.TextureDetail>(textures.size());
                for (int i = 0; i < textures.size(); ++i) {
                    ObjectNode item = (ObjectNode)textures.get(i);
                    ret.add(new TexturesModel.TextureDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<TexturesModel.TextureDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }
}

