/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ItemModel;

public final class AddonModel {

    public static interface Types {
        public static final String UNKNOWN = "unknown";
        public static final String XBMC_PLAYER_MUSICVIZ = "xbmc.player.musicviz";
        public static final String XBMC_GUI_SKIN = "xbmc.gui.skin";
        public static final String XBMC_PVRCLIENT = "xbmc.pvrclient";
        public static final String KODI_ADSP = "kodi.adsp";
        public static final String XBMC_PYTHON_SCRIPT = "xbmc.python.script";
        public static final String XBMC_PYTHON_WEATHER = "xbmc.python.weather";
        public static final String XBMC_SUBTITLE_MODULE = "xbmc.subtitle.module";
        public static final String XBMC_PYTHON_LYRICS = "xbmc.python.lyrics";
        public static final String XBMC_METADATA_SCRAPER_ALBUMS = "xbmc.metadata.scraper.albums";
        public static final String XBMC_METADATA_SCRAPER_ARTISTS = "xbmc.metadata.scraper.artists";
        public static final String XBMC_METADATA_SCRAPER_MOVIES = "xbmc.metadata.scraper.movies";
        public static final String XBMC_METADATA_SCRAPER_MUSICVIDEOS = "xbmc.metadata.scraper.musicvideos";
        public static final String XBMC_METADATA_SCRAPER_TVSHOWS = "xbmc.metadata.scraper.tvshows";
        public static final String XBMC_UI_SCREENSAVER = "xbmc.ui.screensaver";
        public static final String XBMC_PYTHON_PLUGINSOURCE = "xbmc.python.pluginsource";
        public static final String XBMC_ADDON_REPOSITORY = "xbmc.addon.repository";
        public static final String XBMC_WEBINTERFACE = "xbmc.webinterface";
        public static final String XBMC_SERVICE = "xbmc.service";
        public static final String XBMC_AUDIOENCODER = "xbmc.audioencoder";
        public static final String KODI_CONTEXT_ITEM = "kodi.context.item";
        public static final String KODI_AUDIODECODER = "kodi.audiodecoder";
        public static final String KODI_RESOURCE_IMAGES = "kodi.resource.images";
        public static final String KODI_RESOURCE_LANGUAGE = "kodi.resource.language";
        public static final String KODI_RESOURCE_UISOUNDS = "kodi.resource.uisounds";
        public static final String XBMC_ADDON_VIDEO = "xbmc.addon.video";
        public static final String XBMC_ADDON_AUDIO = "xbmc.addon.audio";
        public static final String XBMC_ADDON_IMAGE = "xbmc.addon.image";
        public static final String XBMC_ADDON_EXECUTABLE = "xbmc.addon.executable";
        public static final String VISUALIZATION_LIBRARY = "visualization-library";
        public static final String XBMC_METADATA_SCRAPER_LIBRARY = "xbmc.metadata.scraper.library";
        public static final String XBMC_PYTHON_LIBRARY = "xbmc.python.library";
        public static final String XBMC_PYTHON_MODULE = "xbmc.python.module";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "xbmc.player.musicviz", "xbmc.gui.skin", "xbmc.pvrclient", "kodi.adsp", "xbmc.python.script", "xbmc.python.weather", "xbmc.subtitle.module", "xbmc.python.lyrics", "xbmc.metadata.scraper.albums", "xbmc.metadata.scraper.artists", "xbmc.metadata.scraper.movies", "xbmc.metadata.scraper.musicvideos", "xbmc.metadata.scraper.tvshows", "xbmc.ui.screensaver", "xbmc.python.pluginsource", "xbmc.addon.repository", "xbmc.webinterface", "xbmc.service", "xbmc.audioencoder", "kodi.context.item", "kodi.audiodecoder", "kodi.resource.images", "kodi.resource.language", "kodi.resource.uisounds", "xbmc.addon.video", "xbmc.addon.audio", "xbmc.addon.image", "xbmc.addon.executable", "visualization-library", "xbmc.metadata.scraper.library", "xbmc.python.library", "xbmc.python.module"));
    }

    public static interface Fields {
        public static final String NAME = "name";
        public static final String VERSION = "version";
        public static final String SUMMARY = "summary";
        public static final String DESCRIPTION = "description";
        public static final String PATH = "path";
        public static final String AUTHOR = "author";
        public static final String THUMBNAIL = "thumbnail";
        public static final String DISCLAIMER = "disclaimer";
        public static final String FANART = "fanart";
        public static final String DEPENDENCIES = "dependencies";
        public static final String BROKEN = "broken";
        public static final String EXTRAINFO = "extrainfo";
        public static final String RATING = "rating";
        public static final String ENABLED = "enabled";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("name", "version", "summary", "description", "path", "author", "thumbnail", "disclaimer", "fanart", "dependencies", "broken", "extrainfo", "rating", "enabled"));
    }

    public static interface Content {
        public static final String UNKNOWN = "unknown";
        public static final String VIDEO = "video";
        public static final String AUDIO = "audio";
        public static final String IMAGE = "image";
        public static final String EXECUTABLE = "executable";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "video", "audio", "image", "executable"));
    }

    public static class Detail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "Addon.Details";
        public static final String ADDONID = "addonid";
        public static final String AUTHOR = "author";
        public static final String BROKEN = "broken";
        public static final String DEPENDENCIES = "dependencies";
        public static final String DESCRIPTION = "description";
        public static final String DISCLAIMER = "disclaimer";
        public static final String ENABLED = "enabled";
        public static final String EXTRAINFO = "extrainfo";
        public static final String FANART = "fanart";
        public static final String NAME = "name";
        public static final String PATH = "path";
        public static final String RATING = "rating";
        public static final String SUMMARY = "summary";
        public static final String THUMBNAIL = "thumbnail";
        public static final String TYPE = "type";
        public static final String VERSION = "version";
        public final String addonid;
        public final String author;
        public final Broken broken;
        public final List<Dependency> dependencies;
        public final String description;
        public final String disclaimer;
        public final Boolean enabled;
        public final List<Extrainfo> extrainfo;
        public final String fanart;
        public final String name;
        public final String path;
        public final Integer rating;
        public final String summary;
        public final String thumbnail;
        public final String type;
        public final String version;

        public Detail(JsonNode node) {
            super(node);
            this.addonid = node.get(ADDONID).getTextValue();
            this.author = Detail.parseString(node, AUTHOR);
            this.broken = node.has(BROKEN) ? new Broken(node.get(BROKEN)) : null;
            this.dependencies = Dependency.getAddonModelDependencyList(node, DEPENDENCIES);
            this.description = Detail.parseString(node, DESCRIPTION);
            this.disclaimer = Detail.parseString(node, DISCLAIMER);
            this.enabled = Detail.parseBoolean(node, ENABLED);
            this.extrainfo = Extrainfo.getAddonModelExtrainfoList(node, EXTRAINFO);
            this.fanart = Detail.parseString(node, FANART);
            this.name = Detail.parseString(node, NAME);
            this.path = Detail.parseString(node, PATH);
            this.rating = Detail.parseInt(node, RATING);
            this.summary = Detail.parseString(node, SUMMARY);
            this.thumbnail = Detail.parseString(node, THUMBNAIL);
            this.type = Detail.parseString(node, TYPE);
            this.version = Detail.parseString(node, VERSION);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(ADDONID, this.addonid);
            node.put(AUTHOR, this.author);
            node.put(BROKEN, this.broken == null ? null : this.broken.toJsonNode());
            ArrayNode dependenciesArray = OM.createArrayNode();
            for (Dependency item : this.dependencies) {
                dependenciesArray.add(item.toJsonNode());
            }
            node.put(DEPENDENCIES, (JsonNode)dependenciesArray);
            node.put(DESCRIPTION, this.description);
            node.put(DISCLAIMER, this.disclaimer);
            node.put(ENABLED, this.enabled);
            ArrayNode extrainfoArray = OM.createArrayNode();
            for (Extrainfo item : this.extrainfo) {
                extrainfoArray.add(item.toJsonNode());
            }
            node.put(EXTRAINFO, (JsonNode)extrainfoArray);
            node.put(FANART, this.fanart);
            node.put(NAME, this.name);
            node.put(PATH, this.path);
            node.put(RATING, this.rating);
            node.put(SUMMARY, this.summary);
            node.put(THUMBNAIL, this.thumbnail);
            node.put(TYPE, this.type);
            node.put(VERSION, this.version);
            return node;
        }

        static List<Detail> getAddonModelDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<Detail> l = new ArrayList<Detail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new Detail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<Detail>(0);
        }

        public static interface Type {
            public static final String UNKNOWN = "unknown";
            public static final String XBMC_PLAYER_MUSICVIZ = "xbmc.player.musicviz";
            public static final String XBMC_GUI_SKIN = "xbmc.gui.skin";
            public static final String XBMC_PVRCLIENT = "xbmc.pvrclient";
            public static final String KODI_ADSP = "kodi.adsp";
            public static final String XBMC_PYTHON_SCRIPT = "xbmc.python.script";
            public static final String XBMC_PYTHON_WEATHER = "xbmc.python.weather";
            public static final String XBMC_SUBTITLE_MODULE = "xbmc.subtitle.module";
            public static final String XBMC_PYTHON_LYRICS = "xbmc.python.lyrics";
            public static final String XBMC_METADATA_SCRAPER_ALBUMS = "xbmc.metadata.scraper.albums";
            public static final String XBMC_METADATA_SCRAPER_ARTISTS = "xbmc.metadata.scraper.artists";
            public static final String XBMC_METADATA_SCRAPER_MOVIES = "xbmc.metadata.scraper.movies";
            public static final String XBMC_METADATA_SCRAPER_MUSICVIDEOS = "xbmc.metadata.scraper.musicvideos";
            public static final String XBMC_METADATA_SCRAPER_TVSHOWS = "xbmc.metadata.scraper.tvshows";
            public static final String XBMC_UI_SCREENSAVER = "xbmc.ui.screensaver";
            public static final String XBMC_PYTHON_PLUGINSOURCE = "xbmc.python.pluginsource";
            public static final String XBMC_ADDON_REPOSITORY = "xbmc.addon.repository";
            public static final String XBMC_WEBINTERFACE = "xbmc.webinterface";
            public static final String XBMC_SERVICE = "xbmc.service";
            public static final String XBMC_AUDIOENCODER = "xbmc.audioencoder";
            public static final String KODI_CONTEXT_ITEM = "kodi.context.item";
            public static final String KODI_AUDIODECODER = "kodi.audiodecoder";
            public static final String KODI_RESOURCE_IMAGES = "kodi.resource.images";
            public static final String KODI_RESOURCE_LANGUAGE = "kodi.resource.language";
            public static final String KODI_RESOURCE_UISOUNDS = "kodi.resource.uisounds";
            public static final String XBMC_ADDON_VIDEO = "xbmc.addon.video";
            public static final String XBMC_ADDON_AUDIO = "xbmc.addon.audio";
            public static final String XBMC_ADDON_IMAGE = "xbmc.addon.image";
            public static final String XBMC_ADDON_EXECUTABLE = "xbmc.addon.executable";
            public static final String VISUALIZATION_LIBRARY = "visualization-library";
            public static final String XBMC_METADATA_SCRAPER_LIBRARY = "xbmc.metadata.scraper.library";
            public static final String XBMC_PYTHON_LIBRARY = "xbmc.python.library";
            public static final String XBMC_PYTHON_MODULE = "xbmc.python.module";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "xbmc.player.musicviz", "xbmc.gui.skin", "xbmc.pvrclient", "kodi.adsp", "xbmc.python.script", "xbmc.python.weather", "xbmc.subtitle.module", "xbmc.python.lyrics", "xbmc.metadata.scraper.albums", "xbmc.metadata.scraper.artists", "xbmc.metadata.scraper.movies", "xbmc.metadata.scraper.musicvideos", "xbmc.metadata.scraper.tvshows", "xbmc.ui.screensaver", "xbmc.python.pluginsource", "xbmc.addon.repository", "xbmc.webinterface", "xbmc.service", "xbmc.audioencoder", "kodi.context.item", "kodi.audiodecoder", "kodi.resource.images", "kodi.resource.language", "kodi.resource.uisounds", "xbmc.addon.video", "xbmc.addon.audio", "xbmc.addon.image", "xbmc.addon.executable", "visualization-library", "xbmc.metadata.scraper.library", "xbmc.python.library", "xbmc.python.module"));
        }

        public static class Extrainfo
        extends AbstractModel {
            public static final String KEY = "key";
            public static final String VALUE = "value";
            public final String key;
            public final String value;

            public Extrainfo(String key, String value) {
                this.key = key;
                this.value = value;
            }

            public Extrainfo(JsonNode node) {
                this.key = node.get(KEY).getTextValue();
                this.value = node.get(VALUE).getTextValue();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(KEY, this.key);
                node.put(VALUE, this.value);
                return node;
            }

            static List<Extrainfo> getAddonModelExtrainfoList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<Extrainfo> l = new ArrayList<Extrainfo>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new Extrainfo(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<Extrainfo>(0);
            }
        }

        public static class Dependency
        extends AbstractModel {
            public static final String ADDONID = "addonid";
            public static final String OPTIONAL = "optional";
            public static final String VERSION = "version";
            public final String addonid;
            public final Boolean optional;
            public final String version;

            public Dependency(String addonid, Boolean optional, String version) {
                this.addonid = addonid;
                this.optional = optional;
                this.version = version;
            }

            public Dependency(JsonNode node) {
                this.addonid = node.get("addonid").getTextValue();
                this.optional = node.get(OPTIONAL).getBooleanValue();
                this.version = node.get("version").getTextValue();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put("addonid", this.addonid);
                node.put(OPTIONAL, this.optional);
                node.put("version", this.version);
                return node;
            }

            static List<Dependency> getAddonModelDependencyList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<Dependency> l = new ArrayList<Dependency>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new Dependency(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<Dependency>(0);
            }
        }

        public static class Broken
        extends AbstractModel {
            public final Boolean booleanArg;
            public final String stringArg;

            public Broken(Boolean booleanArg) {
                this.booleanArg = booleanArg;
                this.stringArg = null;
            }

            public Broken(String stringArg) {
                this.stringArg = stringArg;
                this.booleanArg = null;
            }

            public Broken(JsonNode node) {
                if (node.isBoolean()) {
                    this.booleanArg = node.getBooleanValue();
                    this.stringArg = null;
                } else if (node.isTextual()) {
                    this.stringArg = node.getTextValue();
                    this.booleanArg = null;
                } else {
                    throw new RuntimeException("Weird type for \"broken\", I'm confused!");
                }
            }

            @Override
            public JsonNode toJsonNode() {
                if (this.booleanArg != null) {
                    return this.booleanArg != false ? BooleanNode.TRUE : BooleanNode.FALSE;
                }
                if (this.stringArg != null) {
                    return new TextNode(this.stringArg);
                }
                return null;
            }

            static List<Broken> getAddonModelBrokenList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<Broken> l = new ArrayList<Broken>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new Broken(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<Broken>(0);
            }
        }
    }
}

