/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class ApplicationModel {

    public static interface PropertyName {
        public static final String VOLUME = "volume";
        public static final String MUTED = "muted";
        public static final String NAME = "name";
        public static final String VERSION = "version";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("volume", "muted", "name", "version"));
    }

    public static class PropertyValue
    extends AbstractModel {
        public static final String API_TYPE = "Application.Property.Value";
        public static final String MUTED = "muted";
        public static final String NAME = "name";
        public static final String VERSION = "version";
        public static final String VOLUME = "volume";
        public final Boolean muted;
        public final String name;
        public final Version version;
        public final Integer volume;

        public PropertyValue(Boolean muted, String name, Version version, Integer volume) {
            this.muted = muted;
            this.name = name;
            this.version = version;
            this.volume = volume;
        }

        public PropertyValue(JsonNode node) {
            this.muted = PropertyValue.parseBoolean(node, MUTED);
            this.name = PropertyValue.parseString(node, NAME);
            this.version = node.has(VERSION) ? new Version(node.get(VERSION)) : null;
            this.volume = PropertyValue.parseInt(node, VOLUME);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(MUTED, this.muted);
            node.put(NAME, this.name);
            node.put(VERSION, this.version == null ? null : this.version.toJsonNode());
            node.put(VOLUME, this.volume);
            return node;
        }

        static List<PropertyValue> getApplicationModelPropertyValueList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<PropertyValue> l = new ArrayList<PropertyValue>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new PropertyValue(a.get(i)));
                }
                return l;
            }
            return new ArrayList<PropertyValue>(0);
        }

        public static class Version
        extends AbstractModel {
            public static final String MAJOR = "major";
            public static final String MINOR = "minor";
            public static final String REVISION = "revision";
            public static final String TAG = "tag";
            public static final String TAGVERSION = "tagversion";
            public final Integer major;
            public final Integer minor;
            public final Revision revision;
            public final String tag;
            public final String tagversion;

            public Version(Integer major, Integer minor, Revision revision, String tag, String tagversion) {
                this.major = major;
                this.minor = minor;
                this.revision = revision;
                this.tag = tag;
                this.tagversion = tagversion;
            }

            public Version(JsonNode node) {
                this.major = node.get(MAJOR).getIntValue();
                this.minor = node.get(MINOR).getIntValue();
                this.revision = node.has(REVISION) ? new Revision(node.get(REVISION)) : null;
                this.tag = Version.parseString(node, TAG);
                this.tagversion = Version.parseString(node, TAGVERSION);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(MAJOR, this.major);
                node.put(MINOR, this.minor);
                node.put(REVISION, this.revision == null ? null : this.revision.toJsonNode());
                node.put(TAG, this.tag);
                node.put(TAGVERSION, this.tagversion);
                return node;
            }

            static List<Version> getApplicationModelVersionList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<Version> l = new ArrayList<Version>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new Version(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<Version>(0);
            }

            public static interface Tag {
                public static final String PREALPHA = "prealpha";
                public static final String ALPHA = "alpha";
                public static final String BETA = "beta";
                public static final String RELEASECANDIDATE = "releasecandidate";
                public static final String STABLE = "stable";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("prealpha", "alpha", "beta", "releasecandidate", "stable"));
            }

            public static class Revision
            extends AbstractModel {
                public final Integer integerArg;
                public final String stringArg;

                public Revision(Integer integerArg) {
                    this.integerArg = integerArg;
                    this.stringArg = null;
                }

                public Revision(String stringArg) {
                    this.stringArg = stringArg;
                    this.integerArg = null;
                }

                public Revision(JsonNode node) {
                    if (node.isInt()) {
                        this.integerArg = node.getIntValue();
                        this.stringArg = null;
                    } else if (node.isTextual()) {
                        this.stringArg = node.getTextValue();
                        this.integerArg = null;
                    } else {
                        throw new RuntimeException("Weird type for \"revision\", I'm confused!");
                    }
                }

                @Override
                public JsonNode toJsonNode() {
                    if (this.integerArg != null) {
                        return new IntNode(this.integerArg.intValue());
                    }
                    if (this.stringArg != null) {
                        return new TextNode(this.stringArg);
                    }
                    return null;
                }

                static List<Revision> getApplicationModelRevisionList(JsonNode node, String key) {
                    if (node.has(key)) {
                        ArrayNode a = (ArrayNode)node.get(key);
                        ArrayList<Revision> l = new ArrayList<Revision>(a.size());
                        for (int i = 0; i < a.size(); ++i) {
                            l.add(new Revision(a.get(i)));
                        }
                        return l;
                    }
                    return new ArrayList<Revision>(0);
                }
            }
        }
    }
}

