/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ItemModel;
import org.tinymediamanager.jsonrpc.api.model.MediaModel;
import org.tinymediamanager.jsonrpc.api.model.VideoModel;

public final class ListModel {

    public static interface OperatorFilters {
        public static final String CONTAINS = "contains";
        public static final String DOESNOTCONTAIN = "doesnotcontain";
        public static final String IS = "is";
        public static final String ISNOT = "isnot";
        public static final String STARTSWITH = "startswith";
        public static final String ENDSWITH = "endswith";
        public static final String GREATERTHAN = "greaterthan";
        public static final String LESSTHAN = "lessthan";
        public static final String AFTER = "after";
        public static final String BEFORE = "before";
        public static final String INTHELAST = "inthelast";
        public static final String NOTINTHELAST = "notinthelast";
        public static final String TRUE = "true";
        public static final String FALSE = "false";
        public static final String BETWEEN = "between";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("contains", "doesnotcontain", "is", "isnot", "startswith", "endswith", "greaterthan", "lessthan", "after", "before", "inthelast", "notinthelast", "true", "false", "between"));
    }

    public static interface TextureFilterFields {
        public static final String TEXTUREID = "textureid";
        public static final String URL = "url";
        public static final String CACHEDURL = "cachedurl";
        public static final String LASTHASHCHECK = "lasthashcheck";
        public static final String IMAGEHASH = "imagehash";
        public static final String WIDTH = "width";
        public static final String HEIGHT = "height";
        public static final String USECOUNT = "usecount";
        public static final String LASTUSED = "lastused";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("textureid", "url", "cachedurl", "lasthashcheck", "imagehash", "width", "height", "usecount", "lastused"));
    }

    public static interface TVShowFilterFields {
        public static final String TITLE = "title";
        public static final String PLOT = "plot";
        public static final String STATUS = "status";
        public static final String VOTES = "votes";
        public static final String RATING = "rating";
        public static final String YEAR = "year";
        public static final String GENRE = "genre";
        public static final String DIRECTOR = "director";
        public static final String ACTOR = "actor";
        public static final String NUMEPISODES = "numepisodes";
        public static final String NUMWATCHED = "numwatched";
        public static final String PLAYCOUNT = "playcount";
        public static final String PATH = "path";
        public static final String STUDIO = "studio";
        public static final String MPAARATING = "mpaarating";
        public static final String DATEADDED = "dateadded";
        public static final String LASTPLAYED = "lastplayed";
        public static final String INPROGRESS = "inprogress";
        public static final String TAG = "tag";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "status", "votes", "rating", "year", "genre", "director", "actor", "numepisodes", "numwatched", "playcount", "path", "studio", "mpaarating", "dateadded", "lastplayed", "inprogress", "tag", "playlist", "virtualfolder"));
    }

    public static interface SongFilterFields {
        public static final String GENRE = "genre";
        public static final String ALBUM = "album";
        public static final String ARTIST = "artist";
        public static final String ALBUMARTIST = "albumartist";
        public static final String TITLE = "title";
        public static final String YEAR = "year";
        public static final String TIME = "time";
        public static final String TRACKNUMBER = "tracknumber";
        public static final String FILENAME = "filename";
        public static final String PATH = "path";
        public static final String PLAYCOUNT = "playcount";
        public static final String LASTPLAYED = "lastplayed";
        public static final String RATING = "rating";
        public static final String COMMENT = "comment";
        public static final String MOODS = "moods";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("genre", "album", "artist", "albumartist", "title", "year", "time", "tracknumber", "filename", "path", "playcount", "lastplayed", "rating", "comment", "moods", "playlist", "virtualfolder"));
    }

    public static interface MusicVideoFilterFields {
        public static final String TITLE = "title";
        public static final String GENRE = "genre";
        public static final String ALBUM = "album";
        public static final String YEAR = "year";
        public static final String ARTIST = "artist";
        public static final String FILENAME = "filename";
        public static final String PATH = "path";
        public static final String PLAYCOUNT = "playcount";
        public static final String LASTPLAYED = "lastplayed";
        public static final String TIME = "time";
        public static final String DIRECTOR = "director";
        public static final String STUDIO = "studio";
        public static final String PLOT = "plot";
        public static final String TAG = "tag";
        public static final String DATEADDED = "dateadded";
        public static final String VIDEORESOLUTION = "videoresolution";
        public static final String AUDIOCHANNELS = "audiochannels";
        public static final String VIDEOCODEC = "videocodec";
        public static final String AUDIOCODEC = "audiocodec";
        public static final String AUDIOLANGUAGE = "audiolanguage";
        public static final String SUBTITLELANGUAGE = "subtitlelanguage";
        public static final String VIDEOASPECT = "videoaspect";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "genre", "album", "year", "artist", "filename", "path", "playcount", "lastplayed", "time", "director", "studio", "plot", "tag", "dateadded", "videoresolution", "audiochannels", "videocodec", "audiocodec", "audiolanguage", "subtitlelanguage", "videoaspect", "playlist", "virtualfolder"));
    }

    public static interface MovieFilterFields {
        public static final String TITLE = "title";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String TAGLINE = "tagline";
        public static final String VOTES = "votes";
        public static final String RATING = "rating";
        public static final String TIME = "time";
        public static final String WRITERS = "writers";
        public static final String PLAYCOUNT = "playcount";
        public static final String LASTPLAYED = "lastplayed";
        public static final String INPROGRESS = "inprogress";
        public static final String GENRE = "genre";
        public static final String COUNTRY = "country";
        public static final String YEAR = "year";
        public static final String DIRECTOR = "director";
        public static final String ACTOR = "actor";
        public static final String MPAARATING = "mpaarating";
        public static final String TOP250 = "top250";
        public static final String STUDIO = "studio";
        public static final String HASTRAILER = "hastrailer";
        public static final String FILENAME = "filename";
        public static final String PATH = "path";
        public static final String SET = "set";
        public static final String TAG = "tag";
        public static final String DATEADDED = "dateadded";
        public static final String VIDEORESOLUTION = "videoresolution";
        public static final String AUDIOCHANNELS = "audiochannels";
        public static final String VIDEOCODEC = "videocodec";
        public static final String AUDIOCODEC = "audiocodec";
        public static final String AUDIOLANGUAGE = "audiolanguage";
        public static final String SUBTITLELANGUAGE = "subtitlelanguage";
        public static final String VIDEOASPECT = "videoaspect";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "plotoutline", "tagline", "votes", "rating", "time", "writers", "playcount", "lastplayed", "inprogress", "genre", "country", "year", "director", "actor", "mpaarating", "top250", "studio", "hastrailer", "filename", "path", "set", "tag", "dateadded", "videoresolution", "audiochannels", "videocodec", "audiocodec", "audiolanguage", "subtitlelanguage", "videoaspect", "playlist", "virtualfolder"));
    }

    public static interface EpisodeFilterFields {
        public static final String TITLE = "title";
        public static final String TVSHOW = "tvshow";
        public static final String PLOT = "plot";
        public static final String VOTES = "votes";
        public static final String RATING = "rating";
        public static final String TIME = "time";
        public static final String WRITERS = "writers";
        public static final String AIRDATE = "airdate";
        public static final String PLAYCOUNT = "playcount";
        public static final String LASTPLAYED = "lastplayed";
        public static final String INPROGRESS = "inprogress";
        public static final String GENRE = "genre";
        public static final String YEAR = "year";
        public static final String DIRECTOR = "director";
        public static final String ACTOR = "actor";
        public static final String EPISODE = "episode";
        public static final String SEASON = "season";
        public static final String FILENAME = "filename";
        public static final String PATH = "path";
        public static final String STUDIO = "studio";
        public static final String MPAARATING = "mpaarating";
        public static final String DATEADDED = "dateadded";
        public static final String TAG = "tag";
        public static final String VIDEORESOLUTION = "videoresolution";
        public static final String AUDIOCHANNELS = "audiochannels";
        public static final String VIDEOCODEC = "videocodec";
        public static final String AUDIOCODEC = "audiocodec";
        public static final String AUDIOLANGUAGE = "audiolanguage";
        public static final String SUBTITLELANGUAGE = "subtitlelanguage";
        public static final String VIDEOASPECT = "videoaspect";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "tvshow", "plot", "votes", "rating", "time", "writers", "airdate", "playcount", "lastplayed", "inprogress", "genre", "year", "director", "actor", "episode", "season", "filename", "path", "studio", "mpaarating", "dateadded", "tag", "videoresolution", "audiochannels", "videocodec", "audiocodec", "audiolanguage", "subtitlelanguage", "videoaspect", "playlist", "virtualfolder"));
    }

    public static interface ArtistFilterFields {
        public static final String ARTIST = "artist";
        public static final String GENRE = "genre";
        public static final String MOODS = "moods";
        public static final String STYLES = "styles";
        public static final String INSTRUMENTS = "instruments";
        public static final String BIOGRAPHY = "biography";
        public static final String BORN = "born";
        public static final String BANDFORMED = "bandformed";
        public static final String DISBANDED = "disbanded";
        public static final String DIED = "died";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("artist", "genre", "moods", "styles", "instruments", "biography", "born", "bandformed", "disbanded", "died", "playlist", "virtualfolder"));
    }

    public static interface AlbumFilterFields {
        public static final String GENRE = "genre";
        public static final String ALBUM = "album";
        public static final String ARTIST = "artist";
        public static final String ALBUMARTIST = "albumartist";
        public static final String YEAR = "year";
        public static final String REVIEW = "review";
        public static final String THEMES = "themes";
        public static final String MOODS = "moods";
        public static final String STYLES = "styles";
        public static final String TYPE = "type";
        public static final String LABEL = "label";
        public static final String RATING = "rating";
        public static final String PLAYCOUNT = "playcount";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("genre", "album", "artist", "albumartist", "year", "review", "themes", "moods", "styles", "type", "label", "rating", "playcount", "playlist", "virtualfolder"));
    }

    public static interface FileFields {
        public static final String TITLE = "title";
        public static final String ARTIST = "artist";
        public static final String ALBUMARTIST = "albumartist";
        public static final String GENRE = "genre";
        public static final String YEAR = "year";
        public static final String RATING = "rating";
        public static final String ALBUM = "album";
        public static final String TRACK = "track";
        public static final String DURATION = "duration";
        public static final String COMMENT = "comment";
        public static final String LYRICS = "lyrics";
        public static final String MUSICBRAINZTRACKID = "musicbrainztrackid";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String MUSICBRAINZALBUMID = "musicbrainzalbumid";
        public static final String MUSICBRAINZALBUMARTISTID = "musicbrainzalbumartistid";
        public static final String PLAYCOUNT = "playcount";
        public static final String FANART = "fanart";
        public static final String DIRECTOR = "director";
        public static final String TRAILER = "trailer";
        public static final String TAGLINE = "tagline";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String LASTPLAYED = "lastplayed";
        public static final String WRITER = "writer";
        public static final String STUDIO = "studio";
        public static final String MPAA = "mpaa";
        public static final String CAST = "cast";
        public static final String COUNTRY = "country";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String PREMIERED = "premiered";
        public static final String PRODUCTIONCODE = "productioncode";
        public static final String RUNTIME = "runtime";
        public static final String SET = "set";
        public static final String SHOWLINK = "showlink";
        public static final String STREAMDETAILS = "streamdetails";
        public static final String TOP250 = "top250";
        public static final String VOTES = "votes";
        public static final String FIRSTAIRED = "firstaired";
        public static final String SEASON = "season";
        public static final String EPISODE = "episode";
        public static final String SHOWTITLE = "showtitle";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String RESUME = "resume";
        public static final String ARTISTID = "artistid";
        public static final String ALBUMID = "albumid";
        public static final String TVSHOWID = "tvshowid";
        public static final String SETID = "setid";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public static final String DISC = "disc";
        public static final String TAG = "tag";
        public static final String ART = "art";
        public static final String GENREID = "genreid";
        public static final String DISPLAYARTIST = "displayartist";
        public static final String ALBUMARTISTID = "albumartistid";
        public static final String DESCRIPTION = "description";
        public static final String THEME = "theme";
        public static final String MOOD = "mood";
        public static final String STYLE = "style";
        public static final String ALBUMLABEL = "albumlabel";
        public static final String SORTTITLE = "sorttitle";
        public static final String EPISODEGUIDE = "episodeguide";
        public static final String UNIQUEID = "uniqueid";
        public static final String DATEADDED = "dateadded";
        public static final String SIZE = "size";
        public static final String LASTMODIFIED = "lastmodified";
        public static final String MIMETYPE = "mimetype";
        public static final String SPECIALSORTSEASON = "specialsortseason";
        public static final String SPECIALSORTEPISODE = "specialsortepisode";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "artist", "albumartist", "genre", "year", "rating", "album", "track", "duration", "comment", "lyrics", "musicbrainztrackid", "musicbrainzartistid", "musicbrainzalbumid", "musicbrainzalbumartistid", "playcount", "fanart", "director", "trailer", "tagline", "plot", "plotoutline", "originaltitle", "lastplayed", "writer", "studio", "mpaa", "cast", "country", "imdbnumber", "premiered", "productioncode", "runtime", "set", "showlink", "streamdetails", "top250", "votes", "firstaired", "season", "episode", "showtitle", "thumbnail", "file", "resume", "artistid", "albumid", "tvshowid", "setid", "watchedepisodes", "disc", "tag", "art", "genreid", "displayartist", "albumartistid", "description", "theme", "mood", "style", "albumlabel", "sorttitle", "episodeguide", "uniqueid", "dateadded", "size", "lastmodified", "mimetype", "specialsortseason", "specialsortepisode"));
    }

    public static interface AllFields {
        public static final String TITLE = "title";
        public static final String ARTIST = "artist";
        public static final String ALBUMARTIST = "albumartist";
        public static final String GENRE = "genre";
        public static final String YEAR = "year";
        public static final String RATING = "rating";
        public static final String ALBUM = "album";
        public static final String TRACK = "track";
        public static final String DURATION = "duration";
        public static final String COMMENT = "comment";
        public static final String LYRICS = "lyrics";
        public static final String MUSICBRAINZTRACKID = "musicbrainztrackid";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String MUSICBRAINZALBUMID = "musicbrainzalbumid";
        public static final String MUSICBRAINZALBUMARTISTID = "musicbrainzalbumartistid";
        public static final String PLAYCOUNT = "playcount";
        public static final String FANART = "fanart";
        public static final String DIRECTOR = "director";
        public static final String TRAILER = "trailer";
        public static final String TAGLINE = "tagline";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String LASTPLAYED = "lastplayed";
        public static final String WRITER = "writer";
        public static final String STUDIO = "studio";
        public static final String MPAA = "mpaa";
        public static final String CAST = "cast";
        public static final String COUNTRY = "country";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String PREMIERED = "premiered";
        public static final String PRODUCTIONCODE = "productioncode";
        public static final String RUNTIME = "runtime";
        public static final String SET = "set";
        public static final String SHOWLINK = "showlink";
        public static final String STREAMDETAILS = "streamdetails";
        public static final String TOP250 = "top250";
        public static final String VOTES = "votes";
        public static final String FIRSTAIRED = "firstaired";
        public static final String SEASON = "season";
        public static final String EPISODE = "episode";
        public static final String SHOWTITLE = "showtitle";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String RESUME = "resume";
        public static final String ARTISTID = "artistid";
        public static final String ALBUMID = "albumid";
        public static final String TVSHOWID = "tvshowid";
        public static final String SETID = "setid";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public static final String DISC = "disc";
        public static final String TAG = "tag";
        public static final String ART = "art";
        public static final String GENREID = "genreid";
        public static final String DISPLAYARTIST = "displayartist";
        public static final String ALBUMARTISTID = "albumartistid";
        public static final String DESCRIPTION = "description";
        public static final String THEME = "theme";
        public static final String MOOD = "mood";
        public static final String STYLE = "style";
        public static final String ALBUMLABEL = "albumlabel";
        public static final String SORTTITLE = "sorttitle";
        public static final String EPISODEGUIDE = "episodeguide";
        public static final String UNIQUEID = "uniqueid";
        public static final String DATEADDED = "dateadded";
        public static final String CHANNEL = "channel";
        public static final String CHANNELTYPE = "channeltype";
        public static final String HIDDEN = "hidden";
        public static final String LOCKED = "locked";
        public static final String CHANNELNUMBER = "channelnumber";
        public static final String STARTTIME = "starttime";
        public static final String ENDTIME = "endtime";
        public static final String SPECIALSORTSEASON = "specialsortseason";
        public static final String SPECIALSORTEPISODE = "specialsortepisode";
        public static final String COMPILATION = "compilation";
        public static final String RELEASETYPE = "releasetype";
        public static final String ALBUMRELEASETYPE = "albumreleasetype";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "artist", "albumartist", "genre", "year", "rating", "album", "track", "duration", "comment", "lyrics", "musicbrainztrackid", "musicbrainzartistid", "musicbrainzalbumid", "musicbrainzalbumartistid", "playcount", "fanart", "director", "trailer", "tagline", "plot", "plotoutline", "originaltitle", "lastplayed", "writer", "studio", "mpaa", "cast", "country", "imdbnumber", "premiered", "productioncode", "runtime", "set", "showlink", "streamdetails", "top250", "votes", "firstaired", "season", "episode", "showtitle", "thumbnail", "file", "resume", "artistid", "albumid", "tvshowid", "setid", "watchedepisodes", "disc", "tag", "art", "genreid", "displayartist", "albumartistid", "description", "theme", "mood", "style", "albumlabel", "sorttitle", "episodeguide", "uniqueid", "dateadded", "channel", "channeltype", "hidden", "locked", "channelnumber", "starttime", "endtime", "specialsortseason", "specialsortepisode", "compilation", "releasetype", "albumreleasetype"));
    }

    public static class Sort
    extends AbstractModel {
        public static final String API_TYPE = "List.Sort";
        public static final String IGNOREARTICLE = "ignorearticle";
        public static final String METHOD = "method";
        public static final String ORDER = "order";
        public final Boolean ignorearticle;
        public final String method;
        public final String order;

        public Sort(Boolean ignorearticle, String method, String order) {
            this.ignorearticle = ignorearticle;
            this.method = method;
            this.order = order;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(IGNOREARTICLE, this.ignorearticle);
            node.put(METHOD, this.method);
            node.put(ORDER, this.order);
            return node;
        }

        public static interface Method {
            public static final String NONE = "none";
            public static final String LABEL = "label";
            public static final String DATE = "date";
            public static final String SIZE = "size";
            public static final String FILE = "file";
            public static final String PATH = "path";
            public static final String DRIVETYPE = "drivetype";
            public static final String TITLE = "title";
            public static final String TRACK = "track";
            public static final String TIME = "time";
            public static final String ARTIST = "artist";
            public static final String ALBUM = "album";
            public static final String ALBUMTYPE = "albumtype";
            public static final String GENRE = "genre";
            public static final String COUNTRY = "country";
            public static final String YEAR = "year";
            public static final String RATING = "rating";
            public static final String VOTES = "votes";
            public static final String TOP250 = "top250";
            public static final String PROGRAMCOUNT = "programcount";
            public static final String PLAYLIST = "playlist";
            public static final String EPISODE = "episode";
            public static final String SEASON = "season";
            public static final String TOTALEPISODES = "totalepisodes";
            public static final String WATCHEDEPISODES = "watchedepisodes";
            public static final String TVSHOWSTATUS = "tvshowstatus";
            public static final String TVSHOWTITLE = "tvshowtitle";
            public static final String SORTTITLE = "sorttitle";
            public static final String PRODUCTIONCODE = "productioncode";
            public static final String MPAA = "mpaa";
            public static final String STUDIO = "studio";
            public static final String DATEADDED = "dateadded";
            public static final String LASTPLAYED = "lastplayed";
            public static final String PLAYCOUNT = "playcount";
            public static final String LISTENERS = "listeners";
            public static final String BITRATE = "bitrate";
            public static final String RANDOM = "random";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("none", "label", "date", "size", "file", "path", "drivetype", "title", "track", "time", "artist", "album", "albumtype", "genre", "country", "year", "rating", "votes", "top250", "programcount", "playlist", "episode", "season", "totalepisodes", "watchedepisodes", "tvshowstatus", "tvshowtitle", "sorttitle", "productioncode", "mpaa", "studio", "dateadded", "lastplayed", "playcount", "listeners", "bitrate", "random"));
        }

        public static interface Order {
            public static final String ASCENDING = "ascending";
            public static final String DESCENDING = "descending";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("ascending", "descending"));
        }
    }

    public static class LimitsReturned
    extends AbstractModel {
        public static final String API_TYPE = "List.LimitsReturned";
        public static final String END = "end";
        public static final String START = "start";
        public static final String TOTAL = "total";
        public final Integer end;
        public final Integer start;
        public final Integer total;

        public LimitsReturned(Integer end, Integer start, Integer total) {
            this.end = end;
            this.start = start;
            this.total = total;
        }

        public LimitsReturned(JsonNode node) {
            this.end = LimitsReturned.parseInt(node, END);
            this.start = LimitsReturned.parseInt(node, START);
            this.total = node.get(TOTAL).getIntValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(END, this.end);
            node.put(START, this.start);
            node.put(TOTAL, this.total);
            return node;
        }

        static List<LimitsReturned> getListModelLimitsReturnedList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<LimitsReturned> l = new ArrayList<LimitsReturned>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new LimitsReturned(a.get(i)));
                }
                return l;
            }
            return new ArrayList<LimitsReturned>(0);
        }
    }

    public static class Limits
    extends AbstractModel {
        public static final String API_TYPE = "List.Limits";
        public static final String END = "end";
        public static final String START = "start";
        public final Integer end;
        public final Integer start;

        public Limits(Integer end, Integer start) {
            this.end = end;
            this.start = start;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(END, this.end);
            node.put(START, this.start);
            return node;
        }
    }

    public static class SourceItem
    extends ItemModel.BaseDetail {
        public static final String FILE = "file";
        public final String file;

        public SourceItem(JsonNode node) {
            super(node);
            this.file = node.get(FILE).getTextValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FILE, this.file);
            return node;
        }

        static List<SourceItem> getListModelSourceItemList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SourceItem> l = new ArrayList<SourceItem>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SourceItem(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SourceItem>(0);
        }
    }

    public static class FileItem
    extends BaseItem {
        public static final String API_TYPE = "List.Item.File";
        public static final String FILE = "file";
        public static final String FILETYPE = "filetype";
        public static final String LASTMODIFIED = "lastmodified";
        public static final String MIMETYPE = "mimetype";
        public static final String SIZE = "size";
        public final String file;
        public final String filetype;
        public final String lastmodified;
        public final String mimetype;
        public final Integer size;

        public FileItem(JsonNode node) {
            super(node);
            this.file = node.get(FILE).getTextValue();
            this.filetype = FileItem.parseString(node, FILETYPE);
            this.lastmodified = FileItem.parseString(node, LASTMODIFIED);
            this.mimetype = FileItem.parseString(node, MIMETYPE);
            this.size = FileItem.parseInt(node, SIZE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FILE, this.file);
            node.put(FILETYPE, this.filetype);
            node.put(LASTMODIFIED, this.lastmodified);
            node.put(MIMETYPE, this.mimetype);
            node.put(SIZE, this.size);
            return node;
        }

        static List<FileItem> getListModelFileItemList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<FileItem> l = new ArrayList<FileItem>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new FileItem(a.get(i)));
                }
                return l;
            }
            return new ArrayList<FileItem>(0);
        }

        public static interface Filetype {
            public static final String FILE = "file";
            public static final String DIRECTORY = "directory";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("file", "directory"));
        }
    }

    public static class BaseItem
    extends AbstractModel {
        public static final String API_TYPE = "List.Item.Base";
        public static final String ALBUM = "album";
        public static final String ALBUMARTIST = "albumartist";
        public static final String ALBUMARTISTID = "albumartistid";
        public static final String ALBUMID = "albumid";
        public static final String ALBUMLABEL = "albumlabel";
        public static final String ALBUMRELEASETYPE = "albumreleasetype";
        public static final String ART = "art";
        public static final String ARTIST = "artist";
        public static final String ARTISTID = "artistid";
        public static final String CAST = "cast";
        public static final String COMMENT = "comment";
        public static final String COMPILATION = "compilation";
        public static final String COUNTRY = "country";
        public static final String DATEADDED = "dateadded";
        public static final String DESCRIPTION = "description";
        public static final String DIRECTOR = "director";
        public static final String DISC = "disc";
        public static final String DISPLAYARTIST = "displayartist";
        public static final String DURATION = "duration";
        public static final String EPISODE = "episode";
        public static final String EPISODEGUIDE = "episodeguide";
        public static final String FANART = "fanart";
        public static final String FILE = "file";
        public static final String FIRSTAIRED = "firstaired";
        public static final String GENRE = "genre";
        public static final String GENREID = "genreid";
        public static final String ID = "id";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String LABEL = "label";
        public static final String LASTPLAYED = "lastplayed";
        public static final String LYRICS = "lyrics";
        public static final String MOOD = "mood";
        public static final String MPAA = "mpaa";
        public static final String MUSICBRAINZALBUMARTISTID = "musicbrainzalbumartistid";
        public static final String MUSICBRAINZALBUMID = "musicbrainzalbumid";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String MUSICBRAINZTRACKID = "musicbrainztrackid";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String PLAYCOUNT = "playcount";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String PREMIERED = "premiered";
        public static final String PRODUCTIONCODE = "productioncode";
        public static final String RATING = "rating";
        public static final String RELEASETYPE = "releasetype";
        public static final String RESUME = "resume";
        public static final String RUNTIME = "runtime";
        public static final String SEASON = "season";
        public static final String SET = "set";
        public static final String SETID = "setid";
        public static final String SHOWLINK = "showlink";
        public static final String SHOWTITLE = "showtitle";
        public static final String SORTTITLE = "sorttitle";
        public static final String SPECIALSORTEPISODE = "specialsortepisode";
        public static final String SPECIALSORTSEASON = "specialsortseason";
        public static final String STREAMDETAILS = "streamdetails";
        public static final String STUDIO = "studio";
        public static final String STYLE = "style";
        public static final String TAG = "tag";
        public static final String TAGLINE = "tagline";
        public static final String THEME = "theme";
        public static final String THUMBNAIL = "thumbnail";
        public static final String TITLE = "title";
        public static final String TOP250 = "top250";
        public static final String TRACK = "track";
        public static final String TRAILER = "trailer";
        public static final String TVSHOWID = "tvshowid";
        public static final String TYPE = "type";
        public static final String UNIQUEID = "uniqueid";
        public static final String VOTES = "votes";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public static final String WRITER = "writer";
        public static final String YEAR = "year";
        public final String album;
        public final List<String> albumartist;
        public final List<Integer> albumartistid;
        public final Integer albumid;
        public final String albumlabel;
        public final String albumreleasetype;
        public final MediaModel.Artwork art;
        public final List<String> artist;
        public final List<Integer> artistid;
        public final List<VideoModel.Cast> cast;
        public final String comment;
        public final Boolean compilation;
        public final List<String> country;
        public final String dateadded;
        public final String description;
        public final List<String> director;
        public final Integer disc;
        public final String displayartist;
        public final Integer duration;
        public final Integer episode;
        public final String episodeguide;
        public final String fanart;
        public final String file;
        public final String firstaired;
        public final List<String> genre;
        public final List<Integer> genreid;
        public final Integer id;
        public final String imdbnumber;
        public final String label;
        public final String lastplayed;
        public final String lyrics;
        public final List<String> mood;
        public final String mpaa;
        public final String musicbrainzalbumartistid;
        public final String musicbrainzalbumid;
        public final String musicbrainzartistid;
        public final String musicbrainztrackid;
        public final String originaltitle;
        public final Integer playcount;
        public final String plot;
        public final String plotoutline;
        public final String premiered;
        public final String productioncode;
        public final Integer rating;
        public final String releasetype;
        public final VideoModel.Resume resume;
        public final Integer runtime;
        public final Integer season;
        public final String set;
        public final Integer setid;
        public final List<String> showlink;
        public final String showtitle;
        public final String sorttitle;
        public final Integer specialsortepisode;
        public final Integer specialsortseason;
        public final VideoModel.Streams streamdetails;
        public final List<String> studio;
        public final List<String> style;
        public final List<String> tag;
        public final String tagline;
        public final List<String> theme;
        public final String thumbnail;
        public final String title;
        public final Integer top250;
        public final Integer track;
        public final String trailer;
        public final Integer tvshowid;
        public final String type;
        public final HashMap<String, String> uniqueid;
        public final String votes;
        public final Integer watchedepisodes;
        public final List<String> writer;
        public final Integer year;

        public BaseItem(String album, List<String> albumartist, List<Integer> albumartistid, Integer albumid, String albumlabel, String albumreleasetype, MediaModel.Artwork art, List<String> artist, List<Integer> artistid, List<VideoModel.Cast> cast, String comment, Boolean compilation, List<String> country, String dateadded, String description, List<String> director, Integer disc, String displayartist, Integer duration, Integer episode, String episodeguide, String fanart, String file, String firstaired, List<String> genre, List<Integer> genreid, Integer id, String imdbnumber, String label, String lastplayed, String lyrics, List<String> mood, String mpaa, String musicbrainzalbumartistid, String musicbrainzalbumid, String musicbrainzartistid, String musicbrainztrackid, String originaltitle, Integer playcount, String plot, String plotoutline, String premiered, String productioncode, Integer rating, String releasetype, VideoModel.Resume resume, Integer runtime, Integer season, String set, Integer setid, List<String> showlink, String showtitle, String sorttitle, Integer specialsortepisode, Integer specialsortseason, VideoModel.Streams streamdetails, List<String> studio, List<String> style, List<String> tag, String tagline, List<String> theme, String thumbnail, String title, Integer top250, Integer track, String trailer, Integer tvshowid, String type, HashMap<String, String> uniqueid, String votes, Integer watchedepisodes, List<String> writer, Integer year) {
            this.album = album;
            this.albumartist = albumartist;
            this.albumartistid = albumartistid;
            this.albumid = albumid;
            this.albumlabel = albumlabel;
            this.albumreleasetype = albumreleasetype;
            this.art = art;
            this.artist = artist;
            this.artistid = artistid;
            this.cast = cast;
            this.comment = comment;
            this.compilation = compilation;
            this.country = country;
            this.dateadded = dateadded;
            this.description = description;
            this.director = director;
            this.disc = disc;
            this.displayartist = displayartist;
            this.duration = duration;
            this.episode = episode;
            this.episodeguide = episodeguide;
            this.fanart = fanart;
            this.file = file;
            this.firstaired = firstaired;
            this.genre = genre;
            this.genreid = genreid;
            this.id = id;
            this.imdbnumber = imdbnumber;
            this.label = label;
            this.lastplayed = lastplayed;
            this.lyrics = lyrics;
            this.mood = mood;
            this.mpaa = mpaa;
            this.musicbrainzalbumartistid = musicbrainzalbumartistid;
            this.musicbrainzalbumid = musicbrainzalbumid;
            this.musicbrainzartistid = musicbrainzartistid;
            this.musicbrainztrackid = musicbrainztrackid;
            this.originaltitle = originaltitle;
            this.playcount = playcount;
            this.plot = plot;
            this.plotoutline = plotoutline;
            this.premiered = premiered;
            this.productioncode = productioncode;
            this.rating = rating;
            this.releasetype = releasetype;
            this.resume = resume;
            this.runtime = runtime;
            this.season = season;
            this.set = set;
            this.setid = setid;
            this.showlink = showlink;
            this.showtitle = showtitle;
            this.sorttitle = sorttitle;
            this.specialsortepisode = specialsortepisode;
            this.specialsortseason = specialsortseason;
            this.streamdetails = streamdetails;
            this.studio = studio;
            this.style = style;
            this.tag = tag;
            this.tagline = tagline;
            this.theme = theme;
            this.thumbnail = thumbnail;
            this.title = title;
            this.top250 = top250;
            this.track = track;
            this.trailer = trailer;
            this.tvshowid = tvshowid;
            this.type = type;
            this.uniqueid = uniqueid;
            this.votes = votes;
            this.watchedepisodes = watchedepisodes;
            this.writer = writer;
            this.year = year;
        }

        public BaseItem(JsonNode node) {
            this.album = BaseItem.parseString(node, ALBUM);
            this.albumartist = BaseItem.getStringArray(node, ALBUMARTIST);
            this.albumartistid = BaseItem.getIntegerArray(node, ALBUMARTISTID);
            this.albumid = BaseItem.parseInt(node, ALBUMID);
            this.albumlabel = BaseItem.parseString(node, ALBUMLABEL);
            this.albumreleasetype = BaseItem.parseString(node, ALBUMRELEASETYPE);
            this.art = node.has(ART) ? new MediaModel.Artwork(node.get(ART)) : null;
            this.artist = BaseItem.getStringArray(node, ARTIST);
            this.artistid = BaseItem.getIntegerArray(node, ARTISTID);
            this.cast = VideoModel.Cast.getVideoModelCastList(node, CAST);
            this.comment = BaseItem.parseString(node, COMMENT);
            this.compilation = BaseItem.parseBoolean(node, COMPILATION);
            this.country = BaseItem.getStringArray(node, COUNTRY);
            this.dateadded = BaseItem.parseString(node, DATEADDED);
            this.description = BaseItem.parseString(node, DESCRIPTION);
            this.director = BaseItem.getStringArray(node, DIRECTOR);
            this.disc = BaseItem.parseInt(node, DISC);
            this.displayartist = BaseItem.parseString(node, DISPLAYARTIST);
            this.duration = BaseItem.parseInt(node, DURATION);
            this.episode = BaseItem.parseInt(node, EPISODE);
            this.episodeguide = BaseItem.parseString(node, EPISODEGUIDE);
            this.fanart = BaseItem.parseString(node, FANART);
            this.file = BaseItem.parseString(node, FILE);
            this.firstaired = BaseItem.parseString(node, FIRSTAIRED);
            this.genre = BaseItem.getStringArray(node, GENRE);
            this.genreid = BaseItem.getIntegerArray(node, GENREID);
            this.id = BaseItem.parseInt(node, ID);
            this.imdbnumber = BaseItem.parseString(node, IMDBNUMBER);
            this.label = node.get(LABEL).getTextValue();
            this.lastplayed = BaseItem.parseString(node, LASTPLAYED);
            this.lyrics = BaseItem.parseString(node, LYRICS);
            this.mood = BaseItem.getStringArray(node, MOOD);
            this.mpaa = BaseItem.parseString(node, MPAA);
            this.musicbrainzalbumartistid = BaseItem.parseString(node, MUSICBRAINZALBUMARTISTID);
            this.musicbrainzalbumid = BaseItem.parseString(node, MUSICBRAINZALBUMID);
            this.musicbrainzartistid = BaseItem.parseString(node, MUSICBRAINZARTISTID);
            this.musicbrainztrackid = BaseItem.parseString(node, MUSICBRAINZTRACKID);
            this.originaltitle = BaseItem.parseString(node, ORIGINALTITLE);
            this.playcount = BaseItem.parseInt(node, PLAYCOUNT);
            this.plot = BaseItem.parseString(node, PLOT);
            this.plotoutline = BaseItem.parseString(node, PLOTOUTLINE);
            this.premiered = BaseItem.parseString(node, PREMIERED);
            this.productioncode = BaseItem.parseString(node, PRODUCTIONCODE);
            this.rating = BaseItem.parseInt(node, RATING);
            this.releasetype = BaseItem.parseString(node, RELEASETYPE);
            this.resume = node.has(RESUME) ? new VideoModel.Resume(node.get(RESUME)) : null;
            this.runtime = BaseItem.parseInt(node, RUNTIME);
            this.season = BaseItem.parseInt(node, SEASON);
            this.set = BaseItem.parseString(node, SET);
            this.setid = BaseItem.parseInt(node, SETID);
            this.showlink = BaseItem.getStringArray(node, SHOWLINK);
            this.showtitle = BaseItem.parseString(node, SHOWTITLE);
            this.sorttitle = BaseItem.parseString(node, SORTTITLE);
            this.specialsortepisode = BaseItem.parseInt(node, SPECIALSORTEPISODE);
            this.specialsortseason = BaseItem.parseInt(node, SPECIALSORTSEASON);
            this.streamdetails = node.has(STREAMDETAILS) ? new VideoModel.Streams(node.get(STREAMDETAILS)) : null;
            this.studio = BaseItem.getStringArray(node, STUDIO);
            this.style = BaseItem.getStringArray(node, STYLE);
            this.tag = BaseItem.getStringArray(node, TAG);
            this.tagline = BaseItem.parseString(node, TAGLINE);
            this.theme = BaseItem.getStringArray(node, THEME);
            this.thumbnail = BaseItem.parseString(node, THUMBNAIL);
            this.title = BaseItem.parseString(node, TITLE);
            this.top250 = BaseItem.parseInt(node, TOP250);
            this.track = BaseItem.parseInt(node, TRACK);
            this.trailer = BaseItem.parseString(node, TRAILER);
            this.tvshowid = BaseItem.parseInt(node, TVSHOWID);
            this.type = BaseItem.parseString(node, TYPE);
            this.uniqueid = BaseItem.getStringMap(node, UNIQUEID);
            this.votes = BaseItem.parseString(node, VOTES);
            this.watchedepisodes = BaseItem.parseInt(node, WATCHEDEPISODES);
            this.writer = BaseItem.getStringArray(node, WRITER);
            this.year = BaseItem.parseInt(node, YEAR);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(ALBUM, this.album);
            ArrayNode albumartistArray = OM.createArrayNode();
            for (String string : this.albumartist) {
                albumartistArray.add(string);
            }
            node.put(ALBUMARTIST, (JsonNode)albumartistArray);
            ArrayNode albumartistidArray = OM.createArrayNode();
            for (Integer n : this.albumartistid) {
                albumartistidArray.add(n);
            }
            node.put(ALBUMARTISTID, (JsonNode)albumartistidArray);
            node.put(ALBUMID, this.albumid);
            node.put(ALBUMLABEL, this.albumlabel);
            node.put(ALBUMRELEASETYPE, this.albumreleasetype);
            node.put(ART, this.art == null ? null : this.art.toJsonNode());
            ArrayNode arrayNode = OM.createArrayNode();
            for (String string : this.artist) {
                arrayNode.add(string);
            }
            node.put(ARTIST, (JsonNode)arrayNode);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (Integer n : this.artistid) {
                arrayNode2.add(n);
            }
            node.put(ARTISTID, (JsonNode)arrayNode2);
            ArrayNode arrayNode3 = OM.createArrayNode();
            for (VideoModel.Cast cast : this.cast) {
                arrayNode3.add(cast.toJsonNode());
            }
            node.put(CAST, (JsonNode)arrayNode3);
            node.put(COMMENT, this.comment);
            node.put(COMPILATION, this.compilation);
            ArrayNode arrayNode4 = OM.createArrayNode();
            for (String string : this.country) {
                arrayNode4.add(string);
            }
            node.put(COUNTRY, (JsonNode)arrayNode4);
            node.put(DATEADDED, this.dateadded);
            node.put(DESCRIPTION, this.description);
            ArrayNode arrayNode5 = OM.createArrayNode();
            for (String string : this.director) {
                arrayNode5.add(string);
            }
            node.put(DIRECTOR, (JsonNode)arrayNode5);
            node.put(DISC, this.disc);
            node.put(DISPLAYARTIST, this.displayartist);
            node.put(DURATION, this.duration);
            node.put(EPISODE, this.episode);
            node.put(EPISODEGUIDE, this.episodeguide);
            node.put(FANART, this.fanart);
            node.put(FILE, this.file);
            node.put(FIRSTAIRED, this.firstaired);
            ArrayNode arrayNode6 = OM.createArrayNode();
            for (String string : this.genre) {
                arrayNode6.add(string);
            }
            node.put(GENRE, (JsonNode)arrayNode6);
            ArrayNode arrayNode7 = OM.createArrayNode();
            for (Integer n : this.genreid) {
                arrayNode7.add(n);
            }
            node.put(GENREID, (JsonNode)arrayNode7);
            node.put(ID, this.id);
            node.put(IMDBNUMBER, this.imdbnumber);
            node.put(LABEL, this.label);
            node.put(LASTPLAYED, this.lastplayed);
            node.put(LYRICS, this.lyrics);
            ArrayNode arrayNode8 = OM.createArrayNode();
            for (String string : this.mood) {
                arrayNode8.add(string);
            }
            node.put(MOOD, (JsonNode)arrayNode8);
            node.put(MPAA, this.mpaa);
            node.put(MUSICBRAINZALBUMARTISTID, this.musicbrainzalbumartistid);
            node.put(MUSICBRAINZALBUMID, this.musicbrainzalbumid);
            node.put(MUSICBRAINZARTISTID, this.musicbrainzartistid);
            node.put(MUSICBRAINZTRACKID, this.musicbrainztrackid);
            node.put(ORIGINALTITLE, this.originaltitle);
            node.put(PLAYCOUNT, this.playcount);
            node.put(PLOT, this.plot);
            node.put(PLOTOUTLINE, this.plotoutline);
            node.put(PREMIERED, this.premiered);
            node.put(PRODUCTIONCODE, this.productioncode);
            node.put(RATING, this.rating);
            node.put(RELEASETYPE, this.releasetype);
            node.put(RESUME, this.resume == null ? null : this.resume.toJsonNode());
            node.put(RUNTIME, this.runtime);
            node.put(SEASON, this.season);
            node.put(SET, this.set);
            node.put(SETID, this.setid);
            ArrayNode arrayNode9 = OM.createArrayNode();
            for (String string : this.showlink) {
                arrayNode9.add(string);
            }
            node.put(SHOWLINK, (JsonNode)arrayNode9);
            node.put(SHOWTITLE, this.showtitle);
            node.put(SORTTITLE, this.sorttitle);
            node.put(SPECIALSORTEPISODE, this.specialsortepisode);
            node.put(SPECIALSORTSEASON, this.specialsortseason);
            node.put(STREAMDETAILS, this.streamdetails == null ? null : this.streamdetails.toJsonNode());
            ArrayNode arrayNode10 = OM.createArrayNode();
            for (String string : this.studio) {
                arrayNode10.add(string);
            }
            node.put(STUDIO, (JsonNode)arrayNode10);
            ArrayNode arrayNode11 = OM.createArrayNode();
            for (String string : this.style) {
                arrayNode11.add(string);
            }
            node.put(STYLE, (JsonNode)arrayNode11);
            ArrayNode arrayNode12 = OM.createArrayNode();
            for (String string : this.tag) {
                arrayNode12.add(string);
            }
            node.put(TAG, (JsonNode)arrayNode12);
            node.put(TAGLINE, this.tagline);
            ArrayNode arrayNode13 = OM.createArrayNode();
            for (String string : this.theme) {
                arrayNode13.add(string);
            }
            node.put(THEME, (JsonNode)arrayNode13);
            node.put(THUMBNAIL, this.thumbnail);
            node.put(TITLE, this.title);
            node.put(TOP250, this.top250);
            node.put(TRACK, this.track);
            node.put(TRAILER, this.trailer);
            node.put(TVSHOWID, this.tvshowid);
            node.put(TYPE, this.type);
            ObjectNode objectNode = OM.createObjectNode();
            for (String key : this.uniqueid.values()) {
                objectNode.put(key, this.uniqueid.get(key));
            }
            node.put(UNIQUEID, (JsonNode)objectNode);
            node.put(VOTES, this.votes);
            node.put(WATCHEDEPISODES, this.watchedepisodes);
            ArrayNode arrayNode14 = OM.createArrayNode();
            for (String item : this.writer) {
                arrayNode14.add(item);
            }
            node.put(WRITER, (JsonNode)arrayNode14);
            node.put(YEAR, this.year);
            return node;
        }

        static List<BaseItem> getListModelBaseItemList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<BaseItem> l = new ArrayList<BaseItem>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new BaseItem(a.get(i)));
                }
                return l;
            }
            return new ArrayList<BaseItem>(0);
        }

        public static interface Releasetype {
            public static final String ALBUM = "album";
            public static final String SINGLE = "single";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("album", "single"));
        }

        public static interface Albumreleasetype {
            public static final String ALBUM = "album";
            public static final String SINGLE = "single";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("album", "single"));
        }

        public static interface Type {
            public static final String UNKNOWN = "unknown";
            public static final String MOVIE = "movie";
            public static final String EPISODE = "episode";
            public static final String MUSICVIDEO = "musicvideo";
            public static final String SONG = "song";
            public static final String PICTURE = "picture";
            public static final String CHANNEL = "channel";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "movie", "episode", "musicvideo", "song", "picture", "channel"));
        }
    }

    public static class AllItems
    extends BaseItem {
        public static final String API_TYPE = "List.Item.All";
        public static final String CHANNEL = "channel";
        public static final String CHANNELNUMBER = "channelnumber";
        public static final String CHANNELTYPE = "channeltype";
        public static final String ENDTIME = "endtime";
        public static final String HIDDEN = "hidden";
        public static final String LOCKED = "locked";
        public static final String STARTTIME = "starttime";
        public final String channel;
        public final Integer channelnumber;
        public final String channeltype;
        public final String endtime;
        public final Boolean hidden;
        public final Boolean locked;
        public final String starttime;

        public AllItems(JsonNode node) {
            super(node);
            this.channel = AllItems.parseString(node, CHANNEL);
            this.channelnumber = AllItems.parseInt(node, CHANNELNUMBER);
            this.channeltype = AllItems.parseString(node, CHANNELTYPE);
            this.endtime = AllItems.parseString(node, ENDTIME);
            this.hidden = AllItems.parseBoolean(node, HIDDEN);
            this.locked = AllItems.parseBoolean(node, LOCKED);
            this.starttime = AllItems.parseString(node, STARTTIME);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(CHANNEL, this.channel);
            node.put(CHANNELNUMBER, this.channelnumber);
            node.put(CHANNELTYPE, this.channeltype);
            node.put(ENDTIME, this.endtime);
            node.put(HIDDEN, this.hidden);
            node.put(LOCKED, this.locked);
            node.put(STARTTIME, this.starttime);
            return node;
        }

        static List<AllItems> getListModelAllItemsList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<AllItems> l = new ArrayList<AllItems>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new AllItems(a.get(i)));
                }
                return l;
            }
            return new ArrayList<AllItems>(0);
        }

        public static interface Channeltype {
            public static final String TV = "tv";
            public static final String RADIO = "radio";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("tv", "radio"));
        }
    }

    public static class TextureFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Textures";
        public final And and;
        public final TextureFilterRule filterRuleTextures;
        public final Or or;

        public TextureFilter(And and) {
            this.and = and;
            this.filterRuleTextures = null;
            this.or = null;
        }

        public TextureFilter(TextureFilterRule filterRuleTextures) {
            this.filterRuleTextures = filterRuleTextures;
            this.and = null;
            this.or = null;
        }

        public TextureFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleTextures = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleTextures != null) {
                return this.filterRuleTextures.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<TextureFilter> or;

            public Or(List<TextureFilter> or) {
                this.or = or;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode orArray = OM.createArrayNode();
                for (TextureFilter item : this.or) {
                    orArray.add(item.toJsonNode());
                }
                node.put(OR, (JsonNode)orArray);
                return node;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<TextureFilter> and;

            public And(List<TextureFilter> and) {
                this.and = and;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode andArray = OM.createArrayNode();
                for (TextureFilter item : this.and) {
                    andArray.add(item.toJsonNode());
                }
                node.put(AND, (JsonNode)andArray);
                return node;
            }
        }
    }

    public static class TVShowFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.TVShows";
        public final And and;
        public final TVShowFilterRule filterRuleTVShows;
        public final Or or;

        public TVShowFilter(And and) {
            this.and = and;
            this.filterRuleTVShows = null;
            this.or = null;
        }

        public TVShowFilter(TVShowFilterRule filterRuleTVShows) {
            this.filterRuleTVShows = filterRuleTVShows;
            this.and = null;
            this.or = null;
        }

        public TVShowFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleTVShows = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleTVShows != null) {
                return this.filterRuleTVShows.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<TVShowFilter> or;

            public Or(List<TVShowFilter> or) {
                this.or = or;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode orArray = OM.createArrayNode();
                for (TVShowFilter item : this.or) {
                    orArray.add(item.toJsonNode());
                }
                node.put(OR, (JsonNode)orArray);
                return node;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<TVShowFilter> and;

            public And(List<TVShowFilter> and) {
                this.and = and;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode andArray = OM.createArrayNode();
                for (TVShowFilter item : this.and) {
                    andArray.add(item.toJsonNode());
                }
                node.put(AND, (JsonNode)andArray);
                return node;
            }
        }
    }

    public static class SongFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Songs";
        public final And and;
        public final SongFilterRule filterRuleSongs;
        public final Or or;

        public SongFilter(And and) {
            this.and = and;
            this.filterRuleSongs = null;
            this.or = null;
        }

        public SongFilter(SongFilterRule filterRuleSongs) {
            this.filterRuleSongs = filterRuleSongs;
            this.and = null;
            this.or = null;
        }

        public SongFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleSongs = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleSongs != null) {
                return this.filterRuleSongs.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<SongFilter> or;

            public Or(List<SongFilter> or) {
                this.or = or;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode orArray = OM.createArrayNode();
                for (SongFilter item : this.or) {
                    orArray.add(item.toJsonNode());
                }
                node.put(OR, (JsonNode)orArray);
                return node;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<SongFilter> and;

            public And(List<SongFilter> and) {
                this.and = and;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode andArray = OM.createArrayNode();
                for (SongFilter item : this.and) {
                    andArray.add(item.toJsonNode());
                }
                node.put(AND, (JsonNode)andArray);
                return node;
            }
        }
    }

    public static class TextureFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.Textures";
        public static final String FIELD = "field";
        public final String field;

        public TextureFilterRule(String operator, FilterRule.Value value, String field) {
            super(operator, value);
            this.field = field;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FIELD, this.field);
            return node;
        }

        public static interface Field {
            public static final String TEXTUREID = "textureid";
            public static final String URL = "url";
            public static final String CACHEDURL = "cachedurl";
            public static final String LASTHASHCHECK = "lasthashcheck";
            public static final String IMAGEHASH = "imagehash";
            public static final String WIDTH = "width";
            public static final String HEIGHT = "height";
            public static final String USECOUNT = "usecount";
            public static final String LASTUSED = "lastused";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("textureid", "url", "cachedurl", "lasthashcheck", "imagehash", "width", "height", "usecount", "lastused"));
        }
    }

    public static class TVShowFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.TVShows";
        public static final String FIELD = "field";
        public final String field;

        public TVShowFilterRule(String operator, FilterRule.Value value, String field) {
            super(operator, value);
            this.field = field;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FIELD, this.field);
            return node;
        }

        public static interface Field {
            public static final String TITLE = "title";
            public static final String PLOT = "plot";
            public static final String STATUS = "status";
            public static final String VOTES = "votes";
            public static final String RATING = "rating";
            public static final String YEAR = "year";
            public static final String GENRE = "genre";
            public static final String DIRECTOR = "director";
            public static final String ACTOR = "actor";
            public static final String NUMEPISODES = "numepisodes";
            public static final String NUMWATCHED = "numwatched";
            public static final String PLAYCOUNT = "playcount";
            public static final String PATH = "path";
            public static final String STUDIO = "studio";
            public static final String MPAARATING = "mpaarating";
            public static final String DATEADDED = "dateadded";
            public static final String LASTPLAYED = "lastplayed";
            public static final String INPROGRESS = "inprogress";
            public static final String TAG = "tag";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "status", "votes", "rating", "year", "genre", "director", "actor", "numepisodes", "numwatched", "playcount", "path", "studio", "mpaarating", "dateadded", "lastplayed", "inprogress", "tag", "playlist", "virtualfolder"));
        }
    }

    public static class SongFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.Songs";
        public static final String FIELD = "field";
        public final String field;

        public SongFilterRule(String operator, FilterRule.Value value, String field) {
            super(operator, value);
            this.field = field;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FIELD, this.field);
            return node;
        }

        public static interface Field {
            public static final String GENRE = "genre";
            public static final String ALBUM = "album";
            public static final String ARTIST = "artist";
            public static final String ALBUMARTIST = "albumartist";
            public static final String TITLE = "title";
            public static final String YEAR = "year";
            public static final String TIME = "time";
            public static final String TRACKNUMBER = "tracknumber";
            public static final String FILENAME = "filename";
            public static final String PATH = "path";
            public static final String PLAYCOUNT = "playcount";
            public static final String LASTPLAYED = "lastplayed";
            public static final String RATING = "rating";
            public static final String COMMENT = "comment";
            public static final String MOODS = "moods";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("genre", "album", "artist", "albumartist", "title", "year", "time", "tracknumber", "filename", "path", "playcount", "lastplayed", "rating", "comment", "moods", "playlist", "virtualfolder"));
        }
    }

    public static class MusicVideoFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.MusicVideos";
        public static final String FIELD = "field";
        public final String field;

        public MusicVideoFilterRule(String operator, FilterRule.Value value, String field) {
            super(operator, value);
            this.field = field;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FIELD, this.field);
            return node;
        }

        public static interface Field {
            public static final String TITLE = "title";
            public static final String GENRE = "genre";
            public static final String ALBUM = "album";
            public static final String YEAR = "year";
            public static final String ARTIST = "artist";
            public static final String FILENAME = "filename";
            public static final String PATH = "path";
            public static final String PLAYCOUNT = "playcount";
            public static final String LASTPLAYED = "lastplayed";
            public static final String TIME = "time";
            public static final String DIRECTOR = "director";
            public static final String STUDIO = "studio";
            public static final String PLOT = "plot";
            public static final String TAG = "tag";
            public static final String DATEADDED = "dateadded";
            public static final String VIDEORESOLUTION = "videoresolution";
            public static final String AUDIOCHANNELS = "audiochannels";
            public static final String VIDEOCODEC = "videocodec";
            public static final String AUDIOCODEC = "audiocodec";
            public static final String AUDIOLANGUAGE = "audiolanguage";
            public static final String SUBTITLELANGUAGE = "subtitlelanguage";
            public static final String VIDEOASPECT = "videoaspect";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "genre", "album", "year", "artist", "filename", "path", "playcount", "lastplayed", "time", "director", "studio", "plot", "tag", "dateadded", "videoresolution", "audiochannels", "videocodec", "audiocodec", "audiolanguage", "subtitlelanguage", "videoaspect", "playlist", "virtualfolder"));
        }
    }

    public static class MovieFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.Movies";
        public static final String FIELD = "field";
        public final String field;

        public MovieFilterRule(String operator, FilterRule.Value value, String field) {
            super(operator, value);
            this.field = field;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FIELD, this.field);
            return node;
        }

        public static interface Field {
            public static final String TITLE = "title";
            public static final String PLOT = "plot";
            public static final String PLOTOUTLINE = "plotoutline";
            public static final String TAGLINE = "tagline";
            public static final String VOTES = "votes";
            public static final String RATING = "rating";
            public static final String TIME = "time";
            public static final String WRITERS = "writers";
            public static final String PLAYCOUNT = "playcount";
            public static final String LASTPLAYED = "lastplayed";
            public static final String INPROGRESS = "inprogress";
            public static final String GENRE = "genre";
            public static final String COUNTRY = "country";
            public static final String YEAR = "year";
            public static final String DIRECTOR = "director";
            public static final String ACTOR = "actor";
            public static final String MPAARATING = "mpaarating";
            public static final String TOP250 = "top250";
            public static final String STUDIO = "studio";
            public static final String HASTRAILER = "hastrailer";
            public static final String FILENAME = "filename";
            public static final String PATH = "path";
            public static final String SET = "set";
            public static final String TAG = "tag";
            public static final String DATEADDED = "dateadded";
            public static final String VIDEORESOLUTION = "videoresolution";
            public static final String AUDIOCHANNELS = "audiochannels";
            public static final String VIDEOCODEC = "videocodec";
            public static final String AUDIOCODEC = "audiocodec";
            public static final String AUDIOLANGUAGE = "audiolanguage";
            public static final String SUBTITLELANGUAGE = "subtitlelanguage";
            public static final String VIDEOASPECT = "videoaspect";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "plotoutline", "tagline", "votes", "rating", "time", "writers", "playcount", "lastplayed", "inprogress", "genre", "country", "year", "director", "actor", "mpaarating", "top250", "studio", "hastrailer", "filename", "path", "set", "tag", "dateadded", "videoresolution", "audiochannels", "videocodec", "audiocodec", "audiolanguage", "subtitlelanguage", "videoaspect", "playlist", "virtualfolder"));
        }
    }

    public static class EpisodeFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.Episodes";
        public static final String FIELD = "field";
        public final String field;

        public EpisodeFilterRule(String operator, FilterRule.Value value, String field) {
            super(operator, value);
            this.field = field;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FIELD, this.field);
            return node;
        }

        public static interface Field {
            public static final String TITLE = "title";
            public static final String TVSHOW = "tvshow";
            public static final String PLOT = "plot";
            public static final String VOTES = "votes";
            public static final String RATING = "rating";
            public static final String TIME = "time";
            public static final String WRITERS = "writers";
            public static final String AIRDATE = "airdate";
            public static final String PLAYCOUNT = "playcount";
            public static final String LASTPLAYED = "lastplayed";
            public static final String INPROGRESS = "inprogress";
            public static final String GENRE = "genre";
            public static final String YEAR = "year";
            public static final String DIRECTOR = "director";
            public static final String ACTOR = "actor";
            public static final String EPISODE = "episode";
            public static final String SEASON = "season";
            public static final String FILENAME = "filename";
            public static final String PATH = "path";
            public static final String STUDIO = "studio";
            public static final String MPAARATING = "mpaarating";
            public static final String DATEADDED = "dateadded";
            public static final String TAG = "tag";
            public static final String VIDEORESOLUTION = "videoresolution";
            public static final String AUDIOCHANNELS = "audiochannels";
            public static final String VIDEOCODEC = "videocodec";
            public static final String AUDIOCODEC = "audiocodec";
            public static final String AUDIOLANGUAGE = "audiolanguage";
            public static final String SUBTITLELANGUAGE = "subtitlelanguage";
            public static final String VIDEOASPECT = "videoaspect";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "tvshow", "plot", "votes", "rating", "time", "writers", "airdate", "playcount", "lastplayed", "inprogress", "genre", "year", "director", "actor", "episode", "season", "filename", "path", "studio", "mpaarating", "dateadded", "tag", "videoresolution", "audiochannels", "videocodec", "audiocodec", "audiolanguage", "subtitlelanguage", "videoaspect", "playlist", "virtualfolder"));
        }
    }

    public static class ArtistFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.Artists";
        public static final String FIELD = "field";
        public final String field;

        public ArtistFilterRule(String operator, FilterRule.Value value, String field) {
            super(operator, value);
            this.field = field;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FIELD, this.field);
            return node;
        }

        public static interface Field {
            public static final String ARTIST = "artist";
            public static final String GENRE = "genre";
            public static final String MOODS = "moods";
            public static final String STYLES = "styles";
            public static final String INSTRUMENTS = "instruments";
            public static final String BIOGRAPHY = "biography";
            public static final String BORN = "born";
            public static final String BANDFORMED = "bandformed";
            public static final String DISBANDED = "disbanded";
            public static final String DIED = "died";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("artist", "genre", "moods", "styles", "instruments", "biography", "born", "bandformed", "disbanded", "died", "playlist", "virtualfolder"));
        }
    }

    public static class AlbumFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.Albums";
        public static final String FIELD = "field";
        public final String field;

        public AlbumFilterRule(String operator, FilterRule.Value value, String field) {
            super(operator, value);
            this.field = field;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FIELD, this.field);
            return node;
        }

        public static interface Field {
            public static final String GENRE = "genre";
            public static final String ALBUM = "album";
            public static final String ARTIST = "artist";
            public static final String ALBUMARTIST = "albumartist";
            public static final String YEAR = "year";
            public static final String REVIEW = "review";
            public static final String THEMES = "themes";
            public static final String MOODS = "moods";
            public static final String STYLES = "styles";
            public static final String TYPE = "type";
            public static final String LABEL = "label";
            public static final String RATING = "rating";
            public static final String PLAYCOUNT = "playcount";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("genre", "album", "artist", "albumartist", "year", "review", "themes", "moods", "styles", "type", "label", "rating", "playcount", "playlist", "virtualfolder"));
        }
    }

    public static class FilterRule
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Rule";
        public static final String OPERATOR = "operator";
        public static final String VALUE = "value";
        public final String operator;
        public final Value value;

        public FilterRule(String operator, Value value) {
            this.operator = operator;
            this.value = value;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(OPERATOR, this.operator);
            node.put(VALUE, this.value == null ? null : this.value.toJsonNode());
            return node;
        }

        public static interface Operator {
            public static final String CONTAINS = "contains";
            public static final String DOESNOTCONTAIN = "doesnotcontain";
            public static final String IS = "is";
            public static final String ISNOT = "isnot";
            public static final String STARTSWITH = "startswith";
            public static final String ENDSWITH = "endswith";
            public static final String GREATERTHAN = "greaterthan";
            public static final String LESSTHAN = "lessthan";
            public static final String AFTER = "after";
            public static final String BEFORE = "before";
            public static final String INTHELAST = "inthelast";
            public static final String NOTINTHELAST = "notinthelast";
            public static final String TRUE = "true";
            public static final String FALSE = "false";
            public static final String BETWEEN = "between";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("contains", "doesnotcontain", "is", "isnot", "startswith", "endswith", "greaterthan", "lessthan", "after", "before", "inthelast", "notinthelast", "true", "false", "between"));
        }

        public static class Value
        extends AbstractModel {
            public final String stringArg;
            public final List<String> stringArgList;

            public Value(String stringArg) {
                this.stringArg = stringArg;
                this.stringArgList = null;
            }

            public Value(List<String> stringArgList) {
                this.stringArgList = stringArgList;
                this.stringArg = null;
            }

            @Override
            public JsonNode toJsonNode() {
                if (this.stringArg != null) {
                    return new TextNode(this.stringArg);
                }
                if (this.stringArgList != null) {
                    ArrayNode an = OM.createArrayNode();
                    for (String item : this.stringArgList) {
                        an.add(item);
                    }
                    return an;
                }
                return null;
            }
        }
    }

    public static class MusicVideoFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.MusicVideos";
        public final And and;
        public final MusicVideoFilterRule filterRuleMusicVideos;
        public final Or or;

        public MusicVideoFilter(And and) {
            this.and = and;
            this.filterRuleMusicVideos = null;
            this.or = null;
        }

        public MusicVideoFilter(MusicVideoFilterRule filterRuleMusicVideos) {
            this.filterRuleMusicVideos = filterRuleMusicVideos;
            this.and = null;
            this.or = null;
        }

        public MusicVideoFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleMusicVideos = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleMusicVideos != null) {
                return this.filterRuleMusicVideos.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<MusicVideoFilter> or;

            public Or(List<MusicVideoFilter> or) {
                this.or = or;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode orArray = OM.createArrayNode();
                for (MusicVideoFilter item : this.or) {
                    orArray.add(item.toJsonNode());
                }
                node.put(OR, (JsonNode)orArray);
                return node;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<MusicVideoFilter> and;

            public And(List<MusicVideoFilter> and) {
                this.and = and;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode andArray = OM.createArrayNode();
                for (MusicVideoFilter item : this.and) {
                    andArray.add(item.toJsonNode());
                }
                node.put(AND, (JsonNode)andArray);
                return node;
            }
        }
    }

    public static class MovieFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Movies";
        public final And and;
        public final MovieFilterRule filterRuleMovies;
        public final Or or;

        public MovieFilter(And and) {
            this.and = and;
            this.filterRuleMovies = null;
            this.or = null;
        }

        public MovieFilter(MovieFilterRule filterRuleMovies) {
            this.filterRuleMovies = filterRuleMovies;
            this.and = null;
            this.or = null;
        }

        public MovieFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleMovies = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleMovies != null) {
                return this.filterRuleMovies.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<MovieFilter> or;

            public Or(List<MovieFilter> or) {
                this.or = or;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode orArray = OM.createArrayNode();
                for (MovieFilter item : this.or) {
                    orArray.add(item.toJsonNode());
                }
                node.put(OR, (JsonNode)orArray);
                return node;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<MovieFilter> and;

            public And(List<MovieFilter> and) {
                this.and = and;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode andArray = OM.createArrayNode();
                for (MovieFilter item : this.and) {
                    andArray.add(item.toJsonNode());
                }
                node.put(AND, (JsonNode)andArray);
                return node;
            }
        }
    }

    public static class EpisodeFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Episodes";
        public final And and;
        public final EpisodeFilterRule filterRuleEpisodes;
        public final Or or;

        public EpisodeFilter(And and) {
            this.and = and;
            this.filterRuleEpisodes = null;
            this.or = null;
        }

        public EpisodeFilter(EpisodeFilterRule filterRuleEpisodes) {
            this.filterRuleEpisodes = filterRuleEpisodes;
            this.and = null;
            this.or = null;
        }

        public EpisodeFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleEpisodes = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleEpisodes != null) {
                return this.filterRuleEpisodes.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<EpisodeFilter> or;

            public Or(List<EpisodeFilter> or) {
                this.or = or;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode orArray = OM.createArrayNode();
                for (EpisodeFilter item : this.or) {
                    orArray.add(item.toJsonNode());
                }
                node.put(OR, (JsonNode)orArray);
                return node;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<EpisodeFilter> and;

            public And(List<EpisodeFilter> and) {
                this.and = and;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode andArray = OM.createArrayNode();
                for (EpisodeFilter item : this.and) {
                    andArray.add(item.toJsonNode());
                }
                node.put(AND, (JsonNode)andArray);
                return node;
            }
        }
    }

    public static class ArtistFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Artists";
        public final And and;
        public final ArtistFilterRule filterRuleArtists;
        public final Or or;

        public ArtistFilter(And and) {
            this.and = and;
            this.filterRuleArtists = null;
            this.or = null;
        }

        public ArtistFilter(ArtistFilterRule filterRuleArtists) {
            this.filterRuleArtists = filterRuleArtists;
            this.and = null;
            this.or = null;
        }

        public ArtistFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleArtists = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleArtists != null) {
                return this.filterRuleArtists.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<ArtistFilter> or;

            public Or(List<ArtistFilter> or) {
                this.or = or;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode orArray = OM.createArrayNode();
                for (ArtistFilter item : this.or) {
                    orArray.add(item.toJsonNode());
                }
                node.put(OR, (JsonNode)orArray);
                return node;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<ArtistFilter> and;

            public And(List<ArtistFilter> and) {
                this.and = and;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode andArray = OM.createArrayNode();
                for (ArtistFilter item : this.and) {
                    andArray.add(item.toJsonNode());
                }
                node.put(AND, (JsonNode)andArray);
                return node;
            }
        }
    }

    public static class AlbumFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Albums";
        public final And and;
        public final AlbumFilterRule filterRuleAlbums;
        public final Or or;

        public AlbumFilter(And and) {
            this.and = and;
            this.filterRuleAlbums = null;
            this.or = null;
        }

        public AlbumFilter(AlbumFilterRule filterRuleAlbums) {
            this.filterRuleAlbums = filterRuleAlbums;
            this.and = null;
            this.or = null;
        }

        public AlbumFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleAlbums = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleAlbums != null) {
                return this.filterRuleAlbums.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<AlbumFilter> or;

            public Or(List<AlbumFilter> or) {
                this.or = or;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode orArray = OM.createArrayNode();
                for (AlbumFilter item : this.or) {
                    orArray.add(item.toJsonNode());
                }
                node.put(OR, (JsonNode)orArray);
                return node;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<AlbumFilter> and;

            public And(List<AlbumFilter> and) {
                this.and = and;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                ArrayNode andArray = OM.createArrayNode();
                for (AlbumFilter item : this.and) {
                    andArray.add(item.toJsonNode());
                }
                node.put(AND, (JsonNode)andArray);
                return node;
            }
        }
    }
}

