/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class PlaylistModel {

    public static interface Type {
        public static final String UNKNOWN = "unknown";
        public static final String VIDEO = "video";
        public static final String AUDIO = "audio";
        public static final String PICTURE = "picture";
        public static final String MIXED = "mixed";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "video", "audio", "picture", "mixed"));
    }

    public static interface PropertyName {
        public static final String TYPE = "type";
        public static final String SIZE = "size";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("type", "size"));
    }

    public static class PropertyValue
    extends AbstractModel {
        public static final String API_TYPE = "Playlist.Property.Value";
        public static final String SIZE = "size";
        public static final String TYPE = "type";
        public final Integer size;
        public final String type;

        public PropertyValue(Integer size, String type) {
            this.size = size;
            this.type = type;
        }

        public PropertyValue(JsonNode node) {
            this.size = PropertyValue.parseInt(node, SIZE);
            this.type = PropertyValue.parseString(node, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(SIZE, this.size);
            node.put(TYPE, this.type);
            return node;
        }

        static List<PropertyValue> getPlaylistModelPropertyValueList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<PropertyValue> l = new ArrayList<PropertyValue>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new PropertyValue(a.get(i)));
                }
                return l;
            }
            return new ArrayList<PropertyValue>(0);
        }

        public static interface Type {
            public static final String UNKNOWN = "unknown";
            public static final String VIDEO = "video";
            public static final String AUDIO = "audio";
            public static final String PICTURE = "picture";
            public static final String MIXED = "mixed";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "video", "audio", "picture", "mixed"));
        }
    }

    public static class Item
    extends AbstractModel {
        public static final String API_TYPE = "Playlist.Item";
        public final Albumid albumid;
        public final Artistid artistid;
        public final Episodeid episodeid;
        public final File file;
        public final Genreid genreid;
        public final Movieid movieid;
        public final Musicvideoid musicvideoid;
        public final RecursiveDirectoryMedia recursiveDirectoryMedia;
        public final Songid songid;

        public Item(Albumid albumid) {
            this.albumid = albumid;
            this.artistid = null;
            this.episodeid = null;
            this.file = null;
            this.genreid = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(Artistid artistid) {
            this.artistid = artistid;
            this.albumid = null;
            this.episodeid = null;
            this.file = null;
            this.genreid = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(Episodeid episodeid) {
            this.episodeid = episodeid;
            this.albumid = null;
            this.artistid = null;
            this.file = null;
            this.genreid = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(File file) {
            this.file = file;
            this.albumid = null;
            this.artistid = null;
            this.episodeid = null;
            this.genreid = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(Genreid genreid) {
            this.genreid = genreid;
            this.albumid = null;
            this.artistid = null;
            this.episodeid = null;
            this.file = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(Movieid movieid) {
            this.movieid = movieid;
            this.albumid = null;
            this.artistid = null;
            this.episodeid = null;
            this.file = null;
            this.genreid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(Musicvideoid musicvideoid) {
            this.musicvideoid = musicvideoid;
            this.albumid = null;
            this.artistid = null;
            this.episodeid = null;
            this.file = null;
            this.genreid = null;
            this.movieid = null;
            this.recursiveDirectoryMedia = null;
            this.songid = null;
        }

        public Item(RecursiveDirectoryMedia recursiveDirectoryMedia) {
            this.recursiveDirectoryMedia = recursiveDirectoryMedia;
            this.albumid = null;
            this.artistid = null;
            this.episodeid = null;
            this.file = null;
            this.genreid = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.songid = null;
        }

        public Item(Songid songid) {
            this.songid = songid;
            this.albumid = null;
            this.artistid = null;
            this.episodeid = null;
            this.file = null;
            this.genreid = null;
            this.movieid = null;
            this.musicvideoid = null;
            this.recursiveDirectoryMedia = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.albumid != null) {
                return this.albumid.toJsonNode();
            }
            if (this.artistid != null) {
                return this.artistid.toJsonNode();
            }
            if (this.episodeid != null) {
                return this.episodeid.toJsonNode();
            }
            if (this.file != null) {
                return this.file.toJsonNode();
            }
            if (this.genreid != null) {
                return this.genreid.toJsonNode();
            }
            if (this.movieid != null) {
                return this.movieid.toJsonNode();
            }
            if (this.musicvideoid != null) {
                return this.musicvideoid.toJsonNode();
            }
            if (this.recursiveDirectoryMedia != null) {
                return this.recursiveDirectoryMedia.toJsonNode();
            }
            if (this.songid != null) {
                return this.songid.toJsonNode();
            }
            return null;
        }

        public static class Genreid
        extends AbstractModel {
            public static final String GENREID = "genreid";
            public final Integer genreid;

            public Genreid(Integer genreid) {
                this.genreid = genreid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(GENREID, this.genreid);
                return node;
            }
        }

        public static class Songid
        extends AbstractModel {
            public static final String SONGID = "songid";
            public final Integer songid;

            public Songid(Integer songid) {
                this.songid = songid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(SONGID, this.songid);
                return node;
            }
        }

        public static class Albumid
        extends AbstractModel {
            public static final String ALBUMID = "albumid";
            public final Integer albumid;

            public Albumid(Integer albumid) {
                this.albumid = albumid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ALBUMID, this.albumid);
                return node;
            }
        }

        public static class Artistid
        extends AbstractModel {
            public static final String ARTISTID = "artistid";
            public final Integer artistid;

            public Artistid(Integer artistid) {
                this.artistid = artistid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ARTISTID, this.artistid);
                return node;
            }
        }

        public static class Musicvideoid
        extends AbstractModel {
            public static final String MUSICVIDEOID = "musicvideoid";
            public final Integer musicvideoid;

            public Musicvideoid(Integer musicvideoid) {
                this.musicvideoid = musicvideoid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(MUSICVIDEOID, this.musicvideoid);
                return node;
            }
        }

        public static class Episodeid
        extends AbstractModel {
            public static final String EPISODEID = "episodeid";
            public final Integer episodeid;

            public Episodeid(Integer episodeid) {
                this.episodeid = episodeid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(EPISODEID, this.episodeid);
                return node;
            }
        }

        public static class Movieid
        extends AbstractModel {
            public static final String MOVIEID = "movieid";
            public final Integer movieid;

            public Movieid(Integer movieid) {
                this.movieid = movieid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(MOVIEID, this.movieid);
                return node;
            }
        }

        public static class RecursiveDirectoryMedia
        extends AbstractModel {
            public static final String DIRECTORY = "directory";
            public static final String MEDIA = "media";
            public static final String RECURSIVE = "recursive";
            public final String directory;
            public final String media;
            public final Boolean recursive;

            public RecursiveDirectoryMedia(String directory, String media, Boolean recursive) {
                this.directory = directory;
                this.media = media;
                this.recursive = recursive;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(DIRECTORY, this.directory);
                node.put(MEDIA, this.media);
                node.put(RECURSIVE, this.recursive);
                return node;
            }

            public static interface Media {
                public static final String VIDEO = "video";
                public static final String MUSIC = "music";
                public static final String PICTURES = "pictures";
                public static final String FILES = "files";
                public static final String PROGRAMS = "programs";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("video", "music", "pictures", "files", "programs"));
            }
        }

        public static class File
        extends AbstractModel {
            public static final String FILE = "file";
            public final String file;

            public File(String file) {
                this.file = file;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(FILE, this.file);
                return node;
            }
        }
    }
}

