/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ItemModel;

public final class ProfilesModel {

    public static interface ProfileFields {
        public static final String THUMBNAIL = "thumbnail";
        public static final String LOCKMODE = "lockmode";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("thumbnail", "lockmode"));
    }

    public static class Password
    extends AbstractModel {
        public static final String API_TYPE = "Profiles.Password";
        public static final String ENCRYPTION = "encryption";
        public static final String VALUE = "value";
        public final String encryption;
        public final String value;

        public Password(String encryption, String value) {
            this.encryption = encryption;
            this.value = value;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(ENCRYPTION, this.encryption);
            node.put(VALUE, this.value);
            return node;
        }

        public static interface Encryption {
            public static final String NONE = "none";
            public static final String MD5 = "md5";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("none", "md5"));
        }
    }

    public static class ProfileDetail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "Profiles.Details.Profile";
        public static final String LOCKMODE = "lockmode";
        public static final String THUMBNAIL = "thumbnail";
        public final Integer lockmode;
        public final String thumbnail;

        public ProfileDetail(JsonNode node) {
            super(node);
            this.lockmode = ProfileDetail.parseInt(node, LOCKMODE);
            this.thumbnail = ProfileDetail.parseString(node, THUMBNAIL);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(LOCKMODE, this.lockmode);
            node.put(THUMBNAIL, this.thumbnail);
            return node;
        }

        static List<ProfileDetail> getProfilesModelProfileDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ProfileDetail> l = new ArrayList<ProfileDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ProfileDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ProfileDetail>(0);
        }
    }
}

