/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class SystemModel {

    public static interface PropertyName {
        public static final String CANSHUTDOWN = "canshutdown";
        public static final String CANSUSPEND = "cansuspend";
        public static final String CANHIBERNATE = "canhibernate";
        public static final String CANREBOOT = "canreboot";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("canshutdown", "cansuspend", "canhibernate", "canreboot"));
    }

    public static class PropertyValue
    extends AbstractModel {
        public static final String API_TYPE = "System.Property.Value";
        public static final String CANHIBERNATE = "canhibernate";
        public static final String CANREBOOT = "canreboot";
        public static final String CANSHUTDOWN = "canshutdown";
        public static final String CANSUSPEND = "cansuspend";
        public final Boolean canhibernate;
        public final Boolean canreboot;
        public final Boolean canshutdown;
        public final Boolean cansuspend;

        public PropertyValue(Boolean canhibernate, Boolean canreboot, Boolean canshutdown, Boolean cansuspend) {
            this.canhibernate = canhibernate;
            this.canreboot = canreboot;
            this.canshutdown = canshutdown;
            this.cansuspend = cansuspend;
        }

        public PropertyValue(JsonNode node) {
            this.canhibernate = PropertyValue.parseBoolean(node, CANHIBERNATE);
            this.canreboot = PropertyValue.parseBoolean(node, CANREBOOT);
            this.canshutdown = PropertyValue.parseBoolean(node, CANSHUTDOWN);
            this.cansuspend = PropertyValue.parseBoolean(node, CANSUSPEND);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(CANHIBERNATE, this.canhibernate);
            node.put(CANREBOOT, this.canreboot);
            node.put(CANSHUTDOWN, this.canshutdown);
            node.put(CANSUSPEND, this.cansuspend);
            return node;
        }

        static List<PropertyValue> getSystemModelPropertyValueList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<PropertyValue> l = new ArrayList<PropertyValue>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new PropertyValue(a.get(i)));
                }
                return l;
            }
            return new ArrayList<PropertyValue>(0);
        }
    }
}

