/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.MediaModel;

public final class VideoModel {

    public static interface TVShowFields {
        public static final String TITLE = "title";
        public static final String GENRE = "genre";
        public static final String YEAR = "year";
        public static final String RATING = "rating";
        public static final String PLOT = "plot";
        public static final String STUDIO = "studio";
        public static final String MPAA = "mpaa";
        public static final String CAST = "cast";
        public static final String PLAYCOUNT = "playcount";
        public static final String EPISODE = "episode";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String PREMIERED = "premiered";
        public static final String VOTES = "votes";
        public static final String LASTPLAYED = "lastplayed";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String SORTTITLE = "sorttitle";
        public static final String EPISODEGUIDE = "episodeguide";
        public static final String SEASON = "season";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public static final String DATEADDED = "dateadded";
        public static final String TAG = "tag";
        public static final String ART = "art";
        public static final String USERRATING = "userrating";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "genre", "year", "rating", "plot", "studio", "mpaa", "cast", "playcount", "episode", "imdbnumber", "premiered", "votes", "lastplayed", "fanart", "thumbnail", "file", "originaltitle", "sorttitle", "episodeguide", "season", "watchedepisodes", "dateadded", "tag", "art", "userrating"));
    }

    public static interface SeasonFields {
        public static final String SEASON = "season";
        public static final String SHOWTITLE = "showtitle";
        public static final String PLAYCOUNT = "playcount";
        public static final String EPISODE = "episode";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String TVSHOWID = "tvshowid";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public static final String ART = "art";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("season", "showtitle", "playcount", "episode", "fanart", "thumbnail", "tvshowid", "watchedepisodes", "art"));
    }

    public static interface MusicVideoFields {
        public static final String TITLE = "title";
        public static final String PLAYCOUNT = "playcount";
        public static final String RUNTIME = "runtime";
        public static final String DIRECTOR = "director";
        public static final String STUDIO = "studio";
        public static final String YEAR = "year";
        public static final String PLOT = "plot";
        public static final String ALBUM = "album";
        public static final String ARTIST = "artist";
        public static final String GENRE = "genre";
        public static final String TRACK = "track";
        public static final String STREAMDETAILS = "streamdetails";
        public static final String LASTPLAYED = "lastplayed";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String RESUME = "resume";
        public static final String DATEADDED = "dateadded";
        public static final String TAG = "tag";
        public static final String ART = "art";
        public static final String USERRATING = "userrating";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "playcount", "runtime", "director", "studio", "year", "plot", "album", "artist", "genre", "track", "streamdetails", "lastplayed", "fanart", "thumbnail", "file", "resume", "dateadded", "tag", "art", "userrating"));
    }

    public static interface MovieSetFields {
        public static final String TITLE = "title";
        public static final String PLAYCOUNT = "playcount";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String ART = "art";
        public static final String PLOT = "plot";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "playcount", "fanart", "thumbnail", "art", "plot"));
    }

    public static interface MovieFields {
        public static final String TITLE = "title";
        public static final String GENRE = "genre";
        public static final String YEAR = "year";
        public static final String RATING = "rating";
        public static final String DIRECTOR = "director";
        public static final String TRAILER = "trailer";
        public static final String TAGLINE = "tagline";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String LASTPLAYED = "lastplayed";
        public static final String PLAYCOUNT = "playcount";
        public static final String WRITER = "writer";
        public static final String STUDIO = "studio";
        public static final String MPAA = "mpaa";
        public static final String CAST = "cast";
        public static final String COUNTRY = "country";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String RUNTIME = "runtime";
        public static final String SET = "set";
        public static final String SHOWLINK = "showlink";
        public static final String STREAMDETAILS = "streamdetails";
        public static final String TOP250 = "top250";
        public static final String VOTES = "votes";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String SORTTITLE = "sorttitle";
        public static final String RESUME = "resume";
        public static final String SETID = "setid";
        public static final String DATEADDED = "dateadded";
        public static final String TAG = "tag";
        public static final String ART = "art";
        public static final String USERRATING = "userrating";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "genre", "year", "rating", "director", "trailer", "tagline", "plot", "plotoutline", "originaltitle", "lastplayed", "playcount", "writer", "studio", "mpaa", "cast", "country", "imdbnumber", "runtime", "set", "showlink", "streamdetails", "top250", "votes", "fanart", "thumbnail", "file", "sorttitle", "resume", "setid", "dateadded", "tag", "art", "userrating"));
    }

    public static interface EpisodeFields {
        public static final String TITLE = "title";
        public static final String PLOT = "plot";
        public static final String VOTES = "votes";
        public static final String RATING = "rating";
        public static final String WRITER = "writer";
        public static final String FIRSTAIRED = "firstaired";
        public static final String PLAYCOUNT = "playcount";
        public static final String RUNTIME = "runtime";
        public static final String DIRECTOR = "director";
        public static final String PRODUCTIONCODE = "productioncode";
        public static final String SEASON = "season";
        public static final String EPISODE = "episode";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String SHOWTITLE = "showtitle";
        public static final String CAST = "cast";
        public static final String STREAMDETAILS = "streamdetails";
        public static final String LASTPLAYED = "lastplayed";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String RESUME = "resume";
        public static final String TVSHOWID = "tvshowid";
        public static final String DATEADDED = "dateadded";
        public static final String UNIQUEID = "uniqueid";
        public static final String ART = "art";
        public static final String SPECIALSORTSEASON = "specialsortseason";
        public static final String SPECIALSORTEPISODE = "specialsortepisode";
        public static final String USERRATING = "userrating";
        public static final String SEASONID = "seasonid";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "votes", "rating", "writer", "firstaired", "playcount", "runtime", "director", "productioncode", "season", "episode", "originaltitle", "showtitle", "cast", "streamdetails", "lastplayed", "fanart", "thumbnail", "file", "resume", "tvshowid", "dateadded", "uniqueid", "art", "specialsortseason", "specialsortepisode", "userrating", "seasonid"));
    }

    public static class Streams
    extends AbstractModel {
        public static final String API_TYPE = "Video.Streams";
        public static final String AUDIO = "audio";
        public static final String SUBTITLE = "subtitle";
        public static final String VIDEO = "video";
        public final List<Audio> audio;
        public final List<Subtitle> subtitle;
        public final List<Video> video;

        public Streams(List<Audio> audio, List<Subtitle> subtitle, List<Video> video) {
            this.audio = audio;
            this.subtitle = subtitle;
            this.video = video;
        }

        public Streams(JsonNode node) {
            this.audio = Audio.getVideoModelAudioList(node, AUDIO);
            this.subtitle = Subtitle.getVideoModelSubtitleList(node, SUBTITLE);
            this.video = Video.getVideoModelVideoList(node, VIDEO);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            ArrayNode audioArray = OM.createArrayNode();
            for (Audio audio : this.audio) {
                audioArray.add(audio.toJsonNode());
            }
            node.put(AUDIO, (JsonNode)audioArray);
            ArrayNode subtitleArray = OM.createArrayNode();
            for (Subtitle item : this.subtitle) {
                subtitleArray.add(item.toJsonNode());
            }
            node.put(SUBTITLE, (JsonNode)subtitleArray);
            ArrayNode arrayNode = OM.createArrayNode();
            for (Video item : this.video) {
                arrayNode.add(item.toJsonNode());
            }
            node.put(VIDEO, (JsonNode)arrayNode);
            return node;
        }

        static List<Streams> getVideoModelStreamsList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<Streams> l = new ArrayList<Streams>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new Streams(a.get(i)));
                }
                return l;
            }
            return new ArrayList<Streams>(0);
        }

        public static class Video
        extends AbstractModel {
            public static final String ASPECT = "aspect";
            public static final String CODEC = "codec";
            public static final String DURATION = "duration";
            public static final String HEIGHT = "height";
            public static final String WIDTH = "width";
            public final Double aspect;
            public final String codec;
            public final Integer duration;
            public final Integer height;
            public final Integer width;

            public Video(Double aspect, String codec, Integer duration, Integer height, Integer width) {
                this.aspect = aspect;
                this.codec = codec;
                this.duration = duration;
                this.height = height;
                this.width = width;
            }

            public Video(JsonNode node) {
                this.aspect = Video.parseDouble(node, ASPECT);
                this.codec = Video.parseString(node, CODEC);
                this.duration = Video.parseInt(node, DURATION);
                this.height = Video.parseInt(node, HEIGHT);
                this.width = Video.parseInt(node, WIDTH);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(ASPECT, this.aspect);
                node.put(CODEC, this.codec);
                node.put(DURATION, this.duration);
                node.put(HEIGHT, this.height);
                node.put(WIDTH, this.width);
                return node;
            }

            static List<Video> getVideoModelVideoList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<Video> l = new ArrayList<Video>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new Video(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<Video>(0);
            }
        }

        public static class Subtitle
        extends AbstractModel {
            public static final String LANGUAGE = "language";
            public final String language;

            public Subtitle(String language) {
                this.language = language;
            }

            public Subtitle(JsonNode node) {
                this.language = Subtitle.parseString(node, LANGUAGE);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(LANGUAGE, this.language);
                return node;
            }

            static List<Subtitle> getVideoModelSubtitleList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<Subtitle> l = new ArrayList<Subtitle>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new Subtitle(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<Subtitle>(0);
            }
        }

        public static class Audio
        extends AbstractModel {
            public static final String CHANNELS = "channels";
            public static final String CODEC = "codec";
            public static final String LANGUAGE = "language";
            public final Integer channels;
            public final String codec;
            public final String language;

            public Audio(Integer channels, String codec, String language) {
                this.channels = channels;
                this.codec = codec;
                this.language = language;
            }

            public Audio(JsonNode node) {
                this.channels = Audio.parseInt(node, CHANNELS);
                this.codec = Audio.parseString(node, CODEC);
                this.language = Audio.parseString(node, LANGUAGE);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(CHANNELS, this.channels);
                node.put(CODEC, this.codec);
                node.put(LANGUAGE, this.language);
                return node;
            }

            static List<Audio> getVideoModelAudioList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<Audio> l = new ArrayList<Audio>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new Audio(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<Audio>(0);
            }
        }
    }

    public static class Resume
    extends AbstractModel {
        public static final String API_TYPE = "Video.Resume";
        public static final String POSITION = "position";
        public static final String TOTAL = "total";
        public final Double position;
        public final Double total;

        public Resume(Double position, Double total) {
            this.position = position;
            this.total = total;
        }

        public Resume(JsonNode node) {
            this.position = Resume.parseDouble(node, POSITION);
            this.total = Resume.parseDouble(node, TOTAL);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(POSITION, this.position);
            node.put(TOTAL, this.total);
            return node;
        }

        static List<Resume> getVideoModelResumeList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<Resume> l = new ArrayList<Resume>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new Resume(a.get(i)));
                }
                return l;
            }
            return new ArrayList<Resume>(0);
        }
    }

    public static class TVShowDetail
    extends ItemDetail {
        public static final String API_TYPE = "Video.Details.TVShow";
        public static final String CAST = "cast";
        public static final String EPISODE = "episode";
        public static final String EPISODEGUIDE = "episodeguide";
        public static final String GENRE = "genre";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String MPAA = "mpaa";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String PREMIERED = "premiered";
        public static final String RATING = "rating";
        public static final String SEASON = "season";
        public static final String SORTTITLE = "sorttitle";
        public static final String STUDIO = "studio";
        public static final String TAG = "tag";
        public static final String TVSHOWID = "tvshowid";
        public static final String USERRATING = "userrating";
        public static final String VOTES = "votes";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public static final String YEAR = "year";
        public final List<Cast> cast;
        public final Integer episode;
        public final String episodeguide;
        public final List<String> genre;
        public final String imdbnumber;
        public final String mpaa;
        public final String originaltitle;
        public final String premiered;
        public final Double rating;
        public final Integer season;
        public final String sorttitle;
        public final List<String> studio;
        public final List<String> tag;
        public final Integer tvshowid;
        public final Integer userrating;
        public final String votes;
        public final Integer watchedepisodes;
        public final Integer year;

        public TVShowDetail(JsonNode node) {
            super(node);
            this.cast = Cast.getVideoModelCastList(node, CAST);
            this.episode = TVShowDetail.parseInt(node, EPISODE);
            this.episodeguide = TVShowDetail.parseString(node, EPISODEGUIDE);
            this.genre = TVShowDetail.getStringArray(node, GENRE);
            this.imdbnumber = TVShowDetail.parseString(node, IMDBNUMBER);
            this.mpaa = TVShowDetail.parseString(node, MPAA);
            this.originaltitle = TVShowDetail.parseString(node, ORIGINALTITLE);
            this.premiered = TVShowDetail.parseString(node, PREMIERED);
            this.rating = TVShowDetail.parseDouble(node, RATING);
            this.season = TVShowDetail.parseInt(node, SEASON);
            this.sorttitle = TVShowDetail.parseString(node, SORTTITLE);
            this.studio = TVShowDetail.getStringArray(node, STUDIO);
            this.tag = TVShowDetail.getStringArray(node, TAG);
            this.tvshowid = TVShowDetail.parseInt(node, TVSHOWID);
            this.userrating = TVShowDetail.parseInt(node, USERRATING);
            this.votes = TVShowDetail.parseString(node, VOTES);
            this.watchedepisodes = TVShowDetail.parseInt(node, WATCHEDEPISODES);
            this.year = TVShowDetail.parseInt(node, YEAR);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            ArrayNode castArray = OM.createArrayNode();
            for (Cast cast : this.cast) {
                castArray.add(cast.toJsonNode());
            }
            node.put(CAST, (JsonNode)castArray);
            node.put(EPISODE, this.episode);
            node.put(EPISODEGUIDE, this.episodeguide);
            ArrayNode genreArray = OM.createArrayNode();
            for (String string : this.genre) {
                genreArray.add(string);
            }
            node.put(GENRE, (JsonNode)genreArray);
            node.put(IMDBNUMBER, this.imdbnumber);
            node.put(MPAA, this.mpaa);
            node.put(ORIGINALTITLE, this.originaltitle);
            node.put(PREMIERED, this.premiered);
            node.put(RATING, this.rating);
            node.put(SEASON, this.season);
            node.put(SORTTITLE, this.sorttitle);
            ArrayNode arrayNode = OM.createArrayNode();
            for (String item : this.studio) {
                arrayNode.add(item);
            }
            node.put(STUDIO, (JsonNode)arrayNode);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (String item : this.tag) {
                arrayNode2.add(item);
            }
            node.put(TAG, (JsonNode)arrayNode2);
            node.put(TVSHOWID, this.tvshowid);
            node.put(USERRATING, this.userrating);
            node.put(VOTES, this.votes);
            node.put(WATCHEDEPISODES, this.watchedepisodes);
            node.put(YEAR, this.year);
            return node;
        }

        static List<TVShowDetail> getVideoModelTVShowDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<TVShowDetail> l = new ArrayList<TVShowDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new TVShowDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<TVShowDetail>(0);
        }
    }

    public static class SeasonDetail
    extends BaseDetail {
        public static final String API_TYPE = "Video.Details.Season";
        public static final String EPISODE = "episode";
        public static final String SEASON = "season";
        public static final String SEASONID = "seasonid";
        public static final String SHOWTITLE = "showtitle";
        public static final String TVSHOWID = "tvshowid";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public final Integer episode;
        public final Integer season;
        public final Integer seasonid;
        public final String showtitle;
        public final Integer tvshowid;
        public final Integer watchedepisodes;

        public SeasonDetail(JsonNode node) {
            super(node);
            this.episode = SeasonDetail.parseInt(node, EPISODE);
            this.season = node.get(SEASON).getIntValue();
            this.seasonid = SeasonDetail.parseInt(node, SEASONID);
            this.showtitle = SeasonDetail.parseString(node, SHOWTITLE);
            this.tvshowid = SeasonDetail.parseInt(node, TVSHOWID);
            this.watchedepisodes = SeasonDetail.parseInt(node, WATCHEDEPISODES);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(EPISODE, this.episode);
            node.put(SEASON, this.season);
            node.put(SEASONID, this.seasonid);
            node.put(SHOWTITLE, this.showtitle);
            node.put(TVSHOWID, this.tvshowid);
            node.put(WATCHEDEPISODES, this.watchedepisodes);
            return node;
        }

        static List<SeasonDetail> getVideoModelSeasonDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SeasonDetail> l = new ArrayList<SeasonDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SeasonDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SeasonDetail>(0);
        }
    }

    public static class MusicVideoDetail
    extends FileDetail {
        public static final String API_TYPE = "Video.Details.MusicVideo";
        public static final String ALBUM = "album";
        public static final String ARTIST = "artist";
        public static final String GENRE = "genre";
        public static final String MUSICVIDEOID = "musicvideoid";
        public static final String STUDIO = "studio";
        public static final String TAG = "tag";
        public static final String TRACK = "track";
        public static final String USERRATING = "userrating";
        public static final String YEAR = "year";
        public final String album;
        public final List<String> artist;
        public final List<String> genre;
        public final Integer musicvideoid;
        public final List<String> studio;
        public final List<String> tag;
        public final Integer track;
        public final Integer userrating;
        public final Integer year;

        public MusicVideoDetail(JsonNode node) {
            super(node);
            this.album = MusicVideoDetail.parseString(node, ALBUM);
            this.artist = MusicVideoDetail.getStringArray(node, ARTIST);
            this.genre = MusicVideoDetail.getStringArray(node, GENRE);
            this.musicvideoid = MusicVideoDetail.parseInt(node, MUSICVIDEOID);
            this.studio = MusicVideoDetail.getStringArray(node, STUDIO);
            this.tag = MusicVideoDetail.getStringArray(node, TAG);
            this.track = MusicVideoDetail.parseInt(node, TRACK);
            this.userrating = MusicVideoDetail.parseInt(node, USERRATING);
            this.year = MusicVideoDetail.parseInt(node, YEAR);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(ALBUM, this.album);
            ArrayNode artistArray = OM.createArrayNode();
            for (String string : this.artist) {
                artistArray.add(string);
            }
            node.put(ARTIST, (JsonNode)artistArray);
            ArrayNode genreArray = OM.createArrayNode();
            for (String string : this.genre) {
                genreArray.add(string);
            }
            node.put(GENRE, (JsonNode)genreArray);
            node.put(MUSICVIDEOID, this.musicvideoid);
            ArrayNode arrayNode = OM.createArrayNode();
            for (String item : this.studio) {
                arrayNode.add(item);
            }
            node.put(STUDIO, (JsonNode)arrayNode);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (String item : this.tag) {
                arrayNode2.add(item);
            }
            node.put(TAG, (JsonNode)arrayNode2);
            node.put(TRACK, this.track);
            node.put(USERRATING, this.userrating);
            node.put(YEAR, this.year);
            return node;
        }

        static List<MusicVideoDetail> getVideoModelMusicVideoDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<MusicVideoDetail> l = new ArrayList<MusicVideoDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new MusicVideoDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<MusicVideoDetail>(0);
        }
    }

    public static class MovieSetExtendedDetail
    extends MovieSetDetail {
        public static final String API_TYPE = "Video.Details.MovieSet.Extended";
        public static final String LIMITS = "limits";
        public static final String MOVIES = "movies";
        public final ListModel.LimitsReturned limits;
        public final List<MovieDetail> movies;

        public MovieSetExtendedDetail(JsonNode node) {
            super(node);
            this.limits = node.has(LIMITS) ? new ListModel.LimitsReturned(node.get(LIMITS)) : null;
            this.movies = MovieDetail.getVideoModelMovieDetailList(node, MOVIES);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(LIMITS, this.limits == null ? null : this.limits.toJsonNode());
            ArrayNode moviesArray = OM.createArrayNode();
            for (MovieDetail item : this.movies) {
                moviesArray.add(item.toJsonNode());
            }
            node.put(MOVIES, (JsonNode)moviesArray);
            return node;
        }

        static List<MovieSetExtendedDetail> getVideoModelMovieSetExtendedDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<MovieSetExtendedDetail> l = new ArrayList<MovieSetExtendedDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new MovieSetExtendedDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<MovieSetExtendedDetail>(0);
        }
    }

    public static class MovieSetDetail
    extends MediaDetail {
        public static final String API_TYPE = "Video.Details.MovieSet";
        public static final String PLOT = "plot";
        public static final String SETID = "setid";
        public final String plot;
        public final Integer setid;

        public MovieSetDetail(JsonNode node) {
            super(node);
            this.plot = MovieSetDetail.parseString(node, PLOT);
            this.setid = MovieSetDetail.parseInt(node, SETID);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(PLOT, this.plot);
            node.put(SETID, this.setid);
            return node;
        }

        static List<MovieSetDetail> getVideoModelMovieSetDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<MovieSetDetail> l = new ArrayList<MovieSetDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new MovieSetDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<MovieSetDetail>(0);
        }
    }

    public static class MovieDetail
    extends FileDetail {
        public static final String API_TYPE = "Video.Details.Movie";
        public static final String CAST = "cast";
        public static final String COUNTRY = "country";
        public static final String GENRE = "genre";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String MOVIEID = "movieid";
        public static final String MPAA = "mpaa";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String RATING = "rating";
        public static final String SET = "set";
        public static final String SETID = "setid";
        public static final String SHOWLINK = "showlink";
        public static final String SORTTITLE = "sorttitle";
        public static final String STUDIO = "studio";
        public static final String TAG = "tag";
        public static final String TAGLINE = "tagline";
        public static final String TOP250 = "top250";
        public static final String TRAILER = "trailer";
        public static final String USERRATING = "userrating";
        public static final String VOTES = "votes";
        public static final String WRITER = "writer";
        public static final String YEAR = "year";
        public final List<Cast> cast;
        public final List<String> country;
        public final List<String> genre;
        public final String imdbnumber;
        public final Integer movieid;
        public final String mpaa;
        public final String originaltitle;
        public final String plotoutline;
        public final Double rating;
        public final String set;
        public final Integer setid;
        public final List<String> showlink;
        public final String sorttitle;
        public final List<String> studio;
        public final List<String> tag;
        public final String tagline;
        public final Integer top250;
        public final String trailer;
        public final Integer userrating;
        public final String votes;
        public final List<String> writer;
        public final Integer year;

        public MovieDetail(JsonNode node) {
            super(node);
            this.cast = Cast.getVideoModelCastList(node, CAST);
            this.country = MovieDetail.getStringArray(node, COUNTRY);
            this.genre = MovieDetail.getStringArray(node, GENRE);
            this.imdbnumber = MovieDetail.parseString(node, IMDBNUMBER);
            this.movieid = MovieDetail.parseInt(node, MOVIEID);
            this.mpaa = MovieDetail.parseString(node, MPAA);
            this.originaltitle = MovieDetail.parseString(node, ORIGINALTITLE);
            this.plotoutline = MovieDetail.parseString(node, PLOTOUTLINE);
            this.rating = MovieDetail.parseDouble(node, RATING);
            this.set = MovieDetail.parseString(node, SET);
            this.setid = MovieDetail.parseInt(node, SETID);
            this.showlink = MovieDetail.getStringArray(node, SHOWLINK);
            this.sorttitle = MovieDetail.parseString(node, SORTTITLE);
            this.studio = MovieDetail.getStringArray(node, STUDIO);
            this.tag = MovieDetail.getStringArray(node, TAG);
            this.tagline = MovieDetail.parseString(node, TAGLINE);
            this.top250 = MovieDetail.parseInt(node, TOP250);
            this.trailer = MovieDetail.parseString(node, TRAILER);
            this.userrating = MovieDetail.parseInt(node, USERRATING);
            this.votes = MovieDetail.parseString(node, VOTES);
            this.writer = MovieDetail.getStringArray(node, WRITER);
            this.year = MovieDetail.parseInt(node, YEAR);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            ArrayNode castArray = OM.createArrayNode();
            for (Cast cast : this.cast) {
                castArray.add(cast.toJsonNode());
            }
            node.put(CAST, (JsonNode)castArray);
            ArrayNode countryArray = OM.createArrayNode();
            for (String string : this.country) {
                countryArray.add(string);
            }
            node.put(COUNTRY, (JsonNode)countryArray);
            ArrayNode arrayNode = OM.createArrayNode();
            for (String string : this.genre) {
                arrayNode.add(string);
            }
            node.put(GENRE, (JsonNode)arrayNode);
            node.put(IMDBNUMBER, this.imdbnumber);
            node.put(MOVIEID, this.movieid);
            node.put(MPAA, this.mpaa);
            node.put(ORIGINALTITLE, this.originaltitle);
            node.put(PLOTOUTLINE, this.plotoutline);
            node.put(RATING, this.rating);
            node.put(SET, this.set);
            node.put(SETID, this.setid);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (String string : this.showlink) {
                arrayNode2.add(string);
            }
            node.put(SHOWLINK, (JsonNode)arrayNode2);
            node.put(SORTTITLE, this.sorttitle);
            ArrayNode arrayNode3 = OM.createArrayNode();
            for (String string : this.studio) {
                arrayNode3.add(string);
            }
            node.put(STUDIO, (JsonNode)arrayNode3);
            ArrayNode arrayNode4 = OM.createArrayNode();
            for (String item : this.tag) {
                arrayNode4.add(item);
            }
            node.put(TAG, (JsonNode)arrayNode4);
            node.put(TAGLINE, this.tagline);
            node.put(TOP250, this.top250);
            node.put(TRAILER, this.trailer);
            node.put(USERRATING, this.userrating);
            node.put(VOTES, this.votes);
            ArrayNode arrayNode5 = OM.createArrayNode();
            for (String item : this.writer) {
                arrayNode5.add(item);
            }
            node.put(WRITER, (JsonNode)arrayNode5);
            node.put(YEAR, this.year);
            return node;
        }

        static List<MovieDetail> getVideoModelMovieDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<MovieDetail> l = new ArrayList<MovieDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new MovieDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<MovieDetail>(0);
        }
    }

    public static class MediaDetail
    extends BaseDetail {
        public static final String API_TYPE = "Video.Details.Media";
        public static final String TITLE = "title";
        public final String title;

        public MediaDetail(JsonNode node) {
            super(node);
            this.title = MediaDetail.parseString(node, TITLE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(TITLE, this.title);
            return node;
        }

        static List<MediaDetail> getVideoModelMediaDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<MediaDetail> l = new ArrayList<MediaDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new MediaDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<MediaDetail>(0);
        }
    }

    public static class ItemDetail
    extends MediaDetail {
        public static final String API_TYPE = "Video.Details.Item";
        public static final String DATEADDED = "dateadded";
        public static final String FILE = "file";
        public static final String LASTPLAYED = "lastplayed";
        public static final String PLOT = "plot";
        public final String dateadded;
        public final String file;
        public final String lastplayed;
        public final String plot;

        public ItemDetail(JsonNode node) {
            super(node);
            this.dateadded = ItemDetail.parseString(node, DATEADDED);
            this.file = ItemDetail.parseString(node, FILE);
            this.lastplayed = ItemDetail.parseString(node, LASTPLAYED);
            this.plot = ItemDetail.parseString(node, PLOT);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(DATEADDED, this.dateadded);
            node.put(FILE, this.file);
            node.put(LASTPLAYED, this.lastplayed);
            node.put(PLOT, this.plot);
            return node;
        }

        static List<ItemDetail> getVideoModelItemDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ItemDetail> l = new ArrayList<ItemDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ItemDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ItemDetail>(0);
        }
    }

    public static class FileDetail
    extends ItemDetail {
        public static final String API_TYPE = "Video.Details.File";
        public static final String DIRECTOR = "director";
        public static final String RESUME = "resume";
        public static final String RUNTIME = "runtime";
        public static final String STREAMDETAILS = "streamdetails";
        public final List<String> director;
        public final Resume resume;
        public final Integer runtime;
        public final Streams streamdetails;

        public FileDetail(JsonNode node) {
            super(node);
            this.director = FileDetail.getStringArray(node, DIRECTOR);
            this.resume = node.has(RESUME) ? new Resume(node.get(RESUME)) : null;
            this.runtime = FileDetail.parseInt(node, RUNTIME);
            this.streamdetails = node.has(STREAMDETAILS) ? new Streams(node.get(STREAMDETAILS)) : null;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            ArrayNode directorArray = OM.createArrayNode();
            for (String item : this.director) {
                directorArray.add(item);
            }
            node.put(DIRECTOR, (JsonNode)directorArray);
            node.put(RESUME, this.resume == null ? null : this.resume.toJsonNode());
            node.put(RUNTIME, this.runtime);
            node.put(STREAMDETAILS, this.streamdetails == null ? null : this.streamdetails.toJsonNode());
            return node;
        }

        static List<FileDetail> getVideoModelFileDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<FileDetail> l = new ArrayList<FileDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new FileDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<FileDetail>(0);
        }
    }

    public static class EpisodeDetail
    extends FileDetail {
        public static final String API_TYPE = "Video.Details.Episode";
        public static final String CAST = "cast";
        public static final String EPISODE = "episode";
        public static final String EPISODEID = "episodeid";
        public static final String FIRSTAIRED = "firstaired";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String PRODUCTIONCODE = "productioncode";
        public static final String RATING = "rating";
        public static final String SEASON = "season";
        public static final String SEASONID = "seasonid";
        public static final String SHOWTITLE = "showtitle";
        public static final String SPECIALSORTEPISODE = "specialsortepisode";
        public static final String SPECIALSORTSEASON = "specialsortseason";
        public static final String TVSHOWID = "tvshowid";
        public static final String UNIQUEID = "uniqueid";
        public static final String USERRATING = "userrating";
        public static final String VOTES = "votes";
        public static final String WRITER = "writer";
        public final List<Cast> cast;
        public final Integer episode;
        public final Integer episodeid;
        public final String firstaired;
        public final String originaltitle;
        public final String productioncode;
        public final Double rating;
        public final Integer season;
        public final Integer seasonid;
        public final String showtitle;
        public final Integer specialsortepisode;
        public final Integer specialsortseason;
        public final Integer tvshowid;
        public final HashMap<String, String> uniqueid;
        public final Integer userrating;
        public final String votes;
        public final List<String> writer;

        public EpisodeDetail(JsonNode node) {
            super(node);
            this.cast = Cast.getVideoModelCastList(node, CAST);
            this.episode = EpisodeDetail.parseInt(node, EPISODE);
            this.episodeid = EpisodeDetail.parseInt(node, EPISODEID);
            this.firstaired = EpisodeDetail.parseString(node, FIRSTAIRED);
            this.originaltitle = EpisodeDetail.parseString(node, ORIGINALTITLE);
            this.productioncode = EpisodeDetail.parseString(node, PRODUCTIONCODE);
            this.rating = EpisodeDetail.parseDouble(node, RATING);
            this.season = EpisodeDetail.parseInt(node, SEASON);
            this.seasonid = EpisodeDetail.parseInt(node, SEASONID);
            this.showtitle = EpisodeDetail.parseString(node, SHOWTITLE);
            this.specialsortepisode = EpisodeDetail.parseInt(node, SPECIALSORTEPISODE);
            this.specialsortseason = EpisodeDetail.parseInt(node, SPECIALSORTSEASON);
            this.tvshowid = EpisodeDetail.parseInt(node, TVSHOWID);
            this.uniqueid = EpisodeDetail.getStringMap(node, UNIQUEID);
            this.userrating = EpisodeDetail.parseInt(node, USERRATING);
            this.votes = EpisodeDetail.parseString(node, VOTES);
            this.writer = EpisodeDetail.getStringArray(node, WRITER);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            ArrayNode castArray = OM.createArrayNode();
            for (Cast cast : this.cast) {
                castArray.add(cast.toJsonNode());
            }
            node.put(CAST, (JsonNode)castArray);
            node.put(EPISODE, this.episode);
            node.put(EPISODEID, this.episodeid);
            node.put(FIRSTAIRED, this.firstaired);
            node.put(ORIGINALTITLE, this.originaltitle);
            node.put(PRODUCTIONCODE, this.productioncode);
            node.put(RATING, this.rating);
            node.put(SEASON, this.season);
            node.put(SEASONID, this.seasonid);
            node.put(SHOWTITLE, this.showtitle);
            node.put(SPECIALSORTEPISODE, this.specialsortepisode);
            node.put(SPECIALSORTSEASON, this.specialsortseason);
            node.put(TVSHOWID, this.tvshowid);
            ObjectNode uniqueidMap = OM.createObjectNode();
            for (String key : this.uniqueid.values()) {
                uniqueidMap.put(key, this.uniqueid.get(key));
            }
            node.put(UNIQUEID, (JsonNode)uniqueidMap);
            node.put(USERRATING, this.userrating);
            node.put(VOTES, this.votes);
            ArrayNode arrayNode = OM.createArrayNode();
            for (String item : this.writer) {
                arrayNode.add(item);
            }
            node.put(WRITER, (JsonNode)arrayNode);
            return node;
        }

        static List<EpisodeDetail> getVideoModelEpisodeDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<EpisodeDetail> l = new ArrayList<EpisodeDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new EpisodeDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<EpisodeDetail>(0);
        }
    }

    public static class BaseDetail
    extends MediaModel.BaseDetail {
        public static final String API_TYPE = "Video.Details.Base";
        public static final String ART = "art";
        public static final String PLAYCOUNT = "playcount";
        public final MediaModel.Artwork art;
        public final Integer playcount;

        public BaseDetail(JsonNode node) {
            super(node);
            this.art = node.has(ART) ? new MediaModel.Artwork(node.get(ART)) : null;
            this.playcount = BaseDetail.parseInt(node, PLAYCOUNT);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(ART, this.art == null ? null : this.art.toJsonNode());
            node.put(PLAYCOUNT, this.playcount);
            return node;
        }

        static List<BaseDetail> getVideoModelBaseDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<BaseDetail> l = new ArrayList<BaseDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new BaseDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<BaseDetail>(0);
        }
    }

    public static class Cast
    extends AbstractModel {
        public static final String NAME = "name";
        public static final String ORDER = "order";
        public static final String ROLE = "role";
        public static final String THUMBNAIL = "thumbnail";
        public final String name;
        public final Integer order;
        public final String role;
        public final String thumbnail;

        public Cast(String name, Integer order, String role, String thumbnail) {
            this.name = name;
            this.order = order;
            this.role = role;
            this.thumbnail = thumbnail;
        }

        public Cast(JsonNode node) {
            this.name = node.get(NAME).getTextValue();
            this.order = node.get(ORDER).getIntValue();
            this.role = node.get(ROLE).getTextValue();
            this.thumbnail = Cast.parseString(node, THUMBNAIL);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(NAME, this.name);
            node.put(ORDER, this.order);
            node.put(ROLE, this.role);
            node.put(THUMBNAIL, this.thumbnail);
            return node;
        }

        static List<Cast> getVideoModelCastList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<Cast> l = new ArrayList<Cast>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new Cast(a.get(i)));
                }
                return l;
            }
            return new ArrayList<Cast>(0);
        }
    }
}

