/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660;

import com.github.stephenc.javaisotools.loopfs.api.FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import com.github.stephenc.javaisotools.loopfs.iso9660.Util;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldCL;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldNM;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldPL;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldPN;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldPX;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldRE;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldRR;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldSF;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldSL;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripFieldTF;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspField;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspFieldCE;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspFieldER;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspFieldPD;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspFieldSP;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspFieldST;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.exceptions.InvalidSuspField;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.exceptions.SuspFieldEnds;
import java.util.ArrayList;
import java.util.List;

public final class Iso9660FileEntry
implements FileEntry {
    public static final String ID_SEPARATOR1 = ".;1";
    public static final String ID_SEPARATOR2 = ";1";
    private Iso9660FileSystem fileSystem;
    private String parentPath;
    private final int entryLength;
    private final long startSector;
    private final long dataLength;
    private final long lastModifiedTime;
    private final int flags;
    private final int fidLength;
    private final String identifier;
    private final boolean suParsed;
    private final List<SuspField> suspFields = new ArrayList<SuspField>();
    private final List<RripFieldNM> rrnmFields = new ArrayList<RripFieldNM>();
    private final List<RripFieldSL> rrslFields = new ArrayList<RripFieldSL>();
    private RripFieldPX rrpxField = null;

    public Iso9660FileEntry(Iso9660FileSystem fileSystem, byte[] block, int pos) {
        this(fileSystem, null, block, pos, true);
    }

    public Iso9660FileEntry(Iso9660FileSystem fileSystem, String parentPath, byte[] block, int startPos) {
        this(fileSystem, parentPath, block, startPos, true);
    }

    public Iso9660FileEntry(Iso9660FileSystem fileSystem, String parentPath, byte[] block, int startPos, boolean parseSu) {
        this.fileSystem = fileSystem;
        this.parentPath = parentPath;
        int offset = startPos - 1;
        this.entryLength = Util.getUInt8(block, offset + 1);
        this.startSector = Util.getUInt32LE(block, offset + 3);
        this.dataLength = Util.getUInt32LE(block, offset + 11);
        this.lastModifiedTime = Util.getDateTime(block, offset + 19);
        this.flags = Util.getUInt8(block, offset + 26);
        this.fidLength = Util.getUInt8(block, offset + 33);
        this.identifier = this.getFileIdentifier(block, offset, this.isDirectory());
        this.suParsed = parseSu;
        if (this.suParsed) {
            int suStartPos = offset + 33 + this.fidLength;
            if (this.fidLength % 2 == 0) {
                ++suStartPos;
            }
            byte[] suBlock = Util.getBytes(block, suStartPos, this.entryLength - (33 + this.fidLength));
            try {
                this.deserializeSuBlock(suBlock);
            }
            catch (InvalidSuspField ex) {
                throw new RuntimeException(ex);
            }
            catch (SuspFieldEnds suspFieldEnds) {
                // empty catch block
            }
        }
    }

    private void deserializeSuBlock(byte[] suBlock) throws InvalidSuspField, SuspFieldEnds {
        int length;
        for (int suBp = 1; suBp < suBlock.length; suBp += length) {
            SuspField field;
            int nextId = SuspField.extractFieldId(suBlock, suBp);
            switch (nextId) {
                case 17221: {
                    field = new SuspFieldCE(suBlock, suBp);
                    break;
                }
                case 20548: {
                    field = new SuspFieldPD(suBlock, suBp);
                    break;
                }
                case 21328: {
                    field = new SuspFieldSP(suBlock, suBp);
                    break;
                }
                case 21332: {
                    field = new SuspFieldST(suBlock, suBp);
                    this.suspFields.add(field);
                    throw new SuspFieldEnds("SU field sequence ends with the ST field");
                }
                case 17746: {
                    field = new SuspFieldER(suBlock, suBp);
                    break;
                }
                case 20568: {
                    field = new RripFieldPX(suBlock, suBp);
                    this.rrpxField = (RripFieldPX)field;
                    break;
                }
                case 20558: {
                    field = new RripFieldPN(suBlock, suBp);
                    break;
                }
                case 21324: {
                    field = new RripFieldSL(suBlock, suBp);
                    this.rrslFields.add((RripFieldSL)field);
                    break;
                }
                case 20045: {
                    field = new RripFieldNM(suBlock, suBp);
                    this.rrnmFields.add((RripFieldNM)field);
                    break;
                }
                case 17228: {
                    field = new RripFieldCL(suBlock, suBp);
                    break;
                }
                case 20556: {
                    field = new RripFieldPL(suBlock, suBp);
                    break;
                }
                case 21061: {
                    field = new RripFieldRE(suBlock, suBp);
                    break;
                }
                case 21574: {
                    field = new RripFieldTF(suBlock, suBp);
                    break;
                }
                case 21318: {
                    field = new RripFieldSF(suBlock, suBp);
                    break;
                }
                case 21074: {
                    field = new RripFieldRR(suBlock, suBp);
                    break;
                }
                default: {
                    String hexId = Integer.toHexString(nextId).toUpperCase();
                    throw new SuspFieldEnds("SU field sequence ends with unknown field id: 0x" + hexId);
                }
            }
            this.suspFields.add(field);
            length = field.getLength();
        }
    }

    private String getFileIdentifier(byte[] block, int offset, boolean isDir) {
        if (isDir) {
            int buff34 = Util.getUInt8(block, offset + 34);
            if (this.fidLength == 1 && buff34 == 0) {
                return ".";
            }
            if (this.fidLength == 1 && buff34 == 1) {
                return "..";
            }
        }
        String id = this.suParsed ? Util.getString(block, offset + 34, this.fidLength) : Util.getDChars(block, offset + 34, this.fidLength, this.fileSystem.getEncoding());
        int sep1Idx = id.indexOf(ID_SEPARATOR1);
        int sep2Idx = id.indexOf(ID_SEPARATOR2);
        if (sep1Idx >= 0) {
            return id.substring(0, sep1Idx);
        }
        if (sep2Idx >= 0) {
            return id.substring(0, sep2Idx);
        }
        return id;
    }

    public String getName() {
        if (this.fileSystem.suspUsed().booleanValue()) {
            if (this.rrnmFields.toArray().length == 0) {
                return this.identifier;
            }
            String name = "";
            for (RripFieldNM field : this.rrnmFields) {
                name = name + field.getNameContent();
                if (field.getFlagContinue()) continue;
                break;
            }
            return name;
        }
        return this.identifier;
    }

    public String getPath() {
        if (".".equals(this.getName())) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (null != this.parentPath) {
            buf.append(this.parentPath);
        }
        buf.append(this.getName());
        if (this.isDirectory()) {
            buf.append("/");
        }
        return buf.toString();
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public boolean isDirectory() {
        return (this.flags & 3) != 0;
    }

    public boolean isSymlink() {
        return this.rrpxField.isSymlink();
    }

    public String getSymlinkPath() {
        if (!this.isSymlink()) {
            throw new RuntimeException("This is not a symbolic link");
        }
        String path = "";
        boolean firstTime = true;
        for (RripFieldSL rrsl : this.rrslFields) {
            if (!firstTime) {
                path = path + "/";
            }
            path = path + rrsl.getPathname();
            if (!rrsl.isContinuous()) break;
            firstTime = false;
        }
        return path;
    }

    public long getSize() {
        return this.dataLength;
    }

    public long getStartBlock() {
        return this.startSector;
    }

    public int getEntryLength() {
        return this.entryLength;
    }

    public final boolean isLastEntry() {
        return (this.flags & 0x40) == 0;
    }

    public List<SuspField> getSuspFields() {
        return this.suspFields;
    }

    public List<RripFieldNM> getRRNMFields() {
        return this.rrnmFields;
    }

    public boolean hasNMFields() {
        return this.rrnmFields.toArray().length > 0;
    }
}

