/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660.rrip;

import com.github.stephenc.javaisotools.loopfs.iso9660.Util;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripSLComponent;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspField;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.exceptions.InvalidSuspField;
import java.util.List;

public class RripFieldSL
extends SuspField {
    private int flags;
    private String pathname;

    public RripFieldSL() {
    }

    public RripFieldSL(byte[] bytes, int bp) throws InvalidSuspField {
        this.deserialize(bytes, bp);
    }

    public String getPathname() {
        return this.pathname;
    }

    public boolean isContinuous() {
        return (this.flags & 1) != 0;
    }

    @Override
    public int getExpectedId() {
        return 21324;
    }

    @Override
    public void deserialize(byte[] block, int bp) throws InvalidSuspField {
        this.deserializeHeader(block, bp);
        this.verifyId();
        this.flags = Util.getUInt8(block, bp + 4);
        byte[] compArea = Util.getBytes(block, bp + 4, this.length - 5);
        List<RripSLComponent> comps = RripSLComponent.fromComponentArea(compArea);
        this.pathname = this.extracPathname(comps);
    }

    private String extracPathname(List<RripSLComponent> comps) throws InvalidSuspField {
        String pathname = "";
        boolean firstTime = true;
        for (RripSLComponent comp : comps) {
            if (!firstTime) {
                pathname = pathname + "/";
            }
            if (comp.isNormalLink()) {
                pathname = pathname + comp.getText();
            }
            if (comp.linksToCurrentDir()) {
                pathname = pathname + ".";
            }
            if (comp.linksToParentDir()) {
                pathname = pathname + "..";
            }
            if (comp.linksToRootDir() && !firstTime) {
                throw new InvalidSuspField("unexpected root symlink");
            }
            firstTime = false;
        }
        return pathname;
    }
}

