/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.TinyMediaManager;
import org.tinymediamanager.core.ExportTemplate;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieComparator;
import org.tinymediamanager.core.movie.MovieExporter;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.movie.tasks.MovieScrapeTask;
import org.tinymediamanager.core.movie.tasks.MovieUpdateDatasourceTask;
import org.tinymediamanager.core.tasks.UpdaterTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowComparator;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowExporter;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowRenameTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowScrapeTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowUpdateDatasourceTask;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.util.StrgUtils;

class TinyMediaManagerCMD {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyMediaManagerCMD.class);
    private static boolean updateMovies = false;
    private static boolean updateTv = false;
    private static boolean scrapeAll = false;
    private static boolean scrapeNew = false;
    private static boolean scrapeUnscraped = false;
    private static boolean rename = false;
    private static boolean dryRun = false;
    private static boolean checkFiles = false;
    private static boolean export = false;
    private static HashSet<Integer> updateMovieDs = new HashSet();
    private static HashSet<Integer> updateTvDs = new HashSet();
    private static Path exportTemplate = null;
    private static Path exportDir = null;

    private TinyMediaManagerCMD() {
    }

    static void parseParams(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.equalsIgnoreCase("-updateMovies")) {
                updateMovies = true;
                continue;
            }
            if (cmd.matches("(?)-updateMovies[1-9]")) {
                updateMovies = true;
                updateMovieDs.add(Integer.parseInt(StrgUtils.substr(cmd, "(?)-updateMovies(\\d)")));
                continue;
            }
            if (cmd.equalsIgnoreCase("-updateTv")) {
                updateTv = true;
                continue;
            }
            if (cmd.matches("(?)-updateTv[1-9]")) {
                updateTv = true;
                updateTvDs.add(Integer.parseInt(StrgUtils.substr(cmd, "(?)-updateTv(\\d)")));
                continue;
            }
            if (cmd.equalsIgnoreCase("-update")) {
                updateMovies = true;
                updateTv = true;
                continue;
            }
            if (cmd.equalsIgnoreCase("-scrapeNew")) {
                scrapeNew = true;
                continue;
            }
            if (cmd.equalsIgnoreCase("-scrapeAll")) {
                scrapeAll = true;
                continue;
            }
            if (cmd.equalsIgnoreCase("-scrapeUnscraped")) {
                scrapeUnscraped = true;
                continue;
            }
            if (cmd.equalsIgnoreCase("-dryRun")) {
                dryRun = true;
                if (args.length != 1) continue;
                TinyMediaManagerCMD.printSyntax();
                TinyMediaManager.shutdownLogger();
                System.exit(0);
                continue;
            }
            if (cmd.equalsIgnoreCase("-checkFiles")) {
                checkFiles = true;
                continue;
            }
            if (cmd.equalsIgnoreCase("-rename") || cmd.equalsIgnoreCase("-renameNew")) {
                rename = true;
                continue;
            }
            if (cmd.equalsIgnoreCase("-export")) {
                try {
                    if (++i == args.length || i == args.length - 1) {
                        throw new Exception("missing parameters");
                    }
                    exportTemplate = Paths.get("templates", args[i]);
                    if (!Files.isDirectory(exportTemplate, new LinkOption[0])) {
                        throw new IOException("template folder not found/accessible");
                    }
                    exportDir = Paths.get(args[++i], new String[0]);
                    export = true;
                }
                catch (Exception e) {
                    System.out.println("ERROR: export failed because of: " + e.getMessage());
                    TinyMediaManagerCMD.printSyntax();
                    TinyMediaManager.shutdownLogger();
                    System.exit(0);
                }
                continue;
            }
            if (cmd.toLowerCase(Locale.ROOT).contains("help")) {
                TinyMediaManagerCMD.printSyntax();
                TinyMediaManager.shutdownLogger();
                System.exit(0);
                continue;
            }
            System.out.println("ERROR: unrecognized command " + cmd);
            TinyMediaManagerCMD.printSyntax();
            TinyMediaManager.shutdownLogger();
            System.exit(0);
        }
    }

    static void printSyntax() {
        System.out.println("\n=====================================================\n=== tinyMediaManager (c) 2012-2020 Manuel Laggner ===\n=====================================================\n\nSYNTAX:    Windows:   tinyMediaManagerCMD.exe <parameters>\n           Linux:   ./tinyMediaManagerCMD.sh  <parameters>\n\n\nPARAMETERS:\n\n    UPDATE: Will scan your folders, and adds all found items to database\n            Keeps an internal list of 'new' items (for this run only!)\n\n    -updateMovies         update all movie datasources\n    -updateMoviesX        replace X with 1-9 - just updates a single movie datasource; ordering like GUI\n    -updateTv             update all TvShow\n    -updateTvX            replace X with 1-9 - just updates a single TvShow datasource; ordering like GUI\n    -update               update all (short for '-updateMovies -updateTv')\n\n    SCRAPE: auto-scrapes (force best match) your specified items:\n    -scrapeNew            only NEW FOUND movies/TvShows/episodes from former update\n    -scrapeUnscraped      all movies/TvShows/episodes, which have not yet been scraped\n    -scrapeAll            ALL movies/TvShows/episodes, whether they have already been scraped or not\n\n    -rename               rename & cleanup all the movies/TvShows/episodes from former scrape command\n    -export template dir  exports your complete movie/tv library with specified template to dir\n    -checkFiles           does a physical check, if all files in DB are existent on filesystem (might take long!)\n\n\nEXAMPLES:\n\n    tinyMediaManagerCMD.exe -updateMovies -updateTv3 -scrapeNew -rename\n    tinyMediaManagerCMD.exe -scrapeUnscraped -rename\n    tinyMediaManagerCMD.exe -export ExcelXml /user/export/movies\n    tinyMediaManagerCMD.exe -export TvShowDetailExampleXml /user/export/tv\n");
    }

    /*
     * WARNING - void declaration
     */
    static void startCommandLineTasks() {
        try {
            void var4_27;
            TmmTask task = null;
            boolean updateAvailable = false;
            if (scrapeNew || scrapeUnscraped || scrapeAll) {
                UpdaterTask updateWorker = new UpdaterTask();
                updateWorker.run();
                updateAvailable = (Boolean)updateWorker.get();
                if (updateAvailable) {
                    LOGGER.warn("There's a new TMM update available!");
                    LOGGER.warn("Please update to remove waiting time ;)");
                    for (int i = 20; i > 0; --i) {
                        System.out.print(i + "..");
                        Thread.sleep(1000L);
                    }
                    System.out.println("0");
                }
            }
            if (updateMovies) {
                LOGGER.info("Commandline - updating movies...");
                if (updateMovieDs.isEmpty()) {
                    task = new MovieUpdateDatasourceTask();
                    task.run();
                } else {
                    ArrayList<String> dataSources = new ArrayList<String>(MovieModuleManager.SETTINGS.getMovieDataSource());
                    for (Integer n : updateMovieDs) {
                        if (dataSources == null || dataSources.size() < n - 1) continue;
                        task = new MovieUpdateDatasourceTask((String)dataSources.get(n - 1));
                        task.run();
                    }
                }
                LOGGER.info("Found " + MovieList.getInstance().getNewMovies().size() + " new movies");
            }
            List<Object> moviesToScrape = new ArrayList();
            if (scrapeAll) {
                LOGGER.info("Commandline - scraping ALL movies...");
                if (MovieList.getInstance().getMovieCount() > 0) {
                    moviesToScrape = MovieList.getInstance().getMovies();
                }
            } else {
                HashSet<Movie> scrape = new HashSet<Movie>();
                if (scrapeNew) {
                    LOGGER.info("Commandline - scraping new movies...");
                    List<Movie> list = MovieList.getInstance().getNewMovies();
                    if (!list.isEmpty()) {
                        scrape.addAll(list);
                    }
                }
                if (scrapeUnscraped) {
                    LOGGER.info("Commandline - scraping all unscraped movies...");
                    List<Movie> list = MovieList.getInstance().getUnscrapedMovies();
                    if (!list.isEmpty()) {
                        scrape.addAll(list);
                    }
                }
                moviesToScrape.addAll(new ArrayList(scrape));
            }
            if (!moviesToScrape.isEmpty()) {
                MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions();
                List<MovieScraperMetadataConfig> list = MovieModuleManager.SETTINGS.getScraperMetadataConfig();
                options.loadDefaults();
                if (dryRun) {
                    for (Movie movie : moviesToScrape) {
                        LOGGER.info("DRYRUN: would have scraped {}", (Object)movie.getTitle());
                    }
                } else {
                    task = new MovieScrapeTask(moviesToScrape, true, options, list);
                    task.run();
                    while (TmmTaskManager.getInstance().poolRunning()) {
                        Thread.sleep(2000L);
                    }
                }
            }
            if (rename) {
                LOGGER.info("Commandline - rename & cleanup movies...");
                if (!moviesToScrape.isEmpty()) {
                    if (dryRun) {
                        for (Movie movie : moviesToScrape) {
                            LOGGER.info("DRYRUN: would have renamed {}", (Object)movie.getTitle());
                        }
                    } else {
                        task = new MovieRenameTask(moviesToScrape);
                        task.run();
                    }
                }
            }
            if (export) {
                for (ExportTemplate exportTemplate : MovieExporter.findTemplates(MediaEntityExporter.TemplateType.MOVIE)) {
                    if (!exportTemplate.getPath().equals(TinyMediaManagerCMD.exportTemplate.toAbsolutePath().toString())) continue;
                    LOGGER.info("Commandline - exporting movies...");
                    if (dryRun) {
                        LOGGER.info("DRYRUN: would have exported ALL movies to {}", (Object)exportDir.toAbsolutePath());
                        break;
                    }
                    MovieExporter ex = new MovieExporter(Paths.get(exportTemplate.getPath(), new String[0]));
                    List<Movie> list = MovieList.getInstance().getMovies();
                    list.sort(new MovieComparator());
                    ex.export(list, exportDir);
                    break;
                }
            }
            if (updateTv) {
                LOGGER.info("Commandline - updating TvShows and episodes...");
                if (updateTvDs.isEmpty()) {
                    task = new TvShowUpdateDatasourceTask();
                    task.run();
                } else {
                    ArrayList<String> dataSources = new ArrayList<String>(TvShowModuleManager.SETTINGS.getTvShowDataSource());
                    for (Integer i : updateTvDs) {
                        if (dataSources == null || dataSources.size() < i - 1) continue;
                        task = new TvShowUpdateDatasourceTask((String)dataSources.get(i - 1));
                        task.run();
                    }
                }
                LOGGER.info("Commandline - found {} TvShow(s) containing {} new episode(s)", (Object)TvShowList.getInstance().getNewTvShows().size(), (Object)TvShowList.getInstance().getNewEpisodes().size());
            }
            List<Object> showToScrape = new ArrayList();
            ArrayList arrayList = new ArrayList();
            if (scrapeAll) {
                LOGGER.info("Commandline - scraping ALL TvShows...");
                if (TvShowList.getInstance().getTvShowCount() > 0) {
                    showToScrape = TvShowList.getInstance().getTvShows();
                    arrayList.clear();
                }
            } else {
                HashSet<TvShow> scrapeShow = new HashSet<TvShow>();
                HashSet<Object> hashSet = new HashSet<Object>();
                if (scrapeNew) {
                    List<TvShow> newTv = TvShowList.getInstance().getNewTvShows();
                    List<TvShowEpisode> newEp = TvShowList.getInstance().getNewEpisodes();
                    LOGGER.info("Commandline - scraping new TvShows...");
                    if (!newTv.isEmpty()) {
                        scrapeShow.addAll(newTv);
                    }
                    LOGGER.info("Commandline - scraping new episodes...");
                    if (!newEp.isEmpty()) {
                        hashSet.addAll(newEp);
                    }
                }
                if (scrapeUnscraped) {
                    LOGGER.info("Commandline - scraping unscraped TvShows...");
                    List<TvShow> unscrapedShows = TvShowList.getInstance().getUnscrapedTvShows();
                    Iterator<Object> unscrapedEpisodes = TvShowList.getInstance().getUnscrapedEpisodes();
                    if (!unscrapedShows.isEmpty()) {
                        scrapeShow.addAll(unscrapedShows);
                    }
                    LOGGER.info("Commandline - scraping unscraped episodes...");
                    if (!unscrapedEpisodes.isEmpty()) {
                        hashSet.addAll((Collection<Object>)((Object)unscrapedEpisodes));
                    }
                }
                HashSet<TvShowEpisode> removedEpisode = new HashSet<TvShowEpisode>();
                for (TvShowEpisode tvShowEpisode : hashSet) {
                    if (!scrapeShow.contains(tvShowEpisode.getTvShow())) continue;
                    removedEpisode.add(tvShowEpisode);
                }
                hashSet.removeAll(removedEpisode);
                showToScrape = new ArrayList(scrapeShow);
                ArrayList arrayList2 = new ArrayList(hashSet);
            }
            TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
            List<TvShowScraperMetadataConfig> list = TvShowModuleManager.SETTINGS.getTvShowScraperMetadataConfig();
            List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig = TvShowModuleManager.SETTINGS.getEpisodeScraperMetadataConfig();
            options.loadDefaults();
            if (!showToScrape.isEmpty()) {
                if (dryRun) {
                    for (TvShow tvShow : showToScrape) {
                        LOGGER.info("DRYRUN: would have scraped show {} with {} episodes", (Object)tvShow.getTitle(), (Object)tvShow.getEpisodeCount());
                    }
                } else {
                    task = new TvShowScrapeTask(showToScrape, true, options, list, episodeScraperMetadataConfig);
                    task.run();
                    while (TmmTaskManager.getInstance().poolRunning()) {
                        Thread.sleep(2000L);
                    }
                }
            }
            if (!var4_27.isEmpty()) {
                if (dryRun) {
                    for (TvShowEpisode tvShowEpisode : var4_27) {
                        LOGGER.info("DRYRUN: would have scraped episode {} S:{} E:{}", new Object[]{tvShowEpisode.getTvShow().getTitle(), tvShowEpisode.getSeason(), tvShowEpisode.getEpisode()});
                    }
                } else {
                    Iterator<Object> options1 = new TvShowEpisodeSearchAndScrapeOptions();
                    ((MediaSearchAndScrapeOptions)((Object)options1)).setDataFromOtherOptions(options);
                    task = new TvShowEpisodeScrapeTask((List<TvShowEpisode>)var4_27, (TvShowEpisodeSearchAndScrapeOptions)((Object)options1), episodeScraperMetadataConfig);
                    task.run();
                    while (TmmTaskManager.getInstance().poolRunning()) {
                        Thread.sleep(2000L);
                    }
                }
            }
            if (rename) {
                LOGGER.info("Commandline - rename & cleanup new shows...");
                if (!showToScrape.isEmpty()) {
                    if (dryRun) {
                        for (TvShow tvShow : showToScrape) {
                            LOGGER.info("DRYRUN: would have renamed show {} with {} episodes", (Object)tvShow.getTitle(), (Object)tvShow.getEpisodeCount());
                        }
                    } else {
                        task = new TvShowRenameTask(showToScrape, null, true);
                        task.run();
                        while (TmmTaskManager.getInstance().poolRunning()) {
                            Thread.sleep(2000L);
                        }
                    }
                }
                LOGGER.info("Commandline - rename & cleanup new episodes...");
                if (!var4_27.isEmpty()) {
                    if (dryRun) {
                        for (TvShowEpisode tvShowEpisode : var4_27) {
                            LOGGER.info("DRYRUN: would have renamed episode {} S:{} E:{}", new Object[]{tvShowEpisode.getTvShow().getTitle(), tvShowEpisode.getSeason(), tvShowEpisode.getEpisode()});
                        }
                    } else {
                        task = new TvShowRenameTask(null, (List<TvShowEpisode>)var4_27, true);
                        task.run();
                    }
                }
            }
            if (export) {
                for (ExportTemplate exportTemplate : TvShowExporter.findTemplates(MediaEntityExporter.TemplateType.TV_SHOW)) {
                    if (!exportTemplate.getPath().equals(TinyMediaManagerCMD.exportTemplate.toAbsolutePath().toString())) continue;
                    LOGGER.info("Commandline - exporting tv shows...");
                    if (dryRun) {
                        LOGGER.info("DRYRUN: would have exported ALL TV shows to {}", (Object)exportDir.toAbsolutePath());
                        break;
                    }
                    TvShowExporter ex = new TvShowExporter(Paths.get(exportTemplate.getPath(), new String[0]));
                    List<TvShow> tvShows = TvShowList.getInstance().getTvShows();
                    tvShows.sort(new TvShowComparator());
                    ex.export(tvShows, exportDir);
                    break;
                }
            }
            if (checkFiles) {
                boolean allOk = true;
                LOGGER.info("Check all files if existing");
                for (Movie m : MovieList.getInstance().getMovies()) {
                    System.out.print(".");
                    for (MediaFile mf : m.getMediaFiles()) {
                        if (mf.exists()) continue;
                        System.out.println();
                        LOGGER.warn("MediaFile not found! {}", (Object)mf.getFileAsPath());
                        allOk = false;
                    }
                }
                for (TvShow s : TvShowList.getInstance().getTvShows()) {
                    System.out.print(".");
                    for (MediaFile mf : s.getMediaFiles()) {
                        if (mf.exists()) continue;
                        System.out.println();
                        LOGGER.warn("MediaFile not found! {}", (Object)mf.getFileAsPath());
                        allOk = false;
                    }
                    for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(s.getEpisodes())) {
                        for (MediaFile mf : episode.getMediaFiles()) {
                            if (mf.exists()) continue;
                            System.out.println();
                            LOGGER.warn("MediaFile not found! {}", (Object)mf.getFileAsPath());
                            allOk = false;
                        }
                    }
                }
                System.out.println();
                if (allOk) {
                    LOGGER.info("no problems found - everything ok :)");
                }
            }
            if (updateAvailable) {
                LOGGER.warn("=====================================================");
                LOGGER.warn("There's a new TMM version available! Please update!");
                LOGGER.warn("=====================================================");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error executing command line task!", (Throwable)e);
        }
    }
}

