/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.StrgUtils;

public class UpgradeTasks {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeTasks.class);

    public static void performUpgradeTasksBeforeDatabaseLoading(String oldVersion) {
        String v = "" + oldVersion;
        if (StringUtils.isBlank((CharSequence)v)) {
            v = "3";
        }
        if (StrgUtils.compareVersion(v, "3.0.5") < 0) {
            LOGGER.info("Performing upgrade tasks to version 3.0.5");
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(Globals.CACHE_FOLDER, new String[0]));){
                for (Path path : stream) {
                    if (path.toFile().isDirectory()) continue;
                    Utils.deleteFileSafely(path);
                }
            }
            catch (Exception e) {
                LOGGER.warn("could not clean up cache folder - {}", (Object)e.getMessage());
            }
        }
        if (StrgUtils.compareVersion(v, "3.1") < 0) {
            LOGGER.info("Performing upgrade tasks to version 3.1");
            Path pluginFolder = Paths.get("plugins", new String[0]);
            if (Files.exists(pluginFolder, new LinkOption[0]) && pluginFolder.toFile().isDirectory()) {
                try {
                    Path backupFolder = Paths.get(Globals.BACKUP_FOLDER, new String[0]);
                    Utils.moveDirectorySafe(pluginFolder, backupFolder.resolve(pluginFolder.getFileName()));
                }
                catch (Exception e) {
                    LOGGER.warn("could not movie plugins folder to the backup folder: {}", (Object)e.getMessage());
                }
            }
        }
        if (StrgUtils.compareVersion(v, "3.1.2") < 0) {
            LOGGER.info("Performing upgrade tasks to version 3.1");
            if (SystemUtils.IS_OS_MAC) {
                Utils.deleteFileSafely(Paths.get("native", "mac", "liblwjgl.dylib"));
                Utils.deleteFileSafely(Paths.get("native", "mac", "liblwjgl_nfd.dylib"));
            }
        }
        if (StrgUtils.compareVersion(v, "3.1.5") < 0) {
            LOGGER.info("Performing upgrade tasks to version 3.1");
            try {
                ObjectMapper mapper = new ObjectMapper();
                Map settingsMap = (Map)mapper.readValue(new File("data/tvShows.json"), Map.class);
                Boolean renamerSpaceSubstitution = (Boolean)settingsMap.get("renamerSpaceSubstitution");
                String renamerSpaceReplacement = (String)settingsMap.get("renamerSpaceReplacement");
                if (renamerSpaceSubstitution != null && renamerSpaceReplacement != null) {
                    TvShowSettings.getInstance().setRenamerFilenameSpaceSubstitution(renamerSpaceSubstitution);
                    TvShowSettings.getInstance().setRenamerFilenameSpaceReplacement(renamerSpaceReplacement);
                    TvShowSettings.getInstance().setRenamerSeasonPathnameSpaceSubstitution(renamerSpaceSubstitution);
                    TvShowSettings.getInstance().setRenamerSeasonPathnameSpaceReplacement(renamerSpaceReplacement);
                    TvShowSettings.getInstance().setRenamerShowPathnameSpaceSubstitution(renamerSpaceSubstitution);
                    TvShowSettings.getInstance().setRenamerShowPathnameSpaceReplacement(renamerSpaceReplacement);
                    TvShowSettings.getInstance().saveSettings();
                }
            }
            catch (Exception e) {
                LOGGER.warn("could not adopt space substitution settings: {}", (Object)e.getMessage());
            }
        }
    }

    public static void performUpgradeTasksAfterDatabaseLoading(String oldVersion) {
        MovieList movieList = MovieList.getInstance();
        TvShowList tvShowList = TvShowList.getInstance();
        String v = "" + oldVersion;
        if (StringUtils.isBlank((CharSequence)v)) {
            v = "3";
        }
        if (StrgUtils.compareVersion(v, "3.0.0") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 3");
            Iterator<MediaEntity> al = new ArrayList();
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(Globals.BACKUP_FOLDER, new String[0]));){
                for (Path path : directoryStream) {
                    if (!path.getFileName().toString().matches("movies\\.db\\.\\d{4}\\-\\d{2}\\-\\d{2}\\.zip") && !path.getFileName().toString().matches("tvshows\\.db\\.\\d{4}\\-\\d{2}\\-\\d{2}\\.zip")) continue;
                    ((ArrayList)((Object)al)).add((MediaEntity)((Object)path));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Iterator iterator = ((ArrayList)((Object)al)).iterator();
            while (iterator.hasNext()) {
                Path path = (Path)iterator.next();
                Utils.deleteFileSafely(path);
            }
            if (MovieSettings.getInstance().getRenamerColonReplacement().equals("")) {
                MovieSettings.getInstance().setRenamerColonReplacement(" ");
                MovieSettings.getInstance().saveSettings();
            }
            if (TvShowSettings.getInstance().getRenamerColonReplacement().equals("")) {
                TvShowSettings.getInstance().setRenamerColonReplacement(" ");
                TvShowSettings.getInstance().saveSettings();
            }
        }
        if (StrgUtils.compareVersion(v, "3.0.1") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 3.0.1");
            for (TvShow tvShow : TvShowList.getInstance().getTvShows()) {
                if (!tvShow.getIds().containsKey("tvShowSeason")) continue;
                tvShow.removeId("tvShowSeason");
                tvShow.saveToDb();
            }
            for (TvShow tvShow : TvShowList.getInstance().getTvShows()) {
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    if (!tvShowEpisode.getArtworkUrl(MediaFileType.THUMB).equals("http://thetvdb.com/banners/")) continue;
                    tvShowEpisode.setArtworkUrl("", MediaFileType.THUMB);
                    tvShowEpisode.saveToDb();
                }
            }
        }
        if (StrgUtils.compareVersion(v, "3.0.2") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 3.0.2");
            for (TvShow tvShow : TvShowList.getInstance().getTvShows()) {
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    if (tvShowEpisode.getYear() != 0 || tvShowEpisode.getFirstAired() == null) continue;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(tvShowEpisode.getFirstAired());
                    tvShowEpisode.setYear(calendar.get(1));
                    tvShowEpisode.saveToDb();
                }
            }
        }
        if (StrgUtils.compareVersion(v, "3.0.3") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 3.0.3");
            for (Movie movie : MovieList.getInstance().getMovies()) {
                boolean bl;
                boolean bl2 = false;
                for (MediaFile mf : movie.getMediaFiles()) {
                    for (MediaFileAudioStream as : mf.getAudioStreams()) {
                        if (!as.defaultStream || as.isDefaultStream()) continue;
                        as.setDefaultStream(true);
                        bl = true;
                    }
                    for (MediaFileSubtitle sub : mf.getSubtitles()) {
                        if (sub.defaultStream && !sub.isDefaultStream()) {
                            sub.setDefaultStream(true);
                            bl = true;
                        }
                        if (!sub.forced || sub.isForced()) continue;
                        sub.setForced(true);
                        bl = true;
                    }
                }
                if (!bl) continue;
                movie.saveToDb();
            }
            for (TvShow tvShow : TvShowList.getInstance().getTvShows()) {
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    boolean dirty = false;
                    for (MediaFile mf : tvShowEpisode.getMediaFiles()) {
                        for (MediaFileAudioStream as : mf.getAudioStreams()) {
                            if (!as.defaultStream || as.isDefaultStream()) continue;
                            as.setDefaultStream(true);
                            dirty = true;
                        }
                        for (MediaFileSubtitle sub : mf.getSubtitles()) {
                            if (sub.defaultStream && !sub.isDefaultStream()) {
                                sub.setDefaultStream(true);
                                dirty = true;
                            }
                            if (!sub.forced || sub.isForced()) continue;
                            sub.setForced(true);
                            dirty = true;
                        }
                    }
                    if (!dirty) continue;
                    tvShowEpisode.saveToDb();
                }
            }
        }
        if (StrgUtils.compareVersion(v, "3.0.4") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 3.0.4");
            ImageCache.migrate();
            boolean alreadyMigrated = false;
            for (String string : Settings.getInstance().getCleanupFileType()) {
                if (!string.endsWith("$")) continue;
                alreadyMigrated = true;
                break;
            }
            if (!alreadyMigrated) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : Settings.getInstance().getCleanupFileType()) {
                    arrayList.add(string + "$");
                }
                Settings.getInstance().setCleanupFileTypes(arrayList);
            }
        }
        if (StrgUtils.compareVersion(v, "3.1") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 3.1");
            for (Movie movie : MovieList.getInstance().getMovies()) {
                boolean bl;
                boolean bl3 = false;
                for (MediaFile mf : movie.getMediaFiles()) {
                    if (mf.isHDR() && StringUtils.isBlank((CharSequence)mf.getHdrFormat())) {
                        mf.setHdrFormat("HDR10");
                        bl = true;
                    }
                    if (!"iso".equalsIgnoreCase(mf.getExtension()) || mf.isISO()) continue;
                    mf.setIsISO(true);
                    bl = true;
                }
                if (!bl) continue;
                movie.saveToDb();
            }
            for (TvShow tvShow : TvShowList.getInstance().getTvShows()) {
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    boolean dirty = false;
                    for (MediaFile mf : tvShowEpisode.getMediaFiles()) {
                        if (mf.isHDR() && StringUtils.isBlank((CharSequence)mf.getHdrFormat())) {
                            mf.setHdrFormat("HDR10");
                            dirty = true;
                        }
                        if (!"iso".equalsIgnoreCase(mf.getExtension()) || mf.isISO()) continue;
                        mf.setIsISO(true);
                        dirty = true;
                    }
                    if (!dirty) continue;
                    tvShowEpisode.saveToDb();
                }
            }
        }
        if (StrgUtils.compareVersion(v, "3.1.3") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 3.1.3");
            for (Movie movie : MovieList.getInstance().getMovies()) {
                movie.setId("imdbId", null);
            }
            for (MovieSet movieSet : MovieList.getInstance().getMovieSetList()) {
                if (movieSet.getId("tmdb") == null) continue;
                if (movieSet.getId("tmdbSet") == null) {
                    movieSet.setId("tmdbSet", movieSet.getId("tmdb"));
                }
                movieSet.setId("tmdb", null);
                movieSet.saveToDb();
            }
        }
        if (StrgUtils.compareVersion(v, "3.1.6") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 3.1.6");
            for (Movie movie : MovieList.getInstance().getMovies()) {
                boolean bl;
                boolean bl4 = false;
                for (MediaFile mediaFile : movie.getMediaFiles(MediaFileType.VIDEO, MediaFileType.TRAILER)) {
                    switch (mediaFile.getVideoCodec().toLowerCase(Locale.ROOT)) {
                        case "hevc": 
                        case "x265": {
                            mediaFile.setVideoCodec("h265");
                            bl = true;
                        }
                    }
                }
                if (!bl) continue;
                movie.saveToDb();
            }
            for (TvShow tvShow : TvShowList.getInstance().getTvShows()) {
                boolean bl;
                boolean bl5 = false;
                for (MediaFile mediaFile : tvShow.getMediaFiles(MediaFileType.VIDEO, MediaFileType.TRAILER)) {
                    switch (mediaFile.getVideoCodec().toLowerCase(Locale.ROOT)) {
                        case "hevc": 
                        case "x265": {
                            mediaFile.setVideoCodec("h265");
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    tvShow.saveToDb();
                }
                for (TvShowEpisode episode : tvShow.getEpisodes()) {
                    boolean bl6 = false;
                    for (MediaFile mediaFile : episode.getMediaFiles(MediaFileType.VIDEO, MediaFileType.TRAILER)) {
                        switch (mediaFile.getVideoCodec().toLowerCase(Locale.ROOT)) {
                            case "hevc": 
                            case "x265": {
                                mediaFile.setVideoCodec("h265");
                                bl6 = true;
                            }
                        }
                    }
                    if (!bl6) continue;
                    episode.saveToDb();
                }
            }
        }
    }

    public static void renameDownloadedFiles() {
        File cur;
        File file = new File("getdown-new.jar");
        if (file.exists() && file.length() > 100000L) {
            cur = new File("getdown.jar");
            if (file.length() != cur.length() || !cur.exists()) {
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update the updater!");
                }
            }
        }
        if (Platform.isWindows()) {
            file = new File("tinyMediaManager.new");
            if (file.exists() && file.length() > 10000L && file.length() < 100000L) {
                cur = new File("tinyMediaManager.exe");
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update tmm!");
                }
            }
            if ((file = new File("tinyMediaManagerUpd.new")).exists() && file.length() > 10000L && file.length() < 100000L) {
                cur = new File("tinyMediaManagerUpd.exe");
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update the updater!");
                }
            }
            if ((file = new File("tinyMediaManagerCMD.new")).exists() && file.length() > 10000L && file.length() < 100000L) {
                cur = new File("tinyMediaManagerCMD.exe");
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update CMD TMM!");
                }
            }
        }
        if (Platform.isMac() && (file = new File("JavaApplicationStub.new")).exists() && file.length() > 0L) {
            cur = new File("../../MacOS/JavaApplicationStub");
            try {
                FileUtils.copyFile((File)file, (File)cur);
            }
            catch (IOException e) {
                LOGGER.error("Could not update JavaApplicationStub");
            }
        }
        if (Platform.isMac() && (file = new File("Info.plist")).exists() && file.length() > 0L) {
            cur = new File("../../Info.plist");
            try {
                FileUtils.copyFile((File)file, (File)cur);
            }
            catch (IOException e) {
                LOGGER.error("Could not update JavaApplicationStub");
            }
        }
        if (Platform.isMac() && (file = new File("tmm.icns")).exists() && file.length() > 0L) {
            cur = new File("../tmm.icns");
            try {
                FileUtils.copyFile((File)file, (File)cur);
            }
            catch (IOException e) {
                LOGGER.error("Could not update tmm.icns");
            }
        }
    }
}

