/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.util.ResourceBundle;
import org.tinymediamanager.core.UTF8Control;

public enum MediaAiredStatus {
    UNKNOWN("Unknown", new String[]{""}),
    CONTINUING("Continuing", new String[]{"Continuing", "returning series"}),
    ENDED("Ended", new String[]{"Ended"});

    private static final ResourceBundle BUNDLE;
    private String name;
    private String[] possibleNotations;

    private MediaAiredStatus(String name, String[] possibleNotations) {
        this.name = name;
        this.possibleNotations = possibleNotations;
    }

    public static MediaAiredStatus findAiredStatus(String text) {
        for (MediaAiredStatus status : MediaAiredStatus.values()) {
            for (String notation : status.possibleNotations) {
                if (!notation.equalsIgnoreCase(text)) continue;
                return status;
            }
        }
        return UNKNOWN;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        try {
            return BUNDLE.getString("MediaAiredStatus." + this.name());
        }
        catch (Exception ignored) {
            return this.name;
        }
    }

    static {
        BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    }
}

