/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.LaunchUtil;
import org.tinymediamanager.core.AbstractFileVisitor;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.RecursiveToStringStyle;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.scraper.util.UrlUtil;

public class Utils {
    private static final Logger LOGGER;
    private static final Pattern localePattern;
    private static final Pattern stackingPattern1;
    private static final Pattern stackingPattern2;
    private static final Pattern stackingPattern3;
    private static final Pattern stackingPattern4;
    private static final Pattern folderStackingPattern;
    public static final Pattern YOUTUBE_PATTERN;
    private static List<Locale> availableLocales;
    private static String tempFolder;

    private Utils() {
    }

    public static String getExtension(Path path) {
        String ext = "";
        String fn = path.getFileName().toString();
        int i = fn.lastIndexOf(46);
        if (i > 0) {
            ext = fn.substring(i + 1);
        }
        return ext;
    }

    public static boolean isRegularFile(Path file) {
        try {
            BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            return (attr.isRegularFile() || attr.isOther()) && !attr.isDirectory();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isRegularFile(BasicFileAttributes attr) {
        return (attr.isRegularFile() || attr.isOther()) && !attr.isDirectory();
    }

    public static void dumpObject(Object o) {
        RecursiveToStringStyle style = new RecursiveToStringStyle(5);
        System.out.println(ReflectionToStringBuilder.toString((Object)o, (ToStringStyle)style));
        style.cleanup();
    }

    public static String relPath(String parent, String child) {
        return Utils.relPath(Paths.get(parent, new String[0]), Paths.get(child, new String[0]));
    }

    public static String relPath(Path parent, Path child) {
        return parent.relativize(child).toString();
    }

    public static String getSortableName(String title) {
        if (title == null || title.isEmpty()) {
            return "";
        }
        if (title.toLowerCase(Locale.ROOT).matches("^die hard$") || title.toLowerCase(Locale.ROOT).matches("^die hard[:\\s].*")) {
            return title;
        }
        if (title.toLowerCase(Locale.ROOT).matches("^die another day$") || title.toLowerCase(Locale.ROOT).matches("^die another day[:\\s].*")) {
            return title;
        }
        for (String prfx : Settings.getInstance().getTitlePrefix()) {
            String delim = "\\s+";
            if (prfx.matches(".*['`\u00b4]$")) {
                delim = "";
            }
            if (!title.matches("(?i)^" + Pattern.quote(prfx) + delim + "(.*)")) continue;
            title = title.replaceAll("(?i)^" + Pattern.quote(prfx) + delim + "(.*)", "$1, " + prfx);
            break;
        }
        return title.trim();
    }

    public static String removeSortableName(String title) {
        if (title == null || title.isEmpty()) {
            return "";
        }
        for (String prfx : Settings.getInstance().getTitlePrefix()) {
            String delim = " ";
            if (prfx.matches(".*['`\u00b4]$")) {
                delim = "";
            }
            title = title.replaceAll("(?i)(.*), " + prfx + "$", prfx + delim + "$1");
        }
        return title.trim();
    }

    public static String cleanStackingMarkers(String filename) {
        if (!StringUtils.isEmpty((CharSequence)filename)) {
            Matcher m = stackingPattern1.matcher(filename);
            if (m.matches()) {
                return m.group(1) + m.group(3);
            }
            m = stackingPattern2.matcher(filename);
            if (m.matches()) {
                return m.group(1) + m.group(3);
            }
            m = stackingPattern3.matcher(filename);
            if (m.matches()) {
                return m.group(1) + m.group(3);
            }
            m = stackingPattern4.matcher(filename);
            if (m.matches()) {
                return m.group(1) + m.group(3);
            }
        }
        return filename;
    }

    public static String cleanFolderStackingMarkers(String filename) {
        Matcher m;
        if (!StringUtils.isEmpty((CharSequence)filename) && (m = folderStackingPattern.matcher(filename)).matches()) {
            return m.group(1);
        }
        return filename;
    }

    public static String getFolderStackingMarker(String filename) {
        Matcher m;
        if (!StringUtils.isEmpty((CharSequence)filename) && (m = folderStackingPattern.matcher(filename)).matches()) {
            return m.group(2);
        }
        return "";
    }

    public static String getStackingMarker(String filename) {
        if (!StringUtils.isEmpty((CharSequence)filename)) {
            Matcher m = stackingPattern1.matcher(filename);
            if (m.matches()) {
                return m.group(2);
            }
            m = stackingPattern2.matcher(filename);
            if (m.matches()) {
                return m.group(2);
            }
            m = stackingPattern3.matcher(filename);
            if (m.matches()) {
                return m.group(2);
            }
            m = stackingPattern4.matcher(filename);
            if (m.matches()) {
                return m.group(2);
            }
        }
        return "";
    }

    public static String substr(String str, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher m = regex.matcher(str);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public static String getStackingPrefix(String filename) {
        String stack = Utils.getStackingMarker(filename).replaceAll("[0-9]", "");
        if (stack.length() == 1 || stack.contains("of")) {
            stack = "";
        }
        return stack;
    }

    public static int getStackingNumber(String filename) {
        String stack;
        if (!StringUtils.isEmpty((CharSequence)filename) && !(stack = Utils.getStackingMarker(filename)).isEmpty()) {
            if (stack.equalsIgnoreCase("a")) {
                return 1;
            }
            if (stack.equalsIgnoreCase("b")) {
                return 2;
            }
            if (stack.equalsIgnoreCase("c")) {
                return 3;
            }
            if (stack.equalsIgnoreCase("d")) {
                return 4;
            }
            if (stack.contains("of")) {
                stack = stack.replaceAll("of.*", "");
            }
            try {
                return Integer.parseInt(stack.replaceAll("[^0-9]", ""));
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    public static boolean isValidImdbId(String imdbId) {
        if (StringUtils.isEmpty((CharSequence)imdbId)) {
            return false;
        }
        return imdbId.matches("tt\\d{6,}");
    }

    public static String unquote(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceFirst("^\\\"(.*)\\\"$", "$1");
    }

    private static String getEncProp(String prop) {
        String property = System.getProperty(prop);
        if (StringUtils.isBlank((CharSequence)property)) {
            return "";
        }
        try {
            return URLEncoder.encode(property, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(property);
        }
    }

    public static void removeEmptyStringsFromList(List<String> list) {
        list.removeAll(Collections.singleton(null));
        list.removeAll(Collections.singleton(""));
    }

    public static String replacePlaceholders(String source, String[] replacements) {
        Matcher matcher;
        String result = source;
        int index = 0;
        Pattern pattern = Pattern.compile("\\{\\}");
        while ((matcher = pattern.matcher(result)).find()) {
            try {
                result = replacements.length > index ? result.replaceFirst(pattern.pattern(), StringEscapeUtils.escapeJava((String)replacements[index])) : result.replaceFirst(pattern.pattern(), "");
            }
            catch (Exception e) {
                result = result.replaceFirst(pattern.pattern(), "");
            }
            ++index;
        }
        return StrgUtils.removeDuplicateWhitespace(result);
    }

    public static boolean moveDirectorySafe(Path srcDir, Path destDir) throws IOException {
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcDir.toAbsolutePath().toString().equals(destDir.toAbsolutePath().toString())) {
            LOGGER.debug("try to move folder {} to {}", (Object)srcDir, (Object)destDir);
            if (!Files.isDirectory(srcDir, new LinkOption[0])) {
                throw new FileNotFoundException("Source '{}" + srcDir + "' does not exist, or is not a directory");
            }
            if (Files.exists(destDir, new LinkOption[0]) && !Files.isSameFile(destDir, srcDir)) {
                throw new FileExistsException("Destination '" + destDir + "' already exists");
            }
            if (destDir.getParent() != null && !Files.exists(destDir.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectories(destDir.getParent(), new FileAttribute[0]);
                }
                catch (Exception e) {
                    LOGGER.error("could not create directory structure {}", (Object)destDir.getParent());
                }
            }
            boolean rename = false;
            for (int i = 0; i < 5; ++i) {
                try {
                    Files.move(srcDir, destDir, StandardCopyOption.ATOMIC_MOVE);
                    rename = true;
                }
                catch (AtomicMoveNotSupportedException a) {
                    try (Stream<Path> stream = Files.walk(srcDir, new FileVisitOption[0]);){
                        Iterator srcFiles = stream.iterator();
                        while (srcFiles.hasNext()) {
                            Path source = (Path)srcFiles.next();
                            Path destination = destDir.resolve(srcDir.relativize(source));
                            if (Files.isSymbolicLink(source)) {
                                Files.createSymbolicLink(destination, source.toRealPath(new LinkOption[0]), new FileAttribute[0]);
                                continue;
                            }
                            if (Files.isDirectory(source, new LinkOption[0])) {
                                if (Files.exists(destination, new LinkOption[0])) continue;
                                Files.createDirectory(destination, new FileAttribute[0]);
                                continue;
                            }
                            Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
                        }
                        Utils.deleteDirectoryRecursive(srcDir);
                        rename = true;
                    }
                    catch (IOException e) {
                        LOGGER.warn("rename problem (fallback): {}", (Object)e.getMessage());
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("rename problem: {}", (Object)e.getMessage());
                }
                if (rename) break;
                try {
                    LOGGER.debug("rename did not work - sleep a while and try again...");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.warn("I'm so excited - could not sleep");
                    break;
                }
            }
            if (!rename) {
                LOGGER.error("Failed to rename directory {} to {}", (Object)srcDir, (Object)destDir);
                LOGGER.error("Movie renaming aborted.");
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, srcDir, "message.renamer.failedrename"));
                return false;
            }
            LOGGER.info("Successfully moved folder {} to {}", (Object)srcDir, (Object)destDir);
            return true;
        }
        return true;
    }

    public static boolean moveFileSafe(Path srcFile, Path destFile) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcFile.toAbsolutePath().toString().equals(destFile.toAbsolutePath().toString())) {
            LOGGER.debug("try to move file {} to {}", (Object)srcFile, (Object)destFile);
            if (!Files.exists(srcFile, new LinkOption[0]) && !Files.isSymbolicLink(srcFile)) {
                throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
            }
            if (Files.isDirectory(srcFile, new LinkOption[0])) {
                throw new IOException("Source '" + srcFile + "' is a directory");
            }
            if (Files.exists(destFile, new LinkOption[0]) && !Files.isSameFile(destFile, srcFile)) {
                throw new FileExistsException("Destination '" + destFile + "' already exists");
            }
            if (Files.isDirectory(destFile, new LinkOption[0])) {
                throw new IOException("Destination '" + destFile + "' is a directory");
            }
            boolean rename = false;
            for (int i = 0; i < 5; ++i) {
                try {
                    Files.move(srcFile, destFile, StandardCopyOption.ATOMIC_MOVE);
                    rename = true;
                }
                catch (AtomicMoveNotSupportedException a) {
                    try {
                        Files.copy(srcFile, destFile, StandardCopyOption.REPLACE_EXISTING);
                        Files.delete(srcFile);
                        rename = true;
                    }
                    catch (IOException e) {
                        LOGGER.warn("rename problem (fallback): {}", (Object)e.getMessage());
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("rename problem: {}", (Object)e.getMessage());
                }
                if (rename) break;
                try {
                    LOGGER.debug("rename did not work - sleep a while and try again...");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.warn("I'm so excited - could not sleep");
                    break;
                }
            }
            if (!rename) {
                LOGGER.error("Failed to rename file {} to {}", (Object)srcFile, (Object)destFile);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, srcFile, "message.renamer.failedrename"));
                return false;
            }
            LOGGER.info("Successfully moved file from {} to {}", (Object)srcFile, (Object)destFile);
            return true;
        }
        return true;
    }

    public static boolean copyFileSafe(Path srcFile, Path destFile) throws IOException {
        return Utils.copyFileSafe(srcFile, destFile, false);
    }

    public static boolean copyFileSafe(Path srcFile, Path destFile, boolean overwrite) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcFile.toAbsolutePath().toString().equals(destFile.toAbsolutePath().toString())) {
            LOGGER.debug("try to copy file {} to {}", (Object)srcFile, (Object)destFile);
            if (!Files.exists(srcFile, new LinkOption[0])) {
                throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
            }
            if (Files.isDirectory(srcFile, new LinkOption[0])) {
                throw new IOException("Source '" + srcFile + "' is a directory");
            }
            if (!overwrite && Files.exists(destFile, new LinkOption[0]) && !Files.isSameFile(destFile, srcFile)) {
                throw new FileExistsException("Destination '" + destFile + "' already exists");
            }
            if (Files.isDirectory(destFile, new LinkOption[0])) {
                throw new IOException("Destination '" + destFile + "' is a directory");
            }
            boolean rename = false;
            for (int i = 0; i < 5; ++i) {
                try {
                    Files.copy(srcFile, destFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    rename = true;
                }
                catch (UnsupportedOperationException u) {
                    try {
                        Files.copy(srcFile, destFile, StandardCopyOption.REPLACE_EXISTING);
                        rename = true;
                    }
                    catch (IOException e) {
                        LOGGER.warn("copy did not work (fallback): {}", (Object)e.getMessage());
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("copy did not work: {}", (Object)e.getMessage());
                }
                if (rename) break;
                try {
                    LOGGER.debug("copy did not work - sleep a while and try again...");
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.warn("I'm so excited - could not sleep");
                    break;
                }
            }
            if (!rename) {
                LOGGER.error("Failed to copy file {} to {}", (Object)srcFile, (Object)destFile);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, srcFile, "message.renamer.failedrename"));
                return false;
            }
            LOGGER.info("Successfully copied file from {} to {}", (Object)srcFile, (Object)destFile);
            return true;
        }
        return true;
    }

    public static boolean deleteFileWithBackup(Path file, String datasource) {
        Path ds = Paths.get(datasource, new String[0]);
        if (!file.startsWith(ds)) {
            LOGGER.warn("could not delete file '{}': datasource '{}' does not match", (Object)file, (Object)datasource);
            return false;
        }
        if (Files.isDirectory(file, new LinkOption[0])) {
            LOGGER.warn("could not delete file '{}': file is a directory!", (Object)file);
            return false;
        }
        if (!Files.exists(file, new LinkOption[0])) {
            return true;
        }
        try {
            Path backup = Paths.get(ds.toAbsolutePath().toString(), ".deletedByTMM", ds.relativize(file).toString());
            if (!Files.exists(backup.getParent(), new LinkOption[0])) {
                Files.createDirectories(backup.getParent(), new FileAttribute[0]);
            }
            Files.deleteIfExists(backup);
            return Utils.moveFileSafe(file, backup);
        }
        catch (IOException e) {
            LOGGER.warn("Could not delete file: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean deleteFileSafely(Path file) {
        if (Files.isDirectory(file = file.toAbsolutePath(), new LinkOption[0])) {
            LOGGER.warn("Will not delete file '{}': file is a directory!", (Object)file);
            return false;
        }
        try {
            Files.deleteIfExists(file);
        }
        catch (Exception e) {
            LOGGER.warn("Could not delete file: {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean deleteDirectorySafely(Path folder, String datasource) {
        folder = folder.toAbsolutePath();
        Path ds = Paths.get(datasource, new String[0]);
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            LOGGER.warn("Will not delete folder '{}': folder is a file, NOT a directory!", (Object)folder);
            return false;
        }
        if (!folder.startsWith(ds)) {
            LOGGER.warn("Will not delete folder '{}': datasource '{}' does not match", (Object)folder, (Object)datasource);
            return false;
        }
        try {
            Instant instant = Instant.now();
            long timeStampSeconds = instant.getEpochSecond();
            Path backup = Paths.get(ds.toAbsolutePath().toString(), ".deletedByTMM", ds.relativize(folder).toString() + timeStampSeconds);
            if (!Files.exists(backup.getParent(), new LinkOption[0])) {
                Files.createDirectories(backup.getParent(), new FileAttribute[0]);
            }
            return Utils.moveDirectorySafe(folder, backup);
        }
        catch (IOException e) {
            LOGGER.warn("could not delete directory: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static List<Locale> getLanguages() {
        block18: {
            if (!availableLocales.isEmpty()) {
                return new ArrayList<Locale>(availableLocales);
            }
            availableLocales.add(Utils.getLocaleFromLanguage(Locale.ENGLISH.getLanguage()));
            try {
                CodeSource src;
                InputStream is = Utils.class.getResourceAsStream("/");
                if (is != null) {
                    String resource;
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    while ((resource = br.readLine()) != null) {
                        Utils.parseLocaleFromFilename(resource);
                    }
                }
                if (availableLocales.size() != 1 || (src = Utils.class.getProtectionDomain().getCodeSource()) == null) break block18;
                URL jar = src.getLocation();
                try (InputStream jarInputStream = jar.openStream();
                     ZipInputStream zip = new ZipInputStream(jarInputStream);){
                    ZipEntry e;
                    while ((e = zip.getNextEntry()) != null) {
                        Utils.parseLocaleFromFilename(e.getName());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("could not read locales: " + e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<Locale>(availableLocales);
    }

    private static void parseLocaleFromFilename(String filename) {
        Matcher matcher = localePattern.matcher(filename);
        if (matcher.matches()) {
            String language = matcher.group(1);
            String country = matcher.group(2);
            Locale myloc = country != null ? new Locale(language, country) : Utils.getLocaleFromLanguage(language);
            if (myloc != null && !availableLocales.contains(myloc)) {
                availableLocales.add(myloc);
            }
        }
    }

    public static Locale getLocaleFromLanguage(String language) {
        block9: {
            if (StringUtils.isBlank((CharSequence)language)) {
                return Locale.getDefault();
            }
            if (language.length() > 2) {
                try {
                    return LocaleUtils.toLocale((String)language);
                }
                catch (Exception e) {
                    if (!language.matches("^\\w\\w_\\w\\w.*")) break block9;
                    if ("zh_HANT".equals(language)) {
                        return new Locale("zh", "HANT");
                    }
                    return LocaleUtils.toLocale((String)language.substring(0, 5));
                }
            }
        }
        if (language.equalsIgnoreCase("en")) {
            return Locale.US;
        }
        Locale l = null;
        List countries = LocaleUtils.countriesByLanguage((String)language.toLowerCase(Locale.ROOT));
        for (Locale locale : countries) {
            if (!locale.getCountry().equalsIgnoreCase(language)) continue;
            l = locale;
        }
        if (l == null && !countries.isEmpty()) {
            l = (Locale)countries.get(0);
        }
        if (l == null) {
            l = new Locale(language);
        }
        return l;
    }

    public static void createBackupFile(Path file) {
        Utils.createBackupFile(file, true);
    }

    public static void createBackupFile(Path file, boolean overwrite) {
        Path backup = Paths.get(Globals.BACKUP_FOLDER, new String[0]);
        try {
            if (!Files.exists(backup, new LinkOption[0])) {
                Files.createDirectory(backup, new FileAttribute[0]);
            }
            if (!Files.exists(file, new LinkOption[0])) {
                return;
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String date = formatter.format(new Date());
            if (!Files.exists(backup = backup.resolve(file.getFileName() + "." + date + ".zip"), new LinkOption[0]) || overwrite) {
                Utils.createZip(backup, file, "/" + file.getFileName().toString());
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not backup file {}: {}", (Object)file, (Object)e.getMessage());
        }
    }

    public static void deleteOldBackupFile(Path file, int keep) {
        ArrayList<Path> al = new ArrayList<Path>();
        String fname = file.getFileName().toString();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(Globals.BACKUP_FOLDER, new String[0]));){
            for (Path path : directoryStream) {
                if (!path.getFileName().toString().matches(fname + "\\.\\d{4}\\-\\d{2}\\-\\d{2}\\.zip") && !path.getFileName().toString().matches(fname + "\\.\\d{4}\\-\\d{2}\\-\\d{2}")) continue;
                al.add(path);
            }
        }
        catch (IOException e) {
            LOGGER.error("could not list files from the backup folder: {}", (Object)e.getMessage());
            return;
        }
        al.sort((o1, o2) -> (int)(o1.toFile().lastModified() - o2.toFile().lastModified()));
        for (int i = 0; i < al.size() - keep; ++i) {
            Path backupFile = (Path)al.get(i);
            LOGGER.debug("deleting old backup file {}", (Object)backupFile.getFileName());
            Utils.deleteFileSafely(backupFile);
        }
    }

    public static void sendWakeOnLanPacket(String macAddr) {
        String IP = "255.255.255.255";
        int port = 7;
        try {
            int i;
            byte[] MACBYTE = new byte[6];
            String[] hex = macAddr.split("(\\:|\\-)");
            for (int i2 = 0; i2 < 6; ++i2) {
                MACBYTE[i2] = (byte)Integer.parseInt(hex[i2], 16);
            }
            byte[] bytes = new byte[6 + 16 * MACBYTE.length];
            for (i = 0; i < 6; ++i) {
                bytes[i] = -1;
            }
            for (i = 6; i < bytes.length; i += MACBYTE.length) {
                System.arraycopy(MACBYTE, 0, bytes, i, MACBYTE.length);
            }
            InetAddress address = InetAddress.getByName("255.255.255.255");
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, address, 7);
            try (DatagramSocket socket = new DatagramSocket();){
                socket.send(packet);
            }
            LOGGER.info("Sent WOL packet to {}", (Object)macAddr);
        }
        catch (Exception e) {
            LOGGER.error("Error sending WOL packet to {} - {}", (Object)macAddr, (Object)e.getMessage());
        }
    }

    public static ProcessBuilder getPBforTMMrestart() {
        Path f = Paths.get("tmm.jar", new String[0]);
        if (!Files.exists(f, new LinkOption[0])) {
            LOGGER.error("cannot restart TMM - tmm.jar not found.");
            return null;
        }
        List<String> arguments = Utils.getJVMArguments();
        arguments.add(0, LaunchUtil.getJVMPath());
        arguments.add("-Dsilent=noupdate");
        arguments.add("-jar");
        arguments.add("getdown.jar");
        arguments.add(".");
        ProcessBuilder pb = new ProcessBuilder(arguments);
        pb.directory(Paths.get("", new String[0]).toAbsolutePath().toFile());
        return pb;
    }

    public static ProcessBuilder getPBforTMMupdate() {
        Path f = Paths.get("getdown.jar", new String[0]);
        if (!Files.exists(f, new LinkOption[0])) {
            LOGGER.error("cannot start updater - getdown.jar not found.");
            return null;
        }
        List<String> arguments = Utils.getJVMArguments();
        arguments.add(0, LaunchUtil.getJVMPath());
        arguments.add("-jar");
        arguments.add("getdown.jar");
        arguments.add(".");
        ProcessBuilder pb = new ProcessBuilder(arguments);
        pb.directory(Paths.get("", new String[0]).toAbsolutePath().toFile());
        return pb;
    }

    private static List<String> getJVMArguments() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        ArrayList<String> arguments = new ArrayList<String>(runtimeMxBean.getInputArguments());
        if (!arguments.contains("-Djava.net.preferIPv4Stack=true")) {
            arguments.add("-Djava.net.preferIPv4Stack=true");
        }
        if (!arguments.contains("-Dfile.encoding=UTF-8")) {
            arguments.add("-Dfile.encoding=UTF-8");
        }
        return arguments;
    }

    public static void deleteDirectoryRecursive(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        LOGGER.info("Deleting complete directory: {}", (Object)dir);
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                LOGGER.warn("Could not delete {} - {}", (Object)file, (Object)exc.getMessage());
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteEmptyDirectoryRecursive(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        LOGGER.info("Deleting complete directory: {}", (Object)dir);
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (Utils.isFolderEmpty(dir)) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static boolean isFolderEmpty(Path folder) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(folder);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    public static void createZip(Path zipFile, Path toBeAdded, String internalPath) {
        block16: {
            HashMap<String, String> env = new HashMap<String, String>();
            try {
                env.put("create", String.valueOf(!Files.exists(zipFile, new LinkOption[0])));
                env.put("useTempFile", "true");
                URI fileUri = zipFile.toUri();
                URI zipUri = new URI("jar:" + fileUri.getScheme(), fileUri.getPath(), null);
                try (FileSystem zipfs = FileSystems.newFileSystem(zipUri, env);){
                    Path internalTargetPath = zipfs.getPath(internalPath, new String[0]);
                    if (!Files.exists(internalTargetPath, new LinkOption[0])) {
                        Files.createDirectory(internalTargetPath, new FileAttribute[0]);
                    }
                    if (Files.isDirectory(toBeAdded, new LinkOption[0])) {
                        try (Stream<Path> files = Files.walk(toBeAdded, new FileVisitOption[0]);){
                            files.forEach(source -> {
                                try {
                                    if (Files.isSameFile(source, toBeAdded)) {
                                        return;
                                    }
                                    if (Files.isDirectory(source, new LinkOption[0])) {
                                        Files.createDirectory(internalTargetPath.resolve(toBeAdded.relativize((Path)source)), new FileAttribute[0]);
                                    } else {
                                        Files.copy(source, internalTargetPath.resolve(toBeAdded.relativize((Path)source).toString()), StandardCopyOption.REPLACE_EXISTING);
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("Failed to create zip file: {}", (Object)e.getMessage());
                                }
                            });
                            break block16;
                        }
                    }
                    Files.copy(toBeAdded, internalTargetPath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to create zip file: {}", (Object)e.getMessage());
            }
        }
    }

    public static void unzip(Path zipFile, final Path destDir) {
        HashMap<String, String> env = new HashMap<String, String>();
        try {
            if (!Files.exists(destDir, new LinkOption[0])) {
                Files.createDirectories(destDir, new FileAttribute[0]);
            }
            env.put("create", String.valueOf(!Files.exists(zipFile, new LinkOption[0])));
            URI fileUri = zipFile.toUri();
            URI zipUri = new URI("jar:" + fileUri.getScheme(), fileUri.getPath(), null);
            try (FileSystem zipfs = FileSystems.newFileSystem(zipUri, env);){
                Path root = zipfs.getPath("/", new String[0]);
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path destFile = Paths.get(destDir.toString(), file.toString());
                        LOGGER.debug("Extracting file {} to {}", (Object)file, (Object)destFile);
                        Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path dirToCreate = Paths.get(destDir.toString(), dir.toString());
                        if (!Files.exists(dirToCreate, new LinkOption[0])) {
                            LOGGER.debug("Creating directory {}", (Object)dirToCreate);
                            Files.createDirectory(dirToCreate, new FileAttribute[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create zip file: {}", (Object)e.getMessage());
        }
    }

    public static void extractTemplates() {
        Utils.extractTemplates(false);
    }

    public static void extractTemplates(boolean force) {
        Path dest = Paths.get("templates", new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dest);){
            int dirCount = 0;
            if (!force) {
                for (Path path : directoryStream) {
                    if (!Files.isDirectory(path, new LinkOption[0])) continue;
                    ++dirCount;
                }
            }
            if (dirCount == 0 || force) {
                Utils.unzip(dest.resolve("templates.jar"), dest);
            }
        }
        catch (IOException e) {
            LOGGER.warn("failed to extract templates: {}", (Object)e.getMessage());
        }
    }

    public static void writeStringToFile(Path file, String text) throws IOException {
        byte[] buf = text.getBytes(StandardCharsets.UTF_8);
        Files.write(file, buf, new OpenOption[0]);
    }

    public static String readFileToString(Path file) throws IOException {
        byte[] fileArray = Files.readAllBytes(file);
        return new String(fileArray, StandardCharsets.UTF_8);
    }

    public static void copyDirectoryRecursive(Path from, Path to) throws IOException {
        LOGGER.info("Copyin complete directory from {} to {}", (Object)from, (Object)to);
        Files.walkFileTree(from, new CopyFileVisitor(to));
    }

    public static void cleanOldLogs() {
        Pattern pattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
        Calendar cal = Calendar.getInstance();
        cal.add(5, -30);
        Date dateBefore30Days = cal.getTime();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get("logs", new String[0]));){
            for (Path path : directoryStream) {
                Matcher matcher = pattern.matcher(path.getFileName().toString());
                if (!matcher.find()) continue;
                try {
                    Date date = StrgUtils.parseDate(matcher.group());
                    if (!dateBefore30Days.after(date)) continue;
                    Utils.deleteFileSafely(path);
                }
                catch (Exception e) {
                    LOGGER.debug("could not clean old logs: {}", (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug("could not clean old logs: {}", (Object)e.getMessage());
        }
    }

    public static String getArtworkExtension(String url) {
        String ext = UrlUtil.getExtension(url).toLowerCase(Locale.ROOT);
        if (StringUtils.isBlank((CharSequence)ext) || "tbn".equals(ext)) {
            ext = "jpg";
        }
        if (!MediaFileHelper.SUPPORTED_ARTWORK_FILETYPES.contains(ext)) {
            ext = "jpg";
        }
        return ext.toLowerCase(Locale.ROOT);
    }

    public static List<Path> listFiles(Path root) {
        ArrayList<Path> filesFound = new ArrayList<Path>();
        if (!Files.isDirectory(root, new LinkOption[0])) {
            return filesFound;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(root);){
            for (Path path : directoryStream) {
                if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                filesFound.add(path);
            }
        }
        catch (IOException e) {
            LOGGER.warn("could not get a file listing: {}", (Object)e.getMessage());
        }
        return filesFound;
    }

    public static List<Path> listFilesRecursive(Path root) {
        final ArrayList<Path> filesFound = new ArrayList<Path>();
        if (!Files.isDirectory(root, new LinkOption[0])) {
            return filesFound;
        }
        try {
            Files.walkFileTree(root, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new AbstractFileVisitor(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (Utils.isRegularFile(file)) {
                        filesFound.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn("could not get a file listing: {}", (Object)e.getMessage());
        }
        return filesFound;
    }

    public static void flushFileOutputStreamToDisk(FileOutputStream fileOutputStream) {
        if (fileOutputStream == null) {
            return;
        }
        try {
            fileOutputStream.flush();
            fileOutputStream.getFD().sync();
            Thread.sleep(150L);
        }
        catch (Exception e) {
            LOGGER.error("could not flush to disk: {}", (Object)e.getMessage());
        }
    }

    public static String getTempFolder() {
        return tempFolder;
    }

    public static HashSet<Path> getUnknownFilesByRegex(Path folder, List<String> regexList) {
        GetUnknownFilesVisitor visitor = new GetUnknownFilesVisitor(regexList);
        try {
            Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, visitor);
        }
        catch (IOException e) {
            LOGGER.error("could not get unknown files: {}", (Object)e.getMessage());
        }
        return visitor.fileList;
    }

    static {
        block2: {
            LOGGER = LoggerFactory.getLogger(Utils.class);
            localePattern = Pattern.compile("messages_(.{2})_?(.{2,4})?\\.properties", 2);
            stackingPattern1 = Pattern.compile("(.*?)[ _.-]+((?:cd|dvd|p(?:ar)?t|dis[ck])[ _.-]*[1-9][0-9]?)(\\.[^.]+)$", 2);
            stackingPattern2 = Pattern.compile("(.*?)[ _.-]+((?:cd|dvd|p(?:ar)?t|dis[ck])[ _.-]*[a-d])(\\.[^.]+)$", 2);
            stackingPattern3 = Pattern.compile("(.*?)[_.-]+([a-d])(\\.[^.]+)$", 2);
            stackingPattern4 = Pattern.compile("(.*?)[ \\(_.-]+([1-9][0-9]?[ .]?of[ .]?[1-9][0-9]?)[ \\)_-]?(\\.[^.]+)$", 2);
            folderStackingPattern = Pattern.compile("(.*?)[ _.-]*((?:cd|dvd|p(?:ar)?t|dis[ck])[ _.-]*[1-9][0-9]?)$", 2);
            YOUTUBE_PATTERN = Pattern.compile("^((?:https?:)?\\/\\/)?((?:www|m)\\.)?((?:youtube\\.com|youtu.be))(\\/(?:[\\w\\-]+\\?v=|embed\\/|v\\/)?)([\\w\\-]+)(\\S+)?$");
            availableLocales = new ArrayList<Locale>();
            try {
                String temp = System.getProperty("java.io.tmpdir");
                Path tempFolder = Paths.get(temp, new String[0]);
                Utils.tempFolder = Files.exists(tempFolder, new LinkOption[0]) && Files.isWritable(tempFolder) ? temp : "tmp";
            }
            catch (Error | Exception ignored) {
                if (tempFolder == null) break block2;
                tempFolder = "tmp";
            }
        }
    }

    private static class GetUnknownFilesVisitor
    extends AbstractFileVisitor {
        private HashSet<Path> fileList = new HashSet();
        private List<String> regexList;

        GetUnknownFilesVisitor(List<String> regexList) {
            this.regexList = regexList;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            for (String regex : this.regexList) {
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(file.getFileName().toString());
                if (!m.find()) continue;
                this.fileList.add(file);
            }
            return FileVisitResult.CONTINUE;
        }
    }

    public static class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private Path sourcePath = null;

        public CopyFileVisitor(Path targetPath) {
            this.targetPath = targetPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            Path target;
            if (this.sourcePath == null) {
                this.sourcePath = dir;
            }
            if (!Files.exists(target = this.targetPath.resolve(this.sourcePath.relativize(dir)), new LinkOption[0])) {
                try {
                    Files.createDirectories(target, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                }
                catch (IOException x) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.targetPath.resolve(this.sourcePath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
            return FileVisitResult.CONTINUE;
        }
    }
}

