/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.scraper.util.UrlUtil;

public class Person
extends AbstractModelObject {
    public static final String ACTOR_DIR = ".actors";
    @JsonProperty
    private Type type = Type.OTHER;
    @JsonProperty
    private String name = "";
    @JsonProperty
    private String role = "";
    @JsonProperty
    private String thumbUrl = "";
    @JsonProperty
    private String profileUrl = "";
    @JsonProperty
    private Map<String, Object> ids = null;

    public Person() {
    }

    public Person(Type type) {
        this.type = type;
    }

    public Person(Type type, String name) {
        this(type);
        this.setName(name);
    }

    public Person(Type type, String name, String role) {
        this(type, name);
        this.setRole(role);
    }

    public Person(Type type, String name, String role, String thumbUrl) {
        this(type, name, role);
        this.setThumbUrl(thumbUrl);
    }

    public Person(Type type, String name, String role, String thumbUrl, String profileUrl) {
        this(type, name, role, thumbUrl);
        this.setProfileUrl(profileUrl);
    }

    public Person(Person source) {
        this.type = source.type;
        this.name = source.name;
        this.role = source.role;
        this.thumbUrl = source.thumbUrl;
        this.profileUrl = source.profileUrl;
        if (source.ids != null && !source.ids.isEmpty()) {
            this.ids = new HashMap<String, Object>(source.ids);
        }
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setId(String key, Object value) {
        String v;
        if (this.ids == null) {
            this.ids = new HashMap<String, Object>(0);
        }
        if ("".equals(v = String.valueOf(value)) || "0".equals(v) || "null".equals(v)) {
            this.ids.remove(key);
        } else {
            this.ids.put(key, value);
        }
    }

    public Object getId(String key) {
        if (this.ids == null) {
            return null;
        }
        return this.ids.get(key);
    }

    public Map<String, Object> getIds() {
        if (this.ids == null) {
            return Collections.emptyMap();
        }
        return this.ids;
    }

    public void setName(String newValue) {
        String oldValue = this.name;
        this.name = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("name", oldValue, newValue);
    }

    public String getName() {
        return this.name;
    }

    public String getNameForStorage() {
        String n = this.name.replace(" ", "_");
        n = n.replaceAll("([\"\\\\:<>|/?*])", "");
        String ext = UrlUtil.getExtension(this.thumbUrl);
        if (ext.isEmpty()) {
            ext = "jpg";
        }
        return n + "." + ext;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String newValue) {
        String oldValue = this.role;
        this.role = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("role", oldValue, newValue);
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public void setThumbUrl(String newValue) {
        String oldValue = this.thumbUrl;
        this.thumbUrl = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("thumb", oldValue, newValue);
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public void setProfileUrl(String newValue) {
        String oldValue = this.profileUrl;
        this.profileUrl = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("profileUrl", oldValue, newValue);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Person)) {
            return false;
        }
        Person cast = (Person)obj;
        return StringUtils.equals((CharSequence)this.name, (CharSequence)cast.name) && StringUtils.equals((CharSequence)this.role, (CharSequence)cast.role) && StringUtils.equals((CharSequence)this.thumbUrl, (CharSequence)cast.thumbUrl) && StringUtils.equals((CharSequence)this.profileUrl, (CharSequence)cast.profileUrl);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append((Object)this.role).append((Object)this.thumbUrl).build();
    }

    public static enum Type {
        ACTOR,
        DIRECTOR,
        WRITER,
        PRODUCER,
        OTHER;

    }
}

