/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.tasks.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.UrlUtil;

public class MovieSetArtworkHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetArtworkHelper.class);
    private static final List<MediaFileType> SUPPORTED_ARTWORK_TYPES = Arrays.asList(MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.LOGO, MediaFileType.CLEARLOGO, MediaFileType.CLEARART, MediaFileType.THUMB, MediaFileType.DISC);
    private static final String[] SUPPORTED_ARTWORK_FILETYPES = new String[]{"jpg", "png", "tbn"};

    private MovieSetArtworkHelper() {
    }

    public static void updateArtwork(MovieSet movieSet) {
        MovieSetArtworkHelper.findArtworkInArtworkFolder(movieSet);
        for (Movie movie : new ArrayList<Movie>(movieSet.getMovies())) {
            MovieSetArtworkHelper.findArtworkInMovieFolder(movieSet, movie);
        }
    }

    public static void cleanupArtwork(MovieSet movieSet) {
        Path artworkFolder = MovieSetArtworkHelper.getArtworkFolder();
        ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>();
        TreeSet<MediaFile> needed = new TreeSet<MediaFile>();
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            List<MediaFile> mediaFiles = movieSet.getMediaFiles(type);
            cleanup.addAll(mediaFiles);
            if ((mediaFiles = mediaFiles.stream().filter(mf -> {
                if (mf.getFilesize() == 0L) {
                    return false;
                }
                return mf.getFile().toFile().exists();
            }).collect(Collectors.toList())).isEmpty()) continue;
            MediaFile artworkFile = MovieSetArtworkHelper.findArtworkInPreferredArtworkFolder(movieSet, mediaFiles);
            if (artworkFile == null) {
                artworkFile = MovieSetArtworkHelper.findArtworkInAlternateArtworkFolder(movieSet, mediaFiles);
            }
            if (artworkFile == null) {
                artworkFile = MovieSetArtworkHelper.findArtworkInMovieFolder(mediaFiles);
            }
            if (artworkFile == null) continue;
            if (artworkFolder != null) {
                MediaFile newFile = new MediaFile(artworkFile);
                newFile.setFile(MovieSetArtworkHelper.createArtworkPathInArtworkFolder(movieSet, type, artworkFile.getExtension()));
                boolean ok = MovieRenamer.copyFile(artworkFile.getFileAsPath(), newFile.getFileAsPath());
                if (ok) {
                    needed.add(newFile);
                } else {
                    needed.add(artworkFile);
                }
            }
            if (!MovieModuleManager.SETTINGS.isEnableMovieSetArtworkMovieFolder()) continue;
            String filename = "movieset-" + type.toString().toLowerCase(Locale.ROOT) + "." + artworkFile.getExtension();
            for (Movie movie : movieSet.getMovies()) {
                try {
                    if (movie.isMultiMovieDir()) continue;
                    MediaFile newFile = new MediaFile(artworkFile);
                    newFile.setFile(movie.getPathNIO().resolve(filename));
                    boolean ok = MovieRenamer.copyFile(artworkFile.getFileAsPath(), newFile.getFileAsPath());
                    if (ok) {
                        needed.add(newFile);
                        continue;
                    }
                    needed.add(artworkFile);
                }
                catch (Exception e) {
                    LOGGER.warn("could not write files", (Throwable)e);
                }
            }
        }
        for (MediaFile mf2 : needed) {
            ImageCache.cacheImageSilently(mf2.getFile());
        }
        cleanup.forEach(movieSet::removeFromMediaFiles);
        movieSet.addToMediaFiles(new ArrayList<MediaFile>(needed));
        for (int i = cleanup.size() - 1; i >= 0; --i) {
            MediaFile cl = (MediaFile)cleanup.get(i);
            if (needed.contains(cl)) continue;
            LOGGER.debug("Deleting {}", (Object)cl.getFileAsPath());
            Utils.deleteFileSafely(cl.getFileAsPath());
            ImageCache.invalidateCachedImage(cl);
            try {
                if (artworkFolder == null || artworkFolder.equals(cl.getFile().getParent()) || !Utils.isFolderEmpty(cl.getFile().getParent())) continue;
                LOGGER.debug("Deleting empty Directory {}", (Object)cl.getFileAsPath().getParent());
                Files.delete(cl.getFileAsPath().getParent());
                continue;
            }
            catch (IOException e) {
                LOGGER.warn("could not search for empty dir: {}", (Object)e.getMessage());
            }
        }
        movieSet.saveToDb();
    }

    private static Path getArtworkFolder() {
        String artworkFolder = MovieModuleManager.SETTINGS.getMovieSetArtworkFolder();
        if (!MovieModuleManager.SETTINGS.isEnableMovieSetArtworkFolder() || StringUtils.isBlank((CharSequence)artworkFolder)) {
            return null;
        }
        return Paths.get(artworkFolder, new String[0]);
    }

    private static Path createArtworkPathInArtworkFolder(MovieSet movieSet, MediaFileType type, String extension) {
        Path artworkFolder = MovieSetArtworkHelper.getArtworkFolder();
        if (artworkFolder == null) {
            return null;
        }
        String movieSetName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle());
        movieSetName = MovieRenamer.replacePathSeparators(movieSetName);
        if (MovieModuleManager.SETTINGS.isMovieSetArtworkFolderStyleKodi()) {
            return Paths.get(artworkFolder.toString(), movieSetName, type.toString().toLowerCase(Locale.ROOT) + "." + extension);
        }
        return Paths.get(artworkFolder.toString(), MovieRenamer.replaceInvalidCharacters(movieSet.getTitle()) + "-" + type.name().toLowerCase(Locale.ROOT) + "." + extension);
    }

    private static MediaFile findArtworkInPreferredArtworkFolder(MovieSet movieSet, List<MediaFile> mediaFiles) {
        Path artworkFolder = MovieSetArtworkHelper.getArtworkFolder();
        if (artworkFolder == null) {
            return null;
        }
        for (MediaFile mediaFile : mediaFiles) {
            if (MovieModuleManager.SETTINGS.isMovieSetArtworkFolderStyleKodi()) {
                String movieSetName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle());
                movieSetName = MovieRenamer.replacePathSeparators(movieSetName);
                if (!mediaFile.getFileAsPath().startsWith(artworkFolder.resolve(movieSetName))) continue;
                return mediaFile;
            }
            if (!mediaFile.getFileAsPath().startsWith(artworkFolder)) continue;
            return mediaFile;
        }
        return null;
    }

    private static MediaFile findArtworkInAlternateArtworkFolder(MovieSet movieSet, List<MediaFile> mediaFiles) {
        if (!MovieModuleManager.SETTINGS.isEnableMovieSetArtworkFolder() || StringUtils.isBlank((CharSequence)MovieModuleManager.SETTINGS.getMovieSetArtworkFolder())) {
            return null;
        }
        Path artworkFolder = Paths.get(MovieModuleManager.SETTINGS.getMovieSetArtworkFolder(), new String[0]);
        for (MediaFile mediaFile : mediaFiles) {
            if (MovieModuleManager.SETTINGS.isMovieSetArtworkFolderStyleKodi()) {
                if (!mediaFile.getFileAsPath().startsWith(artworkFolder)) continue;
                return mediaFile;
            }
            String movieSetName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle());
            movieSetName = MovieRenamer.replacePathSeparators(movieSetName);
            if (!mediaFile.getFileAsPath().startsWith(artworkFolder.resolve(movieSetName))) continue;
            return mediaFile;
        }
        return null;
    }

    private static MediaFile findArtworkInMovieFolder(List<MediaFile> mediaFiles) {
        Path artworkFolder = MovieSetArtworkHelper.getArtworkFolder();
        for (MediaFile mediaFile : mediaFiles) {
            if (artworkFolder != null && mediaFile.getFileAsPath().startsWith(artworkFolder)) continue;
            return mediaFile;
        }
        return null;
    }

    private static void findArtworkInArtworkFolder(MovieSet movieSet) {
        MediaFile mediaFile;
        Path artworkFile;
        String artworkFileName;
        String movieSetName;
        String artworkFolder = MovieModuleManager.SETTINGS.getMovieSetArtworkFolder();
        if (!MovieModuleManager.SETTINGS.isEnableMovieSetArtworkFolder() || StringUtils.isBlank((CharSequence)artworkFolder)) {
            return;
        }
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            for (String fileType : SUPPORTED_ARTWORK_FILETYPES) {
                movieSetName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle());
                artworkFileName = (movieSetName = MovieRenamer.replacePathSeparators(movieSetName)) + "-" + type.name().toLowerCase(Locale.ROOT) + "." + fileType;
                artworkFile = Paths.get(artworkFolder, artworkFileName);
                if (!Files.exists(artworkFile, new LinkOption[0])) continue;
                mediaFile = new MediaFile(artworkFile, type);
                TmmTaskManager.getInstance().addUnnamedTask(new MediaFileInformationFetcherTask(mediaFile, movieSet, false));
                movieSet.addToMediaFiles(mediaFile);
            }
        }
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            for (String fileType : SUPPORTED_ARTWORK_FILETYPES) {
                movieSetName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle());
                artworkFile = Paths.get(artworkFolder, movieSetName = MovieRenamer.replacePathSeparators(movieSetName), artworkFileName = type.name().toLowerCase(Locale.ROOT) + "." + fileType);
                if (!Files.exists(artworkFile, new LinkOption[0])) continue;
                mediaFile = new MediaFile(artworkFile, type);
                TmmTaskManager.getInstance().addUnnamedTask(new MediaFileInformationFetcherTask(mediaFile, movieSet, false));
                movieSet.addToMediaFiles(mediaFile);
            }
        }
    }

    private static void findArtworkInMovieFolder(MovieSet movieSet, Movie movie) {
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            if (!movieSet.getMediaFiles(type).isEmpty()) continue;
            for (String fileType : SUPPORTED_ARTWORK_FILETYPES) {
                String artworkFileName = "movieset-" + type.name().toLowerCase(Locale.ROOT) + "." + fileType;
                Path artworkFile = movie.getPathNIO().resolve(artworkFileName);
                if (!Files.exists(artworkFile, new LinkOption[0])) continue;
                MediaFile mediaFile = new MediaFile(artworkFile, type);
                TmmTaskManager.getInstance().addUnnamedTask(new MediaFileInformationFetcherTask(mediaFile, movieSet, false));
                movieSet.addToMediaFiles(mediaFile);
            }
        }
    }

    public static void setArtwork(MovieSet movieSet, List<MediaArtwork> artwork, List<MovieSetScraperMetadataConfig> config) {
        if (!ScraperMetadataConfig.containsAnyArtwork(config)) {
            return;
        }
        artwork.sort(new MediaArtwork.MediaArtworkComparator(MovieModuleManager.SETTINGS.getImageScraperLanguage().getLanguage()));
        if (config.contains(MovieSetScraperMetadataConfig.POSTER)) {
            MovieSetArtworkHelper.setBestPoster(movieSet, artwork);
        }
        if (config.contains(MovieSetScraperMetadataConfig.FANART)) {
            MovieSetArtworkHelper.setBestFanart(movieSet, artwork);
        }
        if (config.contains(MovieSetScraperMetadataConfig.LOGO)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.LOGO);
        }
        if (config.contains(MovieSetScraperMetadataConfig.CLEARLOGO)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO);
        }
        if (config.contains(MovieSetScraperMetadataConfig.CLEARART)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARART);
        }
        if (config.contains(MovieSetScraperMetadataConfig.BANNER)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.BANNER);
        }
        if (config.contains(MovieSetScraperMetadataConfig.THUMB)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.THUMB);
        }
        if (config.contains(MovieSetScraperMetadataConfig.DISCART)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.DISC);
        }
        movieSet.saveToDb();
    }

    private static void setBestPoster(MovieSet movieSet, List<MediaArtwork> artwork) {
        int preferredSizeOrder = MovieModuleManager.SETTINGS.getImagePosterSize().getOrder();
        String preferredLanguage = MovieModuleManager.SETTINGS.getImageScraperLanguage().getLanguage();
        MediaArtwork foundPoster = null;
        if (MovieModuleManager.SETTINGS.isImageLanguagePriority()) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.POSTER || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != preferredSizeOrder) continue;
                foundPoster = art;
                break;
            }
            if (foundPoster == null) {
                int minOrder = preferredSizeOrder - 1;
                int maxOrder = preferredSizeOrder + 1;
                for (MediaArtwork art : artwork) {
                    if (art.getType() != MediaArtwork.MediaArtworkType.POSTER || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != minOrder && art.getSizeOrder() != maxOrder) continue;
                    foundPoster = art;
                    break;
                }
            }
        }
        if (foundPoster == null) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.POSTER || art.getSizeOrder() != preferredSizeOrder) continue;
                foundPoster = art;
                break;
            }
        }
        if (foundPoster == null) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.POSTER) continue;
                foundPoster = art;
                break;
            }
        }
        if (foundPoster != null) {
            movieSet.setArtworkUrl(foundPoster.getDefaultUrl(), MediaFileType.POSTER);
        }
    }

    private static void setBestFanart(MovieSet movieSet, List<MediaArtwork> artwork) {
        int preferredSizeOrder = MovieModuleManager.SETTINGS.getImageFanartSize().getOrder();
        String preferredLanguage = MovieModuleManager.SETTINGS.getImageScraperLanguage().getLanguage();
        MediaArtwork foundfanart = null;
        if (MovieModuleManager.SETTINGS.isImageLanguagePriority()) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != preferredSizeOrder) continue;
                foundfanart = art;
                break;
            }
            if (foundfanart == null) {
                int minOrder = preferredSizeOrder - 1;
                int maxOrder = preferredSizeOrder + 1;
                for (MediaArtwork art : artwork) {
                    if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != minOrder && art.getSizeOrder() != maxOrder) continue;
                    foundfanart = art;
                    break;
                }
            }
        }
        if (foundfanart == null) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || art.getSizeOrder() != preferredSizeOrder) continue;
                foundfanart = art;
                break;
            }
        }
        if (foundfanart == null) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND) continue;
                foundfanart = art;
                break;
            }
        }
        if (foundfanart != null) {
            movieSet.setArtworkUrl(foundfanart.getDefaultUrl(), MediaFileType.FANART);
        }
    }

    private static void setBestArtwork(MovieSet movieSet, List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type) {
        for (MediaArtwork art : artwork) {
            if (art.getType() != type) continue;
            movieSet.setArtworkUrl(art.getDefaultUrl(), MediaFileType.getMediaFileType(type));
            break;
        }
    }

    public static void downloadArtwork(MovieSet movieSet, MediaFileType type) {
        String url = movieSet.getArtworkUrl(type);
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        MovieSetImageFetcherTask task = new MovieSetImageFetcherTask(movieSet, url, type);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public static void writeImagesToMovieFolder(MovieSet movieSet, List<Movie> movies) {
        if (!MovieModuleManager.SETTINGS.isEnableMovieSetArtworkMovieFolder()) {
            return;
        }
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            String url = movieSet.getArtworkUrl(type);
            if (StringUtils.isBlank((CharSequence)url)) continue;
            MovieSetImageFetcherTask task = new MovieSetImageFetcherTask(movieSet, url, type, movies);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
    }

    public static void cleanMovieSetArtworkInMovieFolder(Movie movie) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(movie.getPathNIO());){
            for (Path entry : stream) {
                Matcher matcher = MediaFileHelper.MOVIESET_ARTWORK_PATTERN.matcher(entry.getFileName().toString());
                if (!matcher.find()) continue;
                Utils.deleteFileSafely(entry);
            }
        }
        catch (Exception e) {
            LOGGER.error("remove movie set artwork: {}", (Object)e.getMessage());
        }
    }

    public static void removeMovieSetArtwork(MovieSet movieSet) {
        for (MediaFile mediaFile : movieSet.getMediaFiles()) {
            if (!mediaFile.isGraphic()) continue;
            Utils.deleteFileSafely(mediaFile.getFile());
        }
        if (!MovieModuleManager.SETTINGS.isEnableMovieSetArtworkFolder() || StringUtils.isBlank((CharSequence)MovieModuleManager.SETTINGS.getMovieSetArtworkFolder())) {
            return;
        }
        try {
            Utils.deleteEmptyDirectoryRecursive(Paths.get(MovieModuleManager.SETTINGS.getMovieSetArtworkFolder(), new String[0]));
        }
        catch (Exception e) {
            LOGGER.warn("could not clean empty subfolders: {}", (Object)e.getMessage());
        }
    }

    public static boolean hasMissingArtwork(MovieSet movieSet) {
        if (!MovieModuleManager.SETTINGS.getPosterFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getFanartFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getBannerFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getDiscartFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getLogoFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getClearlogoFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getClearartFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            return true;
        }
        return !MovieModuleManager.SETTINGS.getThumbFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.THUMB).isEmpty();
    }

    public static void getMissingArtwork(MovieSet movieSet, List<MediaArtwork> artwork) {
        artwork.sort(new MediaArtwork.MediaArtworkComparator(MovieModuleManager.SETTINGS.getScraperLanguage().getLanguage()));
        if (movieSet.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            MovieSetArtworkHelper.setBestPoster(movieSet, artwork);
        }
        if (movieSet.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            MovieSetArtworkHelper.setBestFanart(movieSet, artwork);
        }
        if (movieSet.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.LOGO);
        }
        if (movieSet.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO);
        }
        if (movieSet.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARART);
        }
        if (movieSet.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.BANNER);
        }
        if (movieSet.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.THUMB);
        }
        if (movieSet.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.DISC);
        }
        movieSet.saveToDb();
    }

    private static class MovieSetImageFetcherTask
    implements Runnable {
        private MovieSet movieSet;
        private String urlToArtwork;
        private MediaFileType type;
        private boolean writeToArtworkFolder;
        private String artworkFolder;
        private boolean artworkStyleKodi;
        private boolean writeToMovieFolder;
        private List<MediaFile> writtenArtworkFiles;
        private List<Movie> movies;

        private MovieSetImageFetcherTask(MovieSet movieSet, String url, MediaFileType type) {
            this.movieSet = movieSet;
            this.urlToArtwork = url;
            this.type = type;
            this.writtenArtworkFiles = new ArrayList<MediaFile>();
            this.movies = new ArrayList<Movie>(movieSet.getMovies());
            this.writeToMovieFolder = MovieModuleManager.SETTINGS.isEnableMovieSetArtworkMovieFolder();
            this.artworkFolder = MovieModuleManager.SETTINGS.getMovieSetArtworkFolder();
            this.writeToArtworkFolder = MovieModuleManager.SETTINGS.isEnableMovieSetArtworkFolder() && StringUtils.isNotBlank((CharSequence)this.artworkFolder);
            this.artworkStyleKodi = MovieModuleManager.SETTINGS.isMovieSetArtworkFolderStyleKodi();
        }

        private MovieSetImageFetcherTask(MovieSet movieSet, String url, MediaFileType type, List<Movie> movies) {
            this.movieSet = movieSet;
            this.urlToArtwork = url;
            this.type = type;
            this.writtenArtworkFiles = new ArrayList<MediaFile>();
            this.movies = new ArrayList<Movie>(movies);
            this.writeToMovieFolder = MovieModuleManager.SETTINGS.isEnableMovieSetArtworkMovieFolder();
            this.artworkFolder = "";
            this.writeToArtworkFolder = false;
        }

        @Override
        public void run() {
            try {
                byte[] bytes = UrlUtil.getByteArrayFromUrl(this.urlToArtwork);
                String extension = FilenameUtils.getExtension((String)this.urlToArtwork);
                this.movieSet.removeAllMediaFiles(this.type);
                if (this.writeToArtworkFolder) {
                    this.writeImageToArtworkFolder(bytes, extension);
                }
                if (this.writeToMovieFolder) {
                    this.writeImageToMovieFolders(bytes, extension);
                }
                if (!this.writeToArtworkFolder && !this.writeToMovieFolder) {
                    this.writeImageToCacheFolder(bytes);
                }
                this.movieSet.addToMediaFiles(this.writtenArtworkFiles);
                this.movieSet.saveToDb();
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("fetch image: {} - {}", (Object)this.urlToArtwork, (Object)e.getMessage());
            }
        }

        private void writeImageToArtworkFolder(byte[] bytes, String extension) {
            String movieSetName = MovieRenamer.replaceInvalidCharacters(this.movieSet.getTitle());
            movieSetName = MovieRenamer.replacePathSeparators(movieSetName);
            Path artworkFolderPath = this.artworkStyleKodi ? Paths.get(this.artworkFolder, movieSetName) : Paths.get(this.artworkFolder, new String[0]);
            if (!Files.exists(artworkFolderPath, new LinkOption[0])) {
                try {
                    Files.createDirectories(artworkFolderPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.warn("could not create directory: " + artworkFolderPath, (Throwable)e);
                }
            }
            try {
                String filename = "";
                if (!this.artworkStyleKodi) {
                    filename = movieSetName + "-";
                }
                filename = filename + this.type.name().toLowerCase(Locale.ROOT) + "." + extension;
                Path imageFile = artworkFolderPath.resolve(filename);
                this.writeImage(bytes, imageFile);
                MediaFile artwork = new MediaFile(imageFile, this.type);
                artwork.gatherMediaInformation();
                this.writtenArtworkFiles.add(artwork);
                ImageCache.invalidateCachedImage(artwork);
                ImageCache.cacheImageSilently(artwork);
            }
            catch (Exception e) {
                LOGGER.warn("could not write file", (Throwable)e);
            }
        }

        private void writeImageToMovieFolders(byte[] bytes, String extension) {
            if (this.movies.isEmpty()) {
                return;
            }
            String filename = "movieset-" + this.type.name().toLowerCase(Locale.ROOT) + "." + extension;
            for (Movie movie : this.movies) {
                try {
                    if (movie.isMultiMovieDir()) continue;
                    Path imageFile = movie.getPathNIO().resolve(filename);
                    this.writeImage(bytes, imageFile);
                    MediaFile artwork = new MediaFile(imageFile, this.type);
                    artwork.gatherMediaInformation();
                    this.writtenArtworkFiles.add(artwork);
                    ImageCache.invalidateCachedImage(artwork);
                    ImageCache.cacheImageSilently(artwork);
                }
                catch (Exception e) {
                    LOGGER.warn("could not write files", (Throwable)e);
                }
            }
        }

        private void writeImageToCacheFolder(byte[] bytes) {
            String filename = ImageCache.getMD5WithSubfolder(this.urlToArtwork);
            try {
                this.writeImage(bytes, ImageCache.getCacheDir().resolve(filename + ".jpg"));
            }
            catch (Exception e) {
                LOGGER.warn("error in image fetcher", (Throwable)e);
            }
        }

        private void writeImage(byte[] bytes, Path pathAndFilename) throws IOException {
            FileOutputStream outputStream = new FileOutputStream(pathAndFilename.toFile());
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            IOUtils.copy((InputStream)is, (OutputStream)outputStream);
            outputStream.flush();
            try {
                outputStream.getFD().sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
            outputStream.close();
            ((InputStream)is).close();
        }
    }
}

