/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieMediaFileComparator;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSetArtworkHelper;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public class MovieSet
extends MediaEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSet.class);
    private static final Comparator<Movie> MOVIE_SET_COMPARATOR = new MovieInMovieSetComparator();
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new MovieMediaFileComparator();
    @JsonProperty
    private List<UUID> movieIds = new ArrayList<UUID>(0);
    private List<Movie> movies = new CopyOnWriteArrayList<Movie>();
    private String titleSortable = "";

    public MovieSet() {
    }

    public MovieSet(String title) {
        this();
        this.setTitle(title);
        MovieSetArtworkHelper.updateArtwork(this);
    }

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        for (UUID uuid : this.movieIds) {
            Movie movie = MovieList.getInstance().lookupMovie(uuid);
            if (movie == null || movie.getMovieSet() != this) continue;
            this.movies.add(movie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTitle(String newValue) {
        String oldValue = this.title;
        super.setTitle(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
        String oldValueTitleSortable = this.titleSortable;
        this.titleSortable = "";
        this.firePropertyChange("titleSortable", oldValueTitleSortable, this.titleSortable);
        if (!StringUtils.equals((CharSequence)oldValue, (CharSequence)newValue)) {
            MovieSetArtworkHelper.cleanupArtwork(this);
            List<Movie> list = this.movies;
            synchronized (list) {
                for (Movie movie : this.movies) {
                    movie.movieSetTitleChanged();
                }
            }
        }
    }

    public String getTitleSortable() {
        if (StringUtils.isEmpty((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public int getTmdbId() {
        int id;
        try {
            id = (Integer)this.ids.get("tmdbSet");
        }
        catch (Exception e) {
            return 0;
        }
        return id;
    }

    public void setTmdbId(int newValue) {
        int oldValue = this.getTmdbId();
        this.ids.put("tmdbSet", newValue);
        this.firePropertyChange("tmdb", oldValue, newValue);
    }

    @Override
    public void setArtworkUrl(String url, MediaFileType type) {
        super.setArtworkUrl(url, type);
        MovieSetArtworkHelper.downloadArtwork(this, type);
    }

    @Override
    public void deleteMediaFiles(MediaFileType type) {
        this.getMediaFiles(type).forEach(mediaFile -> {
            Utils.deleteFileSafely(mediaFile.getFile());
            this.removeFromMediaFiles((MediaFile)mediaFile);
        });
    }

    public void setArtwork(List<MediaArtwork> artwork, List<MovieSetScraperMetadataConfig> config) {
        MovieSetArtworkHelper.setArtwork(this, artwork, config);
    }

    @Override
    public String getArtworkFilename(MediaFileType type) {
        Path cachedFile;
        String artworkFilename = super.getArtworkFilename(type);
        if (StringUtils.isBlank((CharSequence)artworkFilename) && (cachedFile = ImageCache.getCachedFile(this.getArtworkUrl(type))) != null && cachedFile.toFile().exists()) {
            return cachedFile.toAbsolutePath().toString();
        }
        return artworkFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMovie(Movie movie) {
        List<Movie> list = this.movies;
        synchronized (list) {
            if (this.movies.contains(movie)) {
                return;
            }
            this.movies.add(movie);
            this.movieIds.add(movie.getDbId());
            MovieSetArtworkHelper.updateArtwork(this);
            this.saveToDb();
        }
        if (MovieModuleManager.SETTINGS.isEnableMovieSetArtworkMovieFolder()) {
            MovieSetArtworkHelper.writeImagesToMovieFolder(this, Collections.singletonList(movie));
        }
        this.firePropertyChange("addedMovie", null, movie);
        this.firePropertyChange("movies", null, this.movies);
        this.firePropertyChange("watched", null, this.movies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMovie(Movie movie) {
        List<Movie> list = this.movies;
        synchronized (list) {
            if (this.movies.contains(movie)) {
                return;
            }
            int index = Collections.binarySearch(this.movies, movie, MOVIE_SET_COMPARATOR);
            if (index < 0) {
                this.movies.add(-index - 1, movie);
                this.movieIds.add(-index - 1, movie.getDbId());
            } else {
                this.movies.add(index, movie);
                this.movieIds.add(index, movie.getDbId());
            }
            MovieSetArtworkHelper.updateArtwork(this);
            this.saveToDb();
        }
        if (MovieModuleManager.SETTINGS.isEnableMovieSetArtworkMovieFolder()) {
            MovieSetArtworkHelper.writeImagesToMovieFolder(this, Collections.singletonList(movie));
        }
        this.firePropertyChange("addedMovie", null, movie);
        this.firePropertyChange("movies", null, this.movies);
        this.firePropertyChange("watched", null, this.movies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMovie(Movie movie, boolean doCleanup) {
        if (doCleanup) {
            MovieSetArtworkHelper.cleanMovieSetArtworkInMovieFolder(movie);
        }
        if (movie.getMovieSet() != null) {
            movie.setMovieSet(null);
            movie.saveToDb();
        }
        List<Movie> list = this.movies;
        synchronized (list) {
            this.movies.remove(movie);
            this.movieIds.remove(movie.getDbId());
            if (doCleanup) {
                MovieSetArtworkHelper.updateArtwork(this);
            }
            this.saveToDb();
        }
        this.firePropertyChange("removedMovie", null, movie);
        this.firePropertyChange("movies", null, this.movies);
        this.firePropertyChange("watched", null, this.movies);
    }

    public List<Movie> getMovies() {
        return this.movies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortMovies() {
        List<Movie> list = this.movies;
        synchronized (list) {
            this.movies.sort(MOVIE_SET_COMPARATOR);
            this.movieIds.clear();
            for (Movie movie : this.movies) {
                this.movieIds.add(movie.getDbId());
            }
        }
        this.firePropertyChange("movies", null, this.movies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMovies() {
        ArrayList<Movie> oldValue = new ArrayList<Movie>(this.movies);
        List<Movie> list = this.movies;
        synchronized (list) {
            for (Movie movie : this.movies) {
                MovieSetArtworkHelper.cleanMovieSetArtworkInMovieFolder(movie);
                if (movie.getMovieSet() == null) continue;
                movie.setMovieSet(null);
                movie.writeNFO();
                movie.saveToDb();
            }
            this.movies.clear();
            this.movieIds.clear();
            MovieSetArtworkHelper.updateArtwork(this);
            this.saveToDb();
        }
        this.firePropertyChange("removedAllMovies", oldValue, this.movies);
        this.firePropertyChange("movies", null, this.movies);
    }

    public String toString() {
        return this.getTitle();
    }

    public int getMovieIndex(Movie movie) {
        return this.movies.indexOf(movie);
    }

    public void rewriteAllImages() {
        List<MediaFileType> types = Arrays.asList(MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.LOGO, MediaFileType.CLEARLOGO, MediaFileType.CLEARART);
        for (MediaFileType type : types) {
            MovieSetArtworkHelper.downloadArtwork(this, type);
        }
    }

    public Boolean getHasImages() {
        for (MediaArtwork.MediaArtworkType type : MovieModuleManager.SETTINGS.getCheckImagesMovie()) {
            if (!StringUtils.isEmpty((CharSequence)this.getArtworkFilename(MediaFileType.getMediaFileType(type)))) continue;
            return false;
        }
        return true;
    }

    public Boolean getHasMetadata() {
        return StringUtils.isNotBlank((CharSequence)this.plot) && StringUtils.isNotBlank((CharSequence)this.title);
    }

    public Boolean isWatched() {
        for (Movie movie : this.movies) {
            if (movie.isWatched()) continue;
            return false;
        }
        return true;
    }

    public List<MediaFile> getImagesToCache() {
        ArrayList<MediaFile> filesToCache = new ArrayList<MediaFile>();
        if (StringUtils.isNotBlank((CharSequence)this.getArtworkFilename(MediaFileType.POSTER))) {
            filesToCache.add(new MediaFile(Paths.get(this.getArtworkFilename(MediaFileType.POSTER), new String[0])));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getArtworkFilename(MediaFileType.FANART))) {
            filesToCache.add(new MediaFile(Paths.get(this.getArtworkFilename(MediaFileType.FANART), new String[0])));
        }
        return filesToCache;
    }

    @Override
    public MediaFile getMainFile() {
        return new MediaFile();
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
    }

    @Override
    public void saveToDb() {
        MovieList.getInstance().persistMovieSet(this);
    }

    @Override
    public void deleteFromDb() {
        MovieList.getInstance().removeMovieSetFromDb(this);
    }

    public void cleanMovieSet() {
        MovieList movieList = MovieList.getInstance();
        boolean dirty = false;
        for (Movie movie : new ArrayList<Movie>(this.movies)) {
            if (movieList.getMovies().contains(movie)) continue;
            this.movies.remove(movie);
            this.movieIds.remove(movie.getDbId());
            dirty = true;
        }
        if (dirty) {
            this.saveToDb();
        }
    }

    public boolean hasNewlyAddedMovies() {
        for (Movie movie : this.movies) {
            if (!movie.isNewlyAdded()) continue;
            return true;
        }
        return false;
    }

    public void setMetadata(MediaMetadata metadata, List<MovieSetScraperMetadataConfig> config) {
        if (metadata == null) {
            LOGGER.error("metadata was null");
            return;
        }
        if (metadata.getIds().isEmpty()) {
            LOGGER.warn("wanted to save empty metadata for {}", (Object)this.getTitle());
            return;
        }
        this.ids.clear();
        this.setIds(metadata.getIds());
        if (config.contains(MovieSetScraperMetadataConfig.TITLE)) {
            if (MovieModuleManager.SETTINGS.getCapitalWordsInTitles()) {
                this.setTitle(WordUtils.capitalize((String)metadata.getTitle()));
            } else {
                this.setTitle(metadata.getTitle());
            }
        }
        if (config.contains(MovieSetScraperMetadataConfig.PLOT)) {
            this.setPlot(metadata.getPlot());
        }
        this.setScraped(true);
        this.saveToDb();
    }

    private static class MovieInMovieSetComparator
    implements Comparator<Movie> {
        private MovieInMovieSetComparator() {
        }

        @Override
        public int compare(Movie o1, Movie o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            if (o1.getReleaseDate() != null && o2.getReleaseDate() != null) {
                return o1.getReleaseDate().compareTo(o2.getReleaseDate());
            }
            if (o1.getYear() > 0 && o2.getYear() > 0) {
                try {
                    int year1 = o1.getYear();
                    int year2 = o2.getYear();
                    return year1 - year2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return o2.getTitleForUi().compareTo(o1.getTitleForUi());
        }
    }
}

